/* dummyups.c - Dummy model driver for testing shutdowns nondestructively

   Copyright (C) 2000  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/termios.h>

#define _MIT_POSIX_THREADS 1
#include <pthread.h>

#define INFO_MAX 8

#include "config.h"
#include "proto.h"
#include "shared.h"
#include "version.h"
#include "upscommon.h"
#include "common.h"

	static	pthread_t	thread;
	static	pthread_attr_t	threadattr;

void initinfo (void)
{
	create_info (INFO_MAX, 1);

	/* setup the basics */

	addinfo (INFO_MFR, "Testing", 0, 0);
	addinfo (INFO_MODEL, "Dummy UPS", 0, 0);
	addinfo (INFO_STATUS, "OL", 0, 0);
}

/* background thread - keep the struct current so upsd is happy */
static void *updateinfo (void *ptr)
{
	for (;;) {
/*		printf ("writeinfo\n"); */
		writeinfo();
		sleep (2);
	}
}

#if 0
/* install pointers to functions for msg handlers called from msgparse */
void setuphandlers()
{
	/* TODO: future */
}
#endif

int main (int argc, char **argv)
{
	int	res;
	char	exec[512], status[32], buf[128], *portname;
	FILE	*xd;

	printf ("Network UPS Tools - Dummy UPS driver 0.01 (%s)\n", UPS_VERSION);

	if (argc < 2)
		portname = "null";
	else
		portname = argv[1];

	snprintf (statefn, sizeof(statefn), "%s/dummyups-%s", STATEPATH, portname);

	printf ("State file: %s\n", statefn);

	droproot();
	initinfo();
	background();

	pthread_attr_init(&threadattr);
	pthread_attr_setscope(&threadattr, PTHREAD_SCOPE_SYSTEM);
	res = pthread_create (&thread, &threadattr, updateinfo, NULL);

	strcpy (status, "OL");

	for (;;) {
		snprintf (exec, sizeof(exec), "%s %s %s %s %s %s %s %s %s",
			"Xdialog --title \"Network UPS Tools: Dummy UPS driver:",
			portname,
			"\" --stdout --radiolist \"Pick UPS status\" 20 50 3",
			"\"OL\" \"Online\"",
			strcmp(status, "OL") ? "off" : "ON",
			"\"OB\" \"On Battery\"",
			strcmp(status, "OB") ? "off" : "ON",
			"\"OB LB\" \"On Battery + Low Battery\"",
			strcmp(status, "OB LB") ? "off" : "ON");

		/* call Xdialog */

		xd = popen (exec, "r");

		if (!xd)
			fatal("popen");

		/* read choice */

		bzero (buf, sizeof(buf));
		fgets (buf, sizeof(buf), xd);
		pclose (xd);

		if (strlen(buf) > 1)
			buf[strlen(buf) - 1] = '\0';
		else
			exit (1);

		snprintf (status, sizeof(status), "%s", buf);
		setinfo(INFO_STATUS, "%s", status);
	}
}
