/* ups-trust425+625.h - some model specific defines for Trust UPS 425/625
      also known as PowerCom King Pro 425/625 Smart-UPS units

   Copyright (C) 1999  Peter Bieringer <pb@bieringer.de>


     
   based on 
    smartups.h - serial commands for APC Smart-UPS units 
    Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#define REQ_BINARYDATA		0x01	/* ^A */

/* here define the voltage in your country (only used to detect BOOST or TRIM) */
#define ACLINEVOLTAGE		230 	/* V */

/* here define the voltage lower AC freq count isn't working well (and so set to zero) */
#define ACFREQ_ZEROTH		30 	/* V */

/* Number of received bytes */
#define NUMRECEIVEDBYTES	11

/* length value for info[] array */
#define INFOMAX 16

/* set DTR and RTS lines on a serial port to supply a passive serial interface */
/*  here: DTR to 0 (-V), RTS to 1 (+V) */
void set_serialDTR0RTS1(void);

/* wait for an binary answer and get buflen bytes */
int recvbinary (unsigned char *buf, int buflen);

