/* NVTV nv_tv -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This is open software protected by the GPL. See GPL.txt for details.
 *
 * Header: Access the BT chip (and the CRTC). This part could
 * eventually become a part of the XFree NV-Driver.
 * 
 */

#ifndef _NV_TV_H
#define _NV_TV_H

#include "xfree.h"
#include "nv_tvchip.h"
#include "nv_type.h"

extern Bool nvBusOk;

extern NVTvState nvTvState;

U008 readCrt (NVPtr pNv, int reg);
void writeCrt (NVPtr pNv, int reg, U008 val);
void orCrt (NVPtr pNv, int reg, U008 val);
void andCrt (NVPtr pNv, int reg, U008 val);

typedef struct {
  U008 regs [0x34];
} NVCrtState;

Bool NVTvBusInit(ScrnInfoPtr pScrn);

void NVSaveCrt (NVPtr pNv, NVCrtState *state);
void NVRestoreCrt (NVPtr pNv, NVCrtState *state);

I2CChainPtr NVFindTvDevice (NVPtr pNv, NVTvChip chip);
void NVSetTvDevice (NVPtr pNv, I2CChainPtr chain, Bool init);
void NVCreateChain (NVPtr pNv);

void NVDestroyDevices (NVPtr pNv);
void NVDestroyBusses (NVPtr pNv);

void NVProbeAllDevices (NVPtr pNv);
void NVProbeTvDevices (NVPtr pNv);

void NVSetCrtRegs (NVPtr pNv, DisplayModePtr mode);
void NVGetCrtRegs (NVPtr pNv, DisplayModePtr mode);

void NVSetTestImage (NVPtr pNv);
void NVSetTvMode (NVPtr pNv, DisplayModePtr mode);

char* NVGetTvVersion (NVPtr pNv);
long NVGetTvStatus (NVPtr pNv, int index);
NVConnect NVGetTvConnect (NVPtr pNv);

#endif /* _NV_TV_H */
