if not openfst then
    print "OpenFST is disabled, we can't test it."
    os.exit(0)
end


function print_array(a)
    for i = 0, a:length() - 1 do
        print(a:at(i))
    end
    print()
end

function generate_random_fst(nstates, maxspan)
    local f = ocr.make_StandardFst()
    for i = 0, nstates - 1 do
        local s = f:newState()
        assert(s == i)
    end
    f:setStart(0)
    f:setAccept(nstates - 1)
    for i = 0, nstates - 1 do
        for j = 1, maxspan do
            if i + j >= nstates then
                break
            end
            f:addTransition(i, i + j, math.random(32, 128),
                                      math.random(),
                                      math.random(32, 128))
        end
    end
    return f
end

function test_compare_openfst_search_with_beam_search(fst, beam_width)
    if not beam_width then
        beam_width = 21
    end
    local fst_builder = make_FstBuilder()
    fst_copy(fst_builder, fst)
    local openfst_fst = fst_builder:take()

    -- OpenFST's search
    local openfst_outputs = nustring.nustring()
    local openfst_costs = floatarray()
    local openfst_inputs = intarray()
    openfst.bestpath(openfst_outputs, openfst_costs, openfst_inputs,
                     openfst_fst, false --[[that's copy_eps; what's that?]])

    -- Beam search
    local beam_outputs = intarray()
    local beam_costs = floatarray()
    local beam_vertices = intarray()
    local beam_inputs = intarray()
    ocr.beam_search(beam_inputs, beam_vertices, beam_outputs, beam_costs, fst,
                    beam_width)

    openfst_fst:Write("_debug.fst")

    -- compare inputs
    -- beam_search has that extra 0 padding
    assert(beam_inputs:length() == openfst_inputs:length() + 1)
    local beam_inputs_top = beam_inputs:pop()
    assert(beam_inputs_top == 0)
    assert(narray.equal(beam_inputs, openfst_inputs))

    -- compare costs
    assert(beam_costs:length() == openfst_costs:length() + 1)
    -- beam_search returns also the accept cost of the last vertex
    local beam_costs_top = beam_costs:pop()
    local last_vertex = beam_vertices:at(beam_vertices:length() - 1)
    assert(beam_costs_top == f:getAcceptCost(last_vertex))
    assert(narray.equal(beam_costs, openfst_costs))

    -- too bad we can't compare vertices because openfst doesn't return them
    -- (or maybe it's our openfst binding)
    
    -- compare outputs
    assert(beam_outputs:length() == openfst_outputs:length() + 1)
    local beam_outputs_top = beam_outputs:pop()
    assert(beam_outputs_top == 0)
    -- we have a little problem here because openfst_outputs is a nustring,
    -- and beam_outputs is a intarray. Well, we have to make a Lua loop, then.
    local n = openfst_outputs:length()
    for i = 0, n - 1 do
        assert(openfst_outputs:at(i):ord() == beam_outputs:at(i))
    end
end

--f = make_StandardFst()
--test_compare_openfst_search_with_beam_search(f)
for i = 1, 1000 do
    f = generate_random_fst(math.random(20,30), math.random(1, 6))
    test_compare_openfst_search_with_beam_search(f)
end
