%%NAME
%%  eview  -  show eps-file 
%%
%%  if  no EPS-viewer installed then html-browser will be started
%%SYNOPSIS
%%  eview([epsFileName])
%%
%%PARAMETER(S)
%%  epsFileName    name of eps-file
%%                 default: string of global parameter 'eFileName' 
%%GLOBAL PARAMETER(S)
%%  eFileName
%%  eGhostview
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010
function eview(epsFileName)
  if nargin>1
    eusage('eview([epsFileName])');
  end
  eglobpar;
  if exist('eFac')
    if isempty(eFac)
      einit;
    end
  else
    einit;
  end
  if nargin<1
    epsFileName=eFileName;
  end

  if exist(epsFileName)~=2
    disp('error in eview: file not exist');
  else
    if isempty(eGhostview)
      nameL=length(epsFileName);
      htmlFileName=[epsFileName(1:nameL-3) 'html'];
      ehtmlnew(htmlFileName,[0.95 0.95 0.95]);
      ehtmladdeps(htmlFileName,epsFileName,80);
      ebrowse(htmlFileName);
    else
      gsview=sprintf('%s %s',eGhostview,epsFileName);
      if exist('matlabpath')~=5
        system(gsview);
      else
        unix(gsview);
      end
    end
  end
