#include "crlibm.h"
#include "crlibm_private.h"
/*
 * Constant to compute the logarithm base 2. 
 */
#ifdef WORDS_BIGENDIAN
static const db_number 
  norm_number = {{0x3FD60000, 0x00000000}}; /* 11*2^(-5) */
#else
static const db_number 
  norm_number = {{0x00000000, 0x3FD60000}}; /* 11*2^(-5) */
#endif


static const scs table_ti[13]=
/* ~-5.405684e-01 */ 
{{{0x2298ac1f, 0x33457c40, 0x1c141e66, 0x3eaaab29, 
0x1030633d, 0x048bef17, 0x1a91d6a1, 0x22230522},
DB_ONE,  -1,  -1 } 
,
/* ~-4.150375e-01 */ 
{{0x1a8ff971, 0x20429786, 0x017fd3b7, 0x35f97452, 
0x0bb6c306, 0x15c5da64, 0x3efe1069, 0x2fb2da05},
DB_ONE,  -1,  -1 } 
,
/* ~-2.995603e-01 */ 
{{0x132bfee3, 0x1c3b9a19, 0x1a24978d, 0x38d67cae, 
0x3878c2df, 0x02d6ff98, 0x24e1a2a9, 0x1b4f917d},
DB_ONE,  -1,  -1 } 
,
/* ~-1.926451e-01 */ 
{{0x0c544c05, 0x17f7a64c, 0x3354dbf1, 0x1bec1a57, 
0x2e31ce56, 0x2b7fe8e9, 0x20d510a7, 0x19e262f3},
DB_ONE,  -1,  -1 } 
,
/* ~-9.310940e-02 */ 
{{0x05f58125, 0x2cfbb4c6, 0x1ced1447, 0x38c2b4e4, 
0x3edd56b0, 0x1637ed79, 0x2a14f4fe, 0x3db0ce67},
DB_ONE,  -1,  -1 } 
,
/* ZERO         */
{{0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000},
{{0, 0}},  0,   1 }
,
/* ~8.746284e-02 */ 
{{0x0598fdbe, 0x2c913167, 0x33314e09, 0x2144575a, 
0x30f2941f, 0x0fab1d27, 0x3e612491, 0x0849fe51},
DB_ONE,  -1,   1 } 
,
/* ~1.699250e-01 */ 
{{0x0ae00d1c, 0x3f7ad0f3, 0x3d005890, 0x140d175b, 
0x289279f3, 0x14744b36, 0x0203df2c, 0x209a4bf4},
DB_ONE,  -1,   1 } 
,
/* ~2.479275e-01 */ 
{{0x0fde0b5c, 0x204d0144, 0x1d46ccc5, 0x0f09de6b, 
0x39267ab7, 0x1b5a9520, 0x35aacfb1, 0x311d7642},
DB_ONE,  -1,   1 } 
,
/* ~3.219281e-01 */ 
{{0x149a784b, 0x3346e2bf, 0x2492bf6f, 0x3d36bf6d, 
0x0cd96c55, 0x3f8deceb, 0x14e91b6a, 0x32020b9e},
DB_ONE,  -1,   1 } 
,
/* ~3.923174e-01 */ 
{{0x191bba89, 0x07c5c22d, 0x0b2b5056, 0x2e1a7156, 
0x06176ea2, 0x3eba3cb1, 0x202cdeee, 0x366ac306},
DB_ONE,  -1,   1 } 
,
/* ~4.594316e-01 */ 
{{0x1d6753e0, 0x0cba83bf, 0x23ebe199, 0x015554d6, 
0x2fcf9cc2, 0x3b7410e8, 0x256e295e, 0x1ddcfadd},
DB_ONE,  -1,   1 } 
,
/* ~5.235620e-01 */ 
{{0x21820a01, 0x2b1d532c, 0x104aea53, 0x1b12ef0a, 
0x2a0fca1a, 0x1dd6be1d, 0x0730b711, 0x35eaa979},
DB_ONE,  -1,   1 } 
};



static const scs table_inv_wi[13]=
/* ~1.454545e+00 */ 
{{{0x00000001, 0x1d1745d1, 0x1d1745d1, 0x1d1745d1, 
0x1d1745d1, 0x1d1745d1, 0x1d183e2a, 0x36835582},
DB_ONE,   0,   1 } 
,
/* ~1.333333e+00 */ 
{{0x00000001, 0x15555555, 0x15555555, 0x15555555, 
0x15555555, 0x15555555, 0x15549b7e, 0x1a416c6b},
DB_ONE,   0,   1 } 
,
/* ~1.230769e+00 */ 
{{0x00000001, 0x0ec4ec4e, 0x313b13b1, 0x0ec4ec4e, 
0x313b13b1, 0x0ec4ec4e, 0x313a6825, 0x3ab28b77},
DB_ONE,   0,   1 } 
,
/* ~1.142857e+00 */ 
{{0x00000001, 0x09249249, 0x09249249, 0x09249249, 
0x09249249, 0x09249249, 0x09238b74, 0x26f620a6},
DB_ONE,   0,   1 } 
,
/* ~1.066667e+00 */ 
{{0x00000001, 0x04444444, 0x11111111, 0x04444444, 
0x11111111, 0x04444444, 0x1111d60e, 0x1f0c9d58},
DB_ONE,   0,   1 } 
,
/* ~1.000000e+00 */ 
{{0x00000001, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000},
DB_ONE,   0,   1 } 
,
/* ~9.411765e-01 */ 
{{0x3c3c3c3c, 0x0f0f0f0f, 0x03c3c3c3, 0x30f0f0f0, 
0x3c3c3c3c, 0x0f0f923d, 0x16e0e0a4, 0x3a84202f},
DB_ONE,  -1,   1 } 
,
/* ~8.888889e-01 */ 
{{0x38e38e38, 0x38e38e38, 0x38e38e38, 0x38e38e38, 
0x38e38e38, 0x38e3946a, 0x2e0ee2c9, 0x0d6e0fbd},
DB_ONE,  -1,   1 } 
,
/* ~8.421053e-01 */ 
{{0x35e50d79, 0x10d79435, 0x39435e50, 0x35e50d79, 
0x10d79435, 0x3943324d, 0x0637ea85, 0x131a67ba},
DB_ONE,  -1,   1 } 
,
/* ~8.000000e-01 */ 
{{0x33333333, 0x0ccccccc, 0x33333333, 0x0ccccccc, 
0x33333333, 0x0ccccccc, 0x33333333, 0x0ccccccc},
DB_ONE,  -1,   1 } 
,
/* ~7.619048e-01 */ 
{{0x30c30c30, 0x30c30c30, 0x30c30c30, 0x30c30c30, 
0x30c30c30, 0x30c2f1a4, 0x160958a1, 0x2b03bc88},
DB_ONE,  -1,   1 } 
,
/* ~7.272727e-01 */ 
{{0x2e8ba2e8, 0x2e8ba2e8, 0x2e8ba2e8, 0x2e8ba2e8, 
0x2e8ba2e8, 0x2e8bcb74, 0x2d78b525, 0x00a1db67},
DB_ONE,  -1,   1 } 
,
/* ~6.956522e-01 */ 
{{0x2c8590b2, 0x0590b216, 0x10b21642, 0x321642c8, 
0x1642c859, 0x02c8590b, 0x08590b21, 0x190b2164},
DB_ONE,  -1,   1 } 
};






static const scs constant_poly[20]=
/* ~-7.247187e-02 */ 
{{{0x04a3610e, 0x3280f22f, 0x1de04b83, 0x13d0592c, 
0x01c1f347, 0x0e59a808, 0x0bcf5cfa, 0x3009a167},
DB_ONE,  -1,  -1 } 
,
/* ~7.626763e-02 */ 
{{0x04e191a1, 0x27127aea, 0x2fb498c3, 0x3f8e3721, 
0x2688ed52, 0x38503e4f, 0x3b216e42, 0x17d8666c},
DB_ONE,  -1,   1 } 
,
/* ~-8.014898e-02 */ 
{{0x05212933, 0x12c0276e, 0x1534c74e, 0x1ffc3802, 
0x36935f91, 0x25fe848d, 0x2bade416, 0x110f0662},
DB_ONE,  -1,  -1 } 
,
/* ~8.486372e-02 */ 
{{0x056e6838, 0x35aa4f4a, 0x2ae2f258, 0x30768483, 
0x2bc43d6e, 0x176d2fe1, 0x17488263, 0x30f7670b},
DB_ONE,  -1,   1 } 
,
/* ~-9.016844e-02 */ 
{{0x05c551da, 0x1166e535, 0x10625f98, 0x08af81ee, 
0x04feb59e, 0x2906123e, 0x0b31f878, 0x0693beb1},
DB_ONE,  -1,  -1 } 
,
/* ~9.617967e-02 */ 
{{0x0627cec6, 0x20792d0d, 0x181b90ab, 0x0c8e3405, 
0x1fe3b53f, 0x0f6d3b7a, 0x00eefd12, 0x0808849b},
DB_ONE,  -1,   1 } 
,
/* ~-1.030496e-01 */ 
{{0x06985d8a, 0x27a1d37d, 0x3fa3c0e9, 0x37e7d679, 
0x0379ed1d, 0x25a15e16, 0x3ef8c491, 0x2414ab4f},
DB_ONE,  -1,  -1 } 
,
/* ~1.109765e-01 */ 
{{0x071a3d5a, 0x0d27a702, 0x138411a6, 0x15701cae, 
0x31ef415d, 0x1985227d, 0x31a4c54c, 0x15d3a279},
DB_ONE,  -1,   1 } 
,
/* ~-1.202246e-01 */ 
{{0x07b1c277, 0x03a04150, 0x3be8d05b, 0x2f373cf4, 
0x105c73c2, 0x0ee0272b, 0x0b2bf018, 0x1ad7026f},
DB_ONE,  -1,  -1 } 
,
/* ~1.311541e-01 */ 
{{0x0864d424, 0x328046b9, 0x132f0fc6, 0x2b14d554, 
0x189d4b79, 0x2ec40035, 0x15083d44, 0x33a13b8c},
DB_ONE,  -1,   1 } 
,
/* ~-1.442695e-01 */ 
{{0x093bb628, 0x1df37fcf, 0x022eb69a, 0x0b325d1d, 
0x0625c904, 0x1ccaa7ae, 0x0ed7ce1d, 0x3202ff74},
DB_ONE,  -1,  -1 } 
,
/* ~1.602994e-01 */ 
{{0x0a42589e, 0x2f80551e, 0x3eb3ec54, 0x1a1094cd, 
0x23649796, 0x328d4019, 0x3f6371c6, 0x37a359a1},
DB_ONE,  -1,   1 } 
,
/* ~-1.803369e-01 */ 
{{0x0b8aa3b2, 0x25705fc2, 0x3bbedcca, 0x35a13588, 
0x15c06cdc, 0x39fbf52c, 0x2b666451, 0x350d8287},
DB_ONE,  -1,  -1 } 
,
/* ~2.060993e-01 */ 
{{0x0d30bb15, 0x0f5bdb27, 0x3b23121c, 0x383c6bb0, 
0x2f3b4fd2, 0x2dba0ce0, 0x0230a445, 0x306b1136},
DB_ONE,  -1,   1 } 
,
/* ~-2.404492e-01 */ 
{{0x0f6384ee, 0x07407fae, 0x24fe0aa6, 0x3c7aefd2, 
0x12953456, 0x0d1d1991, 0x2af86714, 0x26b4c925},
DB_ONE,  -1,  -1 } 
,
/* ~2.885390e-01 */ 
{{0x12776c50, 0x3be6ff9e, 0x12ca7330, 0x1a6d448b, 
0x1ef18433, 0x375e9366, 0x21f2efcf, 0x38ab1d93},
DB_ONE,  -1,   1 } 
,
/* ~-3.606738e-01 */ 
{{0x17154765, 0x0ae0bf85, 0x377d0ffd, 0x2836248a, 
0x3b8e6858, 0x123f10ae, 0x0c65387c, 0x26048456},
DB_ONE,  -1,  -1 } 
,
/* ~4.808983e-01 */ 
{{0x1ec709dc, 0x0e80ff5d, 0x09fc1552, 0x0af12c97, 
0x37bd6a2c, 0x3ebc8f65, 0x113a7c28, 0x1663571a},
DB_ONE,  -1,   1 } 
,
/* ~-7.213475e-01 */ 
{{0x2e2a8eca, 0x15c17f0b, 0x2efa1ffb, 0x10691d3d, 
0x09a93721, 0x2d59e835, 0x1baea424, 0x28b120a0},
DB_ONE,  -1,  -1 } 
,
/* ~1.442695e+00 */ 
{{0x00000001, 0x1c551d94, 0x2b82fe17, 0x1df43ff6, 
0x20d23a7c, 0x3b9ff352, 0x14d59cbf, 0x00fe1bdb},
DB_ONE,   0,   1 } 
};


#define constant_poly_ptr (scs_ptr)&constant_poly
#define table_ti_ptr      (scs_ptr)&table_ti
#define table_inv_wi_ptr  (scs_ptr)&table_inv_wi
