Digits := 200:
interface(quiet=true):
read "common-procedures.mpl":
read "triple-double.mpl":
with(orthopoly):
mkdir("TEMPTRIG"):

smallest := 2^(-1023) * 1 * 2^(-51):

pih, pim, pil := hi_mi_lo(Pi):

# precompute Dekker decomposition of pih
DekkerConst:=2^27+1:
t:=nearest(pih*DekkerConst) :
pihh:= nearest(pih-t) + t :
pihm:= pih-pihh :





SinCosSize:= 64: # size f the table



outputHighPart:=proc(cvarname, var)
  local varMinusLSB:
  Digits:=8:
  varMinusLSB:=var/(1+2^(-20)):
  ("#define " || cvarname || " 0x" || (ieeehexa(varMinusLSB)[1])
    ||  "        /* " || (convert(evalf(varMinusLSB),string)) ||  " */" )
end proc:


filename:="TEMPTRIG/trigpi.h":
fd:=fopen(filename, WRITE, TEXT):

fprintf(fd, "#include \"crlibm.h\"\n#include \"crlibm_private.h\"\n"):
fprintf(fd, "\n/*File generated by maple/trigpi.pl*/\n"):
fprintf(fd, "#define TWOTO42     %1.50e \n", 2^42):
fprintf(fd, "\n"):
fprintf(fd, "#define TWOTO52     %1.50e \n", 2^52):
fprintf(fd, "\n"):
fprintf(fd, "#define INV128      %1.50e \n", 1/128):
fprintf(fd, "\n"):
fprintf(fd, "#define TWOTO5251        %1.50e \n", 2^52+2^51):
fprintf(fd, "\n"):
fprintf(fd, "#define SMALLEST       %1.50e\n",smallest):
fprintf(fd, "\n"):

fprintf(fd, "#define PIH %1.50e\n", pih):
fprintf(fd, "\n"):
fprintf(fd, "#define PIM %1.50e\n", pim):
fprintf(fd, "\n"):
fprintf(fd, "#define PIL %1.50e\n", pil):
fprintf(fd, "\n"):
fprintf(fd, "#define PIHH %1.50e\n", pihh):
fprintf(fd, "\n"):
fprintf(fd, "#define PIHM %1.50e\n", pihm):
fprintf(fd, "\n"):
fprintf(fd, "#define PIX_RNCST_SIN %1.50e\n", compute_rn_constant(2^(-61))):
fprintf(fd, "\n"):
fprintf(fd, "#define PIX_EPS_SIN   %1.50e\n", 2^(-61)):
fprintf(fd, "\n"):
fprintf(fd, "#define PIX_RNCST_TAN %1.50e\n", compute_rn_constant(2^(-60))):
fprintf(fd, "\n"):
fprintf(fd, "#define PIX_EPS_TAN   %1.50e\n", 2^(-60)):
fprintf(fd, "\n"):

# The Pi SCS constant TODO: fuse with the Pi/256 in trigo.h
  fprintf(fd, "static const scs PiSCS=\n"):
  WriteSCS(fd, evalf(Pi)):
  fprintf(fd, ";\n#define PiSCS_ptr  (scs_ptr)(& PiSCS)\n\n"):

# Table
fprintf(fd, "typedef struct tPi_t_tag {double sh; double ch; double sm; double cm; double sl; double cl;} tPi_t;\n");
fprintf(fd, "static const tPi_t sincosTable[%d] =\n{\n",  SinCosSize):
for i from 0 to SinCosSize-1 do
    sh,sm,sl:=hi_mi_lo(sin(i*Pi/(2*SinCosSize))):
    ch,cm,cl:=hi_mi_lo(cos(i*Pi/(2*SinCosSize))):
    fprintf(fd, "  { /* sin/cos(%d*pi/%d) */\n", i, 2*SinCosSize):
    fprintf(fd, "    %1.50e, /* sh */ \n", sh):
    fprintf(fd, "    %1.50e, /* ch */ \n", ch):
    fprintf(fd, "    %1.50e, /* sm */ \n", sm):
    fprintf(fd, "    %1.50e, /* cm */ \n", cm):
    fprintf(fd, "    %1.50e, /* sl */ \n", sl):
    fprintf(fd, "    %1.50e, /* cl */ \n", cl):
    fprintf(fd, "  } "):
    fprintf(fd, ", \n"):
od:
fprintf(fd, "}; \n \n"):



fclose(fd):
