## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{f} =} vtk_quiver3(@var{z},@var{u},@var{v},@var{w})
## Plots the surface defined by @var{z} and line segments (~arrows) from
## the surface as defined by (@var{u},@var{v},@var{w}).
##
## This function is a bit rough and likely to change in the future.
##
## @end deftypefn
## @seealso{vtk_surf}

## Author: Dragan Tubic


## In m****b it seems that quiver3 does what vtk_arrows3 currently does.
## If we want to keep this function, it should be renamed and reworked.
## JJS 10/26/04

function vtk_quiver3(pz,pu,pv,pw)
  
  [nr nc] = size(pz);
  
  [x y] = meshgrid(1:nr,1:nc);
  c = max(max(pz)) - pz;
  x = x(:);
  y = y(:);
  z = pz(:);
  c = c(:);
  u = pu(:);
  v = pv(:);
  w = pw(:);
  
  len = nr*nc;
  q = zeros(nr,nc);
  q(:) = 1:len;
  q = q(1:nr-1,1:nc-1) - 1;
  q = q(:);
  t = [q q+1 q+nc; q+1 q+nc+1 q+nc];
  
  vtk_init;	
  
  if ( length(x) != length(y) | length(x) != length(z) | length(x) != length(c) )
    error('Lengths of all three coordinates have to be the same.');
  end
  
  %% We'll create the building blocks of polydata including data attributes.
  surface = vtkPolyData();
  points   = vtkPoints();
  polys    = vtkCellArray();
  scalars  = vtkFloatArray();
  
  %% Load the point, cell, and data attributes.
  %% for (i=0; i<8; i++) points->InsertPoint(i,x[i]);
  coords = vtkFloatArray; 
  coords.SetNumberOfTuples( length(x) );
  coords.SetNumberOfComponents(3);
  pts = [x y z]';
  coords.SetArray( pts(:), 3*length(x), 0 );
  points.SetData(coords);
  
  %% for (i=0; i<6; i++) polys->InsertNextCell(4,pts[i]);
  [nr nc] = size(t);
  if ( nr < nc )
    t = t';
  end	
  [nr nc] = size(t);
  if ( nc != 3 )
    error('t has to be a Nx3 matrix');
  end	
  no_tris = length(t);
  t = [ones(no_tris,1)*3 t]';
  ptids = vtkIdTypeArray;
  ptids.SetArray( t(:), no_tris*4, 0 );
  polys.SetCells( no_tris, ptids );
  
  %%for (i=0; i<8; i++) scalars->InsertValue(i,i);
  scalars.SetArray( c, length(c) , 0 );
  
  %% We now assign the pieces to the vtkPolyData.
  surface.SetPoints(points);
  surface.SetPolys(polys);
  surface.GetPointData().SetScalars(scalars);
  
  %% Now we'll look at it.
  surfaceMapper = vtkPolyDataMapper();
  surfaceMapper.SetInput(surface);
  surfaceMapper.SetScalarRange(0,max(c));
  surfaceMapper.ScalarVisibilityOn();
  surfaceMapper.SetColorModeToMapScalars();
  
  surfaceActor = vtkLODActor();
  surfaceActor.SetMapper(surfaceMapper);
  prop = surfaceActor.GetProperty();
  prop.SetInterpolationToGouraud();
  prop.SetDiffuse(0);
  prop.SetAmbient(1);
  
  [nr nc] = size(pz);
  len = nr*nc*3;		
  vect = zeros(len,1);
  size(u)
  len
  vect(1:3:len) = u;
  vect(2:3:len) = v;
  vect(3:3:len) = w;
  
  vectors = vtkFloatArray;
  vectors.SetArray(vect,nr*nc,0);
  vectors.SetNumberOfComponents(3);
  
  surface.GetPointData().SetVectors(vectors);
  
  hedgehog = vtkHedgeHog();
  hedgehog.SetInput(surface);
  hedgehog.SetScaleFactor(1);
  
  %% The contour lines are mapped to the graphics library.
  hog_mapper = vtkPolyDataMapper();
  hog_mapper.SetInput(hedgehog.GetOutput())
  hog_mapper.SetScalarRange(0,max(c));
  
  hog_actor = vtkActor();
  hog_actor.SetMapper(hog_mapper)
  
  f = vtk_figure(0);
  f.renderer.AddActor(surfaceActor);
  f.renderer.AddActor(hog_actor);
  vtk_update(f);
  
endfunction
