/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef CONNECTIONMODEL_H
#define CONNECTIONMODEL_H

#include <string>
#include <cassert>
using std::string;

namespace LibOmClient {


/** Class to represent a port->port connection in the engine
 */
class ConnectionModel
{
public:
	ConnectionModel() {}

	ConnectionModel(const string& src_port, const string& dst_port)
	: m_src_port_path(src_port),
	  m_dst_port_path(dst_port)
	{
		// Be sure connection is within one patch
		//assert(OmPath::parent(OmPath::parent(m_src_port_path))
		//	== OmPath::parent(OmPath::parent(m_dst_port_path)));
	}

	void src_port_path(const string& s) { m_src_port_path = s; }
	void dst_port_path(const string& s) { m_dst_port_path = s; }
	
	const string& src_port_path() const { return m_src_port_path; }
	const string& dst_port_path() const { return m_dst_port_path; }
	const string  src_port_name() const { return OmPath::name(m_src_port_path); }
	const string  dst_port_name() const { return OmPath::name(m_dst_port_path); }
	const string  src_node_name() const { return OmPath::name(OmPath::parent(m_src_port_path)); }
	const string  dst_node_name() const { return OmPath::name(OmPath::parent(m_dst_port_path)); }
	const string  patch_path()    const { return OmPath::parent(OmPath::parent(m_src_port_path)); }

	bool operator==(const ConnectionModel& cm) {
		return (m_src_port_path == cm.m_src_port_path
		     && m_dst_port_path == cm.m_dst_port_path);
	}
	
private:
	string m_src_port_path;
	string m_dst_port_path;
};


} // namespace LibOmClient

#endif // CONNECTIONMODEL_H
