#!/usr/bin/perl
#
# downloadhours.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: downloadhours.cgi,v 1.13 2001/08/29 22:22:45 adam Exp $

require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';
use CGI qw(:standard);
use ADB;

my %state;
my $dbconn;
my $reply;
my $oops;

#%state = &initialize_state(%state);
$state{'remote_user'} = remote_user;
#$state{'super'} = &is_superuser($state{'remote_user'});
if ($state{'remote_user'} eq "$Conf::DOWNLOAD_USER") {
    $state{'super'} = 1;
} else {
    $state{'super'} = 0;
}


$dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
if (!$dbconn->is_ok) {
    $oops = $dbconn->errorstring;
    &error("Cannot connect to backend: $oops");
}

if ($state{'super'}) {

    # do SuperUser download
    my $sql = "SELECT HR.*, JB.*, CL.client_name from hours HR, client CL,
 job JB WHERE CL.client_id = HR.fkclient_id 
 AND HR.approval_date > '$Conf::DUMMY_APPROVAL_DATE'
 AND HR.downloaded = 'n'
 AND JB.job_id = HR.fkjob_id
 AND HR.del = 'n' ORDER BY hours_id;";
    $reply = $dbconn->query($sql);
    if (!$reply) {
        $oops = $dbconn->errorstring;
        &error("Error getting your hours: $oops", $sql);
    }
    my $numrows = $reply->get_num_rows;
    my %row;  
    my @hrs;   
    my $i = 0;
    print "Content-type: application/x-onshore-hours\n\n";
    &print_heading;
    open(LOG, ">>logs/downloadhours.log") ||
	&error("Cannot open logfile for writing.  Contact Timesheet Aministrator");
    while ($i < $numrows) {
        %row = $reply->get_row($i);
	&print_row(%row);
	push @hrs, $row{'hours_id'};
	$i++;
    }
    my $date = &dbdate_today;
    print LOG "$remote_user\t$date\t@hrs";
    print LOG "\n";
    close LOG;
    my $var;
    foreach $var (@hrs) {
	$reply = $dbconn->query("UPDATE hours set downloaded = 'y' where hours_id = $var;");
    }
    
} else {
    my $sql = "SELECT HR.*, JB.*, CL.client_name from hours HR, client CL,
 job JB WHERE HR.fkpersonnel_id = '$state{'remote_user'}'
 AND CL.client_id = HR.fkclient_id
 AND HR.approval_date > '$Conf::DUMMY_APPROVAL_DATE' AND HR.downloaded = 'n'
 AND JB.job_id = HR.fkjob_id AND HR.del = 'n' ORDER BY hours_id;";

    $reply = $dbconn->query($sql);
    if (!$reply) {
	$oops = $dbconn->errorstring;
	&error("Error getting your hours: $oops", $sql);
    }
    my $numrows = $reply->get_num_rows;
    my %row;
    my @rec;
    my $var;	
    my $i = 0;
    if ($numrows == 0) {
	print_empty_download($state{'remote_user'});
	exit(0);
    }
    print "Content-type: application/x-onshore-hours\n\n";
    &print_heading;
    while ($i < $numrows) {
	%row = $reply->get_row($i);
	&print_row(%row);
	
	$i++;
    }
}


sub print_row {
    my %rec = @_;
    my $var;
    my $first;
    $first = 0;

    if ($rec{"billable"} > 0) {
	$rec{'billable'} = "yes";
    } else{
	$rec{'billable'} = "no";
    }

    # untabify 
    # Stel hack, to make him happy
    # char date_entered in the DB to jobdate for Stel
    $rec{'jobdate'} = $rec{'date_entered'};

    # Just give Stel the "date" from "time" which is renamed to date_entered
    $rec{'intime'} =~ /.*:.*:(.*)/;
    $rec{'date_entered'} = $1;

    my @variables = ('hours_id','fkjob_id', 'fkclient_id','fkpersonnel_id',
		     'jobdate','date_entered','time_in','time_out',
		     'total_hours','billable','hours_description',
		     'comment', 'parking', 
		     'expense_amount','fkapprover_id',
		     'approval_date');

    foreach $var (@variables) {
	$rec{$var} =~ s/\t/    /g;
	$rec{$var} =~ s/\n/ /g;
	$rec{$var} =~ s/\r/ /g;
	$rec{$var} =~ s/\f/ /g;
	if ($first == 0) {
	    $first = 1;
	    print "$rec{$var}";
	} else {
	    print "\t$rec{$var}";
	}
    } 
    print "\r";
}
    
sub print_heading {
    my $first;
    my $var;
    my @variables = ('hours_id','fkjob_id', 'fkclient_id','fkpersonnel_id',
		     'jobdate','date_entered','time_in','time_out',
		     'total_hours','billable','hours_description',
		     'comment','expense_amount','fkapprover_id',
		     'approval_date');
    $first = 0;
    foreach $var (@variables) {
	$var =~ s/\n/ /g;
	$var =~ s/\r/ /g;
	$var =~ s/\f/ /g;
	if ($first == 0) {
            $first = 1;
            print "$var";
        } else {
            print "\t$var";
        }
    }
    print "\r";
}


sub print_empty_download {
    my $username = shift;
    print header, start_html(-'title' => $Conf::ORG,
			     -BACKGROUND => $Conf::BACKGROUND, 
			     -'script' => $javascript,
			     -BGCOLOR => 'ababab');		    
    print "<h1>No Hours to Download</h1>\n";
    print "<p>Currently you have no hours that have been not been ";
    print "transferred out of the system and that are approved.  ";
    print "<p>Use ``View/Edit Hours'' to look at all the hours under ";
    print "your account, including unapproved and downloaded ones.\n";
}
