#Timesheet
#
# client-funcs.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 
# Functions related to manipulating clients.
#
#$Id: client-funcs.pl,v 1.7 2001/08/29 22:23:03 adam Exp $
use CGI qw(:standard);
use ADB;
require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';

###########################################################
###########################################################
# print out an empty form for the creation of a new client
# we allow them to set the client_id, but if they leave it 
# blank we set it for them
sub new_client_form {
    
    my %yes_no_labels = ('y',' yes','n',' no',);      
    my %vars;
    
    $vars{'client_name_widget'} = textfield('-name'=>'client_name',
					    '-default'=>'',
					    '-override'=>'1',
					    '-size'=>'25');
    
    $vars{'client_id_widget'} = textfield('-name'=>'client_id',
					  '-default'=>'',
					  '-override'=>'1',
					  '-size'=>'10');
    
    $vars{'default_bill_widget'} = textfield('-name'=>'default_bill_rate',
                                             '-default'=>'',
					     '-override'=>'1',
                                             '-size'=>'8');
    
    $vars{'default_approved_widget'} = popup_menu('-name'=>'default_approved',
                                                  '-values'=>['y','n'],
                                                  '-default'=>'n',
						  '-override'=>'1',
                                                  '-linebreak'=>'true',
                                                  '-labels'=>\%yes_no_labels);
    
    &subprint_file("$Conf::CLIENT_NEW_TMPL", \%vars);

}

###########################################################
sub reset_all_params {
    param('client_name'       ,'');
    param('default_bill_rate' ,'');
    param('default_approved'  ,'');
}

#############
# admin_search_jobs_form takes a hash with the following values
#
# remote_user is the user from the REMOTE_USER ENV var
# client_name is the name of the currently selected client, NOT ID
# client_id is the unique ID for the client
# today is today's date in dd/mm/yy format
# supers = reference to list of superusers
sub admin_search_client_form
{
    my %args = @_;
    my %yes_no_labels = ('y',' Yes','n',' No', 'any', 'Any');
    my %vars;
    $vars{'client_name_widget'} = textfield('-name'=>'client_name',
				    '-default'=>"$state{'client_name'}",
				    '-size'=>'25');
    
    
    $vars{'default_bill_widget'} = textfield('-name'=>'default_bill_rate',
					     '-default'=>'',
					     '-size'=>'8');
    
    
    $vars{'default_approved_widget'} = popup_menu('-name'=>'default_approved',
						  '-values'=>['y','n','any'],
						  '-default'=>'any',
						  '-linebreak'=>'true',
						  '-labels'=>\%yes_no_labels);

    &subprint_file("$Conf::CLIENT_SEARCH_TMPL", \%vars);
}

sub search_client{
    my %args = @_;
    my $sql;
    my $dbconn;
    my $oops;
    my $result;
    my $table;
    my $notfirst = 0;
    if (!$args{'remote_user'}){
	&error("remote_user not passed to search_job");
    }
    $table = "c_s_$args{'remote_user'}";
    $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if (!$dbconn->is_ok){
	$oops = $dbconn->errorstring;
	&error("Failed to connect to backend: $oops");
    }
    $dbconn->query("DROP TABLE $table;");
    $dbconn->query("create table $table (client_id int4);");
    $result = $dbconn->query("create index $table_idx on $table using btree (client_id int4_ops);");    
    $sql = "insert into $table select client_id ";
    $sql .= "FROM $Conf::CLIENT_DB ";


    if($args{'client_name'}){
	if ($notfirst == 0){
	    $notfirst = 1;
	    $sql .= "WHERE client_name ~* '$args{'client_name'}' ";
	}else{
	    $sql .= "AND client_name ~* '$args{'client_name'}' ";
	}
    }

    if($args{'default_approved'} eq "y"){
	if ($notfirst == 0){
	    $notfirst = 1;
	    $sql .= "WHERE default_approved = 1 ";
	}else{
	    $sql .= "AND default_approved = 1 ";
	}
    }
    if($args{'default_approved'} eq "n"){
	if ($notfirst == 0){
	    $notfirst = 1;
	    $sql .= "WHERE default_approved = 0 ";
	}else{
	    $sql .= "AND default_approved = 0 ";
	}
    }
    if($args{'client_id'}){
	if ($notfirst == 0){
	    $notfirst = 1;
	    $sql .= "WHERE client_id = $args{'client_id'} ";
	}else{
	    $sql .= "AND client_id = $args{'client_id'} ";
	}
    }
    if($args{'default_bill_rate'}){
	if ($notfirst == 0){
	    $notfirst = 1;
	    $sql .= "WHERE default_bill_rate = $args{'default_bill_rate'} ";
	}else{
	    $sql .= "AND default_bill_rate = $args{'default_bill_rate'} ";
	}
    }

    $sql .= ";";
    $result = $dbconn->query("$sql");
    if(!$result){
	$oops = $dbconn->errorstring;
	&error("Error searching for clients: $oops", $sql);
    }

    return $table;
}

###############
# returns a indexed hash from the supplied temporary result table using 
# the supplied dbconn object.
#
# &get_job_search_result($dbconn, $table);
sub get_client_search_result
{
    my $dbconn = shift;
    my $table = shift;
    my %results;
    my $i = 0;

    my @list = $dbconn->list('client_id',$table);

    while ($i <= $#list){
	my $tempjob_id = $list[$i];
	$i++;
	$results{$i} = $tempjob_id;
    }
	return %results;
}



sub admin_show_client_form
{
    my %args = @_;
    my %yes_no_labels = ('y',' Yes','n',' No',); 
    my %vars;

    $vars{'client_id_widget'} = "$args{'client_id'}";

    $vars{'client_name_widget'} = textfield('-name'=>'client_name',
					    '-default'=>"$args{'client_name'}",
					    '-size'=>'25',
					    '-override'=>'1');

    $vars{'default_bill_widget'} = textfield('-name'=>'default_bill_rate',
                                             '-default'=>"$args{'default_bill_rate'}",
					     '-override'=>'1',
                                             '-size'=>'8');

    
    $vars{'default_approved_widget'} = popup_menu('-name'=>'default_approved',
						  '-values'=>['y','n'],
						  '-default'=>"$args{'default_approved'}",
						  '-linebreak'=>'true',
						  '-override'=>'1',
						  '-labels'=>\%yes_no_labels);
    
    &subprint_file("$Conf::CLIENT_EDIT_TMPL", \%vars);

    
    
}  




sub client_join{
    my $dbconn = shift;
    my $client_entry = shift;
    
    my $sql = "SELECT * ";
    $sql .= "FROM $Conf::CLIENT_DB WHERE ";
    $sql .= "client_id = $client_entry; ";
    
    my $sqlresult = $dbconn->query($sql);
    if(!$sqlresult){
	my $oops = $dbconn->errorstring;
	&error("Error getting client '$client_entry' join:: $oops", $sql);
    }
    my %client = $sqlresult->get_row(0);
    return %client;
}



sub print_client_commands
{
    my %state = @_;
    print "<TABLE BORDER=0>",
    "<TR VALIGN=\"top\">\n";
    print "<TD>",
    "<INPUT TYPE=\"image\" NAME=\"apply\" SRC=\"images/apply.gif\" BORDER=0>\n",
    "</TD>";
    
    # Print seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    
    print "<TD>\n",
    "<INPUT TYPE=\"image\" NAME=\"delete\" SRC=\"images/delete.gif\" BORDER=0>\n",
    "</TD>\n";

    # Print seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    print "<TD>";
    print "<INPUT TYPE=\"image\" NAME=\"search\" SRC=\"images/search.gif\" BORDER=0>\n",
    "</TD></TR>\n",
    "</TABLE>\n";
}



1;
