#!/usr/bin/perl
#
# updatejobs.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: updatejobs.cgi,v 1.6 2001/08/29 22:22:45 adam Exp $ 

use CGI qw(:standard);
use ADB;

require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';

# record the URL that wsused to generate the search that is
# submiting to us.
my $result_url = param('search_url');

my $dbconn = 0;

sub update_job_status {
    my $jid = shift;
    my $tempcurrent = shift;
    my $temptarget = shift;
    unless($dbconn) {
	$dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
	if(!$dbconn->is_ok){
	    $oops = $dbconn->errorstring;
	    &error("Failed connection to backend: $oops");
	}
    }
    my $current;
    $current = 0 if $tempcurrent eq 'closed';
    $current = 1 if $tempcurrent eq 'open';

    my $target;
    $target = 0 if $temptarget eq 'closed';
    $target = 1 if $temptarget eq 'open';

    # Set up our open and close dates properly
    my $date_sql;
    my $today = &dbdate_today;
    
    if($current != $target){
	if(!$target){
	    $date_sql = ", close_date = '$today' ";
	}else{
	    $date_sql = ", open_date = '$today' ";
	}
	my $sql = "UPDATE $Conf::JOB_DB set open = $target ";
	$sql .= $date_sql;
	$sql .= "WHERE job_id = $jid;";
	
	my $sqlresult = $dbconn->query($sql);
	if(!sqlresult) {
	    my $oops = $dbconn->errorstring;
	    &error("Update error for job '$jid': $oops", $sql);
	}
    }
}

foreach $name (param()) {
    my $job;
    my $status;
    my $changeto;
    if ($name =~ /job(\S*)status/) {
	$job = $1;
	$status = param( job . $job . status );
	$changeto = param( job . $job . set );
	unless($changeto) {
	    &error("Could not find desired state for job $job");
	}
	if($changeto && $status ne $changeto) {
	    &update_job_status($job, $status, $changeto);
	}
    }		
}

print redirect($result_url);
