// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepTools_ReShape_HeaderFile
#define _BRepTools_ReShape_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_BRepTools_ReShape_HeaderFile
#include <Handle_BRepTools_ReShape.hxx>
#endif

#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class TopoDS_Shape;


//! Rebuilds a Shape by making pre-defined substitutions on some <br>
//!          of its components <br>
class BRepTools_ReShape : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns an empty Reshape <br>
Standard_EXPORT BRepTools_ReShape();

//! Clears all substitutions requests <br>
Standard_EXPORT   void Clear() ;

//! Sets a request to Remove a Shape <br>
//!          If <oriented> is True, only for a shape with the SAME <br>
//!          orientation. Else, whatever the orientation <br>
Standard_EXPORT   void Remove(const TopoDS_Shape& shape,const Standard_Boolean oriented = Standard_False) ;

//! Sets a request to Replace a Shape by a new one <br>
//!          If <oriented> is True, only if the orientation is the same <br>
//!          Else, whatever the orientation, and the new shape takes the <br>
//!          same orientation as <newshape> if the replaced one has the <br>
//!          same as <shape>, else it is reversed <br>
Standard_EXPORT   void Replace(const TopoDS_Shape& shape,const TopoDS_Shape& newshape,const Standard_Boolean oriented = Standard_False) ;

//! Tells if a shape is recorded for Replace/Remove <br>
Standard_EXPORT   Standard_Boolean IsRecorded(const TopoDS_Shape& shape) const;

//! Returns the new value for an individual shape <br>
//!          If not recorded, returns the original shape itself <br>
//!          If to be Removed, returns a Null Shape <br>
//!          Else, returns the replacing item <br>
Standard_EXPORT   TopoDS_Shape Value(const TopoDS_Shape& shape) const;

//! Returns a complete substitution status for a shape <br>
//!          0  : not recorded,   <newsh> = original <shape> <br>
//!          < 0: to be removed,  <newsh> is NULL <br>
//!          > 0: to be replaced, <newsh> is a new item <br>
//!          If <last> is False, returns status and new shape recorded in <br>
//!          the map directly for the shape, if True and status > 0 then <br>
//!          recursively searches for the last status and new shape. <br>
Standard_EXPORT virtual  Standard_Integer Status(const TopoDS_Shape& shape,TopoDS_Shape& newsh,const Standard_Boolean last = Standard_False) ;

//! Applies the substitutions requests to a shape <br>
//! <br>
//!          <until> gives the level of type until which requests are taken <br>
//!          into account. For subshapes of the type <until> no rebuild <br>
//!          and futher exploring are done. <br>
//!          ACTUALLY, NOT IMPLEMENTED BELOW  TopAbs_FACE <br>
//! <br>
//!          <buildmode> says how to do on a SOLID,SHELL ... if one of its <br>
//!          sub-shapes has been changed: <br>
//!          0: at least one Replace or Remove -> COMPOUND, else as such <br>
//!          1: at least one Remove (Replace are ignored) -> COMPOUND <br>
//!          2: Replace and Remove are both ignored <br>
//!          If Replace/Remove are ignored or absent, the result as same <br>
//!          type as the starting shape <br>
Standard_EXPORT virtual  TopoDS_Shape Apply(const TopoDS_Shape& shape,const TopAbs_ShapeEnum until,const Standard_Integer buildmode) ;

//! Applies the substitutions requests to a shape. <br>
//! <br>
//!          <until> gives the level of type until which requests are taken <br>
//!          into account. For subshapes of the type <until> no rebuild <br>
//!          and futher exploring are done. <br>
Standard_EXPORT virtual  TopoDS_Shape Apply(const TopoDS_Shape& shape,const TopAbs_ShapeEnum until = TopAbs_SHAPE) ;

//!Returns (modifiable) the flag which defines whether Location of shape take into account <br>
//!         during replacing shapes. <br>
Standard_EXPORT   Standard_Boolean& ModeConsiderLocation() ;

//!Returns (modifiable) the flag which defines whether Orientation of shape take into account <br>
//!         during replacing shapes. <br>
Standard_EXPORT   Standard_Boolean& ModeConsiderOrientation() ;
//Standard_EXPORT ~BRepTools_ReShape();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Integer myStatus;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopTools_DataMapOfShapeShape myNMap;
TopTools_DataMapOfShapeShape myRMap;
Standard_Boolean myConsiderLocation;
Standard_Boolean myConsiderOrientation;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
