// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopClass_SolidExplorer_HeaderFile
#define _TopClass_SolidExplorer_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_Pnt;
class gp_Lin;
class TopoDS_Face;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provide an   exploration of a  BRep Shape   for the <br>
//!          classification. <br>
class TopClass_SolidExplorer  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Should  return  True  if the  point  is  outside a <br>
//!          bounding volume of the shape. <br>
Standard_EXPORT virtual  Standard_Boolean Reject(const gp_Pnt& P) const = 0;

//! Returns  in <L>, <Par>  a segment having at least <br>
//!          one  intersection  with  the  shape  boundary  to <br>
//!          compute  intersections. <br>
//! <br>
Standard_EXPORT virtual  void Segment(const gp_Pnt& P,gp_Lin& L,Standard_Real& Par)  = 0;

//! Returns  in <L>, <Par>  a segment having at least <br>
//!          one  intersection  with  the  shape  boundary  to <br>
//!          compute  intersections. <br>
//! <br>
//!          The First Call to this method returns a line which <br>
//!          point to a point of the first face of the shape. <br>
//!          The Second Call provide a line to the second face <br>
//!          and so on. <br>
//! <br>
//!          if the method is called N times on a shape with F <br>
//!          faces (N>F) the line point to other points on the <br>
//!          face 1,2,3 ... N <br>
Standard_EXPORT virtual  void OtherSegment(const gp_Pnt& P,gp_Lin& L,Standard_Real& Par)  = 0;

//! Starts an exploration of the shells. <br>
Standard_EXPORT virtual  void InitShell()  = 0;

//! Returns True if there is  a current shell. <br>
Standard_EXPORT virtual  Standard_Boolean MoreShells() const = 0;

//! Sets the explorer  to the  next  shell and  returns <br>
//!          False if there are no more wires. <br>
Standard_EXPORT virtual  void NextShell()  = 0;

//! Returns True  if the shell  bounding volume does not <br>
//!          intersect the segment. <br>
Standard_EXPORT virtual  Standard_Boolean RejectShell(const gp_Lin& L,const Standard_Real Par) const = 0;

//! Starts an exploration of the faces. <br>
Standard_EXPORT virtual  void InitFace()  = 0;

//! Returns True if there is  a current face. <br>
Standard_EXPORT virtual  Standard_Boolean MoreFaces() const = 0;

//! Sets the explorer  to the  next  face and  returns <br>
//!          False if there are no more wires. <br>
Standard_EXPORT virtual  void NextFace()  = 0;

//! Returns the current face. <br>
Standard_EXPORT virtual  TopoDS_Face CurrentFace() const = 0;

//! Returns True  if the face  bounding volume does not <br>
//!          intersect the segment. <br>
Standard_EXPORT virtual  Standard_Boolean RejectFace(const gp_Lin& L,const Standard_Real Par) const = 0;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
