// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _UnitsMethods_HeaderFile
#define _UnitsMethods_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Geom2d_Curve;
class Geom_Surface;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class UnitsMethods  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes the 3 factors for the conversion of <br>
//!          units <br>
Standard_EXPORT static  void InitializeFactors(const Standard_Real LengthFactor,const Standard_Real PlaneAngleFactor,const Standard_Real SolidAngleFactor) ;


Standard_EXPORT static  Standard_Real LengthFactor() ;


Standard_EXPORT static  Standard_Real PlaneAngleFactor() ;


Standard_EXPORT static  Standard_Real SolidAngleFactor() ;


Standard_EXPORT static  void Set3dConversion(const Standard_Boolean B) ;


Standard_EXPORT static  Standard_Boolean Convert3d() ;


Standard_EXPORT static  Handle_Geom2d_Curve RadianToDegree(const Handle(Geom2d_Curve)& C,const Handle(Geom_Surface)& S) ;


Standard_EXPORT static  Handle_Geom2d_Curve DegreeToRadian(const Handle(Geom2d_Curve)& C,const Handle(Geom_Surface)& S) ;


Standard_EXPORT static  Handle_Geom2d_Curve MirrorPCurve(const Handle(Geom2d_Curve)& C) ;

//! Returns value of unit encoded by parameter param <br>
//!          (integer value denoting unit, as described in IGES <br>
//!          standard) in millimeters <br>
Standard_EXPORT static  Standard_Real GetLengthFactorValue(const Standard_Integer param) ;

//! Returns value of current internal unit for CASCADE <br>
//!          in millemeters <br>
Standard_EXPORT static  Standard_Real GetCasCadeLengthUnit() ;

//! Sets value of current internal unit for CASCADE <br>
//!          by parameter param (integer value denoting unit, <br>
//!          as described in IGES standard) <br>
//!          GetCasCadeLengthUnit() will then return value <br>
//!          equal to GetLengthFactorValue(param) <br>
Standard_EXPORT static  void SetCasCadeLengthUnit(const Standard_Integer param) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
