<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/widgets.php");
include_once("./functions/utils.php");

//
// XML Export Plugin
//

/*
* The content type, when saved as file.
*/
function file_content_type()
{
	return "text/xml";
}

/*
* The filename extension, when saved as file.
*/
function file_extension()
{
	return "xml";
}

/*
* The file header, when saved as file.
*/
function file_header($title)
{
	return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n".
			"<!DOCTYPE opendb-items SYSTEM \"http://opendb.i-am-vegan.net/dtd/opendb-items.dtd\">\n\n".
			"<!--\n".
			"\t$title\n".
			"-->\n".
			"<opendb-items>";
}

/*
* The file footer, when saved as file.
*/
function file_footer()
{
	return "\n</opendb-items>\n";
}

function start_item($level, $item_id, $s_item_type, $title, $category)
{
	return "\n".tab_indent($level)."<item item_id=\"$item_id\" s_item_type=\"$s_item_type\" title=\"".escape_xml_entities($title)."\" category=\"".escape_xml_entities($category)."\">";
}

function end_item($level, $item_id)
{
	return "\n".tab_indent($level)."</item>";
}

function item_instance($level, $item_id, $instance_no, $owner_id, $borrow_duration, $s_status_type, $status_comment)
{
	return "\n".tab_indent($level)."<instance instance_no=\"$instance_no\" owner_id=\"$owner_id\" borrow_duration=\"$borrow_duration\" s_status_type=\"$s_status_type\" status_comment=\"".escape_xml_entities($status_comment)."\"/>";
}

function item_attribute($level, $item_id, $s_attribute_type, $order_no, $attribute_val)
{
	return "\n".tab_indent($level)."<attribute s_attribute_type=\"$s_attribute_type\" order_no=\"$order_no\">".
		"\n".tab_indent($level+1)."<![CDATA[".
		"\n".tab_indent_lines($level+1, $attribute_val).
		"".tab_indent($level+1)."]]>".
		"\n".tab_indent($level)."</attribute>";
}

function tab_indent_lines($level, $value)
{
	$buffer = "";
	$lines = explode_lines($value);
	if(is_not_empty_array($lines))
	{
		while(list(,$line) = each($lines))
		{
			$buffer .= tab_indent($level).$line."\n";
		}
	}
	return $buffer;
}

//utility functions
function tab_indent($level)
{
	if(is_numeric($level) && $level>0)
		return str_repeat("\t", $level);
	else
		return "";
}

function escape_xml_entities($str)
{
	return str_replaces(
				array("\"", "<", ">", "\n", "\r", "&"), // find
				array("&#34;", "&#60;", "&#62;", "&#10;", "&#13;", "&#38;"), // replace
				$str);
}
?>
