<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/function.php");
include_once("./functions/site.php");

function is_exists_item_type($s_item_type)
{
	if(strlen($s_item_type)>0)
	{
		$query = "SELECT 'x' FROM s_item_type WHERE s_item_type = '".$s_item_type."'";
		$result = run_opendb_query($query);
		if($result && mysql_num_rows($result)>0)
		{
			mysql_free_result($result);
			return TRUE;
		}
	}
	//else
	return FALSE;
}

/*
* In order to be considered a valid s_item_type structure, several 
* s_item_attribute_type records must exist with specific s_field_type's 
* underneath it.
* 
* We are not checking that TITLE s_field_type s_item_attribute_type
* mandatory_ind is set to 'Y', because item_input.php will enforce
* that itself.  All we care about is that the item_type is actually
* structured well enough that it will work within item_input.php to
* add new records.
*/
function is_valid_item_type_structure($s_item_type)
{
	global $CONFIG_VARS;
	
	if(is_exists_item_type($s_item_type))
	{
		if(fetch_sfieldtype_item_attribute_type($s_item_type, 'TITLE'))
		{
			if(fetch_sfieldtype_item_attribute_type($s_item_type, 'STATUSTYPE'))
			{
				if(fetch_sfieldtype_item_attribute_type($s_item_type, 'STATUSCMNT'))
				{
					if(fetch_sfieldtype_item_attribute_type($s_item_type, 'CATEGORY'))
					{
						if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE)
						{
							if(fetch_sfieldtype_item_attribute_type($s_item_type, 'DURATION'))
							{
								// At this point all the required s_field_type mappings have been
								// provided.
								return TRUE;
							}
							else //if(fetch_sfieldtype_item_attribute_type($s_item_type, 'DURATION'))
							{
								return FALSE;
							}
						}
						else //No borrow duration functionality enabled.
						{
							// At this point $borrow functionality is not enabled, so we do not
							// have to do anymore testing.
							return TRUE;
						}
					}
					else //if(fetch_sfieldtype_item_attribute_type($s_item_type, 'CATEGORY'))
					{
						return FALSE;
					}
				}
				else//if(fetch_sfieldtype_item_attribute_type($s_item_type, 'STATUSCMNT'))
				{
					return FALSE;
				}					
			}
			else //if(fetch_sfieldtype_item_attribute_type($s_item_type, 'STATUSTYPE'))
			{
				return FALSE;
			}
		}
		else //if(fetch_sfieldtype_item_attribute_type($s_item_type, 'TITLE'))
		{
			return FALSE;
		}
	}
	else //if(is_exists_item_type($s_item_type))
	{
		return FALSE;
	}
}

/*
  This function will return a <img src="" alt=""> tag if the
  image field is defined, or FALSE if not defined.  Will not
  actually check if the image exists.   It assumes that if
  you have defined an image it does exist. 
*/
function fetch_item_type_image($s_item_type)
{
	$query = "select image from s_item_type where s_item_type = '".$s_item_type."'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		if ($found)
		{
			mysql_free_result($result);
			if(strlen($found['image'])>0)
				return $found['image'];
		}
	}
	
    //else
	return FALSE;
}

/**
	Fetch the default item site type value.  This does not
	take into account any mappings to other types.
*/
function fetch_item_type_sitetype($s_item_type)
{
	$query = "select default_site_type from s_item_type where s_item_type = '$s_item_type'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
        if ($found)
		{
			mysql_free_result($result);
			return $found['default_site_type'];
		}
	}
	
    //else
	return FALSE;
}

function fetch_sfieldtype_item_attribute_type($s_item_type, $s_field_type)
{
	$attribute_type_r = fetch_sfieldtype_item_attribute_type_rs($s_item_type, $s_field_type);
	if($attribute_type_r)
		return $attribute_type_r['s_attribute_type'];
	else
		return FALSE;
}

function fetch_sfieldtype_item_attribute_type_r($s_item_type, $s_field_type, $all_columns=FALSE)
{
	return fetch_sfieldtype_item_attribute_type_rs($s_item_type, $s_field_type, $all_columns);
}

/*
 * Fetch the s_field_type s_attribute_type.
 * 
 * @param $all_records Specifies if we want to return all of the matches,
 * or only the first one.
 * 
 * Note assumes that the $s_field_type has been specified UPPERCASE!
*/
function fetch_sfieldtype_item_attribute_type_rs($s_item_type, $s_field_type, $all_columns=FALSE, $all_records=FALSE)
{
	$query = "SELECT siat.s_attribute_type, ".
			"siat.order_no, ".
			"sat.s_field_type ";
	
	if($all_columns)
	{
		$query .= ", if(length(siat.prompt)>0,siat.prompt,sat.prompt) as prompt,".
				"sat.description,". 
                "sat.input_type,".
                "sat.display_type ";
	}
	
	if(is_array($s_field_type))
		$sfieldtype_clause = "UPPER(sat.s_field_type) IN (".format_sql_in_clause($s_field_type).")";
	else if(strlen($s_field_type)>0)
		$sfieldtype_clause = "UPPER(sat.s_field_type) = '$s_field_type'";
	else
		$sfieldtype_clause = "LENGTH(IFNULL(sat.s_field_type,''))>0";
		
	$query .= "FROM s_item_attribute_type siat, s_attribute_type sat ".
			"WHERE siat.s_attribute_type = sat.s_attribute_type AND $sfieldtype_clause AND ".
			"siat.s_item_type = '$s_item_type' ".
			"ORDER BY order_no asc";

	// Only get one record in this case.			
	if(!$all_records)
		$query .= " LIMIT 0,1";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		if(!$all_records)
		{
			$found = mysql_fetch_array($result, MYSQL_ASSOC);
			mysql_free_result($result);
			return $found;
		}
		else // return all the records as a resultset.
			return $result;			
	}
	
    //else
	return FALSE;
}

/**
  @param is_loookup.  Indicates we are using this as a lookup result, so the s_item_type
  needs to be named "value" and the description needs to be named "display"
*/
function fetch_item_type_rs($is_lookup = FALSE)
{
	$query = "select s_item_type ".($is_lookup?"as value":"").", description ".($is_lookup?"as display":"")." from s_item_type order by order_no, s_item_type";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

//
// Return an item_record.  Currently this is:description, image, default_site_type
//
function fetch_item_type_r($s_item_type)
{
	// Assumes that the language.php has been included by calling script.
	global $LANG_VARS;

	$query = "select description, image, default_site_type from s_item_type where s_item_type = '$s_item_type'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

/*
	Will fetch a resultset of all s_item_types for a particular site_type.  
	
	Will set the s_item_type as value and description as display so 
	they can be used seemlessly in single_select call.
*/
function fetch_site_item_type_rs($site_type)
{
	$query = "select	DISTINCT sit.s_item_type as value,".
						"sit.description as display, ".
						"sit.order_no ".
						"from s_item_type sit,".
						"s_attribute_type sat,".
						"s_item_attribute_type siat ".
				"where 	sit.s_item_type = siat.s_item_type AND ".
						"sat.s_attribute_type = siat.s_attribute_type AND ".
						"sat.site_type = '".$site_type."' ".
						"order by 3,1";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/*
	Will return an array of all site-plugins that are compatible with the s_item_type.
	It is returned as an array instead of a resultset to be compatible with the filesystem
    based get_site_type_r() function in site.php.
*/
function fetch_site_type_rs($s_item_type)
{
	$query = 	"SELECT	DISTINCT sat.site_type ".
				"FROM	s_attribute_type sat,".
						"s_item_attribute_type siat ".
				"WHERE 	sat.s_attribute_type = siat.s_attribute_type AND ".
                		"length(sat.site_type)>0 AND ".
						"siat.s_item_type = '".$s_item_type."' ".
						"order by 1";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
    {
		while($site_type_r = mysql_fetch_array($result, MYSQL_ASSOC))
			$site_type[] = $site_type_r['site_type'];

        return $site_type;
	}        
	else
		return FALSE;
}

/*
	Checks if an s_item_type has any site plugins linked to it.
*/
function is_item_legal_site_type($s_item_type)
{
	$query = 	"select	sat.site_type ".
				"from 	s_attribute_type sat,".
				"		s_item_attribute_type siat ".
				"where 	sat.s_attribute_type = siat.s_attribute_type AND ".
                		"length(sat.site_type)>0 AND ".
						"siat.s_item_type = '".$s_item_type."'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		while($site_type_r = mysql_fetch_array($result, MYSQL_ASSOC))
		{
			if(is_legal_site($site_type_r['site_type']))
			{
				mysql_free_result($result);
				return TRUE;
			}
		}

		mysql_free_result($result);
	}

	//else
	return FALSE;
}

/*
	Checks if an s_item_type has any site plugins linked to it.
*/
function is_item_site_type($s_item_type)
{
	$query = 	"select	'X' ".
				"from 	s_attribute_type sat,".
				"		s_item_attribute_type siat ".
				"where 	sat.s_attribute_type = siat.s_attribute_type AND ".
                		"length(sat.site_type)>0 AND ".
						"siat.s_item_type = '".$s_item_type."' ".
						"LIMIT 0,1";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		// The very fact that at least one row was returned indicates that owner
		// has at least one instance of item.
		return TRUE;
	}

	//else
	return FALSE;
}
?>
