<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/item.php");
include_once("./functions/item_type.php");
include_once("./functions/widgets.php");
include_once("./functions/user.php");
include_once("./functions/utils.php");
include_once("./functions/status_type.php");
include_once("./functions/item_input.php");

//---------------------------------------------------
function check_dvddbp_user()
{
	if( count_fields("user")<7)
		return true;
	else
		return false;
}

//---------------------------------------------------
// Check if any old tables are still present
function old_tables_exist()
{
	if( check_table("dvd",FALSE) || check_table("comments",FALSE) || check_table("olduser",FALSE) )
		return true;
	else
		return false;

}

//---------------------------------------------------
// Check if all the new tables are present
function new_tables_exist()
{
	return (check_table("borrowed_item",FALSE) && check_table("item",FALSE) && check_table("item_instance",FALSE) &&
			check_table("item_attribute",FALSE) && check_table("review",FALSE) && check_table("s_attribute_type",FALSE) &&
			check_table("s_attribute_type_lookup",FALSE) && check_table("s_item_attribute_type",FALSE) &&
			check_table("s_item_type",FALSE) && check_table("user",FALSE));
}

//---------------------------------------------------
// Used to convert "Friday, 23 of January 2001" type datestring into integer timestamp
function get_comment_date_as_timestamp($comment_date)
{
	// Get rid of the ", " and " of " so sscanf will have an easier time of it!
	$comment_date = str_replace(", ", " ", $comment_date);
	$comment_date = str_replace(" of ", " ", $comment_date);

	// Now extract the elements of the date.
	list($dayword, $day, $month, $year) = sscanf($comment_date,"%s %d %s %d");

	//Finally convert to Timestamp.  Format is:YYYYMMDDHHMMSS
	// Defaults to 12:00 midday.
	$timestamp = date("Ymd", strtotime("$day $month $year"))."120000";

	// Now return the darn thing.
	return $timestamp;
}

//---------------------------------------------------
// Used to insert a review based from "old comment" type data
function add_review($item_id, $author_id, $comment, $rating, $comment_date)
{   
	// convert the date.
	$update_on = get_comment_date_as_timestamp($comment_date);

	$query="INSERT INTO review (item_id,author_id,comment,rating,update_on)".
			"VALUES ('".$item_id."',".
					"'".$author_id."',".
					"'".addslashes($comment)."',".
					"'".$rating."',".
					"'".$update_on."')";

	$insert = run_opendb_query($query,FALSE);
	if (mysql_affected_rows() > 0)
	{
		opendb_log("PATCH: $author_id inserted review (id=$item_id)");
		return true;
	}else{
		opendb_log("PATCH: $author_id failed to insert review. (".mysql_error().")");
		return false;
	}
}

//---------------------------------------------------
// Local version of insert_user (beats unencrypting/re-encrypting pass and preserves lastvisit)
function add_user($uid, $fullname, $pwd, $type, $location, $email, $language, $theme, $lastvisit)
{
	$query="INSERT INTO user (user_id,fullname,pwd,type,location,email,language,theme,lastvisit)".
				"VALUES('".strtolower($uid)."',".
						"'".addslashes($fullname)."',".
						"'".$pwd."',".
						"'".ifempty($type,'N')."',".
						"'".addslashes($location)."',".
						"'".addslashes($email)."',".
						"'".addslashes($language)."',".
						"'".addslashes($theme)."',".
						"'".$lastvisit."')";
	$insert = run_opendb_query($query,FALSE);
	if(mysql_affected_rows()>0)
	{
		opendb_log("PATCH: inserted user $uid.");
		return true;
	}
	else
	{
		opendb_log("PATCH: failed to insert user $uid. (".mysql_error().")");
		return false;
	}
}

//---------------------------------------------------
function do_droptable($table)
{
	if(!check_table($table,FALSE))
	{
		print("<div class=\"upgrade_warning\">DVDDBp ".strtoupper($table)." table has already been dropped.</div><br>\n");
		return true;
	}

	print("<!-- DROP TABLE IF EXISTS $table; -->\n");
	$query  = "DROP TABLE IF EXISTS $table;";
	$result = run_opendb_query($query,FALSE);
	if($result)
	{
		print("<div class=\"upgrade_success\">DVDDBp ".strtoupper($table)." table has been dropped successfully.</div><br>\n");
		opendb_log("PATCH: Dropped old 1.45 database table $table");
		return true;
	}
	else
	{
		print("<div class=\"upgrade_failure\">Unable to drop DVDDBp ".strtoupper($table)." table!</div><br>\n");
		opendb_log("PATCH: Unable to drop old 1.45 database table $table");
		return false;
	}
}

//---------------------------------------------------
// Upload sql\opendb.sql to build new database tables
function build_new_tables($from) 
{
	global $PHP_SELF;
?>
	<h3>Create tables for new database format:</h3>

	<p class="colortext">
	<B>To create tables click on the GO button below:</B>
	</p>
	
	<FORM Action="<?php echo $PHP_SELF; ?>" method="POST">
	<p><DIV CLASS="error">* <U>Note</U> If you want to configure your OpenDb installation for a different country and/or language, please
	run the 'International Language' or 'Customise for Country' patch after completing this upgrade.</DIV></p>
	<BR>
	<INPUT TYPE="HIDDEN" NAME="op" VALUE="result">
	<INPUT TYPE="HIDDEN" NAME="from" VALUE="<?php echo $from; ?>">
	<INPUT TYPE="SUBMIT" NAME="evalUpload" VALUE="**  Go!  **">
	</FORM>
<?php
}

//---------------------------------------------------
// Convert old user table to new user format
function upgrade_user_table($from) 
{
	global $PHP_SELF;
	
	echo( "<h3>Upgrade User Table:</h3>\n" );
	echo( "<p class=\"colortext\">\n" );
	echo( "<B>To convert your old DVDDBp tables to the new user format, click on the GO button below:</B>\n" );
	echo( "</p>\n");
	
	echo( "<FORM action=\"$PHP_SELF\" method=\"POST\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"op\" VALUE=\"result\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"from\" VALUE=\"$from\">\n" );
	echo( "<INPUT TYPE=\"SUBMIT\" NAME=\"evalUser\" VALUE=\"**  Go!  **\">\n" );
	echo( "</FORM>\n");
}

function backup_user_table($from) 
{
	global $PHP_SELF;

	echo( "<h3>Backup User Table:</h3>\n");

	echo( "<p class=\"colortext\">\n" );
	echo( "<B>To backup your old DVDDBp tables, click on the GO button below:</B>\n" );
	echo( "</p>\n");
	
	echo( "<FORM action=\"$PHP_SELF\" method=\"POST\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"op\" VALUE=\"result\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"from\" VALUE=\"$from\">\n" );
	echo( "<INPUT TYPE=\"SUBMIT\" NAME=\"evalBackupUser\" VALUE=\"**  Go!  **\">\n" );
	echo( "</FORM>\n");
}

//---------------------------------------------------
// Convert old comments table to new review format
function upgrade_comments_table($from) 
{
	global $PHP_SELF;

	echo( "<h3>Upgrade Comments Table:</h3>\n");

	echo( "<p class=\"colortext\">\n" );
	echo( "<B>To convert your old DVDDBp tables to the new review format, click on the GO button below:</B>\n" );
	echo( "</p>\n");
	
	echo( "<FORM Action=\"$PHP_SELF\" Method=\"POST\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"op\" VALUE=\"result\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"from\" VALUE=\"$from\">\n" );
	echo( "<INPUT TYPE=\"SUBMIT\" NAME=\"evalComments\" VALUE=\"**  Go!  **\">\n" );
	echo( "</FORM>\n");
}

//---------------------------------------------------
// Convert old dvd table to new item format
function upgrade_dvd_table($from) 
{
	global $PHP_SELF;

	echo( "<h3>Upgrade DVD Table:</h3>");

	echo( "<FORM Action=\"$PHP_SELF\" Method=\"POST\">\n" );
	echo( "<TABLE BORDER=0 FRAMEBORDER=0 CELLSPACING=1>\n" );

	// jpell: do not need to specify order_no, as the fields only occur once.
	echo get_input_field(get_field_name("DVD_REGION"), "DVD_REGION", "Region", "checkbox_grid(%value% - %display%, 1)", "N");
	echo get_input_field(get_field_name("RATIO"), "RATIO", "Aspect Ratio", "checkbox_grid(%value%, *)", "N");
	echo get_input_field(get_field_name("VID_FORMAT"), "VID_FORMAT", "Video Format", "single_select(%value%)", "N");
   	echo( "</TABLE>\n" );
	
	echo( "<p class=\"colortext\">\n" );
	echo( "The upgrade process will convert the 'status' column to a matching s_status_type of either <b>'A' - Active</b> (status=A) or ".
		"<b>'N' - Not Active</b> (status=U).  The 'location' dvd value, will be transferred across to the status_comment, for 'U' status' only. ".
		"<br><br><B>To convert your old DVDDBp tables to the new item format, click on the GO button below:</B>\n" );
	echo( "</p>\n");
	
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"op\" VALUE=\"result\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"from\" VALUE=\"$from\">\n" );
	echo( "<INPUT TYPE=\"SUBMIT\" NAME=\"evalDVD\" VALUE=\"**  Go!  **\">\n" );
	echo( "</FORM>\n");
}

//---------------------------------------------------
// Drop old dvd, comments, olduser tables
function drop_old_tables($from) 
{
	global $PHP_SELF;

	echo( "<h3>Drop old tables:</h3>\n");

	echo( "<p class=\"colortext\">\n" );
	echo( "<B>To drop your old DVDDBp tables, click on the GO button below:</B>\n" );

	echo( "<br><br><DIV CLASS=\"error\">\n");
    echo( "* <u>Note</u> that dropping the table means that your old tables will be erased and destroyed,\n");
    echo( " so you may want to <a href=\"index.php\" target=\"_blank\">Login to OpenDb</a> and check the listings\n");
	echo( " just to be certain that the conversion process worked first!</div><br>\n");
	echo( "</DIV></p>\n");
	
	echo( "<FORM Action=\"$PHP_SELF\" Method=\"POST\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"op\" VALUE=\"result\">\n" );
	echo( "<INPUT TYPE=\"HIDDEN\" NAME=\"from\" VALUE=\"$from\">\n" );
	echo( "<INPUT TYPE=\"SUBMIT\" NAME=\"evalDrop\" VALUE=\"**  Go!  **\">\n" );
	echo( "</FORM>\n");
}

// Evaluate a backup_user table (DVDDBp old user table)
function eval_backup_user()
{
//      Old Structure:
//	CREATE TABLE user (
//	   name varchar(20) NOT NULL,     [0]
//	   pwd varchar(40) NOT NULL,      [1]
//	   type char(1) NOT NULL,         [2]
//	   location varchar(50) NOT NULL, [3]
//	   email varchar(50) NOT NULL,    [4]
//	   lastvisit datetime NOT NULL,   [5]
//	   UNIQUE name (name)
//	);

	echo( "<p class=\"querytitle\">Backing up old user table...</p>\n" );

	// make sure olduser table doesn't already exist
	if( !check_table("olduser",FALSE) )
	{
		// rename user-> olduser for backup
		$result = run_opendb_query("ALTER TABLE user RENAME AS olduser",FALSE);
		if($result)
		{
			echo( "<DIV CLASS=\"upgrade_success\">User table backed up as \"olduser\"</DIV>\n" );
			opendb_log("PATCH: Renamed old \"user\" table as \"olduser\" for backup");
			return TRUE;
		}
		else
		{
			echo( "<DIV CLASS=\"upgrade_failure\">Unable to backup user table as \"olduser\" (".mysql_error().")</DIV>\n" );
			opendb_log("PATCH: Unable to rename old \"user\" table as \"olduser\" for backup");
			return FALSE;
		}
	}
	else
		echo( "<div class=\"upgrade_warning\">Backup table \"olduser\" already exists, not doing backup of current user table</div>\n" );

	return TRUE;
}	

//---------------------------------------------------
// Evaluate a convert user command
function eval_user()
{
//      Old Structure:
//	CREATE TABLE user (
//	   name varchar(20) NOT NULL,     [0]
//	   pwd varchar(40) NOT NULL,      [1]
//	   type char(1) NOT NULL,         [2]
//	   location varchar(50) NOT NULL, [3]
//	   email varchar(50) NOT NULL,    [4]
//	   lastvisit datetime NOT NULL,   [5]
//	   UNIQUE name (name)
//	);
	// now migrate the olduser data into new user table

?>
	<p class="querytitle">Converting user to new user table format...</p>

	<TABLE WIDTH=95% CELLSPACING=1 Border=1>
	<TR>
	<TH>#</TH>
	<TH>Username</TH>
	<TH>Type</TH>
	<TH>Location</TH>	
	<TH>Email</TH>
	</TR>	
<?php

	$result = run_opendb_query("SELECT name,pwd,type,location,email,lastvisit FROM olduser", FALSE);
	$i = 0;
	$succ = 0; $fail = 0;

	while( $user_r = mysql_fetch_array($result) ) // fetch table data one row at a time
	{
		//$uid, $fullname, $pwd, $type, $location, $email, $language, $theme, $lastvisit
		if( add_user($user_r['name'], $user_r['name'], $user_r['pwd'], $user_r['type'], $user_r['location'], $user_r['email'], '', '', $user_r['lastvisit']) )
		{		
			print("<TR class=\"upgrade_success\">");
			$succ++;
		}		
		else
		{
			print("<TR class=\"upgrade_failure\">");
			$fail++;
		}
		
		$i++;
		print("<TD>$i</TD>");                         			// #
		print("<TD>".$user_r['name']."</TD>");                	// username
		print("<TD align=\"center\">".$user_r['type']."</TD>");	// type
		print("<TD>".$user_r['location']."</TD>");              // location
		print("<TD>".$user_r['email']."</TD>");                 // email
		
		print("</TR>\n");
	}

	// SHOW RESULTS OF OPERATION
	print("<CAPTION>\n");
	print("<div class=\"upgrade_success\">Converted $succ user(s) to new format</div>\n");
	//No need to display unless a failure actually occurred.
	if($fail>0)
		print("<div class=\"upgrade_failure\">There were $fail failures!</div>\n");
	print("<br>");
	print("</CAPTION>\n");
	print("</TABLE>\n");
	
}

//---------------------------------------------------
// Evaluate a convert comments command
function eval_comments()
{
//      Old Structure:
//	CREATE TABLE comments (
//	  title varchar(100) NOT NULL,   [0]
//	  author varchar(50) NOT NULL,   [1]
//	  date varchar(40),              [2]
//	  comment text,                  [3]
//	  rating char(1) NOT NULL        [4]
//	);

	if( !check_table("review",FALSE) )
	{
		echo( "<DIV CLASS=\"error\">Review table doesn't exist!\nYou need to run \"Create Tables\"!</DIV>" );
		return;
	}
	?>

	<p class="querytitle">Converting comments to review...</p>

	<TABLE WIDTH=95% CELLSPACING=1 Border=1>
	<TR>
	<TH>#</TH>
	<TH>Author</TH>
	<TH>Title</TH>
	<TH>Comment (excerpt)</TH>	
	<TH>Rating</TH>
	</TR>	
<?php
	$result = run_opendb_query("SELECT title,author,date,comment,rating FROM comments",FALSE);
	$i = 0;
	$succ = 0; $fail = 0;

	while( $review_r=mysql_fetch_array($result) ) // fetch table data one row at a time
	{
		// Set to all lowercase here.
		$review_r['author'] = strtolower($review_r['author']);

		// We have to insert a review record for each title, even if duplicates.
		$query2 = "select i.id,i.title from item i where i.title = '".$review_r['title']."' order by i.id";
		$result2 = run_opendb_query($query2,FALSE);
		while($item_r = mysql_fetch_array($result2))
		{
			// note that "date" is actually converted to update_on for insert into review table.
			if(add_review($item_r['id'], $review_r['author'], $review_r['comment'], $review_r['rating'], $review_r['date']))
			{		
				print("<TR class=\"upgrade_success\">");
				$succ++;
			}		
			else
			{
				print("<TR class=\"upgrade_failure\">");
				$fail++;
			}
		
			$i++;
			print("<TD>$i</TD>");                      // #
			print("<TD>".$review_r['author']."</TD>"); // owner
			print("<TD>".$item_r['title']."(id=".$item_r['id'].")</TD>"); // title
			print("<TD>".excerpt($review_r['comment'],20)."</TD>"); // comment substring
			print("<TD>".$review_r['rating']."</TD>");	// rating
		
			print("</TR>\n");
		}
	}

	// SHOW RESULTS OF OPERATION
	print("<CAPTION>\n");
	print("<div class=\"upgrade_success\">Converted $succ review(s) to new format</div>\n");
	//No need to display unless a failure actually occurred.
	if($fail>0)
		print("<div class=\"upgrade_failure\">There were $fail failures!</div>\n");
	print("<br>");
	print("</CAPTION>\n");
	print("</TABLE>\n");
}

//---------------------------------------------------
// Evaluate a convert dvd command
function eval_dvd($region, $ratio, $format)
{
//      Old Structure:
// CREATE TABLE dvd (
//   owner varchar(50) NOT NULL,   [0]
//   status char(1),               [1]
//   location varchar(50),         [2]
//   title varchar(100),           [3]
//   actors text,                  [4]
//   director varchar(100),        [5]
//   year varchar(4),              [6]
//   length varchar(6),            [7]
//   description text,             [8]
//   languages text,               [9]
//   subtitles text,               [10]
//   id varchar(40) NOT NULL,      [11]
//   age varchar(5) NOT NULL,      [12]
//   genre varchar(20) NOT NULL,   [13]
//   imagetag text NOT NULL,       [14]
//   options text,                 [15]
//   PRIMARY KEY (id),
//   UNIQUE id (id)
//);

	if( !check_table("item",FALSE) || !check_table("item_attribute",FALSE) || !check_table("item_instance",FALSE))
	{
		echo( "<DIV CLASS=\"error\">Item table doesn't exist!\nYou need to run \"Create Tables\"!</DIV>" );
		return;
	}

?>
	<p class="querytitle">Converting dvd to item...</p>

	<TABLE WIDTH=95% CELLSPACING=1 Border=1>
	<TR>
	<TH>id</TH>
	<TH>Movie</TH>
	<TH>Owner</TH>
	<TH>Status Type</TH>
	<TH>Status Comment</TH>
	<TH>Genre</TH>	
	</TR>	
<?php
	$result = run_opendb_query("SELECT owner,status,location,title,actors,director,year,length,description,languages,subtitles,id,age,genre,imagetag,options FROM dvd",FALSE);
	$succ = 0; $fail = 0;
	
	echo( "<!-- DEFAULTS ARE: Region=$region, Ratio=$ratio, Format=$format, Media=DVD -->\n" );

	while( $dvd_item_r = mysql_fetch_array($result) ) // fetch table data one row at a time
	{
		// Set to all lowercase here.
		$dvd_item_r['owner'] = strtolower($dvd_item_r['owner']);

		$genre = $dvd_item_r['genre'];

		if($genre=='Music.')
			$genre='Music';

		if($dvd_item_r['status'] == 'U')
		{
			$s_status_type = 'N';
			$status_comments = $dvd_item_r['location'];
		}
		else
		{
			$s_status_type = 'A';
			$status_comments = NULL;
		}
		
		if(is_newitem_status_type_valid($dvd_item_r['owner'], fetch_status_type_r($s_status_type), $errors))
		{	
			$add_id = insert_item(NULL, "DVD", $dvd_item_r['title'], $genre, $dvd_item_r['owner']);
			
			// DID WE INSERT THE ITEM SUCCESSFULLY?
			if($add_id!==FALSE && insert_newitem_instance($add_id, $s_status_type, $status_comments, NULL, $dvd_item_r['owner']))
			{
				print("<TR class=\"upgrade_success\">");
				$succ++;
			
				insert_item_attribute($add_id, 'DVD_REGION', '100', $region);
				insert_item_attribute($add_id, 'RATIO', '110', $ratio);		  
				insert_item_attribute($add_id, 'VID_FORMAT', '120', $format);
			
				if(!empty($dvd_item_r['description'])) insert_item_attribute($add_id, 'MOVIE_PLOT', '10', $dvd_item_r['description']);
				if(!empty($dvd_item_r['actors'])) insert_item_attribute($add_id, 'ACTORS', '30', $dvd_item_r['actors']);
				if(!empty($dvd_item_r['age'])) insert_item_attribute($add_id, 'AGE_RATING', '90', $dvd_item_r['age']);
				if(!empty($dvd_item_r['director'])) insert_item_attribute($add_id, 'DIRECTOR', '20', $dvd_item_r['director']);
				if(!empty($dvd_item_r['year'])) insert_item_attribute($add_id, 'YEAR', '50', $dvd_item_r['year']);
				// The 'http://' prefix is being added as part of 0.37
				if(!empty($dvd_item_r['imagetag'])) insert_item_attribute($add_id, 'IMAGEURL', '0', "http://".$dvd_item_r['imagetag']);			
				if(!empty($dvd_item_r['length'])) insert_item_attribute($add_id, 'RUN_TIME', '60', $dvd_item_r['length']);
				if(!empty($dvd_item_r['languages'])) insert_item_attribute($add_id, 'AUDIO_LANG', '70', strtoupper($dvd_item_r['languages']));
				if(!empty($dvd_item_r['subtitles'])) insert_item_attribute($add_id, 'SUBTITLES', '80', strtoupper($dvd_item_r['subtitles']));
				if(!empty($dvd_item_r['options'])) insert_item_attribute($add_id, 'DVD_EXTRAS', '130', $dvd_item_r['options']);

				opendb_log("PATCH: Migrating 1.45 DVD table to item table");
				
				print("<TD>$add_id</TD>");  // id#
				print("<TD>".$dvd_item_r['title']."</TD>");  // title column
				print("<TD>".$dvd_item_r['owner']."</TD>");  // owner
				print("<TD>".ifempty($s_status_type,'&nbsp;')."</TD>");  // owner
				print("<TD>".ifempty($status_comments,'&nbsp;')."</TD>");  // owner
				print("<TD>".ifempty($genre,'&nbsp;')."</TD>");   // genre
			}
			else
			{
				print("<TR class=\"upgrade_failure\">");
				
				if($add_id!==FALSE)
				{
					print("<TD>$add_id</TD>");  // id#
					print("<TD colspan=5>Item Instance insert failed</TD>");  // title column
				}
				else
				{
					print("<TD colspan=6>Item insert failed</TD>");  // title column
				}
				$fail++;
			}
		}
		else // if(is_newitem_status_type_valid($owner_id, $new_status_type_r, $errors))
		{
			print("<TR>");
			print("<TD colspan=6>".format_error_block($errors)."</TD>");  // title column
			$fail++;
		}

		print("</TR>\n");
	}

	// SHOW RESULTS OF OPERATION
	print("<CAPTION>\n");
	print("<div class=\"upgrade_success\">Converted $succ item(s) to new format</div>\n");
	//No need to display unless a failure actually occurred.
	if($fail>0)
		print("<div class=\"upgrade_failure\">There were $fail failures!</div>\n");
	print("<br>");
	print("</CAPTION>\n");
	print("</TABLE>\n");
}

//---------------------------------------------------
// Evaluate a drop old table command
function eval_drop()
{
	echo("<p class=\"querytitle\">Dropping old DVDDBp tables...</p>\n");
	
	// DROP DVD
	do_droptable("dvd");

	// DROP COMMENTS
	do_droptable("comments");

	// DROP OLDUSER
	do_droptable("olduser");
}

//---------------------------------------------------
// This is important for security reasons.
if($CONFIG_VARS['patch.enable']===TRUE && isset($HTTP_VARS['from']))
{
	if($HTTP_VARS['op'] == "menu")
	{
	?>
		<?php
		echo("<div class=\"colortext\" align=\"center\">");
		if(strlen($CONFIG_VARS['db_server.table_prefix'])==0)
		{
			echo("<form action=\"$PHP_SELF\" method=\"get\" target=\"main\">");
			print_button("doBackupUser", "1. Backup User Table", !check_dvddbp_user() || check_table("olduser",FALSE));
			print_button("doNew", "2. Create Tables", new_tables_exist() || !check_table("olduser",FALSE));
			print_button("doUser", "3. Upgrade DVDDBp Users", !new_tables_exist() || !check_table("olduser",FALSE) || count_table_records("olduser",FALSE) === count_table_records("user",FALSE));
			print_button("doDvd", "4. Upgrade DVDDBp DVD", !check_table("dvd",FALSE) || !new_tables_exist() || count_table_records("dvd",FALSE) === count_table_records("item",FALSE));
			print_button("doComments", "5. Upgrade DVDDBp Comments", !check_table("comments",FALSE) || !new_tables_exist() || count_table_records("comments",FALSE)===0 || count_table_records("review",FALSE)>0 || count_table_records("dvd",FALSE) !== count_table_records("item",FALSE));
			print_button("doDrop", "6. Drop DVDDBp Tables", !old_tables_exist() || !new_tables_exist());
			echo("<input type=\"hidden\" name=\"op\" value=\"main\">");
			echo("<input type=\"hidden\" name=\"from\" value=\"".$HTTP_VARS['from']."\">");
			echo("</form>");
		}	
		else
		{
			echo("The include/config.php variable <b>\$CONFIG_VARS['db_server.table_prefix']</b> <i>must not</i> be defined.");
		}
		echo("</div>");
		?>

		<p class="colortext">
			<b>Note: </b>
			<ol>
				<li>Please follow the steps in their numbered order!</li>
			</ol>
		</p>
	<?php
	}
	else if( $HTTP_VARS['op'] == "main" ) // This is the operation that allows user to configure how they are going to run result operation!
	{
		if($HTTP_VARS['doBackupUser'])
		{
			backup_user_table($HTTP_VARS['from']);
		}			
		else if($HTTP_VARS['doNew'])
		{
			build_new_tables($HTTP_VARS['from']);
		}			
		else if($HTTP_VARS['doUser'])
		{
			upgrade_user_table($HTTP_VARS['from']);
		}			
		else if($HTTP_VARS['doDvd'])
		{
			upgrade_dvd_table($HTTP_VARS['from']);
		}			
		else if($HTTP_VARS['doComments'])
		{
			upgrade_comments_table($HTTP_VARS['from']);
		}			
		else if($HTTP_VARS['doDrop'])
		{
			drop_old_tables($HTTP_VARS['from']);
		}			
	}
	else if( $HTTP_VARS['op'] == "result" ) // Setup the result page
	{
		// evaluate the commands
		// The opendb.sql script is in the 'install' patch directory.
		if($HTTP_VARS['evalUpload'])
		{
			// upload SQL
			exec_sql_file("install", "opendb.sql", FALSE);
			exec_sql("delete from user where user_id = 'test';", FALSE);
		}			
		else if($HTTP_VARS['evalDrop'])
		{
			eval_drop(); // drop old tables
		}			
		else if($HTTP_VARS['evalUser'])
		{
			eval_user(); // migrate user table
		}			
		else if($HTTP_VARS['evalBackupUser'])
		{
			eval_backup_user(); // backup old dvddbp to olduser
		}			
		else if($HTTP_VARS['evalComments'])
		{
			eval_comments(); // migrate comments table
		}			
		else if($HTTP_VARS['evalDVD'])// migrate DVD table
		{
			$HTTP_VARS['dvd_region'] = get_item_attr_col_value("DVD_REGION", $HTTP_VARS['dvd_region']);
			$HTTP_VARS['ratio'] = get_item_attr_col_value("RATIO", $HTTP_VARS['ratio']);
			$HTTP_VARS['vid_format'] = get_item_attr_col_value("VID_FORMAT", $HTTP_VARS['vid_format']);
			
			eval_dvd($HTTP_VARS['dvd_region'], $HTTP_VARS['ratio'], $HTTP_VARS['vid_format']);
		}
	}
}//end of $CONFIG_VARS['patch.enable']===TRUE
