
.\" * OpenGGSN - Gateway GPRS Support Node
.\" * Copyright (C) 2002, 2003 Mondru AB.
.\" * Polish translation copyright (C) 2004 Marek akowicz <mazaczek@users.sourceforge.net>
.\" * 
.\" * The contents of this file may be used under the terms of the GNU
.\" * General Public License Version 2, provided that the above copyright
.\" * notice and this permission notice is included in all copies or
.\" * substantial portions of the software.
.\" * 
.\" * The initial developer of the original code is
.\" * Jens Jakobsen <jj@openggsn.org>
.\" * 
.\" * Contributor(s):
.\" * 
.\" * Translation to polish: Marek Zakowicz <mazak@debian.linux.org.pl>
.\" Manual page for ggsn
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label

.TH ggsn 8 "Lipiec 2003"
.SH NAZWA
ggsn \- Wze Wspierajcy Bramy GPRS (ang. Gateway GPRS Support Node).
.SH UYTKOWANIE
.B ggsn
\-\-help
  
.B ggsn
  \-\-version

.B ggsn
[
.BI \-\-fg
] [
.BI \-\-debug
] [
.BI \-\-conf " plik"
] [
.BI \-\-pidfile " plik"
] [
.BI \-\-statedir " plik" 
] [ 
.BI \-\-listen " host" 
] [
.BI \-\-net " sie" 
] [
.BI \-\-ipup " skrypt" 
] [
.BI \-\-ipdown " skrypt" 
] [
.BI \-\-dynip " sie" 
] [
.BI \-\-statip " sie" 
] [
.BI \-\-pcodns1 " host" 
] [
.BI \-\-pcodns2 " host" 
] [
.BI \-\-timelimit " sekundy" 
]

.SH OPIS
.B ggsn
jest czci projektu 
.B OpenGGSN
i implementuje funkcjonalno wza wspierajcego bramy GPRS.
Wzy GGSN s wykorzystywane przez operatorw sieci komrkowych jako interfejsy
pomidzy Internetem i reszt infrastruktury sieci komrkowej.
  
Funkcjonalno i protokoy GPRS zostay ustandaryzowane w ramach projektu
Third Generation Partnership Project (3GPP).  Stosownie do specyfikacji 3GPP,
GGSN posiada dwa interfejsy: interfejs Gn/Gp oraz interfejs Gi.
 
Interfejs Gn/Gp moe by postrzegany jako cze podrzdne wza GGSN.
Jest on wykorzystywany do komunikacji z Wzem Dostarczajcym Usug GPRS
(SGSN), ktry z kolei jest interfejsem do radiowej sieci dostpowej.
Interfejs Gn/Gp wykorzystuje protok tunelowania GPRS (GTP).  Pakiety danych
uytkownika (zazwyczaj pakiety IP) s tunelowane za porednictwem protokou GTP,
ktry z kolei wykorzystuje protok UDP nad IP.
  
Drugi z interfejsw moe by postrzegany jako cze nadrzdne,
prowadzce z wza GGSN do zewntrznej sieci danych.
Gi jest najczciej interfejsem do Internetu.
 
.B ggsn
wykorzystuje
.B sterownik TUN/TAP
jako interfejs Gi.  Interfejs w sieci tun jest uruchamiany podczas startu
.B ggsn.
 
.B ggsn
odbiera poczenia nadchodzce od urzdze ruchomych za porednictwem
sieci radiowej oraz SGSN.  Gdy nadchodzi danie poczenia, ggsn rezerwuje
dla urzdzenia ruchomego dynamiczny adres IP i pozwala urzdzeniu ruchomemu
korzysta z interfejsu Gi.  Poczenia mog by zamykane zarwno przez
stacje ruchome, jak i SGSN.  Bdy wystpujce podczas pracy programu
s raportowane z wykorzystaniem 
.B syslogd (8).
  
W typowej sytuacji
.B ggsn
jest uruchamiany na komputerze z dwoma kartami Ethernet - jedn
przeznaczon dla interfejsu Gn/Gp i jedn dla interfejsu Gi.
Polityki trasowania i reguy ciany ogniowej powinny by wykorzystane
w celu rozdzielenia ruchu Gi od ruchu Gn/Gp.
  
.SH OPCJE
.TP
.BI --help
Wywietla pomoc i na tym koczy wykonanie programu.
  
.TP
.BI --version
Wywietla pomoc i na tym koczy wykonanie programu.
 
.TP
.BI --fg
Uruchamia na pierwszym planie (domylnie wyczone).
  
.TP
.BI --debug
Uruchamia w trybie usuwania bdw (domylnie wyczone).
  
.TP
.BI --conf " plik"
Odczytuje konfiguracj z
.I pliku
(domylnie /etc/ggsn.conf), ktrego kada linia odpowiada jednej opcji
linii polece pozbawionej przedrostka '--'.  Opcje podane w linii polece
nadpisuj opcje podane w pliku konfiguracyjnym.
 
.TP
.BI --pidfile " plik"
Nazwa
.I pliku
z identyfikatorem procesu (domylnie /var/run/ggsn.pid)
  
.TP
.BI --statedir " cieka"
.I cieka
do katalogu z trwaymi (nie ulotnymi) danymi (domylnie /var/lib/ggsn/)
 
.TP
.BI --listen " host"
Lokalny adres IP, ktry zostanie uyty do nasuchu przez interfejs Gn/Gp.
Ta opcja musi zosta podana.
Z przyczyn bezpieczestwa nie moe by wykorzystany INADDR_ANY.

.TP
.BI --net " sie"
Adres sieci interfejsu Gi (domylnie 192.168.0.0/24).
Adres sieci jest ustawiany podczas inicjalizacji, gdy
.B ggsn
uruchamia urzdzenie tun dla interfejsu Gi.
 
.TP
.BI --ipup " skrypt"
Skrypt wykonywany po aktywacji interfejsu Gi w sieci tun.
Skrypt jest uruchamiany z nastpujcymi parametrami <nazwa urzdzenia> <adres ip>.
  
.TP
.BI --ipdown " skrypt"
Skrypt wykonywany po wyczeniu interfejsu Gi w sieci tun.
Skrypt jest uruchamiany z nastpujcymi parametrami <nazwa urzdzenia> <adres ip>.
  
.TP
.BI --dynip " sie"
Pula dynamicznych adresw sieci IP.  Okrela pul dynamicznych adresw IP.
Jeli ta opcja zostanie pominita, ggsn wykorzystuje do dynamicznej rezerwacji
adresw IP, adres sieci okrelony przez opcj
.BI --net.
  
.TP
.BI --pcodns1 " host"
Serwer PCO DNS 1 (domylnie 0.0.0.0). PCO jest akronimem 
Protocol Configuration Options, co tumaczy si jako Protok Opcji
Konfiguracyjnych i jest czci specyfikacji prtokow GPRS.  Jest
wykorzystywany do informowania stacji ruchomej o adresie serwera DNS
stosowanego do rozwizywania nazw hostw.
  
.TP
.BI --pcodns2 " host"
Serwer PCO DNS 2 (domylnie 0.0.0.0). PCO jest akronimem 
Protocol Configuration Options, co tumaczy si jako Protok Opcji
Konfiguracyjnych i jest czci specyfikacji prtokow GPRS.  Jest
wykorzystywany do informowania stacji ruchomej o adresie serwera DNS
stosowanego do rozwizywania nazw hostw.
  
.TP
.BI --timelimit " sekundy"
Koczy wykonanie
.b ggsn
po upywie podanej liczy \fIsekund\fP.
Opcja wykorzystywana w celu usuwania bdw.
  

.SH PLIKI
.I /etc/ggsn.conf
.RS
Plik konfiguracyjny dla
.B ggsn.
.RE
.I /var/run/ggsn.pid
.RS
Plik zawierajcy identyfikator procesu.
.RE
.I /var/lib/ggsn
.RS
Katalog przechowujcy trwae (nie ulotne) dane.
.RE

.SH BDY
Zgaszaj bdy na list ledzenia bdw OpenGGSN
.I http://sourceforge.net/projects/ggsn/

.B ggsn
ma bardzo ograniczone wsparcie dla zarzdzania.
Obecnie zarwno SNMP jak i mechanizmy rozliczania s pominite.
  
.SH "ZOBACZ TAKE"
.BR sgsnemu (8), 
.BR syslogd (8)
 
.SH UWAGI
.LP
  
Oprcz dugich, udokumentowanych w tym podrczniku, opcji
.B ggsn
wspiera rwnie pewn liczb krtkich opcji o tej samej funkcjonalnoci.
Wywoaj 
.B ggsn --help
by uzyska pen list dostpnych opcji.

Sterownik TUN/TAP jest wymagany dla poprawnego dziaania
.B ggsn. 
Dla jder linuksa pniejszych ni 2.4.7 sterownik TUN/TAP jest zawarty w jdrze,
chocia w typowej sytuacji musi by adowany oddzielnie za pomoc
.B modprobe tun.
Aby adowa automatycznie naley do pliku
.B /etc/modules.conf.
doda lini  
.B alias char-major-10-200 tun
Aby uzyska informacje o innych platformach zobacz stron
.I http://vtun.sourceforge.net/tun/
opisujc jak zainstalowa i skonfigurowa sterownik tun.

.B ggsn 
wykorzystuje protok tunelowania GPRS (GTP) wyspecyfikowany przez 
Third Generation Partnership Project (3GPP). Specyfikacje protokow 3GPP
mog by znalezione na
.I http://www.3gpp.org

.SH COPYRIGHT

Copyright (C) 2002, 2003 by Mondru AB.

Zawarto tego pliku moe by wykorzystywana stosownie do terminw
Oglnej, Publicznej Licencji (GPL) GNU w wersji 2 dostarczonej wraz
z niniejsz uwag o prawach autorskich zawart we wszystkich kopiach
i istotnych fragmentach oprogramowania.

.SH AUTORZY
Jens Jakobsen <jj@openggsn.org>

.SH TUMACZENIE
Polish translation copyright (C) 2004 Marek akowicz <mazaczek@users.sourceforge.net>

Tumaczenie jest chronione prawami autorskimi.
Dozwolone jest korzystanie, rozprowadzanie i modyfikacja na zasadach licencji GNU GPL 2.
