// $Id: MSXKanji12.hh,v 1.9 2004/10/19 19:47:44 m9710797 Exp $

#ifndef __MSXKANJI12_HH__
#define __MSXKANJI12_HH__

#include "MSXDevice.hh"
#include "Rom.hh"
#include "MSXDeviceSwitch.hh"

namespace openmsx {

class MSXKanji12 : public MSXDevice, public MSXSwitchedDevice
{
public:
	MSXKanji12(const XMLElement& config, const EmuTime& time);
	virtual ~MSXKanji12();
	
	virtual void reset(const EmuTime& time);
	virtual byte readIO(byte port, const EmuTime& time);
	virtual byte peekIO(byte port, const EmuTime& time) const;
	virtual void writeIO(byte port, byte value, const EmuTime& time);

private:
	Rom rom;
	int adr;
	int size;
};

} // namespace openmsx

#endif //__MSXKANJI12_HH__
