// $Id: DiskImageCLI.cc,v 1.28 2005/01/28 22:42:56 m9710797 Exp $

#include "DiskImageCLI.hh"
#include "GlobalSettings.hh"
#include "XMLElement.hh"
#include "FileContext.hh"

using std::list;
using std::string;

namespace openmsx {

DiskImageCLI::DiskImageCLI(CommandLineParser& cmdLineParser)
{
	cmdLineParser.registerOption("-diska", this);
	cmdLineParser.registerOption("-diskb", this);

	cmdLineParser.registerFileClass("diskimage", this);
	driveLetter = 'a';
}

bool DiskImageCLI::parseOption(const string& option,
                         list<string>& cmdLine)
{
	driveLetter = option[5];	// -disk_
	parseFileType(getArgument(option, cmdLine), cmdLine);
	return true;
}
const string& DiskImageCLI::optionHelp() const
{
	static const string text("Insert the disk image specified in argument");
	return text;
}

void DiskImageCLI::parseFileType(const string& filename,
                                 list<string>& cmdLine)
{
	XMLElement& config = GlobalSettings::instance().getMediaConfig();
	XMLElement& diskElem = config.getCreateChild(string("disk") + driveLetter);
	diskElem.getCreateChild("filename", filename);
	diskElem.setFileContext(std::auto_ptr<FileContext>(new UserFileContext()));
	while (peekArgument(cmdLine) == "-ips") {
		cmdLine.pop_front();
		string ipsFile = getArgument("-ips", cmdLine);
		diskElem.getCreateChild("ips", ipsFile);
	}
	++driveLetter;
}

const string& DiskImageCLI::fileTypeHelp() const
{
	static const string text("Disk image");
	return text;
}

} // namespace openmsx
