// $Id: MSXRom.hh,v 1.21 2006/01/16 17:59:50 m9710797 Exp $

#ifndef MSXROM_HH
#define MSXROM_HH

#include "MSXDevice.hh"
#include <memory>

namespace openmsx {

class Rom;
class MSXCPU;

class MSXRom : public MSXDevice
{
public:
	virtual ~MSXRom();

	virtual void writeMem(word address, byte value, const EmuTime& time);
	virtual byte* getWriteCacheLine(word address) const;

protected:
	MSXRom(MSXMotherBoard& motherBoard, const XMLElement& config,
	       const EmuTime& time, std::auto_ptr<Rom> rom);

	const std::auto_ptr<Rom> rom;
	MSXCPU& cpu;
};

} // namespace openmsx

#endif
