// $Id: RomHarryFox.cc 5751 2006-10-05 19:34:54Z m9710797 $

#include "RomHarryFox.hh"
#include "CacheLine.hh"
#include "Rom.hh"

namespace openmsx {

RomHarryFox::RomHarryFox(MSXMotherBoard& motherBoard, const XMLElement& config,
                         const EmuTime& time, std::auto_ptr<Rom> rom)
	: Rom16kBBlocks(motherBoard, config, time, rom)
{
	reset(time);
}

void RomHarryFox::reset(const EmuTime& /*time*/)
{
	setBank(0, unmappedRead);
	setRom (1, 0);
	setRom (2, 1);
	setBank(3, unmappedRead);
}

void RomHarryFox::writeMem(word address, byte value, const EmuTime& /*time*/)
{
	if (address == 0x6000) {
		setRom(1, 2 * (value & 1));
	}
	if (address == 0x7000) {
		setRom(2, 2 * (value & 1) + 1);
	}
}

byte* RomHarryFox::getWriteCacheLine(word address) const
{
	if ((address == (0x6000 & CacheLine::HIGH)) ||
	    (address == (0x7000 & CacheLine::HIGH))) {
		return NULL;
	} else {
		return unmappedWrite;
	}
}

} // namespace openmsx
