// $Id: V9990GLRasterizer.hh 5993 2007-01-12 22:12:12Z m9710797 $

#ifndef V9990GLRASTERIZER_HH
#define V9990GLRASTERIZER_HH

#include "V9990Rasterizer.hh"

namespace openmsx {

class V9990;
class V9990VRAM;

/** Rasterizer using SDL-GL
  */
class V9990GLRasterizer : public V9990Rasterizer
{
public:
	explicit V9990GLRasterizer(V9990& vdp);
	virtual ~V9990GLRasterizer();

	// Rasterizer interface:
	virtual bool isActive();
	virtual void reset();
	virtual void frameStart();
	virtual void frameEnd(const EmuTime& time);
	virtual void setDisplayMode(V9990DisplayMode displayMode);
	virtual void setColorMode(V9990ColorMode colorMode);
	virtual void setPalette(int index, byte r, byte g, byte b);
	virtual void drawBorder(int fromX, int fromY, int limitX, int limitY);
	virtual void drawDisplay(int fromX, int fromY,
	                         int displayX, int displayY,
	                         int displayWidth, int displayHeight);
	virtual bool isRecording() const;

private:
	/** The VDP of which the video output is rendered
	  */
	V9990& vdp;

	/** The VRAM connected to the V9990 VDP
	  */
	V9990VRAM& vram;
};

} // namespace openmsx

#endif
