'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Database_Wizard.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: msc $ $Date: 2006/08/10 09:35:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : new Database Wizard
'*
'************************************************************************
'*
' #1 tNewDatabase
' #1 tOpenDatabase
' #1 tOpenNoneDatabaseDocument
' #1 tODBC
' #1 tEvolution
' #1 tMozilla
' #1 tJDBC
' #1 tAdabas
' #1 tdBase
' #1 tMySQLODBC
' #1 tMySQLJDBC
' #1 tSpreadsheet
' #1 tText
' #1 tOracleJDBC
'*
'\***********************************************************************
sub b_lvl1_Database_Wizard
    call tNewDatabase
    call tOpenDatabase
    ' work only after cws dba205a is integrated
    'call tOpenNoneDatabaseDocument
    call tODBC
    call tEvolution
    call tMozilla
    call tJDBC
    call tAdabas
    call tdBase
    call tMySQLODBC
    call tMySQLJDBC
    call tSpreadsheet
    call tText
    call tOracleJDBC
end sub
'-------------------------------------------------------------------------
testcase tNewDatabase
        
    Kontext "DocumentWriter"
        DocumentWriter.UseMenu
        hMenuSelectNr(1)
        hMenuSelectNr(1)
        hMenuSelectNr(5)
    
    sleep(10)
        
    Kontext "DatabaseWizard"    
        CreateNewDatabase.Check
        sleep(1)
        NextBtn.Click
        sleep(1)        
        FinishBtn.Click
        sleep(1)
	                  
    Kontext "SpeichernDlg"
        if ( Dateiname.getSelText() = "" ) then
            warnlog "#i58413# Default filename is missing"
            Dim sFileName as String
            sFileName = ConvertPath(gOfficePath + "user/work/TTDB1.odb")
            if ( app.Dir( ConvertPath(sFileName) ) ) <> "" then
                app.kill(ConvertPath(sFileName))
            endif
            Dateiname.setText(sFileName)
        endif            
        Speichern.click 
        sleep(10)
        
    Kontext "MessageBox" 
        if MessageBox.exists then
            MessageBox.yes
        end if
        
    sleep(5)

    Kontext "ContainerView"
    
    ViewTables
    
    sleep(1)
    
    call fCloseDatabase(true)
    
endcase
'-------------------------------------------------------------------------
testcase tOpenDatabase
        
    Kontext "DocumentWriter"
        DocumentWriter.UseMenu
        hMenuSelectNr(1)
        hMenuSelectNr(1)
        hMenuSelectNr(5)
    
    sleep(5)
        
    Kontext "DatabaseWizard"    
        OpenExistingDoc.Check
        sleep(1)
        OpenBtn.Click
        sleep(1)        
                      
    Kontext "GeneralFileDialog"
        printlog "open database from: " + Convertpath(gofficePath + "user/database/biblio.odb")
        Dateiname.setText(Convertpath(gofficePath + "user/database/biblio.odb"))            
        Oeffnen.click 
        sleep(5)
        
    Kontext "ContainerView"
    
    ViewTables
    
    sleep(1)
    
    call fCloseDatabase(false)
    
endcase   
'-------------------------------------------------------------------------
testcase tOpenNoneDatabaseDocument
        
    Kontext "DocumentWriter"
        DocumentWriter.UseMenu
        hMenuSelectNr(1)
        hMenuSelectNr(1)
        hMenuSelectNr(5)
    
    sleep(5)
        
    Kontext "DatabaseWizard"    
        OpenExistingDoc.Check
        sleep(1)
        OpenBtn.Click
        sleep(1)        
                      
    Kontext "GeneralFileDialog"
        printlog "open spreadsheet file from: " + Convertpath(gTesttoolPath + "base/level1/input/spreadsheet_datasource/TT_Query1.ods")
        Dateiname.setText(Convertpath(gTesttoolPath + "base/level1/input/spreadsheet_datasource/TT_Query1.ods"))            
        Oeffnen.click 
        sleep(5)
        
    Kontext "DocumentCalc"
    if (DocumentCalc.exists()) then
        printlog "the spreadsheet is loaded"
        printlog "close spreadsheet again"
        call hCloseDocument()
    else
        warnlog "the spreadsheet is not loaded"
    endif
    
endcase
'-------------------------------------------------------------------------
testcase tODBC
qaerrorlog "not yet implemented"
endcase
'-------------------------------------------------------------------------
testcase tEvolution

    if gPlatgroup <> "lin" then
        printlog "Evolution does only exists under linux."
        goto endsub    
    end if   

    call fCreateEvolutionAddressbookDatasource(gOfficePath + "user\work\tt_evolution.odb")
    call fOpendatabase(gOfficePath + "user\work\tt_evolution.odb")
    
    Kontext "ContainerView"
        ViewTables
    
    call fCloseDatabase(true)   
    
endcase
'-------------------------------------------------------------------------
testcase tMozilla

    call fCreateMozillaAddressbookDatasource(gOfficePath + "user\work\tt_mozilla.odb")
    call fOpendatabase(gOfficePath + "user\work\tt_mozilla.odb")
    
    Kontext "ContainerView"
        ViewTables
    
    call fCloseDatabase(true)    

endcase
'-------------------------------------------------------------------------
testcase tJDBC
qaerrorlog "not yet implemented"
endcase
'-------------------------------------------------------------------------
testcase tAdabas

    if gPlatform = "x86" then
        printlog "Adabas doesn't exists under x86."
        goto endsub    
    end if   

    call fCreateAdabasDatasource(gOfficePath + "user\work\tt_adabas.odb","waikiki:TESTDB","testuser")
    call fOpendatabase(gOfficePath + "user\work\tt_adabas.odb","testuser")
    
    Kontext "ContainerView"
        ViewTables
    
    call fCloseDatabase(true)    
    
endcase
'-------------------------------------------------------------------------
testcase tdBase

    call fCreateDbaseDatasource(gOfficePath + "user\work\tt_dbase.odb",gOfficePath + "user\work\")
    call fOpendatabase(gOfficePath + "user\work\tt_dbase.odb")
    
    Kontext "ContainerView"
        ViewTables
    
    call fCloseDatabase(true)
    
endcase
'-------------------------------------------------------------------------
testcase tMySQLODBC
qaerrorlog "not yet implemented"
endcase
'-------------------------------------------------------------------------
testcase tMySQLJDBC
qaerrorlog "not yet implemented"
endcase
'-------------------------------------------------------------------------
testcase tSpreadsheet
qaerrorlog "not yet implemented"
endcase
'-------------------------------------------------------------------------
testcase tText

    call fCreateTextDatasource(gOfficePath + "user\work\tt_text.odb",gOfficePath + "user\work\")
    call fOpendatabase(gOfficePath + "user\work\tt_text.odb")
    
    Kontext "ContainerView"
        ViewTables
    
    call fCloseDatabase(true)    
    
endcase
'-------------------------------------------------------------------------
testcase tOracleJDBC
qaerrorlog "not yet implemented"
endcase
'-------------------------------------------------------------------------
