'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: coption4.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/16 12:23:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Check Tools->Options->Spreadsheet->Sort Lists
'*
'************************************************************************
'*
' #1 cOption4                         ' Initial Routine
' #1 tOptionsSortList_save            ' Check all Sort Lists Options and change them
' #1 tOptionsSortList_reload          ' Check if changes persist after exit and restart the office
' #1 tOptionsSortListRestore_settings ' Restore default settings
'*
'\***********************************************************************

Global lEntry (1 to 4)
Global str_ListCont as string, str_CListCont as string, str_NListCont as string
Global lCounter as integer, nlCounter, i as integer

sub cOption4

        printLog Chr(13) + "--------- cOption4 ---------"
        printlog "Tools|Options|Spreadsheet|SortList"

        call tOptionsSortList_save
        call tOptionsSortList_reload
        call tOptionsSortListRestore_settings

end sub

'*********************************************************************************************************

testcase tOptionsSortList_save
'/// This test invokes the "Tools|Options|Spreadsheet|List" dialog ///'
'/// First a check for correct default settings is run ///'
'/// For any unexpected value a warning is thrown ///'
'/// Then each item is modified and the dialog is saved & closed using <OK> ///'
'/// After a restart of the office the persistence of the changes is verified ///'
'/// Finally the original settings are restored. ///'
'/// The functionality test is integrated in the 'tOptionsSortList_reload' testcase. ///'

        dim sheetName as String
        ' First the environment is determined
        select case iSystemSprache
                case 01 :       lEntry(1) = "Sun,Mon,Tue,Wed,Thu,Fri,Sat"
                                lEntry(2) = "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday"
                                lEntry(3) = "Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec"
                                lEntry(4) = "January,February,March,April,May,June,July,August,September,October,November,December"
                case 49 :       lEntry(1) = "So,Mo,Di,Mi,Do,Fr,Sa"
                                        lEntry(2) = "Sonntag,Montag,Dienstag,Mittwoch,Donnerstag,Freitag,Samstag"
                                        lEntry(3) = "Jan,Feb,Mrz,Apr,Mai,Jun,Jul,Aug,Sep,Okt,Nov,Dez"
                                lEntry(4) = "Januar,Februar,März,April,Mai,Juni,Juli,August,September,Oktober,November,Dezember"
        end select

        ' Now we load a document and prepare some things

        select case iSprache
                case 01 : str_ListCont = "$Sheet1.$A$1:$A$5"
                case 07 : str_ListCont = "$Лист1.$A$1:$A$5"
                case 31 : str_ListCont = "$Werkblad1.$A$1:$A$5"
                case 33 : str_ListCont = "$Feuille1.$A$1:$A$5"
                case 34 : str_ListCont = "$Hoja1.$A$1:$A$5"
                case 39 : str_ListCont = "$Tabella1.$A$1:$A$5"
                case 46 : str_ListCont = "$Tabell1.$A$1:$A$5"
                case 49 : str_ListCont = "$Tabelle1.$A$1:$A$5"
                case 55 : str_ListCont = "$Planilha1.$A$1:$A$5"
                case 81 : str_ListCont = "$表1.$A$1:$A$5"
                case 82 : str_ListCont = "$시트1.$A$1:$A$5"
                case 86 : str_ListCont = "$工作表1.$A$1:$A$5"
                case 88 : str_ListCont = "$工作表1.$A$1:$A$5"
                case else : QAErrorLog "This testcase is only designed to run on BIG 10 languges"
                            goto endsub
        end select

        Call hNewDocument
        str_CListCont = "Alpha" & chr(10) & "Beta" & chr(10) & "Gamma" & chr(10) & "Delta" & chr(10) & "Epsilon"

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Home>"
        DocumentCalc.TypeKeys "Alpha<return>Beta<return>Gamma<return>Delta<return>Epsilon<return>"
        DocumentCalc.TypeKeys "<Mod1 Home>"
        DocumentCalc.TypeKeys "<Shift down down down down>"

        ' Modify parameters in this tabpage
        ToolsOptions
        hToolsOptions("SPREADSHEET", "SORTLISTS")

    ' Check the existing entries in the ListBox
    lCounter = Listen.GetItemCount
    if lCounter = 4 then
        printlog "OK, all expected entries in sort list found."
    else
        warnlog "The number of entries in this listbox isn't correct."
        warnlog "There are " & lCounter & " entries instead of four entries"
    end if

    for i = 1 to 4
        Listen.Select i
        if Listen.GetSelText = lEntry(i) then
                printlog "OK, the list entry #" & i & "# is correct"
        else
                warnlog "This list entry is " & Listen.GetSelText & " Instead of " & lEntry(i)
        end if
    next i

    if ListeKopierenAus.GetText = str_ListCont then
        printlog "OK, the content of <Copy list from:> is correct"
    else
        warnlog "The content of <Copy list from:> is " & ListeKopierenAus.GetText & " instead of " & str_ListCont
    end if

        ' Import the selected entries as list into the SortList
    Kopieren.click
    if Eintraege.GetText <> str_CListCont then
        warnlog "It seems that the new list hasn't been added to the sort lists"
        warnlog "The list content is " &  Eintraege.GetText & " instead of " & str_CListCont
    else
        printlog "OK, the new list has been imported"
    end if

    ' Create a new sort list
    Neu.click
    Kontext "Eintraege"
    Eintraege.SetText "First" & chr(10) & "Second" & chr(10) & "Third" & chr(10) & "Fourth"

        ' save the modifications and verify if these settings works
    Kontext "OptionenDlg"
        OptionenDlg.OK

    call hCloseDocument

    call hNewDocument
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Mod1 Home>"
    DocumentCalc.TypeKeys "First<return><up>"
    DocumentCalc.TypeKeys "<Shift down down down>"
    EditFillSeries
    Kontext "ReiheFuellen"
    AutoAusfuellen.check
    ReiheFuellen.OK
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Mod1 Home>"
    DocumentCalc.TypeKeys "<down><down><down>"
    if cZellwert(fWhereIsTheCellCursor) = "Fourth" then
        printlog "OK, the new sort list has been applied"
    else
        warnlog "The new sort list hasn't been applied"
        end if

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<down><down>"
        DocumentCalc.TypeKeys "Alpha<return><up>"
        DocumentCalc.TypeKeys "<Shift down down down down>"
    EditFillSeries
    Kontext "ReiheFuellen"
    AutoAusfuellen.check
    ReiheFuellen.OK
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<down><up>"
    if cZellwert(fWhereIsTheCellCursor) = "Epsilon" then
        printlog "OK, the new sort list has been applied"
    else
        warnlog "The new sort list hasn't been applied"
        end if
    sleep 5
    call hCloseDocument


endcase

'*********************************************************************************************************

testcase tOptionsSortList_reload
'/// Documentation is summarized in tOptionsSortList_save

    sleep 5
        'Restart the complete office
        ExitRestartTheOffice
        select case iSprache
                case 01 , 07 , 31 , 33 , 34 , 39 , 46 , 49 , 55 , 81 , 82 , 86 , 88
                     printlog "Language " & iSprache & " is supported!"
                case else 
                     QAErrorLog "This testcase is only designed to run on BIG 10 languges"
                     goto endsub
        end select

        call hNewDocument

        ' Check all parameters in this tabpage
        ToolsOptions
        hToolsOptions("SPREADSHEET", "SORTLISTS")

    nlCounter = Listen.GetItemCount
    if nlCounter = 6 then
        printlog "OK, the added lists are stored"
    else
        warnlog "The number of entries in this listbox isn't correct."
        warnlog "There are " & nlCounter & " entries instead of six 6 entries"
    end if

        Kontext "OptionenDlg"
        OptionenDlg.Cancel

        call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsSortListRestore_settings
'/// Documentation is summarized in tOptionsSortList_save

' Restore all settings

        call hNewDocument

        ToolsOptions
        hToolsOptions("SPREADSHEET", "SORTLISTS")
    lCounter = Listen.GetItemCount
    printlog "lCounter " & lCounter
    While lCounter > 4
        Listen.Select lCounter
        Loeschen.click
        Kontext "Active"
        if Active.exists then
                Active.Yes
        end if
        Kontext "TabSortierlisten"
        lCounter = Listen.GetItemCount
    Wend

    Kontext "OptionenDlg"
        OptionenDlg.OK

    call hCloseDocument

endcase

