'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_105c.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: pj $ $Date: 2005/09/16 13:08:52 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Chart Level 1 test - section FORMAT 4
'*
'************************************************************************
'*
' #1 ch_105c     ' Initial routine
' #1 tFormatCharttype
' #1 tAutoFormatDiagramm
' #1 tFormatAxesAndGrids2D
' #1 tFormatAxesAndGrids3D
' #1 tFormatAllAxesAndGrids
' #1 tFormatNumberFormat
'*
'\***********************************************************************


sub ch_105c

   printLog "---------  Ch_105c     ----------"

   Call tFormatCharttype
   Call tAutoFormatDiagramm
   Call tFormatAxesAndGrids2D
   Call tFormatAxesAndGrids3D
   Call tFormatAllAxesAndGrids
   Call tFormatNumberFormat

end sub

'*********************************************************************************************

testcase tFormatCharttype
'/// This test checks the available settings in the FormatCharttype dialog.
'/// First a chart is created which based on datas of a calc document.

   Dim i as integer,ltext as string
   Dim sFile

   sFile = convertpath(gOfficePath & "user/work/tCharttype" & Ext)

   Call basedocument ("CHART")
   EditObjectEdit
   printlog "Choose charttype"
   Kontext "Diagramm"
'/// Call the menu item 'FormatChartType' and set the chart type to 3D
   FormatChartType
   Kontext "Diagrammtyp"
   DreiD.Check
'/// select the chart type nr 4
   for i= 1 to 4
      Typ.TypeKeys "<Left>"
   next i

   Diagrammtyp.OK
   Kontext "Diagramm"
'/// Call the menu item 'InsertTitle' and modify main title, main title text, sub title and sub title text
   printlog "Set Title"
   InsertTitle
   Kontext "Titel"
   Haupttitel.Check
   HaupttitelText.Settext "Maintitle"
   Untertitel.Check
   UntertitelText.Settext "Subtitle"
   if XAchse.IsEnabled or YAchse.IsEnabled or ZAchse.IsEnabled then
      Warnlog "Chart has no axes"
   end if
   Titel.OK
   Kontext "Diagramm"
'/// Call the menu item 'InsertDataLabels' and modify show value, as percentage, show legend icon
'/// and show label
   printlog "Setting data labels"
   InsertDataLabels
   Kontext "Datenbeschriftung"
   WertAnzeigen.Check
   AlsProzent.Check
   LegendensymbolNebenBeschriftung.Check
   BeschriftungAnzeigen.Check
   Datenbeschriftung.OK
   Kontext "Diagramm"
'/// Call the menu item 'InsertLegend' and uncheck show
   printlog "Hide Legend"
   InsertLegend
   Kontext "Legende"
   Anzeigen.uncheck
   Legende.OK
   Kontext "Diagramm"
'/// Call the menu item 'Format3View' and modify xaxis and 3D view
   printlog "Set 3DView"
   Format3View
   Kontext "DreiDAnsicht"
   xAchse.Settext "37"
   DreiDAnsicht.OK
   Kontext "Diagramm"
'/// Call the menu item 'FormatChartArea' and modify gradient and gradient list
   FormatChartArea
   Kontext
   Active.SetPage TabArea
   Kontext "TabArea"
   FillOptions.select 3
   GradientList.Select 6
   TabArea.OK
   Kontext "Diagramm"
'/// Save, close and reopen the document
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE>"
   if NOT fSaveAsWithFilterKillCatchMissingName (sFile, FileFormat) then
      warnlog "Saving File failed"
      hCloseDocument
      goto endsub
   endif
   
   hCloseDocument
   hDateioeffnen(sFile)

   Kontext "DocumentCalc"
   if NOT fSelectChartByNumber ( 1 ) then
       warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
   endif
   EditObjectEdit
   sleep (2)
   Kontext "Diagramm"
'/// Check all made settings
   printlog "Check the settings"

   FormatChartType
   Kontext "Diagrammtyp"
   if NOT DreiD.isChecked then warnlog "NOT GOOD: 3D-property has been lost"
   Diagrammtyp.close

   Kontext "Diagramm"
   InsertTitle
   Kontext "Titel"
   if Haupttitel.IsChecked=False or Haupttiteltext.Gettext<>"Maintitle" then
      Warnlog "Main title hasn't been saved"
   else
      printlog "OK, main title has been saved"
   end if
   if Untertitel.IsChecked=False or Untertiteltext.Gettext<>"Subtitle" then
      Warnlog "Sub title hasn't been saved"
   else
      printlog "Sub title has been saved"
   end if
   if XAchse.IsEnabled or YAchse.IsEnabled or ZAchse.IsEnabled then
      Warnlog "Chart has no axes"
   else
      printlog "Axes are there"
   end if
   Titel.OK
   Kontext "Diagramm"

   InsertDataLabels
   Kontext "Datenbeschriftung"
   if NOT AlsProzent.IsChecked then
      warnlog "Error in setting of data labels"
   end if

   if NOT LegendensymbolNebenBeschriftung.IsChecked then
      Warnlog "Error in setting of data inscription"
   end if
   BeschriftungAnzeigen.Check
   Datenbeschriftung.OK
   Kontext "Diagramm"

   InsertLegend
   Kontext "Legende"
   'if Keine.IsChecked=False then
   if Anzeigen.ischecked then
      Warnlog "Legend is visible"
   end if
   Legende.OK
   Kontext "Diagramm"

   Format3View
   Kontext "DreiDAnsicht"
   if left(xAchse.Gettext,2) <> "37" then
      QAErrorLog "#68473# View angle isn't stored"
   else
      QAErrorLog "#68473# is fixed, please remove logs on this line and thisLine - 2"
      printlog "X-Axis angles is correct"
   end if
   DreiDAnsicht.OK
   Kontext "Diagramm"

   FormatChartArea
   Kontext
   Active.SetPage TabArea
   Kontext "TabArea"
   If NOT FillOptions.GetSelIndex = 3 then
      Warnlog "Color gradient is disabled"
   end if
   if GradientList.GetSelIndex <> 6 then
      Warnlog "Wrong color gradient"
   end if
   TabArea.OK

   'Kontext "Diagramm"
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tAutoFormatDiagramm
'/// This test checks the available settings in the AutoFormatDiagramm dialog.
'/// There are three different chart types tested.
'/// First a chart is created.
   ' if gPlatform = "lin" then
      ' qaErrorLog "#112023# - Crash only reproducible with this testcase on Linux -> Aborting"
      ' goto endsub
   ' endif
   Dim i as Integer, j as Integer
   dim iWaitIndex as Integer
   Dim bHasXAxis as String ,bHasYAxis as String ,bHasZAxis as String
   Dim sFile as string

   for j= 1 to 3
      sFile = convertpath(gOfficePath & "user/work/testdchart2_" & j & Ext)
      printlog "Start of the charttest for Nr: " & j
      Call basedocument ("CHART")
      sleep (2)
      EditObjectEdit

      printlog "New chart : " & j & " created"

      bHasXAxis=False
      bHasYAxis=False
      bHasZAxis=False
      Kontext "Diagramm"
      printlog "Chart-AutoFormat ChartNr:" + j
      FormatAutoFormat
'/// Select a chart type in 'AutoFormatDiagramm2' by pressing the cursor down
      Kontext "AutoFormatDiagramm2"
      for i=1 to j-1
         Diagrammtyp.TypeKeys "<Down>"
         Diagrammtyp.TypeKeys "<Down>"
      next i
'/// Modify checkbox showtextelements and click on next>>
      TextobjekteDarstellen.Check
      TextobjekteDarstellen.UnCheck
      Weiter.Click
'/// Select in 'AutoFormatDiagramm3' a variant by pressing the cursor right
      try
         Kontext "AutoFormatDiagramm3"
         for i= 1 to j
            Variante.TypeKeys "<Right>"
         next i
      catch
         warnlog "Error by choosing charttype!"
      endcatch
'/// Check all axes and click on next>>
      try
         if XAchse.IsEnabled then XAchse.Check
         if YAchse.IsEnabled then YAchse.Check
         if ZAchse.IsEnabled then ZAchse.Check
      catch
         warnlog "Error by choosing axes!"
      endcatch

      Weiter.Click
'/// Select the chart title and set a text for it
      try
         Kontext "AutoFormatDiagramm4"
         DiagrammtitelText.Settext "1A Bar Chart"
         Diagrammtitel.Check
      catch
         warnlog "Error by setting title!"
      endcatch
'/// Set a text for all available axes in this dialog and create the chart
      if XAchse.IsEnabled then
         XAchse.Check
         XAchseText.Settext "X-Axis"
         bHasXAxis=True
      end if

      if YAchse.IsEnabled then
         YAchse.Check
         YAchseText.Settext "Y-Axis"
         bHasYAxis=True
      end if

      if ZAchse.IsEnabled then
         ZAchse.Check
         ZAchseText.Settext "Z-Axis"
         bHasZAxis=True
      end if
      Fertigstellen.Click

      iWaitIndex = 0
      do while AutoFormatDiagramm4.exists AND iWaitIndex < 10
          sleep(1)
          iWaitIndex = iWaitIndex + 1
          if iWaitIndex = 3 then
              warnlog "It takes about 3 seconds to close the Chart autoformat dialog. This is worth a performance issue!"
          endif
      loop

      printlog "Chart-Nr: " & j & " save"
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<ESCAPE>"
      sleep (2)
'/// Save, close and reopen the chart
      if NOT fSaveAsWithFilterKillCatchMissingName (sFile, FileFormat) then
         warnlog "Saving File failed"
         hCloseDocument
         goto endsub
      endif
      sleep (5)
      hCloseDocument
      sleep (5)
      Kontext
      hDateiOeffnen(sFile)
      sleep (5)
      Kontext "DocumentCalc"
      if NOT fSelectChartByNumber ( 1 ) then
          warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
      endif
      EditObjectEdit
   sleep (2)
'/// Check all made settings
      Kontext "Diagramm"
      printlog "Check parameter for Axes - Chart-Nr: "+ j
      InsertTitle

      Kontext "Titel"
      if Haupttitel.IsChecked=False or HaupttitelText.GetText <> "1A Bar Chart" then
         Warnlog "Main title isn't there! - ChartNr: "+ j
      else
         printlog "OK, found main title ChartNr: " + j
      end if

      if bHasXAxis=True then
         try
            if XAchse.IsChecked=False or XAchseText.GetText <> "X-Axis" then
               warnlog "Label for X-Axis isn't correct! - ChartNr: "+ j
            else
               printlog "OK, correct X-Axis label for ChartNr: " + j
            end if
         catch
            warnlog "No X-Axis"
         endcatch
      end if

      if bHasYAxis=True then
         try
            if YAchse.IsChecked=False or YAchseText.GetText <> "Y-Axis" then
               Warnlog "Label for Y-Axis isn't correct! - ChartNr: " + j
            else
               printlog "OK, correct Y-Axis label for ChartNr: " + j
            end if
         catch
            warnlog "No Y-Axis"
         endcatch
      end if

      if bHasZAxis=True then
         try
            if ZAchse.IsChecked=False or ZAchseText.GetText <> "Z-Axis" then
               Warnlog "Label for Z-Axis isn't correct! - ChartNr: " + j
            end if
         catch
            warnlog "No Z-Axis"
         endcatch
      end if
      Titel.Close
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<ESC><ESC>"
      FileClose
      Kontext "Active"
      if Active.exists then
         Active.NO
      end if

      printlog "End Charttest for Nr: " + j
'/// Execute the same procedure with other charttypes

   Next j

endcase
'
'-----------------------------------------------------------
'
testcase tFormatAxesAndGrids2D
'/// This test checks the available settings in the FormatAxesAndGrids2D dialog.
'/// First a chart is created.

   Dim sFile
   sFile = convertpath(gOfficePath & "user/work/tFormatAxesAndGrids2D" & Ext)
   Call basedocument ("CHART")
   EditObjectEdit
   Kontext "Diagramm"
   printlog "Set and check parameters for X-Grids (2D-Chart)"
'/// Call the menu item 'InsertAxes' and uncheck XaxisMain
   InsertAxes
   Kontext "Achsen"
   xAchsePrim.Uncheck
   Achsen.OK
'/// Call the menu item 'InsertGrids' and check main und sub Xgrid
   InsertGrids
   Kontext "Gitter"
   xAchseHaupt.Check
   xAchseHilfs.Check
   Gitter.OK
'/// Attempt to call the menu item 'FormatAxisXAxis' and go to tabpage 'TabLine'
   Kontext "Diagramm"
   try
      FormatAxisXAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Warnlog "Menu item X-Axis is activ"
            Kontext "Diagramm"
      end if
   catch
   endcatch
'/// Attempt to call the menu item 'FormatGridXAxisMainGrid' and go to tabpage 'TabLine'
   try
      FormatGridXAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      Stil.Select 11
      Farbe.Select 11
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "Menui tem X-Axis main lattice is inactive"
   endcatch
'/// Attempt to call the menu item 'FormatGridXAxisMinorGrid' and go to tabpage 'TabLine'
   try
      FormatGridXAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      Stil.Select 11
      Farbe.Select 11
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "Menu item X-Axis sub lattice is inactive"
   endcatch
'/// Call the menu item 'InsertAxes' and uncheck YaxisMain
   printlog "Set and check parameter for Y-lattice (2D-Chart)"
   InsertAxes
   Kontext "Achsen"
   yAchsePrim.UnCheck
   Achsen.OK
'/// Call the menu item 'InsertGrids' and check YaxisMain and Sub
   InsertGrids
   Kontext "Gitter"
   yAchseHaupt.Check
   yAchseHilfs.Check
   Gitter.OK
'/// Attempt to call the menu item 'FormatAxisYAxis' (it mustn't be possible)
   Kontext "Diagramm"
   try
      FormatAxisYAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Warnlog "Menu item Y-Axis is activ"
            Kontext "Diagramm"
      end if
   catch
   endcatch
'/// Attempt to call the menu item 'FormatGridYAxisMainGrid', go to tab page 'TabLine'
'/// and modify style and color
   try
      FormatGridYAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      Stil.Select 12
      Farbe.Select 12
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "Menu item Y-Axis main lattice is inactive"
   endcatch
'/// Attempt to call the menu item 'FormatGridYAxisMinorGrid'
   try
      FormatGridYAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Kontext "Diagramm"
      end if
   catch
      Warnlog "Menu item Y-Axis sub lattice is inactive"
   endcatch
'/// Save, close and reopen the document
   printlog "save 2D-Chart"
   if NOT fSaveAsWithFilterKillCatchMissingName (sFile, FileFormat) then
      warnlog "Saving File failed"
      hCloseDocument
      goto endsub
   endif
   hCloseDocument
   Kontext

   printlog "Load file and check persistance of changes"
   hDateioeffnen(sFile)
   sleep (3)
   Kontext "DocumentCalc"
   if NOT fSelectChartByNumber ( 1 ) then
       warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
   endif
   EditObjectEdit
   sleep (2)
   Kontext "Diagramm"
'/// Ceck all settings and adjustments the x- and the yaxis
  '############  X-Achse  ###################

   printlog "check parameters for lattices (2D-Chart)"
   try
      FormatAxisXAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
         TabLinie.Cancel
         Warnlog "Menu item X-Axis is activ"
         Kontext "Diagramm"
      end if
   catch
   endcatch
   try
      FormatGridXAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      if Stil.GetSelIndex<>(11) or Farbe.GetSelIndex<>(11) then
            Warnlog "Saved parameters for X-lattice not OK! (2D-Chart)"
      endif
      TabLinie.OK
      Kontext "Diagramm"
   catch
   endcatch
   try
      FormatGridXAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
         if Stil.GetSelIndex<>(11) or Farbe.GetSelIndex<>(11) then
            Warnlog "Saved parameters for X-lattice not OK! (2D-Chart)"
         endif
      TabLinie.OK
      Kontext "Diagramm"
   catch
   endcatch
  '############  Y-Achse  ###################

   try
      FormatAxisYAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Warnlog "Menu item Y-Axis is activ"
            Kontext "Diagramm"
      endif
   catch
   endcatch
   try
      FormatGridYAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      if Stil.GetSelIndex<>(12) or Farbe.GetSelIndex<>(12) then
         Warnlog "Saved parameters for Y-lattice not OK! (2D-Chart)"
    endif
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "Menu item Y-Axismainlattice is inactive"
   endcatch
   try
      FormatGridYAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Kontext "Diagramm"
      endif
   catch
      Warnlog "Menuitem Y-Axis sub lattice is inactive"
   endcatch
   hCloseDocument

endcase
'
'-----------------------------------------------------------
'
'
testcase tFormatAxesAndGrids3D
'/// This test checks the available settings in the FormatAxesAndGrids3D dialog.
'/// First a chart is created which based on datas of a calc document.

   Dim sFile
   sFile = convertpath(gOfficePath & "user/work/tFormatAxesAndGrids3D" & Ext)
   Call basedocument ("CHART")
   EditObjectEdit
   Kontext "Diagramm"
'/// Call the menu item 'FormatChartType' and set the chart type to 3D
   FormatChartType
   Kontext "Diagrammtyp"
   DreiD.Check
   Diagrammtyp.OK
   Kontext "Diagramm"
'/// Call the menu item 'InsertAxes' and uncheck the XaxisMain
   printlog "Set parameters for X-lattice and check them"
   InsertAxes
   Kontext "Achsen"
   xAchsePrim.UnCheck
   Achsen.OK
'/// Call the menu item 'InsertGrids' and check the XaxisMain and Sub
   InsertGrids
   Kontext "Gitter"
   xAchseHaupt.Check
   xAchseHilfs.Check
   Gitter.OK
'/// Attempt to call  the menu item 'FormatAxisXAxis'
   Kontext "Diagramm"
   try
      FormatAxisXAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
         TabLinie.Cancel
         Warnlog "menu item X-Axis is available"
         Kontext "Diagramm"
      end if
   catch
   endcatch
'/// Attempt to call the menuitem 'FormatGridXAxisMainGrid' and modify style and color
   try
      FormatGridXAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      Stil.Select 11
      Farbe.Select 11
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "menu item Format Grid XAxis Main Grid is not available"
   endcatch
'/// Attempt to call the menu item 'FormatGridXAxisMinorGrid' and modify style and color
   try
      FormatGridXAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      Stil.Select 11
      Farbe.Select 11
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "menu item Format Grid XAxis Minor Grid is not available"
   endcatch
'/// Call the menu item 'InsertAxes' and uncheck YaxisMain
   printlog "set parameters for Y-lattice and check them"
   InsertAxes
   Kontext "Achsen"
   yAchsePrim.UnCheck
   Achsen.OK
'/// Call the menu item 'InsertGrids' and check YaxisMain and Sub
   InsertGrids
   Kontext "Gitter"
   yAchseHaupt.Check
   yAchseHilfs.Check
   Gitter.OK
'/// Attempt to call the menu item 'FormatAxisYAxis'
   Kontext "Diagramm"
   try
      FormatAxisYAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
         TabLinie.Cancel
         Warnlog "menu item Format Axis YAxis is available"
         Kontext "Diagramm"
      end if
   catch
   endcatch
'/// Attempt to call the menu item 'FormatGridYAxisMainGrid' and modify style and color
   try
      FormatGridYAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      Stil.Select 12
      Farbe.Select 12
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "menu item Format Grid YAxis Main Grid is disabled"
   endcatch
'/// Attempt to call menu item 'FormatGridYAxisMinorGrid'
   try
      FormatGridYAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
         TabLinie.Cancel
         Kontext "Diagramm"
      end if
   catch
      Warnlog "menu item Format Grid Y-Axis Minor Grid is disabled"
   endcatch

   printlog "set parameters for Z-lattice and check them"
'/// Call the menu item 'InsertAxes' and check ZaxisMain, then call the menu item
'/// 'InsertGrids and uncheck the ZaxisMain- and Subgrid
   InsertAxes
   Kontext "Achsen"
   try
      zAchsePrim.Check
      Achsen.OK
      InsertGrids
      Kontext "Gitter"
      zAchseHaupt.Uncheck
      zAchseHilfs.Uncheck
      Gitter.OK
      Kontext "Diagramm"
   catch
      Warnlog "No 3D Chart!"
   endcatch
'/// Attempt to call the menu item 'FormatAxisZAxis' and modify style and color
   try
      FormatAxisZAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      Stil.Select 13
      Farbe.Select 13
      TabLinie.OK
      Kontext "Diagramm"
      catch
      Warnlog "menu item Format Axis ZAxis is disabled"
   endcatch
'/// Attempt to call the menu item 'FormatGridZAxisMainGrid'
   try
      FormatGridZAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
         TabLinie.Cancel
         warnlog "menu item Format Grid ZAxis Main Grid is available"
         Kontext "Diagramm"
      end if
   catch
   endcatch
'/// Attempt to call the menu item 'FormatGridZAxisMinorGrid'
   try
      FormatGridZAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Warnlog "menu item Format Grid ZAxis Minor Grid is available"
            Kontext "Diagramm"
      end if
   catch
   endcatch

'/// Save, close and reopen the document
   printlog "Save 3D Chart"
   hSpeichernUnterKill(sFile)
   hCloseDocument
   Kontext
'/// Check all made settings
   printlog "Load document and check all changed settings"
   hDateioeffnen(sFile)
   sleep (3)
   Kontext "DocumentCalc"
   if NOT fSelectChartByNumber ( 1 ) then
       warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
   endif
   EditObjectEdit
   sleep (2)
   Kontext "Diagramm"

  '############  X-Axis  ###################

   printlog "- check changed settings for grid (3D-chart)"
      try
      FormatAxisXAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Warnlog "menu item X-axis is active"
            Kontext "Diagramm"
      endif
      catch
      endcatch

   try
      FormatGridXAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      if Stil.GetSelIndex<>(11) or Farbe.GetSelIndex<>(11) then
            Warnlog "changed settings for major X-grid not OK! (3D-chart)"
      endif
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "menu item X-axis main grid is not active"
   endcatch

   try
      FormatGridXAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
         if Stil.GetSelIndex<>(11) or Farbe.GetSelIndex<>(11) then
            Warnlog "changed settings for minor X-grid not OK! (3D-chart)"
         endif
      TabLinie.OK
      Kontext "Diagramm"
   catch
      Warnlog "menu item X-axis minor grid is not active"
   endcatch

  '############  Y-Axis  ###################

   try
      FormatAxisYAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Warnlog "menu item Y-axis is not active"
            Kontext "Diagramm"
      endif
   catch
   endcatch

   try
      FormatGridYAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      if Stil.GetSelIndex<>(12) or Farbe.GetSelIndex<>(12) then
         Warnlog "changed settings for main Y-grid not OK! (3D-chart)"
      endif
      TabLinie.OK
      Kontext "Diagramm"
   catch
   endcatch

   try
      FormatGridYAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
         Kontext "Diagramm"
      endif
   catch
      Warnlog "menu item Y-grid is not active"
   endcatch

 ' ################ Z-Axis ###################

   try
      FormatAxisZAxis
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      if Stil.GetSelIndex<>(13) or Farbe.GetSelIndex<>(13) then
            Warnlog "changed settings for main z-axis not OK! (3D-chart)"
      endif
      TabLinie.OK
   catch
   endcatch

   try
      FormatGridZAxisMainGrid
      Kontext
      Active.SetPage TabLinie
      Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Warnlog "menu item main Z-grid is not active"
            Kontext "Diagramm"
      endif
   catch
   endcatch

   try
      FormatGridZAxisMinorGrid
      Kontext
      Active.SetPage TabLinie
       Kontext "TabLinie"
      If TabLinie.Exists then
            TabLinie.Cancel
            Warnlog "menu item minor Z-grid is not active"
            Kontext "Diagramm"
      endif
   catch
   endcatch

   hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatAllAxesAndGrids
'/// This test checks the available settings in the FormatAllAxesAndGrids dialog.
'/// First a chart is created.

   Dim sFile
   sFile = convertpath(gOfficePath & "user/work/tFormatAllAxesAndGrids" & Ext)
   Call basedocument ("CHART")
   EditObjectEdit

   printlog "* Setting format for all axes *"
   Kontext "Diagramm"
'/// Call the menu item 'FormatChartType' and set the chart type to 3D
   FormatChartType
   Kontext "Diagrammtyp"
   DreiD.Check
   Diagrammtyp.OK
   Kontext "Diagramm"
'/// Call the menu item 'InsertAxes' and check XaxisMain, YaxisMAin and ZaxisMain
   InsertAxes
   Kontext "Achsen"
   try
      xAchsePrim.Check
   catch
      Warnlog "x-axis isn't activ"
   endcatch

   try
      yAchsePrim.Check
   catch
      Warnlog "y-axis isn't activ"
   endcatch

   try
      zAchsePrim.Check
   catch
      Warnlog "z-axis isn't activ"
   endcatch
   Achsen.OK

'/// Call the menuitem 'InsertGrids' and check X/Y/Z axisMain- and Subgrid
   InsertGrids
   Kontext "Gitter"
   try
      xAchseHaupt.Check
      xAchseHilfs.Check
   catch
      warnlog "x-axes aren't activ"
   endcatch

   try
      yAchseHaupt.Check
      yAchseHilfs.Check
   catch
      warnlog "y-axes aren't activ"
   endcatch

   try
      zAchseHaupt.Check
      zAchseHilfs.Check
   catch
      warnlog "z-axes aren't activ"
   endcatch
   Gitter.OK

'/// Call the menu item 'FormatGridAllAxisGrids' and modify style and color
   Kontext "Diagramm"
   FormatGridAllAxisGrids
   Kontext
   Active.Setpage TabLinie
   Kontext "TabLinie"
   Stil.Select 5
   Farbe.Select 20
   TabLinie.OK
   Kontext "Diagramm"
'/// Save, close and reopen the document
   hSpeichernUnterKill(sFile)
   hCloseDocument
   Kontext
'/// Check all made settings
   printlog "Load diagram and check parameters"
   hDateioeffnen(sFile)
   sleep (3)
   Kontext "DocumentCalc"
   if NOT fSelectChartByNumber ( 1 ) then
       warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
   endif
   EditObjectEdit
   sleep (2)
   Kontext "Diagramm"

   FormatGridXAxisMainGrid
   Kontext
   Active.SetPage TabLinie
   Kontext "TabLinie"
   if Stil.GetSelIndex<>(5) or Farbe.GetSelIndex<>(20) then
      Warnlog "Saved parameters for x-lattice_main not OK"
   end if
   TabLinie.OK
   Kontext "Diagramm"
   FormatGridXAxisMinorGrid
   Kontext
   Active.SetPage TabLinie
   Kontext "TabLinie"
   if Stil.GetSelIndex<>(5) or Farbe.GetSelIndex<>(20) then
      Warnlog "Saved paramters for x-lattice_sub not OK"
   end if
   TabLinie.OK
   Kontext "Diagramm"

   FormatGridYAxisMainGrid
   Kontext
   Active.SetPage TabLinie
   Kontext "TabLinie"
   if Stil.GetSelIndex<>(5) or Farbe.GetSelIndex<>(20) then
      Warnlog "Saved paramters for y-lattice_main not OK"
   end if
   TabLinie.OK
   Kontext "Diagramm"

   FormatGridYAxisMinorGrid
   Kontext
   Active.SetPage TabLinie
   Kontext "TabLinie"
   if Stil.GetSelIndex<>(5) or Farbe.GetSelIndex<>(20) then
      Warnlog "Saved paramters for y-lattice_sub not OK"
   end if
   TabLinie.OK
   Kontext "Diagramm"

   FormatGridZAxisMainGrid
   Kontext
   Active.SetPage TabLinie
   Kontext "TabLinie"
   if Stil.GetSelIndex<>(5) or Farbe.GetSelIndex<>(20) then
      Warnlog "Saved parameters for z-lattice_main not OK"
   end if
   TabLinie.OK
   Kontext "Diagramm"
   FormatGridZAxisMinorGrid
   Kontext
   Active.SetPage TabLinie
   Kontext "TabLinie"
   if Stil.GetSelIndex<>(5) or Farbe.GetSelIndex<>(20) then
      Warnlog "Saved parameters for z-lattice_sub not OK"
   end if
   TabLinie.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE ESCAPE>"

   call  hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatNumberFormat
'/// Check correct number format on chart axis after format change in calc data source

   dim file as string
   printlog "Opening the current file"
   file = convertpath(gTesttoolPath & "chart/level1/input/ch_105c/numberformat" & Ext)
'/// Open the file (gTesttoolPath & "chart/level1/input/ch_105c/numberformat" & Ext)
    call hDateiOeffnen file
    Kontext "DocumentCalc"
    DocumentCalc.MouseDown 1, 1
    DocumentCalc.MouseUp 1, 1
    printlog "Set the currency format of the selected cells to EURO"
    DocumentCalc.TypeKeys "<RIGHT><DOWN>"
'/// Select the chart cellrange
    DocumentCalc.TypeKeys "<SHIFT MOD1 RIGHT>"
    DocumentCalc.TypeKeys "<SHIFT MOD1 DOWN>"
'/// Modify the currency of the cells
    FormatCells
    Kontext
    Active.setPage TabZahlen
    Kontext "TabZahlen"
'/// Select currency category
    FormatCode.setText "#.##0,00 [$��-407];-#.##0,00 [$��-407]"
   TabZahlen.OK
   Kontext "DocumentCalc"
'/// Update the calc document by pressing 'F9
   printlog "Update the calc document by pressing 'F9'"
   DocumentCalc.TypeKeys "<F9>"
   if NOT fSelectChartByNumber ( 1 ) then
       warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
   endif
   EditObjectEdit
   sleep (2)
    printlog "Check, if the currency format in the chart has been updated from DM to EURO "
    FormatAxisYAxis
    Kontext
    Active.setPage TabZahlen
    Kontext "TabZahlen"
'/// Check, if the format change has been detected from the chart
    if left(FormatCode.getText, 13) = "#.##0,00 [$��" or left(FormatCode.getText, 13) = "#,##0.00 [$��" then
      printlog "The current currency has been updated"
    else
      warnlog "The first letter current currency is: " & left(FormatCode.getText, 13) & " instead of #.##0,00 [$��"
    end if
    TabZahlen.Cancel
    Kontext "DocumentCalc"
    DocumentCalc.MouseDown 1, 1
    DocumentCalc.MouseUp 1, 1

    call hCloseDocument

endcase

