'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_001_.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Chart resource test - section FILE
'*
'************************************************************************
'*
' #1 Ch_001_        ' Initial routine
' #1 tFileNew
' #1 tFileOpen
' #1 tFileClose
' #1 tFileSave
' #1 tFileSaveAll
' #1 tFileLatestVersion
' #1 tFileVersions
' #1 tFileProperties
' #1 tFilePrint
' #1 tFilePrintersettings
'*
'\************************************************************************


sub Ch_001_

  printLog Chr(13) + "---------  CH_001_     ----------"

  Call tFileNew
  Call tFileOpen
  Call tFileClose
  Call tFileSave
  Call tFileSaveAll
  Call tFileLatestVersion
  call tFileVersions
  Call tFileProperties
  Call tFilePrint
  Call tFilePrintersettings

End Sub

'*******************************************************************

testcase tFileNew
'/// Dialog test FILE -> NEW
  printLog "* FileNew"

  Call hNewDocument
  FileNewFromTemplate
  Kontext "Neu"
  Zusaetze.Open
  Call DialogTest (Neu)
  Zusaetze.Close
  Neu.Cancel
  Call hCloseDocument
endcase
'-----------------------------------------------------------
testcase tFileOpen
'/// Dialog test FILE -> OPEN
  printLog "* FileOpen"

  Call hNewDocument
  FileOpen
  Kontext "OeffnenDlg"
  UebergeordneterOrdner.Click
  Standard.Click
  Call DialogTest ( OeffnenDlg )
  Kontext "OeffnenDlg"
  OeffnenDlg.Cancel
  Call hCloseDocument
endcase
'-----------------------------------------------------------
testcase tFileClose
'/// Dialog test FILE -> CLOSE
  printLog "* FileClose"

  Call hNewDocument
  InsertLegend
  Kontext "Legende"
  Links.Check
  Legende.OK
  FileClose

  Kontext
  Active.Cancel

  FileClose
  Active.Yes
  Kontext "SpeichernDlg"
  SpeichernDlg.Cancel

  FileClose
  Kontext
  Active.No
endcase
'-----------------------------------------------------------
testcase tFileSave
'/// Dialog test FILE -> SAVE
  printLog "* FileSave"

  Call hNewDocument
  InsertLegend
  Kontext "Legende"
  Links.Check
  Legende.OK

  FileCopyUpdate
  Kontext "SpeichernDlg"
  Call DialogTest ( SpeichernDlg )
  Kontext "SpeichernDlg"
  SpeichernDlg.cancel
  hCloseDocument
endcase
'-----------------------------------------------------------
testcase tFileSaveAll
'/// Dialog test FILE -> SAVE ALL
  printLog "* FileSaveAll"

  hNewDocument
  InsertLegend
  Kontext "Legende"
  Links.Check
  Legende.OK

  WindowNewWindow

  hNewDocument
  InsertLegend
  Kontext "Legende"
  Oben.Check
  Legende.OK

  FileSaveAll
  Kontext "SpeichernDlg"
  UebergeordneterOrdner.Click
  Standard.Click
  SpeichernDlg.Cancel
  Kontext "SpeichernDlg"
  UebergeordneterOrdner.Click
  Standard.Click
  SpeichernDlg.Cancel

  call hCloseDocument
  call hCloseDocument
endcase
'-----------------------------------------------------------
testcase tFileLatestVersion
'/// Dialog test FILE -> VERSIONS (latest)
  printLog "* FileLatestVersion"
  Dim Datei$

  hNewDocument

  hSpeichernUnterKill ( gTesttoolPath + "output\applets\ch_letz.sds" )
  InsertLegend
  Kontext "Legende"
  Links.Check
  Legende.OK

  FileVersions
  Kontext "Versionen"
  call Dialogtest (Versionen)
  Versionen.Close

  Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileVersions
'/// Dialog test FILE -> VERSIONS
Printlog "* FileVersions"
  call hNewDocument
  call hSpeichernUnterkill gTesttoolpath + "\output\calc\version.sdc"
    FileVersions
    Kontext "Versionen"
    call Dialogtest (Versionen)
    Speichern.click
      Kontext "VersionskommentarEingeben"
      call DialogTest(VersionskommentarEingeben)
      VersionskommentarEingeben.Cancel
    Kontext "Versionen"
    Schliessen.Click
  Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileProperties
'/// Dialog test FILE -> PROPERTIES
  printLog "* FileProperties"

  Call hNewDocument
  FileProperties

  Kontext
  Active.SetPage TabDokumentinfo
  Kontext "TabDokumentinfo"
  Call DialogTest (TabDokumentinfo)

  Kontext
  Active.SetPage TabDokument
  Kontext "TabDokument"
  Call DialogTest (TabDokument)

  Kontext
  Active.SetPage TabBenutzer
  Kontext "TabBenutzer"
  Call DialogTest ( TabBenutzer )
  Infofelder.Click
  Kontext "InfonamenBearbeiten"
  Call DialogTest (InfonamenBearbeiten)
  InfonamenBearbeiten.Cancel

  Kontext
  Active.SetPage TabInternet
  Kontext "TabInternet"
  Call DialogTest (TabInternet)

  TabInternet.Close

  Call hCloseDocument
endcase
'-----------------------------------------------------------
testcase tFilePrint
'/// Dialog test FILE -> PRINT
  printLog "* FilePrint"

  Call hNewDocument
  FilePrint
  Kontext "DruckenDlg"
  Call DialogTest ( DruckenDlg )
  DruckenDlg.Cancel

  Call hCloseDocument
endcase
'-----------------------------------------------------------
testcase tFilePrintersettings
'/// Dialog test FILE -> PRINTER SETTINGS
  printLog "* FilePrintersettings"

  Call hNewDocument
  FilePrintersettings
  Kontext "DruckerEinrichten"
  Call DialogTest ( DruckerEinrichten )
  DruckerEinrichten.Cancel

  Call hCloseDocument
endcase
'-----------------------------------------------------------

