'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_library_import.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2006/05/31 08:28:19 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Import BASIC library (flat)
'*
'*******************************************************************************
'**
' #1 tBasicLibraryImport ' Import BASIC library (flat)
'**
'\******************************************************************************

testcase tBasicLibraryImport

    '///<h1>Import a basic library (flat)</h1>
    '///<ul>
    
    dim cMsg as string
    dim iCurrentLib as integer

    '///+<li>Open Basic Organizer</li>
    ToolsMacro_uno
    
    '///+<li>Select My Macros</li>
    kontext "Makro"
    MakroAus.Select( 1 )
    
    '///+<li>Open the library Organizer</li>
    Verwalten.click()
    
    '///+<li>Switch to the libraries-tab</li>
    hSelectBasicObjectOrganizerTab( 3 )    
    
    '///+<li>Make sure My Macros is selected</li>
    printlog( "Select My macros" )
    kontext "TabBibliotheken"
    Bibliothek.select( 1 )
    
    '///+<li>Click to import a library</li>
    printlog( "Click to add a library" )
    Hinzufuegen.click()
    
    '///+<li>Enter the name of the library</li>
    printlog( "Enter the name of the library: " & LIBRARY_NAME )
    kontext "OeffnenDlg"
    DateiName.setText( LIBRARY_NAME )
    
    printlog( "Step into the directory" )
    OeffnenDlg.typeKeys( "<RETURN>" )
    
    '///+<li>Select dialog.xlb (use autocompletion)</li>
    printlog( "type <dia>, wait for autocompletion" )
    DateiName.typeKeys( "dia" )
    sleep( 3 )
    
    '///+<li>Open the file</li>
    printlog( "Open dialog.xlb" )
    Oeffnen.click()
    
    '///+<li>Confirm to append libraries, accept defaults</li>
    printlog( "Confirm to append the library" )
    Kontext "AppendLibraries"
    AppendLibraries.ok()
    
    'Errorcondition Begin: The library has already been appended
    'Kontext "Active"
    'if ( Active.exists() ) then
    '    cMsg = Active.getText()
    '    cMsg = hRemoveLineBreaks( cMsg )
    '    warnlog( "Unexpected messagebox: " & cMsg )
    '    printlog( "Recovering from error, the test cannot continue" )
    '    Active.ok()
    '    Kontext "TabBibliotheken"
    '    TabBibliotheken.cancel()
    '    kontext "Makro"
    '    Makro.cancel()
    '    hDeleteFile( hGetWorkPath() & LIBRARY_NAME )
    '    goto endsub
    'endif
    'Errorcondition End: The library has already been appended 

    '///+<li>Find the new library, select it</li>
    printlog( "Select the new library" )
    kontext "TabBibliotheken"
    for iCurrentLib = 1 to Bibliotheksliste.getItemCount()
        Bibliotheksliste.select( iCurrentLib )
        if ( Bibliotheksliste.getSelText = LIBRARY_NAME ) then
            exit for
        endif
    next iCurrentLib        
    
    '///+<li>On libraries-tab click delete-button (correct lib must be selected)</li>
    printlog( "Delete the library, confirm with YES" )
    Kontext "TabBibliotheken"
    Loeschen.click()
    
    '///+<li>Confirm deletion with YES</li>
    Kontext "Active"
    if ( Active.exists() ) then
        active.yes()
    else 
        warnlog( "Deletion warning for libraries is missing" )
    endif
    
    '///+<li>Close the macro organizer (Libraries Tab)</li>
    printlog( "Close macro/library organizer" )
    kontext "TabBibliotheken"
    TabBibliotheken.cancel()
    
    '///+<li>Close OpenOffice.org Basic Macros dialog</li>
    printlog( "Close macro organizer" )
    kontext "Makro"
    Makro.cancel()
    
    '///+<li>Cleanup: Close the document</li>
    hDestroyDocument()

    '///+<li>Cleanup: Delete the library (directory)</li>    
    hDeleteFile( hGetWorkPath() & LIBRARY_NAME )
    
    '///</ul>

    
endcase

