'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras.inc,v $
'*
'*  $Revision: 1.25 $
'*
'*  last change: $Author: jsk $ $Date: 2006/08/14 10:17:17 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : Perform standard operations on all samples/templates etc.
'*
'************************************************************************
'*
' #1 tShowAllObjectsAsPreview    ' show all templates/samples in preview window in the dialog
' #1 tModifyObjects              ' Work with samples and templates
' #1 tOpenObjectsWithFileDialog  ' open templates/samples via file open dialog
'*
'\***********************************************************************

private const MAX_FILE_COUNT = 3000 ' the max number of templates or samples

' NOTE: Usually we have only about a 100 templates but in multi-language
'       installations there are more than 2100. You should not run these     
'       tests on multi language installations. Really.

testcase tShowAllObjectsAsPreview( cCategory as string )

   dim iObjectFolder as Integer   ' the current folder in loops
   dim iObjectFolders as integer  ' the number of template/sample-folders
   
   dim iObject as Integer         ' the current template/sample within loops
   dim iObjectCount( 20 ) as integer  ' number of templates/samples in the folders
   
  
   printlog( "" )
   
   '///<h3>Show documents in the preview pane of the teplates-dialog</h3>
   '///<ul>
   '///+<li>Open File->New->Templates and documents</li>
   FileNewFromTemplate
   
   '///+<li>find the category we want to work with (TEMPLATES/SAMPLES...)</li>
   hSelectCategory( cCategory )
   
   '///+<li>Count the folders in the root of cCategory</li>
   iObjectFolders = FileList.getItemCount()
   
   '///+</li>Now go through every folder and count the number of objects</li>
   for iObject = 1 to iObjectFolders
   
      '//<li>grab a folder below cCategory and open it</li>
      hSelectFileFolder( iObject , true )
      
      '<li>get the number of items</li>
      iObjectCount( iObject ) = FileList.getItemCount()
      
      '<li>step up one level to the root of cCategory</li>
      UpOneLevel.click()
      
   next iObject
   
   Kontext "TemplateAndDocuments"
   '///+<li>Click the preview button</li>
   preview.click()

   printlog( "" )
   printlog( "Displaying documents in preview pane" )
   printlog( "" )


   
   '///+<li>Step through all folders and templates/samples</li>
   '///<ol>   
   for iObjectFolder = 1 to iObjectFolders

        printlog( "Restart The application" )
        Kontext "TemplateAndDocuments"
        TemplateAndDocuments.cancel()
        call exitRestartTheOffice()
        FileNewFromTemplate
        kontext "TemplateAndDocuments"

      '///+<li>Select the category (samples, templates ...)</li>
      hSelectCategory( cCategory )
   
      '///+<li>Select the current folder</li>
      hSelectFileFolder( iObjectFolder , false )

      for iObject = 1 to iObjectCount( iObjectFolder ) 
      
          printlog( "Object-Folder: " & iObjectFolder & " Entry: " & iObject )
      
          ' to skip a document add the rule here and jump to SkipThisObject: 
   
          '///+<li>Select the desired template</li>
          hSelectDocumentObject( iObject , 0 )
          
          '///+<li>Wait for the preview to be loaded and displayed</li>
          'Problem: Cannot verify the content of preview window.
          sleep( 5 )
          
          SkipThisObject: 
          
          '///+<li>Next document</li>

      next iObject
          
      '///</ol>
      
   next iObjectFolder
   
   '///</ul>
   Kontext "TemplateAndDocuments"
   TemplateAndDocuments.cancel()
   
   
endcase   

'*******************************************************************************

testcase tModifyObjects( iMode as integer, cCategory as string, sVer as string )

    const CFN = "tModifyObjects::"
    const RESTART = 15

    '///<h1>Open all Objects, save, close, reload, save and close them</h1>
    '///The test should be able to handle any OOo 1.x and 2.x files
    '///<ul>

    dim iObjectFolder as Integer
    dim iObjectFolders as integer
   
    dim iObject as Integer
   
    dim iObjectCount( 20 ) as integer
   
    dim iResetOffice as integer 
        iResetOffice = 1
       
    dim sFile as string
    dim sPath as string
        sPath = hGetWorkPath()  
    dim brc as boolean
    dim crc as string

    printlog( "" )
   
    '///+<li>Open File->New->Templates and documents</li>
    FileNewFromTemplate
   
    '///+<li>select the category in the template dialog (left pane)</li>
    hSelectCategory( cCategory )
   
    '///+<li>Get the number of folders in the root of cCategory</li>
    iObjectFolders = FileList.getItemCount()
   
    '///+<li>get the number of all objects below cCategory and its subfolders</li>
    for iObject = 1 to iObjectFolders
   
        '///+<li>select and open a folder</li>
        hSelectFileFolder( iObject , true )
      
        '///+<li>count the items in the list</li>
        iObjectCount( iObject ) = FileList.getItemCount()
      
        '///+<li>move back up to the root of cCategory</li>
        UpOneLevel.click()
      
    next iObject
   
    Kontext "TemplateAndDocuments"
    
    '///+<li>Click the document-info button, do not load the preview</li>
    docinfo.click()

    '///+<li>close the templates and samples dialog</li>
    TemplateAndDocuments.cancel()
   
    call exitRestartTheOffice
   
    printlog( "" )
    printlog( "Starting to load/save/close/reload/close all Objects" )
    printlog( "" )
   
   
   
    '///+<li>Step through all folders and Objects</li>
    for iObjectFolder = 1 to iObjectFolders
   
        for iObject = 1 to iObjectCount( iObjectFolder ) 
      
            ' to skip a document add the rule here and jump to SkipThisObject: 
          
            gApplication = "WRITER"    
            
            printlog( "" )
          
            ' we need a mechanism to restart the office after about every 15 
            ' documents because the application becomes unstable after loading
            ' too many templates in a row. However, this is a bug that
            ' should be addressed sometime, this will not appear under normal
            ' circumstances.
            if ( iResetOffice = RESTART ) then
                printlog( "Restarting the office" )
                call exitRestartTheOffice()
                iResetOffice = 1
            endif
   
            '///<ol>
            FileNewFromTemplate
      
            '///+<li>Select the desired-category: Templates/Samples ...</li>
            hSelectCategory( cCategory )
      
            '///+<li>Select the current folder</li>
            hSelectFileFolder( iObjectFolder , false )
          
            '///+<li>Select the desired Object, open or edit it</li>
            crc = hSelectDocumentObject( iObject , iMode )
            
            '///+<li>If the object can be edited we open it. Skip otherwise</li>
            ' treat it like a folder
            kontext "TemplateAndDocuments"
            if ( TemplateAndDocuments.exists() ) then
                if ( not edit.isEnabled() ) then
                    crc = "Folder"
                endif
            else
                printlog( "Templates And Documents dialog is closed" )
            endif
            
            '///+<li>If object is a folder, we skip the entire test</li>
            if ( crc = "Folder" ) then
                printlog( CFN & "Object is folder or #edit# is disabled, skipping" )
                UpOneLevel.click()
                TemplateAndDocuments.cancel()
                goto SkipThisObject
            endif
            
            '///+<li>Cancel the filterdialog if present -> bug</li>
            brc = hCancelFilterDialog()
            if ( brc ) then
                printlog( CFN & "Skipping document" )
            else
               
                '///+<li>Close the navigator if present</li>
                brc = hCloseNavigator()
          
                '///+<li>Build the filename</li>
                sFile = sPath & cCategory & iObjectFolder & "_" & iObject
                sFile = convertpath( sFile )
                
                '///+<li>Delete the file if it exists</li>
                brc = hDeleteFile( sFile )

                '///+<li>Save the file, no overwrite, use autoextension</li>
                brc = hSaveFile( sFile, "" , false , true )
                
                
                '///+<li>Get the filename from the Document-Properties</li>
                sFile = hGetFileNameFromProperties()
                sFile = sPath & sFile
                sFile = convertpath( sFile )
                
                '///+<li>Close the document</li>
                brc = hDestroyDocument()
                
                '///+<li>Check that the document is closed</li>
                brc = hCheckDocCount( 1 , true )
                
                '///+<li>Verify that the last document is "The first doc!"</li>
                brc = hIdentifyWriterDoc( "The first doc!" )                
          
                '///+<li>Load the file again</li>
                brc = hLoadFile( sFile )
                brc = hHandleActivesOnLoad( 1 , 2 )
                brc = hHandleInitialDialogs()
                
                '///+<li>Cancel the filterdialog if present -> bug</li>
                brc = hCancelFilterDialog()
                if ( not brc ) then
                
                    '///+<li>Close the navigator if present</li>
                    brc = hCloseNavigator()
                
                    '///+<li>Close the document</li>
                    brc = hDestroyDocument()
                
                    '///+<li>Verify that the document has been closed</li>
                    brc = hCheckDocCount( 1 , true )
                    
                    '///+<li>Verify that the last document is "The first doc!"</li>
                    brc = hIdentifyWriterDoc( "The first doc!" )
          
          
                    iResetOffice = iResetOffice + 1
                    
                endif

                '///+<li>Delete the file after completion</li>
                brc = hDeleteFile( sFile )

                '///</ol>
                
            endif
            
            SkipThisObject:
            
      
        next iObject
      
    next iObjectFolder
   
   '///</ul>
   
endcase   
   
'*******************************************************************************

testcase tOpenObjectsWithFileDialog( cCategory as string )

    const CFN = "tOpenObjectsWithFileDialog::"

    '///<h1>open all templates with file-open-dialog</h1>
    '///<b>get all templates out of ..\share\template\-directory</b>
    '///<ul>

    dim lsFile ( MAX_FILE_COUNT ) as String ' list of all files below samples or templates
    dim sRootPath as String       ' rootpath, depends on cCategory
    dim sFileIn as String         ' file to open
    dim sFileOut as string        ' file to save, reload, delete
    dim sPathOut as string
        sPathOut = hGetWorkPath()
    dim sExtension as String      ' filter: determines whether to test the file
    
    dim iCurrentTemplate as Integer ' increment: current template from lsFile()
    dim iCounterToBreak as Integer  ' increment: after 10 files: restart
    
    dim bSkipFile as boolean      ' turns true if file is to be skipped
    
    dim brc as boolean            ' some multi purpose boolan returncode
    
    ' the path where the samples/templates are located, verify function params
    select case cCategory
    case "SAMPLES"    : sRootPath = gNetzOfficePath & "share\samples"
    case "TEMPLATES"  : sRootPath = gNetzOfficePath & "share\template"
    case default
        warnlog( CFN & "Invalid category passed to function" )
        goto endsub
    end select
   
    sRootPath = convertpath( sRootPath )
   
    '///+<li>get the complete list of all files below templates/samples</li>
    GetAllFileList ( sRootPath, "*.ot*", lsFile() )
    hListPrint ( lsFile() , "" , "" )

    ' unfortunately we coannot load all samples/templates in a row, the office
    ' freeezes at some point. So we do a restart every ten files.
    iCounterToBreak = 0
   
    '///+<li>go through the list of samples/templates and do things</li>>
    for iCurrentTemplate = 2 to ListCount ( lsFile() )
   
        iCounterToBreak = iCounterToBreak + 1
      
        '///+<li>Restart the office after every 10 templates/samples loaded</li>
        if ( iCounterToBreak = 10 ) then
            printlog( CFN & "Exit and restart StarOffice" )
            iCounterToBreak = 0
            call ExitRestartTheOffice
        end if
      
        ' sFileIn holds the file we currently work with
        sFileIn = lsFile( iCurrentTemplate )
        
        ' compare the filename against the blacklist. TRUE on match
        bSkipFile = hApplyBlackList( sFileIn )
        
        ' if the file does not belong to the blacklist, we do the test on it
        if ( not bSkipFile ) then

            '///+<li>load the file</li>
            printlog( "" )
            brc = hLoadFile( sFileIn ) 
            brc = hHandleActivesOnLoad( 0 , 2 )
            
            '///+<li>Cancel the filterdialog if present -> bug</li>
            brc = hCancelFilterDialog()
            
            '///+<li>Close the navigator if present</li>
            brc = hCloseNavigator()

            ' Build the filename
            sFileOut = cCategory & "_" & iCurrentTemplate
            sFileOut = convertpath( sPathOut & sFileOut ) 
          
            '///+<li>Save the file, use autoextension</li> 
            brc = hSaveFile( sFileOut, "" , true, true )
            
            '///+<li>Get the filename from the Document-Properties</li>
            sFileOut = hGetFileNameFromProperties()
            sFileOut = sPathOut & sFileOut
            sFileOut = convertpath( sFileOut )

            '///+<li>Close possible dialogs like "Update links" etc.</li>
            ' note: this is delayed, because the dialogs take time to pop up
            '       even while the dialog is visible, we can work with the doc.
            brc = hHandleInitialDialogs()
            
            '///+<li>Close the document, verify that it has been closed</li>
            brc = hDestroyDocument()
            brc = hCheckDocCount( 1 , true )
          
            '///+<li>Load the file, close the navigator if present</li>
            brc = hLoadFile( sFileOut )
            brc = hHandleActivesOnLoad( 0 , 2 )
            brc = hCloseNavigator()

            '///+<li>Close the file, verify that only one document remains open</li>
            brc = hDestroyDocument()
            brc = hCheckDocCount( 1 , true )     
      
            '///+<li>Delete the file</li>
            brc = hDeleteFile( sFileOut )
        
        endif         
      
    next iCurrentTemplate
    '///</ul>
   
endcase


