'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: opt_ooo_memory.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/11/15 13:36:19 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : 1. test for general group userdata ... view)
'*
'*******************************************************************************
'**
' #1 tOOoMemory           ' Memory settings
'**
'\******************************************************************************

testcase tOOoMemory

  Dim lsSave (7) as String
  Dim lbSave as Boolean
  Dim sValue as String

'///short test if 'StarOffice / Momory' is saved in configuration
'///open a new document
'///open options 'StarOffice' / 'Memory'
   hNewDocument
   ToolsOptions
   hToolsOptions ( "StarOffice", "Memory" )

'///check platform dependences
'///- 'Load StarOffice at system-startup' has to exists only on windows-systems
 printlog " - check platform dependences "
   if gPlatgroup = "unx" then
      if LoadQuickstarter.Exists then
         if LoadQuickstarter.IsEnabled then Warnlog "The 'Load StarOffice during system-startup'-Feature is visible on non-windows plattforms => BUG 88257"
      end if
   end if

'///save old data
 printlog " - save old data"
   lsSave(1) = UndoSteps.GetText
   lsSave(2) = StarOffice.GetText
   lsSave(3) = MemoryPerObject.GetText
   lsSave(4) = RemoveFromMemoryAfter.GetText
   lsSave(5) = NumberOfObjects.GetText
   if gPlatgroup = "w95" then lbSave = LoadQuickstarter.IsChecked

'///invert/change data
 printlog " - invert/change data"
   UndoSteps.SetText "80"
   StarOffice.SetText "50"
   if Instr ( lsSave(3), "," ) <> 0 then
      sValue = "4,1"
   else
      sValue = "4.1"
   end if
   MemoryPerObject.SetText sValue
   RemoveFromMemoryAfter.SetText "00:41"
   NumberOfObjects.SetText "81"
   if gPlatgroup = "w95" then
      try
          LoadQuickstarter.UnCheck
      catch
      endcatch
   end if

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///close document
   hCloseDocument

'///exit/restart StarOffice
 printlog " - exit/restart StarOffice"
   ExitRestartTheOffice

'///open options 'StarOffice' / 'Memory'
 printlog " - check data"
   ToolsOptions
   hToolsOptions ( "StarOffice", "Memory" )

'///check data
   if UndoSteps.GetText             <> "80" then Warnlog "Undo steps => changes not saved!"
   if StarOffice.GetText            <> "50" then Warnlog "Use For StarOffice => changes not saved!"
   if MemoryPerObject.GetText       <> sValue then Warnlog "Memory per object => changes not saved! => " + MemoryPerObject.GetText
   if RemoveFromMemoryAfter.GetText <> "00:41" then Warnlog "Remove from memory after => changes not saved! =>" + RemoveFromMemoryAfter.GetText
   if NumberOfObjects.GetText       <> "81" then Warnlog "Number of objects => changes not saved!"
   if gPlatgroup = "w95" then
      try
          if LoadQuickstarter.IsEnabled then 
          if LoadQuickstarter.IsChecked = TRUE then 
              Warnlog "Load StarOffice during system-startup => changes not saved!"
          end if
          end if
      catch
      endcatch
   end if

'///make 2. changes
 printlog " - 2. change data"
   UndoSteps.SetText "5"
   StarOffice.SetText "11"
   if Instr ( lsSave(3), "," ) <> 0 then
      sValue = "1,9"
   else
      sValue = "1.9"
   end if
   MemoryPerObject.SetText sValue
   RemoveFromMemoryAfter.SetText "01:32"
   NumberOfObjects.SetText "2"
   if gPlatgroup = "w95" then
      try
          LoadQuickstarter.Check
      catch
      endcatch
   end if

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///open options 'StarOffice' / 'Memory'
 printlog " - check data"
   ToolsOptions
   hToolsOptions ( "StarOffice", "Memory" )

'///check data
   if UndoSteps.GetText             <> "5" then Warnlog "Undo steps => changes not saved!"
   if StarOffice.GetText            <> "11" then Warnlog "Use For StarOffice => changes not saved!"
   if MemoryPerObject.GetText       <> sValue then Warnlog "Memory per object => changes not saved! => " + MemoryPerObject.GetText
   if RemoveFromMemoryAfter.GetText <> "01:32" then Warnlog "Remove from memory after => changes not saved! => " + RemoveFromMemoryAfter.GetText
   if NumberOfObjects.GetText       <> "2" then Warnlog "Number of objects => changes not saved!"
   if gPlatgroup = "w95" then
      try
          if LoadQuickstarter.isEnabled then
          if LoadQuickstarter.IsChecked <> TRUE then 
              Warnlog "Load StarOffice during system-startup => changes not saved!"
          end if
          end if
      catch
      endcatch
   end if

'///reset to saved data
 printlog " - reset to saved data"
   UndoSteps.SetText lsSave(1)
   StarOffice.SetText lsSave(2)
   MemoryPerObject.SetText lsSave(3)
   RemoveFromMemoryAfter.SetText lsSave(4)
   NumberOfObjects.SetText lsSave(5)
   if gPlatgroup = "w95" then
      try
          if lbSave = TRUE then LoadQuickstarter.Check else LoadQuickstarter.UnCheck
      catch
      endcatch
   end if

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///open options 'StarOffice' / 'Memory'
   ToolsOptions
   hToolsOptions ( "StarOffice", "Memory" )

'///check data
 printlog " - check the reset data"
   if UndoSteps.GetText             <> lsSave(1) then Warnlog "Undo steps => changes not saved!"
   if StarOffice.GetText            <> lsSave(2) then Warnlog "Use For StarOffice => changes not saved!"
   if MemoryPerObject.GetText       <> lsSave(3) then Warnlog "Memory per object => changes not saved! => " + MemoryPerObject.GetText
   if RemoveFromMemoryAfter.GetText <> lsSave(4) then Warnlog "Remove from memory after => changes not saved! =>" + RemoveFromMemoryAfter.GetText
   if NumberOfObjects.GetText       <> lsSave(5) then Warnlog "Number of objects => changes not saved!"
   if gPlatgroup = "w95" then
      try
          if LoadQuickstarter.IsEnabled then 
          if LoadQuickstarter.IsChecked <> lbSave then Warnlog "Load StarOffice during system-startup => changes not saved!"
          end if
      catch
      endcatch
   end if

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

endcase


