'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_broken_signature.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2006/07/24 07:34:10 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Load documents containing hidden BASIC scripts
'*
'*******************************************************************************
'**
' #1 tBrokenSignature ' Document with macro and broken digital signature
'**
'\******************************************************************************

testcase tBrokenSignature()

    '///<h1>Level 1 test: Allow macro execution/Security set to medium</h1>
    '///<ul>

    dim acFile( 1 ) as string

        acFile( 1 ) = "framework\security\input\test_macro (signed).odt"
        acFile( 1 ) = gTesttoolPath & acFile( 1 )
        acFile( 1 ) = convertpath( acFile( 1 ) )

    dim iCurrentFile as integer ' increment variable
    dim cMsg as string          ' string from messagebox
    dim brc as boolean          ' some returnvalue
    

    '///+<li>Do following for each document to be tested:</li>
    '///<ul>

    for iCurrentFile = 1 to ubound( acFile() )

        printlog( "" )
        printlog( "File: " & acFile( iCurrentFile ) )

        '///+<li>Click FileOpen or go to the dialog via menu</li>
	    FileOpen

        '///+<li>Enter the name of the file</li>
	    kontext "OeffnenDlg"
	    Dateiname.setText( acFile( iCurrentFile ) )

        '///+<li>Click &quot;Open&quot;</li>
        Oeffnen.click()
        sleep( 3 )
        
        '///+<li>Test for Broken Signature Messagebox:</li>
        '///<ul>
        Kontext "Active"
        if ( active.exists() ) then
            cMsg = active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            
            '///+<li>Make sure that we do not have the macro</li>
            if ( cMsg = "Hello from StarBasic!" ) then
                warnlog( "Macro was executed without any warning" )            
            else
                '///+<li>Guess the dialog by Ressource Type</li>
                if ( active.getRT() = 304 ) then
                    printlog( "Broken signature message: " & cMsg )
                else
                    warnlog( "Unknown messagebox: " & cMsg )
                endif
            endif
            
            '///+<li>Close dialog with OK</li>
            active.ok()
            
        endif
        '///</ul>
        
        '///+<li>Test for the macro again</li>        
        kontext "Active"
        if ( active.exists() ) then
            cMsg = active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            warnlog( "Unexpected messagebox: " & cMsg )
            active.ok()
        endif

        '///+<li>Close the document</li>
        call ExitRestartTheOffice()

    next iCurrentFile

    '///</ul>
    '///</ul>

endcase

