'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_tools.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: jsk $ $Date: 2006/02/16 14:56:06 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : Tools to handle templates and samples
'*
'************************************************************************
'*
' #1 hCompareStylesAndFormats ' Compare styles and formats against a reference
' #1 hApplyBlackList          ' Identify files not to be loaded
' #1 hSelectLineStylesTab   ' switch tabs on format line dialog
' #1 hSelectAreaStylesTab   ' switch tabs on format area dialog
' #1 hGetDrawObjectStyleFileName ' Retrieve name of draw object style file (localized)
' #1 hGetDrawObjectSpecialFileName ' Retrieve name of draw object style file (non-localized)
'*
'\***********************************************************************

function hCompareStylesAndFormats( sFormatListFromGUI() as string, _
                                                 iIndex as integer, _
                                               iVariant as integer ) as boolean
                                               
    '///<h3>Compare styles and formats (drawing objects) to a reference</h3>
    '///<ul>

    dim sFileName as string
    dim sFileOut as string
    dim sFormatListFromFile( 1000 ) as string
    dim cPrefix as string
        cPrefix = gTesttoolpath & "framework\extras\input\formats\"
    dim brc as boolean
    dim irc as integer
    const CSUFFIX = ".txt"
    sFormatListFromFile ( 0 ) = 0
    
    dim cLanguage as string
        cLanguage = hGetTwoDigitLangCode( iSprache )

    '///+<li>Create filenames for:</li>
    '///<ul>
    select case iIndex
     
    '///+<li>Line styles ( standard.sod, *.sod )</li>
    case 1

        select case iVariant
        case 1 : sFileName = cPrefix  & "lines\stand" & cLanguage
        case 2 : sFileName = cPrefix  & "lines\styles" & cLanguage
        end select

    '///+<li>Line ends ( arrows ) ( standard.sow, *.soe )</li>
    case 2  

        select case iVariant
        case = 1 : sFileName = cPrefix  & "arrows\stand" & cLanguage
        case = 2 : sFileName = cPrefix  & "arrows\arrow" & cLanguage
        end select

    '///+<li>Colors ( standard.soc, *.soc )</li>
    case 3  

        select case iVariant
        case 1 : sFileName = cPrefix  & "colors\stand" & cLanguage
        case 2 : sFileName = cPrefix  & "colors\palet"
        case 3 : sFileName = cPrefix  & "colors\cmyk"
        case 4 : sFileName = cPrefix  & "colors\web"
        case 5 : sFileName = cPrefix  & "colors\html"
        case 6 : sFileName = cPrefix  & "colors\gall"
        case 7 : sFileName = cPrefix  & "colors\sun"
        end select

    '///+<li>Gadients ( Standard.sog, *.sog )</li>
    case 4

        select case iVariant
        case 1 : sFileName = cPrefix  & "gradient\stand"  & cLanguage
        case 2 : sFileName = cPrefix  & "gradient\class"  & cLanguage
        case 3 : sFileName = cPrefix  & "gradient\modern" & cLanguage
        end select

    '///+<li>Hatchings = standard.soh</li>
    case 5  

        select case iVariant
        case 1 : sFileName = cPrefix  & "hatching\stand" & cLanguage
        case 2 : sFileName = cPrefix  & "hatching\hatch" & cLanguage
        end select

    '///+<li>Bitmap = standard.soh</li>
    case 6 

        select case iVariant
        case 1 : sFileName = cPrefix  & "bitmap\stand" & cLanguage
        end select

    '///+<li>Name of Table-formats ( internal )</li>
    case 7
    
        sFileName = cPrefix  & "tables\table" & cLanguage
        
    '///+<li>Name of Label-formats</li>
    case 8
    
        sFileName = cPrefix  & "labels\lab" & iVariant & cLanguage
        
    end select
    '///</ul>

    '///+<li>Create filenames (inluding paths) for input and output</li>
    sFileName = sFileName & CSUFFIX
    sFileOut = hGetWorkPath & sFileName
    sFileName = convertpath( sFileName )
    
    '///+<li>Compare the lists or create a new one if it does not exist</li>
    irc = hManageComparisionList( sFileName, sFileOut, sFormatListFromGUI() )
    if ( irc <> 0 ) then
        warnlog( "Comparision failed!" )
        brc = false
    else
        brc = true
    endif
    
    '///+<li>Return TRUE if comparision succeeded with no errors</li>
    hCompareStylesAndFormats() = brc
    '///</ul>

end function

'*******************************************************************************

function hApplyBlackList( sFileName as string ) as boolean

    const CFN = "hApplyBlackList::"
    '///<h3>Function to identify blacklisted files that will not be tested</h3>
    '///<ul>
    '///+<li>Make sure we have a valid functionparameter</li>

    if ( sFileName = "" ) then
        warnlog( CFN & "Empty filename passed to function" )
        hApplyBlackList() = false
        exit function
    endif

    dim sExtension as string
    dim brc as boolean
    
    '///+<li>idxexample.sxw is not a regular document and should not be loaded.</li>
    if ( instr( sFileName , "idxexample.odt" ) > 0 ) then
        printlog( CFN & "Skipping idxexample.odt" )
        hApplyBlackList() = true
        exit function
    endif

    '///+<li>files with the suffix .table are to be skipped as well.</li>
    if ( instr( sFileName , ".table" ) > 0 ) then
        printlog( "" )
        printlog( CFN & "Skipping .table" )
        hApplyBlackList() = true
        exit function
    endif

    '///+<li>Test the suffix and skip graphics files (.gif, .jpg, .bmp)</li>
    brc = hFileHasThreeCharSuffix( sFileName )

    if ( brc ) then
        sExtension = hGetSuffixFromFileName( sFilename )

        if ( sExtension = ".bmp" OR sExtension = ".gif" OR sExtension = ".jpg" ) then
            printlog( CFN & "Skipping bmp, gif or jpg graphic" )
            hApplyBlackList() = true
            exit function
        endif

    endif

    printlog( CFN & "No rules apply" )
    hApplyBlackList() = false
    '///</ul>

end function

'*******************************************************************************

function hSelectLineStylesTab( cTab as string ) as boolean

    '///<h3>Switch between tabpages in the format linestyles dialog</h3>
    '///<i>Starting point: FormatLine must be open</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of the tabpage (string). Valid options are:</li>
    '///<ul>
    '///+<li>&quot;Line&quot;</li>
    '///+<li>&quot;LineStyles&quot;</li>
    '///+<li>&quot;LineEnds&quot;</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstatus (boolean)</li>
    '///<ul>
    '///+<li>TRUE if tabpage could be accessed</li>
    '///+<li>FALSE on any other condition</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    const CFN = "hSelectStylesTab::"
    dim brc as boolean
        brc = true
    
    '///+<li>Set Tabpage</li>
    '///+<li>Set Context</li>
    '///+<li>Warn about errors</li>
    kontext
    
    try
        select case lcase( cTab )
        case "linestyles"   : active.setPage TabLinienStile
                              kontext = "TabLinienStile"
                              call DialogTest( TabLinienStile )
                              kontext = "TabLinienStile"
        case "lineends"     : active.setPage TabLinienEnden   
                              kontext = "TabLinienEnden"
                              call DialogTest( TabLinienEnden )
                              kontext = "TabLinienEnden"
        case "line"         : active.setPage TabLinie
                              kontext = "TabLinie"
                              call DialogTest( TabLinie )
                              kontext = "TabLinie"
        case else           : brc = false
        end select
    catch
        brc = false
        warnlog( CFN & "TabPage does not exist (caught by try...catch)" )
    endcatch
    
    if ( brc ) then
        printlog( CFN & "Successfully selected tab-page: " & cTab )
    else
        printlog( CFN & "Failed to select tab-page: " & cTab ) 
    endif
    
    hSelectLineStylesTab() = brc
    '///</ul>
    
end function

'*******************************************************************************

function hSelectAreaStylesTab( cTab as string ) as boolean

    '///<h3>INCOMPLETE! Switch between tabpages in the format area dialog</h3>
    '///<i>Starting point: FormatLine must be open</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Name of the tabpage (string). Valid options are:</li>
    '///<ul>
    '///+<li>&quot;Colors&quot;</li>
    '///+<li>&quot;Gradients&quot;</li>
    '///+<li>&quot;Hatchings&quot;</li>
    '///+<li>&quot;Bitmaps&quot;</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstatus (boolean)</li>
    '///<ul>
    '///+<li>TRUE if tabpage could be accessed</li>
    '///+<li>FALSE on any other condition</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    const CFN = "hSelectAreaStylesTab::"
    dim brc as boolean
        brc = true
    
    '///+<li>Set Tabpage</li>
    '///+<li>Set Context</li>
    '///+<li>Warn about errors</li>
    kontext
    
    try
        select case lcase( cTab )
        case "colors"       : active.setPage TabFarben 
                              kontext = "TabFarben"
        case "gradients"    : active.setPage TabFarbverlaeufe 
                              kontext = "TabFarbverlaeufe"
        case "hatchings"    : active.setPage TabSchraffuren
                              kontext = "TabSchraffuren"
        case "bitmaps"      : active.setPage TabBitmap
                              kontext = "TabBitmap"
        case else           : brc = false
        end select
    catch
        brc = false
        warnlog( CFN & "TabPage does not exist (caught by try...catch)" )
    endcatch
    
    if ( brc ) then
        printlog( CFN & "Successfully selected tab-page" )
    else
        printlog( CFN & "Failed to select tab-page" 
    endif
    
    hSelectAreaStylesTab() = brc
    '///</ul>
    
end function

'*******************************************************************************

function hGetDrawObjectStyleFileName( cCategory as string ) as string 

    '///<h3>Retrieve the filename of a Draw-Object style (localized)</h3>
    '///<i>Uses file: framework/tools/input/i18ndata.txt</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>The category to retrieve (string). Valid options are</li>
    '///<ul>
    '///+<li>&quot;ArrowHead&quot;</li>
    '///+<li>&quot;LineStyles&quot;</li>
    '///+<li>&quot;Colors&quot;</li>
    '///+<li>&quot;ClassicGradients&quot;</li>
    '///+<li>&quot;ModernGradients&quot;</li>
    '///+<li>&quot;Hatchings&quot;</li>
    '///+<li>&quot;Bitmaps&quot;</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>fully qualified path to a styles file (string)</li>
    '///<ul>
    '///+<li>e.g. /somewhere/nowhere/hatchings_en-US.soh</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hGetDrawObjectStyleFileName::"

    '///+<li>Construct the path to the file where the definitions are stored</li>
    dim cWorkFile as string
        cWorkFile = gTesttoolPath & "framework\extras\input\formats\styles.txt"
        cWorkFile = convertpath( cWorkFile )
    
    '///+<li>Initialize an array that can hold the entire file content</li>
    dim iSize as integer
        iSize = hListFileGetSize( cWorkFile )
    dim aStyleData( iSize ) as string
    
    '///+<li>Create a valid language code (string)</li>
    dim cLanguage as string
        cLanguage = hGetTwoDigitLangCode( iSprache )
    dim cFile as string

    '///+<li>Retrieve the relevant section from the definitions file</li>
    hGetDataFileSection( cWorkFile, aStyleData(), cCategory, "", "" )    
    
    '///+<li>Create path to office installation</li>
    cFile = gNetzOfficePath 
    
    '///+<li>Append path to styles directory</li>
    cFile = cFile & hGetValueForKeyAsString( aStyleData(), "Path" )
    
    '///+<li>Append file prefix</li>
    cFile = cFile & hGetValueForKeyAsString( aStyleData(), "Prefix" )
    
    '///+<li>Append language dependent string</li>
    cFile = cFile & hGetI18nData( "locale_short", cLanguage )
    
    '///+<li>Append suffix</li>
    cFile = cFile & hGetValueForKeyAsString( aStyleData(), "Suffix" )
    
    '///+<li>Do ConvertPath()</li>
    cFile = convertpath( cFile )
    
    printlog( CFN & "File: " & cFile )
    hGetDrawObjectStyleFileName() = cFile
    '///</ul>
        
end function

'*******************************************************************************

function hGetDrawObjectSpecialFileName( cCategory as string, _
                                        cSpecial as string ) as string 

    '///<h3>Retrieve the filename of a Draw-Object style (non localized)</h3>
    '///<i>Uses file: framework/tools/input/i18ndata.txt</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>The category to retrieve (string). Valid options are</li>
    '///<ul>
    '///+<li>&quot;ArrowHead&quot;</li>
    '///+<li>&quot;LineStyles&quot;</li>
    '///+<li>&quot;Colors&quot;</li>
    '///+<li>&quot;ClassicGradients&quot;</li>
    '///+<li>&quot;ModernGradients&quot;</li>
    '///+<li>&quot;Hatchings&quot;</li>
    '///+<li>&quot;Bitmaps&quot;</li>
    '///</ul>
    '///+<li>The category to retrieve (string). Valid options are</li>
    '///<ul>
    '///+<li>&quot;Default&quot; (should always exist)</li>
    '///+<li>Any other identifier found in the section of the definitions file</li>
    '///</ul>    
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>fully qualified path to a styles file (string)</li>
    '///<ul>
    '///+<li>e.g. /somewhere/nowhere/standard.sod</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
                                        
    const CFN = "hGetDrawObjectSpecialFileName::" 
    '///+<li>Construct the path to the file where the definitions are stored</li>
    dim cWorkFile as string
        cWorkFile = gTesttoolPath & "framework\extras\input\formats\styles.txt"
        cWorkFile = convertpath( cWorkFile )
    
    '///+<li>Initialize an array that can hold the entire file content</li>
    dim iSize as integer
        iSize = hListFileGetSize( cWorkFile )
    dim aStyleData( iSize ) as string
    
    '///+<li>Create a valid language code (string)</li>
    dim cLanguage as string
        cLanguage = hGetTwoDigitLangCode( iSprache )
    dim cFile as string

    '///+<li>Retrieve the relevant section from the definitions file</li>
    hGetDataFileSection( cWorkFile, aStyleData(), cCategory, "", "" )    
    
    '///+<li>Create path to office installation</li>
    cFile = gNetzOfficePath 
    
    '///+<li>Append path to styles directory</li>
    cFile = cFile & hGetValueForKeyAsString( aStyleData(), "Path" )
    
    '///+<li>Append file prefix</li>
    cFile = cFile & hGetValueForKeyAsString( aStyleData(), cSpecial )
    
    '///+<li>Append suffix</li>
    cFile = cFile & hGetValueForKeyAsString( aStyleData(), "Suffix" )
    
    '///+<li>Do ConvertPath()</li>
    cFile = convertpath( cFile )
    
    printlog( CFN & "File: " & cFile )
    hGetDrawObjectSpecialFileName() = cFile
    '///</ul>
        
end function


