'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: pathlist.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:54 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description :
'*
'*******************************************************************************
' **
' #1 checkPathItem
' #1 getPathString
' #1 getPathStringFromDialog
' **
'\******************************************************************************

function checkPathItem( _file as string , sKey as string ) as boolean

   dim _sRefpath as string
   dim sRefpath as string

   sKey = lcase( sKey )

   sRefpath = getPathString( sKey )
   _sRefpath = hGetDataFileSection( _file , skey , "" , "" , "" )

   checkPathItem() = keycompare( sRefpath , _sRefpath , sKey )

end function

'*******************************************************************************

function getPathString( sKey as string ) as string

   dim iCurrentPath as integer

   kontext "TabPfade"

   ' select the first item in the list
   typ.typekeys( "<Down>" )
   typ.typekeys( "<Home>" )

   ' run through the list until the key is found.
   for iCurrentPath = 1 to typ.getItemCount()

      if ( lcase( typ.getSelText() ) = sKey ) then

         bearbeiten.click()
         getPathString = getPathStringFromDialog()
         exit function

      else

         typ.typekeys( "<Down>" )

      endif

   next iCurrentPath

   getPathString() = "Error. Key not found in pathlist"

end function

'*******************************************************************************

function getPathStringFromDialog() as string

   ' we have two different path selection dialogs. One supports exactly one
   ' path (FileOpen dialog) and the other allows multiple paths.
   ' PfadeAuswaehlen does not append a trailing / so this has to be done
   ' manually. (sigh)

   dim sPath as string

   kontext "PfadeAuswaehlen"
   if ( PfadeAuswaehlen.exists( 2 )) then

      getPathStringFromDialog() = pfade.getItemText(1) + gPathSigne()
      PfadeAuswaehlen.cancel()

   endif

   kontext "OeffnenDlg"
   if ( OeffnenDlg.exists( 2 ) ) then

      getPathStringFromDialog() = Pfad.getSelText()
      OeffnenDlg.cancel()

   endif

   kontext "TabPfade"

end function
