'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: toolbar_tools.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2006/05/15 18:22:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : global update test (Standardbar)
'*
'***************************************************************************
'**
' #1 hAccessStandardBar       ' Checking if the Toolbar exists in the module
' #1 hResetStandardbar        ' Reset StandardBar to default configuration
' #1 hStandardbarItemGetCount ' Retrieve the number of items on from the StandardBar
' #1 hToggleToolbarItem       ' switch item on or off on the StandardBar
' #1 hStandardbarLoadUrl      ' Access the Load-URL EntryFiels
' #1 hStandardbarNewDialog    ' Handle the New Dialog
' #1 hStandardbarSaveAs       ' Handle the SaveAs dialog
'**
'\***************************************************************************

function hAccessStandardBar() as boolean

    '///<h3>Verify that the Standard Bar exists</h3>
    '///<i>This function works for all gApplications</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE if StandardBar exists</li>
    '///+<li>FALSE if standardBar does not exist</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    const CFN = "hAccessStandardBar::"
    dim brc as boolean
        brc = true

    '///+<li>Open a new document</li>
    hCreateDocument()

    '///+<li>Try to access the standardbar (query .exists())</li>
    kontext "standardbar"
    if ( Standardbar.Exists() ) then

        if ( not Standardbar.IsVisible ) then
            warnlog( "The 'Standardbar' is not visible in " + gApplication 
            brc = false
        endif

    else
        warnlog( "The 'Standardbar' does not exist in " + gApplication )
        brc = false
    endif

    '///+<li>Close the navigator</li>
    hCloseNavigator()
    
    '///+<li>Close the document</li>
    hDestroyDocument()
    hAccessStandardBar() = brc
    '///</ul>
    
end function

'*******************************************************************************

'sub StandardbarResetNow
function hResetStandardBar() as boolean

    '///<h3>Reset the Standard Bar to default configuration</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>Always TRUE as no errorconditions are handled yet</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    '///+<li>Create a new document</li>
    hCreateDocument()
    printlog " - Standardbar"

    kontext "standardbar"
    
    '///+<li>Move the mouse on the Standardbar</li>
    Standardbar.MouseMove ( 70, 50 )
    sleep (1)
    
    '///+<li>Open the context menu on Standardbar</li>
    Standardbar.OpenContextmenu
    
    '///+<li>Click on 2. entry (Cutomize Toolbar)</li>
    hMenuselectNr (2)
    sleep (1)

    kontext
    Active.SetPage TabCustomizeToolbars

    kontext "tabcustomizetoolbars"
    
    '///+<li>Toggle to 'Toolbars' tab page.</li>

    if TabCustomizeToolbars.Exists(2) then
    
        '///+<li>Press in first section '... Toolbars' the 'toolbar'-button</li>
        MenuBtn.Click
        sleep(1)
        
        '///+<li>A drop down menu will be opened.</li>
        '///+<li>Select the first enabled menu entry which should be 'Restore...'</li>
        hMenuSelectNr(1)

        kontext

        if Active.Exists(2) then

            if Active.GetRT = 304 then
            
                '///+<li>Press Yes button on verification dialog.</li>
                Active.Yes
            end if

        else
            warnlog "No verification comes up if the RESET button has been pressed!"
        end if

        '///+<li>Close 'Toolbars' tab page and the dialog with OK.</li>
        kontext "tabcustomizetoolbars"
        
        TabCustomizeToolbars.OK
    else
        warnlog "The customze toolbar dialog does not come up after calling it from context menu!"
        'Closing the Context menu if the dialog does not come up.
        Menuselect(0)
    end if

    '///+<li>Close document.</li>
    hDestroyDocument()
    hResetStandardBar() = true
    '///</ul>
    
end function

'*******************************************************************************

function hStandardbarItemGetCount()

    '///<h3>Update test: Get the number of items in the StandardBar</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    dim iCounter as integer

    '///+<li>open a new writer document</li>
    gApplication = "Writer"
    hCreateDocument()
    
    printlog "Count all items and activate the hidden items:"

    '///+<li>check the number of entries ( must be 30 )</li>
    printlog " - count all items at the Standardbar"

    '///+<li>open the context menu on the Standardbar</li>
    Kontext "Standardbar"
    Standardbar.OpenContextmenu()

    '///+<li>select the 1. entry</li>
    hMenuselectNr( 1 )
    sleep (1)

    '///+<li>count all entries ( there must be 30 entries )</li>
    iCounter = 0
    iCounter = hMenuItemGetCount()
   
    if ( iCounter <> 30 ) then
        warnlog( "Expected: 30 entries at the Standardbar, found: " & iCounter )
    endif

    '///+<li>close the context menu</li>
    hMenuClose()
    sleep (1)
    '///</ul>
    
end function

'*******************************************************************************

function hToggleToolbarItem( iMenuPos as integer )

    '///<h3>Update test: Toggle an icon on the Standardbar (on/off)</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Position of the item in the menu (integer)</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    
    dim iItemsInMenu as integer

    '///+<li>Open the context menu of the standard bar</li>
    Kontext "Standardbar"
    Standardbar.OpenContextmenu()
    
    '///+<li>Retrieve the number of items in the menu</li>
    iItemsInMenu = hMenuItemGetCount()
    
    ' in case the toolbar does not fit into the window we have more items
    ' (those that are invisible will be listed as context menu entries),
    ' the menuitem (invisible items) is placed at position nItems - 3
    '///+<li>Take the number of items -3, select the entry</li>
    hMenuselectNr( iItemsInMenu - 3 )
    sleep( 1 )
    
    '///+<li>Select the provided menu position</li>
    hMenuselectNr( iMenuPos )        
    sleep( 1 )
    '///</ul>

end function

'*******************************************************************************

function hStandardbarLoadUrl() as boolean

    '///<h3>Update test: Access the url-entryfield</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    ' this function tries to write to the url-EntryField. This should fail,
    ' because the item is not visible. Then the item should be enabled,
    ' written to and disabled again (no use of reset toolbar here, this is
    ' done in another testcase
    
    dim iItemMenuPos as integer
    iItemMenuPos = 1
    
    printlog( "Load URL" )

    '///+<li>Write to URL-Filed (fails: Entryfiled is not visible)</li>
    try
        Kontext "Standardbar"
        URLEingabe.settext( "Should not work" )
        warnlog( "The Load URL EntryField is visible and active" )
    catch
        printlog( " - The Load URL EntryField is not visible. Good." )
    endcatch
    
    '///+<li>add the control to the standardbar</li>
    printlog( " - activate load URL" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"
    
    '///+<li>verify its existence by entering some text</li>
    try
        URLEingabe.settext( "Should work" )
        printlog( " - The Load URL REntryFiled is visible and active. Good." )
    catch
        warnlog( "Could not write to 'load url' control" )
    endcatch
        
    '///+<li>remove the control from the standardbar</li>
    printlog( " - deactivate load URL" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"
    
    '///+<li>try to modify non existing object, failure expected</li>
    try
        Kontext "Standardbar"
        URLEingabe.settext( "Should not work" )
        warnlog( "The Load URL EntryField is visible and active" )
    catch 
        printlog( " - The Load URL EntryField is not visible. Good." )
    endcatch
    '///</ul>
    
end function

'*******************************************************************************

function hStandardbarNewDialog()
    
    '///<h3>Update test: New from Template via StandardBar</h3>
    '///<i>Starting point: Plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    dim iItemMenuPos as integer
    iItemMenuPos = 3

    printlog( "New from Template" )

    '///+<li>Click on &quot;New from Template&quot;-button (fails, it is not visible)</li>
    try
        NeuDialog.Click()
        sleep( 3 )
        warnlog( "The 'New from Template'-button should not be visible by default." )
    catch
        printlog( " - the control is not present or active." )
    endcatch
    
    '///+<li>add the control to the standardbar</li>
    printlog( " - activate New from Template button" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"

    '///+<li>click the button</li>
    NeuDialog.click()    
    
    '///+<li>handle possible dialogs (there should never be one)</li>
    kontext "Active"
    if ( active.exists() ) then
        warnlog( "Unexpected active" )
        printlog( active.gettext() )
        try
            printlog( "Closing dialog" )
            active.ok()
        catch
        endcatch
    endif

    '///+<li>close the templates and samples dialog</li>
    printlog( " - close templates and samples (cancel)" )
    Kontext "TemplateAndDocuments"
    if ( TemplateAndDocuments.Exists( 5 ) ) then
        TemplateAndDocuments.cancel()
    else
        warnlog( "The 'Template and Documents'-dialog was not activated" )
    endif
   
    '///+<li>finally remove the button from the toolbar</li>
    printlog( " - deactivate New from Template button" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"
    '///</ul>
    
end function

'*******************************************************************************

function hStandardbarSaveAs()

    '///<h3>Update test: SaveAs button on StandardBar</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>


    dim bBreakOnError as boolean
    dim iItemMenuPos as integer
    iItemMenuPos = 6


    printlog( "Save As" )


    '///+<li>Click on SaveAs (fails, item is not visible)</li>
    try
        SpeichernAls.Click()
        sleep( 3 )
        warnlog( "#i46363# (?)The 'SaveAs'-button should be invisible but is displayed" )
        sleep( 2 )
        kontext "SpeichernDlg"
        SpeichernDlg.cancel()
        bBreakOnError = true
    catch
        printlog( " - the control is not present or active." )
        bBreakOnError = false
    endcatch
    
    if ( not bBreakOnError ) then
    
        '///+<li>Add the control to the standardbar</li>
        printlog( " - activate 'Save As' button" )
        hToggleToolbarItem( iItemMenuPos )
        Kontext "Standardbar"

        '///+<li>Click the button</li>
        SpeichernAls.click()    
    
        '///+<li>Close the save-as dialog</li>
        printlog( " - close Save As (cancel)" )
        Kontext "SpeichernDlg"
        if ( SpeichernDlg.Exists( 5 ) ) then
            SpeichernDlg.cancel()
        else
            warnlog( "The 'Save As'-dialog was not activated" )
        endif
        
    endif
   
    '///+<li>Remove the button from the toolbar</li>
    printlog( " - deactivate 'Save as' button" )
    hToggleToolbarItem( iItemMenuPos )
    Kontext "Standardbar"
    '///</ul>
    
end function

