'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: testdriver.bas,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2006/08/02 08:58:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : QA-Internal test of some functions in framework::tools::inc
'*
'\******************************************************************************

sub main

    use "framework\tools\inc\security_tools.inc"
    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\listfuncs.inc"
    use "framework\tools\inc\extension_manager_tools.inc"
    use "framework\tools\inc\stringtools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\accels.inc"
    
    dim cPath as string
    cPath = gTesttoolPath & "framework\basic\input\extensions\simpleLicense\LongLic.oxt"
    cPath = convertpath( cPath )    
    
    printlog hExtensionAddGUI( cPath , TRUE )
    sResetTheOffice()
    
    printlog hExtensionAddGUI( cPath , FALSE )
    sResetTheOffice()
    
    cPath = gTesttoolPath & "framework\basic\input\pkgmgr\TestArray.uno.pkg"
    cPath = convertpath( cPath )
    
    printlog hExtensionAddGUI( cPath , TRUE )
    sResetTheOffice()
    
    printlog hExtensionAddGUI( cPath , FALSE )
    sResetTheOffice()
    
end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles

    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication = "WRITER"
    call GetUseFiles()

end sub

'-------------------------------------------------------------------------

function TD_hWarnAtSaveOrSend()

    dim brc as boolean
    qaerrorlog( "The bad boys" )
    
    brc = hWarnAtSaveOrSend( -2 )
    if ( brc ) then warnlog( "Failed" )
    brc = hWarnAtSaveOrSend( 2 )
    if ( brc ) then warnlog( "Failed" )    

    qaerrorlog( "The good boys" )
    
    brc = hWarnAtSaveOrSend( -1 )
    if ( not brc ) then warnlog( "Failed" )
    brc = hWarnAtSaveOrSend( 0 )
    if ( not brc ) then warnlog( "Failed" )    
    brc = hWarnAtSaveOrSend( 1 )
    if ( not brc ) then warnlog( "Failed" )   
    
end function

'*******************************************************************************

function TD_hManageComparisionList()

    dim sFileIn as string
    dim sFileOut as string
    dim asMyArray( 4 ) as string
    
    asMyArray( 0 ) = "3"
    asMyArray( 1 ) = "a - first line"
    asMyArray( 2 ) = "b - second line"
    asMyArray( 3 ) = "c - third line"
    asMyArray( 4 ) = "Not used"
    
    sFileIn = hGetWorkPath() & "compare-test.txt"
    sFileOut = sFileIn
    
    hManageComparisionList( sFilein, sFileOut, asMyArray() )  ' file creation
    hManageComparisionList( sFilein, sFileOut, asMyArray() )  ' file comparision
    
    asMyArray( 3 ) = "c - third line - changed"
    
    hManageComparisionList( sFilein, sFileOut, asMyArray() )  ' file comparision/fail
    
end function
