'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_agendawizard.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsk $ $Date: 2006/04/04 11:35:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Update test for agenda wizard
'*
'*******************************************************************************
'**
' #1 tUpdtAgendaWizard ' Update test for agenda wizard
'**
'\******************************************************************************

testcase tUpdtAgendaWizard

    '///<H1>Update test for agenda wizard</H1>
    '///<ul>
    dim iErr as integer
    dim brc as boolean
    
    dim cTemplateName as string
    dim cTemplatePath as string    
    
    ' Build the filename we want to save the template as.
    cTemplateName = "FWK-Testtool-Template-AgendaWizard.ott"
    cTemplatePath = gOfficePath & "user\template\" & cTemplateName
    cTemplatePath = convertpath( cTemplatePath )         

    '///+<li>open the Agenda-wizard using the menu, page design opens</li>
    iErr = hOpenWizardWithMenu( "AGENDA" )
    if ( iErr = 1 ) then
        warnlog( "#i46909# Wizard crashes/does not open" )
        goto endsub
    endif  
    
    '///+<li>First page</li>
    printlog( " * Page 1 : Page Design" )
    Kontext "AutopilotAgenda"
    call dialogtest2( AutopilotAgenda, 1 )
    PageDesignList.select( 3 )
    hClickNextButton()
    
    '///+<li>Second page</li>
    Kontext "AutopilotAgenda"
    call dialogtest2( AutopilotAgenda, 2 )
    hClickNextButton()
    
    '///+<li>Third page</li>
    Kontext "AutopilotAgenda"
    call dialogtest2( AutopilotAgenda, 3 )
    hClickNextButton()

    '///+<li>Fourth page</li>
    Kontext "AutopilotAgenda"
    call dialogtest2( AutopilotAgenda, 4 )
    hClickNextButton()

    '///+<li>Fifth page</li>
    Kontext "AutopilotAgenda"
    call dialogtest2( AutopilotAgenda, 5 )
    hClickNextButton()

    '///+<li>sixth page</li>
    Kontext "AutopilotAgenda"
    call dialogtest2( AutopilotAgenda, 6 )
    
    '///+<li>name the template for further usage</li>
    printlog( "   * name the template for further usage" )
    TemplateName.setText( cTemplateName )
    hSetTemplateSavePath( cTemplatePath )    
        
    '///+<li>Click Finish-Button</li>
    hFinishWizard( 1 )
    
    '///+<li>Handle possible File-Save error</li>
    iErr = hHandleSaveError()
    if ( iErr = 1 ) then
        kontext "AutopilotAgenda"
        hFinishWizard( 1 )
    endif    
    
    '///+<li>Close the new template</li>
    brc = hDestroyDocument()
    if ( not brc ) then
        qaerrorlog( "#i59233# The wizard does not display the new template" )
    endif
        
    '///+<li>delete the new template</li>
    hDeleteFile( cTemplatePath )
    '///</ul>

endcase

