'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_help.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2006/05/16 07:47:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : global update/resource test
'*
'*******************************************************************************
'*
' #1 tHelp_DialogTest      ' update-test for help ( can't close )
' #1 tHelp_ToolBar         ' work with help tool-bar
'*
'\******************************************************************************

testcase tHelp_DialogTest

    '///<h1>Update test for the main help window</h1>
    '///<ul>
    Dim i as Integer
    dim brc as boolean
    printlog "- open the help"

    '///+<li>Open Help</li>
    brc = hOpenHelp()
    if ( not brc ) then
        warnlog( "Could not open the help, aborting" )
        goto endsub
    endif

    '///+<li>activate 'Content'-page</li>
    brc = hSelectHelpTab( "content" )
    call DialogTest( ContentPage )

    '///+<li>activate 'Index'-page</li>
    brc = hSelectHelpTab( "index" )
    call DialogTest( IndexPage )

    '///+<li>activate 'Find'-page</li>
    brc = hSelectHelpTab( "find" )
    call DialogTest( FindPage )

    '///+<li>activate 'Bookmark'-page</li>
    brc = hSelectHelpTab( "bookmarks" )
    call DialogTest( BookmarksPage )

    '///+<li>close help ( does not work correctly with testtool )</li>
    Kontext "StarOfficeHelp"
    hCloseHelp()
    '///</ul>

endcase

'*******************************************************************************

testcase tHelp_ToolBar

    '///<h1>Update test for the toolbar on the main Help window</h1>
    '///<ul>
    Dim i as Integer
    dim brc as boolean

    '///+<li>Open Help</li>
    brc = hOpenHelp()
    if ( not brc ) then
        warnlog( "Could not open the Help Browser, aborting test" )
        goto endsub
    endif

    kontext "starofficehelp"
    '///+<li>Index-button</li>
    printlog "- Index -> on"
    '///+<li>activate 'Index' ( => only the help-window must be shown )</li>
    Index.Click()
    sleep (2)

    printlog "- Index -> off"
    '///+<li>activate 'Index' ( => the full help-window must be shown )</li>
    Index.Click()

    ' Backward- and Forward-button
    '///+<li>open the 'Index'-page</li>
    printlog "- activate 'Index'-page"
    brc = hSelectHelpTab( "index" )
    sleep( 2 )

    SearchIndex.Select 4
    DisplayIndex.Click()
    sleep (2)

    '///+<li>backward</li>
    printlog "- backward"
    Backward.Click()
    sleep (2)

    '///+<li>forward</li>
    printlog "- forward"
    Forward.Click()
    sleep (2)

    '///+<li>first page</li>
    printlog "- first page"
    GoToStart.Click()

    '///+<li>print</li>
    printlog "- print"
    ' the print-dialog must be shown ( if direct-printing is activated => BUG )
    '///+<li>close the print-dialog</li>
    PrintButton.Click()

    kontext "active"

    if Active.Exists ( 1 ) then

        if Active.getRT() = 304 then
            qaerrorlog "- Printing failed: Did you define a default printer?"
            Active.OK()
            
            Kontext "DruckenDlg"
            if ( druckenDlg.exists() ) then
                printlog( "Printer dialog is still open, closing with cancel" )
                druckenDlg. cancel()
            endif
            
        endif

    else
        kontext "druckendlg"
        if DruckenDlg.NotExists (2) then
            warnlog "No print-dialog is open. => direct printing? - bug 93788!"
        else
            DruckenDlg.Cancel()
        endif

    endif
    
    '///+<li>Set Bookmark</li>
    printlog "- Set Bookmark"

    kontext "tb_help"
    SetBookmarks.Click()

    '///+<li>close the 'add bookmark'-dialog</li>
    kontext "addbookmark"
    call DialogTest ( AddBookmark )
    AddBookmark.Cancel()

    '///+<li>close help ( does not work correctly with testtool )</li>
    brc = hCloseHelp()
    '///</ul>

endcase
