'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_standardbar3.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: jsk $ $Date: 2006/03/03 13:31:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : global update test (Standardbar)
'*
'***************************************************************************
'**
' #1 tStandardBar_3  ' Update test for all icons on the StandardBar
'**
'\***************************************************************************

testcase tStandardBar_3

    dim sFileOut as String
    dim iTry as integer ' some increment variable
    dim brc as boolean

    '///<h1>Update test for all icons on the StandardBar</h1>

    '///<ul>
    printlog "************************************************************"
    printlog "Check all visible icons on the Standardbar"
    printlog "************************************************************"
    
    gApplication = "CALC"

    '///+<li>Delete files from the workdirectory to ensure a clean test</li>
    sFileOut = hGetWorkPath() & "FWK-update-functionbar" & hGetSuffix( "current" )
    ConvertPath ( sFileOut )
    hDeleteFile( sFileOut )

    '///+<li>Reset the Standardbar to defaults</li>
    hResetStandardBar()
    printlog "check all entries on the 'Standardbar'"

    '///<i>Note: The URL-field ist not tested here</i>

    '///</ul>
    printlog " - No test of URL-Field"

    '///Save

    '///<ul>
    printlog " - Save File"
    gApplication = "Calc"

    '///+<li>open a calc document</li>
    printlog " - open a Calc document"
    hCreateDocument()

    '///+<li>insert some text in one cell ( don't forget to make a 'return' at the end )</li>
    printlog " - insert text into a random cell, press <Enter>"

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys( "Only for a test.<Return>" )
    sleep ( 1 )

    '///<i>Save-Button must be active -> click on the button</i>
    printlog " - press the 'Save' button"

    Kontext "Standardbar"
    Speichern.Click()

    '///+<li>insert a file name and save the file</li>
    printlog " - save the file to: " + sFileOut

    Kontext "SpeichernDlg"
    Dateiname.SetText( sFileOut )
    AutomatischeDateinamenserweiterung.uncheck()
    Speichern.Click()
    sleep ( 5 )

    '///+<li>close the document</li>
    printlog " - close the document"
    brc = hDestroyDocument()

    '///+<li>open a writer docment</li>
    printlog " - open a writer document"
    gApplication = "WRITER"
    hCreateDocument()

    '///</ul>

    '///Open a file via 'open' button

    '///<ul>
    printlog " - press the 'File Open' button"

    Kontext "Standardbar"
    oeffnen.click()

    '///+<li>open the saved Calc-File</li>
    printlog " - open the recently saved Calc document"

    Kontext "OeffnenDlg"
    sleep ( 1 )
    Dateiname.SetText( sFileOut )
    sleep( 3 )
    oeffnen.click()
    sleep ( 5 )

    '///+<li>close the document</li>
    printlog " - close the document"
    hDestroyDocument()

    '///</ul>

    '///Edit File by pressing 'File Open' button

    '///<ul>
    printlog " - Edit the file by pressing the 'File Open' button"

    Kontext "Standardbar"
    oeffnen.click()

    Kontext "OeffnenDlg"
    sleep (1)

    '///+<li>open the saved Calc-File 'read only'</li>
    Dateiname.SetText( sFileOut )
    NurLesen.Check()
    oeffnen.click()
    sleep (3)

    '///+<li>check if the file is loaded read only ( Object Bar must be invisible )</li>

    Kontext "FormatObjectbar"
    if FormatObjectbar.Exists() then
        if FormatObjectbar.IsVisible() then
            qaerrorlog "The file was not loaded readonly, the objectbar is visible!"
        endif
    end if

    '///+<li>click on 'edit file' -> activate the document</li>

    Kontext "Standardbar"
    try
        Bearbeiten.Click()
        sleep (2)
    catch
        warnlog( "#i33342# The Button 'Bearbeiten' is not enabled" )
        printlog( "->when loading documents readonly, the button should be active" )
    endcatch

    '///+<li>check if the file is not read only ( Object Bar must be active )</li>

    Kontext "FormatObjectbar"
    if FormatObjectbar.Exists() <> TRUE then
        warnlog "The file can't be edit, the objectbar is not visible!!"
    endif

    '///+<li>click on 'edit file' -> deactivate the document</li>

    Kontext "Standardbar"
    try
        Bearbeiten.Click()
        sleep (2)
    catch
        qaerrorlog( "#i33342# The Button 'Bearbeiten' is not enabled" )
        printlog( "->when loading documents readonly, the button should be active" )
    endcatch

    '///+<li>check if the file is loaded read only ( Object Bar must be invisible )</li>

    Kontext "FormatObjectbar"
    if FormatObjectbar.Exists() then
        if FormatObjectbar.IsVisible() then
            qaerrorlog "The file can't be set readonly by click on edit,"
            printlog " ...the objectbar is visible!"
        endif
    end if

    '///+<li>click on 'edit file' -> activate the document</li>

    Kontext "Standardbar"
    try
        Bearbeiten.Click()
        sleep (2)
    catch
        qaerrorlog( "#i33342# The Button 'Bearbeiten' is not enabled" )
        printlog( "->when loading documents readonly, the button should be active" )
    endcatch

    '///</ul>

    '///Print File directly

    '///<ul>
    printlog " - Print File directly"

    '///+<li>insert a short text in the calc document</li>

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys( "<Down><Down>" )
    DocumentCalc.TypeKeys( "Short print-test by an automated test." )
    DocumentCalc.TypeKeys( "<Return>This letter can be trashed after one day!" )
    DocumentCalc.TypeKeys( "<Return>Today is <Tab>" + Date + "<Return>" )

    '///+<li>click on Printer-Button</li>

    Kontext "Standardbar"
    Drucken.Click()
    sleep( 1 )
    ' on windows we can run into a messagebox informing the user that no default printer
    ' is defined. we need to close this one. it is new with src680

    kontext "Active"
    if ( active.exists() ) then
        if ( gPlatGroup = "UNX" ) then
            warnlog( "This messagebox is not expected on Unix" )
        endif
        qaerrorlog( "Messagebox: " & active.getText() )
        active.ok()
    endif

    '///<br><i>if no defaultprinter is defined, cancel the warning</i>
    ' this dialog comes up, if no default printer on the SYSTEM is defined!

    kontext "DruckenDlg"
    if DruckenDlg.exists (2) then
        qaerrorlog "Please set a default printer on this system!"
        DruckenDlg.cancel()
    endif
    ' this dialog is what we expect

    Kontext "Druckbestaetigung"
    if Druckbestaetigung.NotExists( 5 ) then

        Kontext "Active"
        if Active.Exists( 2 ) then
            warnlog "A messagebox comes up : " + Active.GetText()
            try
                Active.OK()
                printlog( "Closed dialog wit OK" )
            catch
                Active.No()
                printlog( "Closed dialog with NO")
            endcatch
        endif
    endif
    ' Confirm printing dialog should not be in the way

    kontext "DruckBestaetigung"
    for iTry = 1 to 20
        if ( not Druckbestaetigung.Exists( 2 ) ) then
            exit for
        endif
    next iTry

    '///+<li>check if a page is printed</li>

    '///</ul>

    '///Cut / Copy / Paste

    '///<ul>
    printlog " - Cut / Copy / Paste"
    sleep (2)

    '///+<li>select a row in the spreadsheet</li>

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys( "<Up>", 7 )
    DocumentCalc.TypeKeys( "<Shift Down>", 5 )
    sleep (1)

    '///+<li>click on Cut</li>

    Kontext "Standardbar"
    Ausschneiden.Click()
    sleep (1)

    '///+<li>move one cell down</li>

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys( "<Down>" )
    sleep (1)

    '///+<li>click on Paste</li>

    Kontext "Standardbar"
    Einfuegen.Click()

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys( "<Up>", 7 )
    DocumentCalc.TypeKeys( "<Shift Down>", 5 )
    sleep (1)

    '///+<li>select a row in the spreadsheet</li>

    '///+<li>click on Copy</li>

    Kontext "Standardbar"
    Kopieren.Click()
    sleep (1)

    '///+<li>press right-arrow and <return></li>

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys( "<Right><Return>" )
    sleep (1)

    '///+<li>click on Paste</li>

    Kontext "Standardbar"
    Einfuegen.Click()
    sleep (1)

    '///</ul>

    '///Undo / Redo

    '///<ul>
    printlog " - Undo / Redo"

    '///+<li>click on Undo</li>
    Undo.Click()
    sleep (1)

    '///+<li>click on Redo</li>
    Redo.Click()
    sleep (1)

    '///</ul>

    '///Navigator ( on/off )

    '///<ul>
    printlog " - Navigator on/off"

    Kontext "Standardbar"

    '///+<li>click on Navigator -> on</li>
    NavigatorButton.Click()

    '///+<li>check if the navigator is visible</li>

    Kontext "Navigator"
    if Navigator.Exists( 2 ) <> TRUE then
        warnlog "The Navigator can't be activated!"
    endif
    sleep (1)

    '///+<li>click on Navigator -> off</li>

    Kontext "Standardbar"
    Standardbar.MouseDoubleClick ( 95, 95 )
    sleep (1)
    try
        NavigatorButton.Click()
    catch

        Kontext "Navigator"
        Navigator.Close()
        printlog "Focus-Problems : The Navigator is closed by the close-method "
        printlog "on the dialog!"
    endcatch

    '///+<li>check if the navigator does not exist</li>

    Kontext "Navigator"
    if Navigator.Exists( 2 ) <> FALSE then
        warnlog "The Navigator can't be deactivated!"
    endif
    sleep (1)

    '///</ul>

    '///Stylist ( on/off )

    '///<ul>
    printlog " - Stylist on/off"

    Kontext "Standardbar"
    GestalterButton.Click()

    '///+<li>click on Stylist -> on</li>

    Kontext "Stylist"

    '///+<li>check if the Stylist is visible</li>
    if Stylist.Exists( 2 ) <> TRUE then
        warnlog "The Stylist can't be activated!"
    endif
    sleep (1)

    '///+<li>click on Stylist -> off</li>

    Kontext "Standardbar"
    Standardbar.MouseDoubleClick ( 95, 95 )
    sleep (1)
    try
        GestalterButton.Click()
    catch

        Kontext "Stylist"
        Stylist.Close()
        Printlog "Focus-Problems : The Stylist is closed by the close-method on the dialog!"
    endcatch

    '///+<li>check if the Stylist does not exist</li>

    Kontext "Stylist"
    if Stylist.Exists( 2 ) <> FALSE then
        warnlog "The Stylist can't be deactivated!"
    endif
    sleep (1)

    '///</ul>

    '///Hyperlink dialog ( on / off )

    '///<ul>
    printlog " - Hyperlink dialog"

    Kontext "Standardbar"

    '///+<li>click on Hyperlink dialog  -> on
    HyperlinkDialog.Click()

    '///+<li>check if the Hyperlink dialog is visible

    Kontext "Hyperlink"
    if Hyperlink.Exists( 2 ) <> TRUE then
        try
            Auswahl.MouseDown (50,10)
            Auswahl.MouseUp (50,10)
        catch
            warnlog "The Hyperlink-Dialog can't be activated!"
        endcatch

        Kontext "Hyperlink"
        if Hyperlink.Exists( 2 ) <> TRUE then
            warnlog "The Hyperlink-Dialog can't still be activated!"
        endif
    endif
    sleep (1)

    '///+<li>click on Hyperlink dialog  -> off

    Kontext "Standardbar"
    Standardbar.MouseDoubleClick ( 95, 95 )
    sleep (1)
    try
        HyperlinkDialog.Click()
    catch

        Kontext "Hyperlink"
        Hyperlink.Cancel()
        Printlog "Focus-Problems : The Hyperlink-dialog is closed "
        printlog "by the close-method on the dialog!"
    endcatch

    '///+<li>check if the Hyperlink dialog does not exist

    Kontext "Hyperlink"
    if Hyperlink.Exists( 2 ) <> FALSE then
        warnlog "The Hyperlink-Dialog can't be deactivated!"
    endif
    sleep ( 1 )

    '///</ul>

    '///Gallery ( on / off )

    '///<ul>
    printlog " - Gallery"

    '///+<li>click on gallery  -> on
    Kontext "Standardbar"
    GalleryButton.Click()

    '///+<li>check if the Gallery-Beamer is visible
    Kontext "Gallery"
    If Gallery.Exists( 3 ) <> TRUE then
        warnlog "The Gallery is not shown!"
    endif
    sleep (1)

    '///+<li>click on gallery  -> off  ( Testtool close the Gallery with tools/gallery )
    ' can't deactivate the gallery with the button in Standardbar with testtool
    ToolsGallery

    '///+<li>check if the Gallery-Beamer does not exist
    Kontext "Gallery"
    If Gallery.Exists( 3 ) = TRUE then
        warnlog "The Gallery is can't be deactivated!"
    endif
    sleep (1)

    '///+<li>close both documents</li>
    hDestroyDocument()
    hDestroyDocument()
    
    '///+<li>Delete the workfile</li>
    hDeleteFile( sFileOut )

    '///</ul>

endcase

'*******************************************************************************

