'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: export_graphic_2.inc,v $
'*
'*  $Revision: 1.12 $
'*
'*  last change: $Author: fredrikh $ $Date: 2006/06/30 15:45:53 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description : Graphics Export Test
'*
'************************************************************************
'*
' #1 tBMP
' #1 tEMF
' #1 tSVM
' #1 tMET
' #1 tWMF
' #1 tPCT
' #1 tEPS
' #1 tGIF
' #1 tJPEG
'*
'\***********************************************************************************

testcase tBMP
   dim x,i as integer
   dim bTemp as boolean
   dim sX, sY as string
   dim slX as string
   dim sX2, sY2 as string
   dim sDocument as string

    '/// open the document
    sDocument = ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) )
    hDateiOeffnen sDocument

   if hCallExport (OutputGrafikTBO , "BMP - Windows Bitmap (.bmp)" ) = TRUE then
      Kontext "BMPOptionen"
      if BMPOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
         '/// 'Color Resolution' listbox contains eight items ///'
         x = Farbaufloesung.GetItemCount
         if x <> 8 then warnlog "Color Resolution Count is wrong; should be:8, is:" + x
         for i = 1 to x
            Farbaufloesung.Select i
            sleep 1
            Printlog " - " + i + ": '" +Farbaufloesung.GetSelText + "'"
            '/// checkbox RLE coding has to be enabled only for '4 and 8 bit' color palettes ///'
            if ((i > 3) AND (i < 8)) then
               if RLEKodierung.IsEnabled <> TRUE then warnlog "'RLE coding' is not checkable :-("
            else
               if RLEKodierung.IsEnabled <> FALSE then warnlog "'RLE coding' is checkable :-("
            endif
         next i
         '/// if Mode 'original' is selected, DPI///'
         Original.Check
            if DPI.IsEnabled then warnlog " :-("
            if Breite.IsEnabled then warnlog " :-("
            if Hoehe.IsEnabled then warnlog " :-("
         Aufloesung.Check
            x = DPI.GetItemCount
            '/// 'DPI' listbox contains eight items ///'
            if x <> 4 then warnlog "'DPI' Count is wrong; should be:4, is:" + x
            for i = 1 to x
               DPI.Select i
               Printlog " - " + i + ": '" +DPI.GetSelText + "'"
            next i
            if Breite.IsEnabled then warnlog " :-("
            if Hoehe.IsEnabled then warnlog " :-("
         Groesse.Check
            if DPI.IsEnabled then warnlog " :-("
            Breite.More
            Hoehe.Less
         Sleep 1
         '/// leave dialog with cancel -> there has to be no file created! ///'
         BMPOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+".bmp") = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "ok :-)"
         else
            warnlog "Dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No BMP-Option-Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog "BMP-Exportfilter has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , "BMP - Windows Bitmap (.bmp)" ) = TRUE then
      Kontext "BMPOptionen"
      if BMPOptionen.Exists (2) then
         Farbaufloesung.Select 7
         RLEKodierung.Check
         Aufloesung.Check
         DPI.Select 3
         BMPOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+".bmp") <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+".bmp" + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+".bmp" )
   endif
   hCloseDocument ()
   Printlog "'/// now save a SELECTION in ORIGINAL SIZE and load the file afterwards ///'"
   hDateiOeffnen (sDocument)
   sleep (10)
   kontext "Filterauswahl"
   if Filterauswahl.exists then
      Warnlog "Error when loading the file. The Filter-dialogue came up. Test aborted."
      Filterauswahl.Cancel
      exit sub
   endif

    ' check if the document is writable
    if fIsDocumentWritable = false then
        ' make the document writable and check if it's succesfull
        if fMakeDocumentWritable = false then
            warnlog "The document can't be make writeable. Test stopped."
            goto endsub
        endif
    endif

   hTypeKeys ("<escape><tab>")
   fGetSizeXY slx, sy, TRUE
   if hCallExport (OutputGrafikTBO + "1" , "BMP - Windows Bitmap (.bmp)", TRUE ) = TRUE then
      Kontext "BMPOptionen"
      if BMPOptionen.Exists (2) then
         Original.Check
         BMPOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO + "1"+".bmp") <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "1"+".bmp" + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO + "1"+".bmp" )
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   hCloseDocument ()
   Printlog "'/// now CREATE a rectangle, select it, save it in SIZE and load the file afterwards ///'"
   hNewDocument()
   hTypeKeys "<TAB>"
   gMouseClick 50, 50
   hRechteckErstellen ( 10, 10, 30, 40 )
   if hCallExport (OutputGrafikTBO + "2" , "BMP - Windows Bitmap (.bmp)", TRUE ) = TRUE then
      Kontext "BMPOptionen"
      if BMPOptionen.Exists (2) then
         Groesse.Check
            Breite.SetText "9"
            Hoehe.SetText "9"
            Groesse.Check  'Press "Size" one more time in order to make the change go through"
            slX = Breite.GetText
            sY = Hoehe.GetText
         BMPOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO + "2"+".bmp") <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "2"+".bmp" + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hDateiOeffnen (OutputGrafikTBO + "2"+".bmp")
      kontext "Filterauswahl"
      if Filterauswahl.exists then
         Warnlog "Error when loading the file. The Filter-dialogue came up. Test aborted."
         Filterauswahl.Cancel
         exit sub
      endif
      kontext "DocumentDraw"
      DocumentDraw.TypeKeys ("<escape><tab>")
      ContextOriginalSize
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   if hCallExport (OutputGrafikTBO + "3" , "BMP - Windows Bitmap (.bmp)", TRUE ) = TRUE then
      Kontext "BMPOptionen"
      if BMPOptionen.Exists (2) then
         Groesse.Check
            sX2 = Breite.GetText
            if (LiberalMeasurement(slX, sX2)) <> TRUE then
               if (val(str(StrToDouble(slX)+5)) >= StrToDouble(sX2) ) AND (val(str(StrToDouble ( slX )-5)) <= StrToDouble ( sX2 )) then
                  Printlog "Width was ok. Expected: " + s1X + "' was: '" + sX2 + "'"
               else
                  warnLog "Width is different expected: '" + s1X + "' is: '" + sX2 + "'"
               endif
            endif
            sY2 = Hoehe.GetText
            if (LiberalMeasurement(sY, sY2)) <> TRUE then
               if ( val(str(StrToDouble(sY)+5)) >= StrToDouble(sY2) ) AND (val(str(StrToDouble ( sY )-5)) <= StrToDouble ( sY2 )) then
                  Printlog "Height was ok. Expected: " + sY + "' was: '" + sY2 + "'"
               else
                  warnLog "Height is different expected: '" + sY + "' is: '" + sY2 + "'"
               endif
            endif
         BMPOptionen.Cancel
         sleep 5
       endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tEMF
   dim x,i as integer
   dim sFilter, sExt as string
   dim bTemp as boolean
   dim sX, sY as string
   dim slX as string
   dim sX2, sY2 as string
   dim sDocument as string

   sFilter = "EMF - Enhanced Metafile (.emf)"
   sExt = ".emf"

   '/// open the document
   sDocument = ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) )
   hDateiOeffnen sDocument

   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
         Original.Check
            if Breite.IsEnabled then warnlog " :-("
            if Hoehe.IsEnabled then warnlog " :-("
         Groesse.Check
            Breite.More
            Hoehe.Less
         '/// leave dialog with cancel -> there has to be no file created! ///'
         SVMOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+sExt) = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "ok :-)"
         else
            warnlog "Dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No  '" + sFilter + "' -Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog " '" + sFilter + "'  has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Groesse.Check
            Breite.Less
            Hoehe.More
         SVMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif
   hCloseDocument ()
   Printlog "'/// now save a SELECTION in ORIGINAL SIZE and load the file afterwards ///'"
   hDateiOeffnen (sDocument)
   sleep (10)
   kontext "Filterauswahl"
   if Filterauswahl.exists then
      Warnlog "Error when loading the file. The Filter-dialogue came up. Test aborted."
      Filterauswahl.Cancel
      exit sub
   endif

    ' check if the document is writable
    if fIsDocumentWritable = false then
        ' make the document writable and check if it's succesfull
        if fMakeDocumentWritable = false then
            warnlog "The document can't be make writeable. Test stopped."
            goto endsub
        endif
    endif

   hTypeKeys ("<escape><tab>")
   fGetSizeXY slX, sY, TRUE
   if hCallExport (OutputGrafikTBO + "1" , sFilter, TRUE ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Original.Check
         SVMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO + "1"+sExt) <> "") then
         Printlog "Ok :-) saved as: '" + OutputGrafikTBO + "1"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO + "1"+sExt )
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   hCloseDocument ()
   Printlog "'/// now CREATE a rectangle, select it, save it in SIZE and load the file afterwards ///'"
   hNewDocument()
   hRechteckErstellen ( 10, 10, 30, 40 )
   if hCallExport (OutputGrafikTBO + "2" , sFilter, TRUE ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Groesse.Check
            Breite.SetText "9"
            Hoehe.SetText "9"
            Groesse.Check   'Press "Size" one more time to make the change go through"
            slX = Breite.GetText
            sY = Hoehe.GetText
         SVMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO + "2"+sExt) <> "") then
         Printlog "Ok :-) saved as: '" + OutputGrafikTBO + "2"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hDateiOeffnen (OutputGrafikTBO + "2"+sExt)
         kontext "DocumentDraw"
         DocumentDraw.TypeKeys ("<escape><tab>")
         ContextOriginalSize
         bTemp = FALSE
         fGetSizeXY slX, sY, bTemp
         if (bTemp = FALSE) then
            warnlog "Selected original size NOT OK :-("
         endif

         if hCallExport (OutputGrafikTBO + "3" , sFilter, TRUE ) = TRUE then
            Kontext "SVMOptionen"
            if SVMOptionen.Exists (2) then
               Groesse.Check
               sX2 = Breite.GetText
               if (LiberalMeasurement(slX, sX2)) <> TRUE then
                  if (val(str(StrToDouble(slX)+5)) >= StrToDouble(sX2) ) AND (val(str(StrToDouble ( slX )-5)) <= StrToDouble ( sX2 )) then
                     Printlog "Width was ok. Expected: " + s1X + "' was: '" + sX2 + "'"
                  else
                     warnLog "Width is different expected: '" + s1X + "' is: '" + sX2 + "'"
                  endif
               endif
               sY2 = Hoehe.GetText
               if (LiberalMeasurement(sY, sY2)) <> TRUE then
                  if ( val(str(StrToDouble(sY)+5)) >= StrToDouble(sY2) ) AND (val(str(StrToDouble ( sY )-5)) <= StrToDouble ( sY2 )) then
                     Printlog "Height was ok. Expected: " + sY + "' was: '" + sY2 + "'"
                  else
                     warnLog "Height is different expected: '" + sY + "' is: '" + sY2 + "'"
                  endif
               endif
               SVMOptionen.Cancel
               sleep 5
            endif
         endif
      endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tSVM
   dim x,i as integer
   dim sFilter, sExt as string
   dim bTemp as boolean
   dim sX, sY as string
   dim slX as string
   dim sX2, sY2 as string
   dim sDocument as string

   sFilter = "SVM - StarView Metafile (.svm)"
   sExt = ".svm"

   '/// open the document
   sDocument = ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) )
   hDateiOeffnen sDocument

   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
         Original.Check
            if Breite.IsEnabled then warnlog " :-("
            if Hoehe.IsEnabled then warnlog " :-("
         Groesse.Check
            Breite.More
            Hoehe.Less
         '/// leave dialog with cancel -> there has to be no file created! ///'
         SVMOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+sExt) = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "ok :-)"
         else
            warnlog "dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No  '" + sFilter + "' -Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog " '" + sFilter + "'  has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Groesse.Check
            Breite.Less
            Hoehe.More
         SVMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif
   hCloseDocument ()
   Printlog "'/// now save a SELECTION in ORIGINAL SIZE and load the file afterwards ///'"
   hDateiOeffnen (sDocument)
   sleep (10)

    ' check if the document is writable
    if fIsDocumentWritable = false then
        ' make the document writable and check if it's succesfull
        if fMakeDocumentWritable = false then
            warnlog "The document can't be make writeable. Test stopped."
            goto endsub
        endif
    endif

   hTypeKeys ("<escape><tab>")
   fGetSizeXY slX, sY, TRUE
   if hCallExport (OutputGrafikTBO + "1" , sFilter, TRUE ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Original.Check
         SVMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO + "1"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "1"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO + "1"+sExt )
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   hCloseDocument ()
   Printlog "'/// now CREATE a rectangle, select it, save it in SIZE and load the file afterwards ///'"
   hNewDocument()
   hRechteckErstellen ( 10, 10, 30, 40 )
   if hCallExport (OutputGrafikTBO + "2" , sFilter, TRUE ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Groesse.Check
            Breite.SetText "9"
            Hoehe.SetText "9"
            Groesse.Check 'Check to make settings go throught
            slX = Breite.GetText
            sY = Hoehe.GetText
         SVMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO + "2"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "2"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hDateiOeffnen (OutputGrafikTBO + "2"+sExt)
      kontext "Filterauswahl"
      if Filterauswahl.exists then
         Warnlog "Error when loading the file. The Filter-dialogue came up. Test aborted."
         Filterauswahl.Cancel
         exit sub
      endif
      kontext "DocumentDraw"
      DocumentDraw.TypeKeys ("<escape><tab>")
      ContextOriginalSize
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   if hCallExport (OutputGrafikTBO + "3" , sFilter, TRUE ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Groesse.Check
            sX2 = Breite.GetText
            if (LiberalMeasurement(slX, sX2)) <> TRUE then
               if (val(str(StrToDouble(slX)+5)) >= StrToDouble(sX2) ) AND (val(str(StrToDouble ( slX )-5)) <= StrToDouble ( sX2 )) then
                  Printlog "Width was ok. Expected: " + s1X + "' was: '" + sX2 + "'"
               else
                  warnLog "Width is different expected: '" + s1X + "' is: '" + sX2 + "'"
               endif
            endif
            sY2 = Hoehe.GetText
            if (LiberalMeasurement(sY, sY2)) <> TRUE then
               if ( val(str(StrToDouble(sY)+5)) >= StrToDouble(sY2) ) AND (val(str(StrToDouble ( sY )-5)) <= StrToDouble ( sY2 )) then
                  Printlog "Height was ok. Expected: " + sY + "' was: '" + sY2 + "'"
               else
                  warnLog "Height is different expected: '" + sY + "' is: '" + sY2 + "'"
               endif
            endif
         SVMOptionen.Cancel
         sleep 5
       endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tMET
   dim x,i as integer
   dim sFilter, sExt as string
   dim bTemp as boolean
   dim sX, sY as string
   dim slX as string
   dim sX2, sY2 as string
   dim sTemp as string
   dim sDocument as string

   sFilter = "MET - OS/2 Metafile (.met)"
   sExt = ".met"

   '/// open the document
   sDocument = ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) )
   hDateiOeffnen sDocument

   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "METOptionen"
      if METOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
         Original.Check
            if Breite.IsEnabled then warnlog " :-("
            if Hoehe.IsEnabled then warnlog " :-("
         Groesse.Check
            sTemp = Breite.getText
            Breite.More
            if (sTemp = Breite.getText) then
                qaErrorLog "Width didn't change on pressing button 'More' #112225#"
                Breite.setText "10"
                Hoehe.setText "10"
            endif
            sTemp = Hoehe.getText
            Hoehe.Less
            if (sTemp = Hoehe.getText) then
                warnlog "Height didn't change on pressing button 'Less'"
            endif
         '/// leave dialog with cancel -> there has to be no file created! ///'
         METOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+sExt) = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "ok :-)"
         else
            warnlog "Dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No  '" + sFilter + "' -Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog " '" + sFilter + "'  has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "METOptionen"
      if METOptionen.Exists (2) then
         Groesse.Check
            sTemp = Breite.getText
            Breite.Less
            if (sTemp = Breite.getText) then
                warnlog "Width didn't change on pressing button 'Less'"
            endif
            sTemp = Hoehe.getText
            Hoehe.More
            if (sTemp = Hoehe.getText) then
                qaErrorLog "Height didn't change on pressing button 'More' #112225#"
                Breite.setText "10"
                Hoehe.setText "10"
            endif
         METOptionen.OK
         sleep 30
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif
   hCloseDocument ()
   Printlog "'/// now save a SELECTION in ORIGINAL SIZE and load the file afterwards ///'"
   hDateiOeffnen (sDocument)
   sleep (10)

    ' check if the document is writable
    if fIsDocumentWritable = false then
        ' make the document writable and check if it's succesfull
        if fMakeDocumentWritable = false then
            warnlog "The document can't be make writeable. Test stopped."
            goto endsub
        endif
    endif

   hTypeKeys ("<escape><tab>")
   fGetSizeXY slX, sY, TRUE
   if hCallExport (OutputGrafikTBO + "1" , sFilter, TRUE ) = TRUE then
      Kontext "METOptionen"
      if METOptionen.Exists (2) then
         Original.Check
         METOptionen.OK
         sleep 30
      endif
      if ( dir(OutputGrafikTBO + "1"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "1"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO + "1"+sExt )
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   hCloseDocument ()
   Printlog "'/// now CREATE a rectangle, select it, save it in SIZE and load the file afterwards ///'"
   hNewDocument()
   hRechteckErstellen ( 10, 10, 30, 40 )
   if hCallExport (OutputGrafikTBO + "2" , sFilter, TRUE ) = TRUE then
      Kontext "METOptionen"
      if METOptionen.Exists (2) then
         Groesse.Check
            Breite.SetText "9"
            Hoehe.SetText "9"
            Groesse.Check  ' Click "Size" one more time to make the changes go through.
            slX = Breite.GetText
            sY = Hoehe.GetText
         METOptionen.OK
         sleep 30
      endif
      if ( dir(OutputGrafikTBO + "2"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "2"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hDateiOeffnen (OutputGrafikTBO + "2"+sExt)
      kontext "DocumentDraw"
      DocumentDraw.TypeKeys ("<escape><tab>")
      ContextOriginalSize
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   if hCallExport (OutputGrafikTBO + "3" , sFilter, TRUE ) = TRUE then
      Kontext "METOptionen"
      if METOptionen.Exists (2) then
         Groesse.Check
            sX2 = Breite.GetText
            if (LiberalMeasurement(slX, sX2)) <> TRUE then
               if (val(str(StrToDouble(slX)+5)) >= StrToDouble(sX2) ) AND (val(str(StrToDouble ( slX )-5)) <= StrToDouble ( sX2 )) then
                  Printlog "Width was ok. Expected: " + s1X + "' was: '" + sX2 + "'"
               else
                  warnLog "Width is different expected: '" + s1X + "' is: '" + sX2 + "'"
               endif
            endif
            sY2 = Hoehe.GetText
            if (LiberalMeasurement(sY, sY2)) <> TRUE then
               if ( val(str(StrToDouble(sY)+5)) >= StrToDouble(sY2) ) AND (val(str(StrToDouble ( sY )-5)) <= StrToDouble ( sY2 )) then
                  Printlog "Height was ok. Expected: " + sY + "' was: '" + sY2 + "'"
               else
                  warnLog "Height is different expected: '" + sY + "' is: '" + sY2 + "'"
               endif
            endif
         METOptionen.Cancel
         sleep 5
       endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tWMF
   dim x,i as integer
   dim sFilter, sExt as string
   dim bTemp as boolean
   dim sX, sY as string
   dim slX as string
   dim sX2, sY2 as string
   dim sDocument as string

   sFilter = "WMF - Windows Metafile (.wmf)"
   sExt = ".wmf"

   '/// open the document
   sDocument = ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) )
   hDateiOeffnen sDocument

   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
         Original.Check
            if Breite.IsEnabled then warnlog " :-("
            if Hoehe.IsEnabled then warnlog " :-("
         Groesse.Check
            Breite.More
            Hoehe.Less
         '/// leave dialog with cancel -> there has to be no file created! ///'
         SVMOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+sExt) = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "ok :-)"
         else
            warnlog "Dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No  '" + sFilter + "' -Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog " '" + sFilter + "'  has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Groesse.Check
            Breite.Less
            Hoehe.More
         SVMOptionen.OK
         sleep 30
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif
   hCloseDocument ()
   Printlog "'/// now save a SELECTION in ORIGINAL SIZE and load the file afterwards ///'"
   hDateiOeffnen (sDocument)
   sleep (10)

    ' check if the document is writable
    if fIsDocumentWritable = false then
        ' make the document writable and check if it's succesfull
        if fMakeDocumentWritable = false then
            warnlog "The document can't be make writeable. Test stopped."
            goto endsub
        endif
    endif

   hTypeKeys ("<escape><tab>")
   fGetSizeXY slX, sY, TRUE
   if hCallExport (OutputGrafikTBO + "1" , sFilter, TRUE ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Original.Check
         SVMOptionen.OK
         sleep 30
      endif
      if ( dir(OutputGrafikTBO + "1"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "1"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO + "1"+sExt )
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   hCloseDocument ()
   Printlog "'/// now CREATE a rectangle, select it, save it in SIZE and load the file afterwards ///'"
   hNewDocument()
   hRechteckErstellen ( 10, 10, 30, 40 )
   if hCallExport (OutputGrafikTBO + "2" , sFilter, TRUE ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Groesse.Check
            Breite.SetText "9"
            Hoehe.SetText "9"
            Groesse.Check 'Check "Size" to make changes really go through.
            slX = Breite.GetText
            sY = Hoehe.GetText
         SVMOptionen.OK
         sleep 30
      endif
      if ( dir(OutputGrafikTBO + "2"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "2"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hDateiOeffnen (OutputGrafikTBO + "2"+sExt)
      kontext "DocumentDraw"
      DocumentDraw.TypeKeys ("<escape><tab>")
      ContextOriginalSize
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   if hCallExport (OutputGrafikTBO + "3" , sFilter, TRUE ) = TRUE then
      Kontext "SVMOptionen"
      if SVMOptionen.Exists (2) then
         Groesse.Check
            sX2 = Breite.GetText
            if (LiberalMeasurement(slX, sX2)) <> TRUE then
               if (val(str(StrToDouble(slX)+5)) >= StrToDouble(sX2) ) AND (val(str(StrToDouble ( slX )-5)) <= StrToDouble ( sX2 )) then
                  Printlog "Width was ok. Expected: " + s1X + "' was: '" + sX2 + "'"
               else
                  warnLog "Width is different expected: '" + s1X + "' is: '" + sX2 + "'"
               endif
            endif
            sY2 = Hoehe.GetText
            if (LiberalMeasurement(sY, sY2)) <> TRUE then
               if ( val(str(StrToDouble(sY)+5)) >= StrToDouble(sY2) ) AND (val(str(StrToDouble ( sY )-5)) <= StrToDouble ( sY2 )) then
                  Printlog "Height was ok. Expected: " + sY + "' was: '" + sY2 + "'"
               else
                  warnLog "Height is different expected: '" + sY + "' is: '" + sY2 + "'"
               endif
            endif
         SVMOptionen.Cancel
         sleep 5
       endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tPCT
   dim x,i as integer
   dim sFilter, sExt as string
   dim bTemp as boolean
   dim sX, sY as string
   dim slX as string
   dim sX2, sY2 as string
   dim sDocument as string

   sFilter = "PCT - Mac Pict (.pct)"
   sExt = ".pct"

   '/// open the document
   sDocument = ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) )
   hDateiOeffnen sDocument

   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
         Original.Check
            if Breite.IsEnabled then warnlog " :-("
            if Hoehe.IsEnabled then warnlog " :-("
         Groesse.Check
            Breite.More
            Hoehe.Less
         '/// leave dialog with cancel -> there has to be no file created! ///'
         PICTOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+sExt) = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "Ok :-)"
         else
            warnlog "Dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No  '" + sFilter + "' -Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog " '" + sFilter + "'  has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
         Groesse.Check
            Breite.Less
            Hoehe.More
         PICTOptionen.OK
         sleep 30
      endif
      i=0
      while ((NOT fileExists(OutputGrafikTBO+sExt)) AND (i<36))
         inc(i)
         sleep(5)
      wend
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif
   hCloseDocument ()
   Printlog "'/// now save a SELECTION in ORIGINAL SIZE and load the file afterwards ///'"
   hDateiOeffnen (sDocument)
   sleep (10)

    ' check if the document is writable
    if fIsDocumentWritable = false then
        ' make the document writable and check if it's succesfull
        if fMakeDocumentWritable = false then
            warnlog "The document can't be make writeable. Test stopped."
            goto endsub
        endif
    endif

   hTypeKeys ("<escape><tab>")
   fGetSizeXY slX, sY, TRUE
   if hCallExport (OutputGrafikTBO + "1" , sFilter, TRUE ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
         Original.Check
         PICTOptionen.OK
         sleep 30
      endif
      i=0
      while ((NOT fileExists(OutputGrafikTBO+ "1"+sExt)) AND (i<36))
         inc(i)
         sleep(5)
      wend
      if ( dir(OutputGrafikTBO + "1"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "1"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO + "1"+sExt )
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   hCloseDocument ()
   Printlog "'/// now CREATE a rectangle, select it, save it in SIZE and load the file afterwards ///'"
   hNewDocument()
   hRechteckErstellen ( 10, 10, 30, 40 )
   if hCallExport (OutputGrafikTBO + "2" , sFilter, TRUE ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
         Groesse.Check
            Breite.SetText "9"
            Hoehe.SetText "9"
            Groesse.Check 'Check "Size" one more time to make the change go through"
            slX = Breite.GetText
            sY = Hoehe.GetText
         PICTOptionen.OK
         sleep 30
      endif
      i=0
      while ((NOT fileExists(OutputGrafikTBO+ "2"+sExt)) AND (i<36))
         inc(i)
         sleep(5)
      wend
      if ( dir(OutputGrafikTBO + "2"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "2"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hDateiOeffnen (OutputGrafikTBO + "2"+sExt)
      kontext "DocumentDraw"
      DocumentDraw.TypeKeys ("<escape><tab>")
      ContextOriginalSize
      bTemp = FALSE
      fGetSizeXY slX, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   if hCallExport (OutputGrafikTBO + "3" , sFilter, TRUE ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
         Groesse.Check
            sX2 = Breite.GetText
            if (LiberalMeasurement(slX, sX2)) <> TRUE then
               if (val(str(StrToDouble(slX)+5)) >= StrToDouble(sX2) ) AND (val(str(StrToDouble ( slX )-5)) <= StrToDouble ( sX2 )) then
                  Printlog "Width was ok. Expected: " + s1X + "' was: '" + sX2 + "'"
               else
                  warnLog "Width is different expected: '" + s1X + "' is: '" + sX2 + "'"
               endif
            endif
            sY2 = Hoehe.GetText
            if (LiberalMeasurement(sY, sY2)) <> TRUE then
               if ( val(str(StrToDouble(sY)+5)) >= StrToDouble(sY2) ) AND (val(str(StrToDouble ( sY )-5)) <= StrToDouble ( sY2 )) then
                  Printlog "Height was ok. Expected: " + sY + "' was: '" + sY2 + "'"
               else
                  warnLog "Height is different expected: '" + sY + "' is: '" + sY2 + "'"
               endif
            endif
         PICTOptionen.Cancel
         sleep 5
       endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tEPS
   dim x,i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "EPS - Encapsulated PostScript (.eps)"
   sExt = ".eps"

   '/// open the document
   hDateiOeffnen ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) )

   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "EPSOptionen"
      if EPSOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
      ' they do not affect annything, i can check (TBO)
      ' VorschauTIF.Check
      '  InterchangeEPSI.Check
         Level1.Check
            if Farbe.IsEnabled then warnlog " :-("
            if Graustufen.IsEnabled then warnlog " :-("
            if LZWKodierung.IsEnabled then warnlog " :-("
            if Keine.IsEnabled then warnlog " :-("
            ' if (TextEinstellungen.IsEnabled <> TRUE) then warnlog " :-("
         Level2.Check
            if (Farbe.IsEnabled <> TRUE) then warnlog " :-("
            if (Graustufen.IsEnabled <> TRUE) then warnlog " :-("
            if (LZWKodierung.IsEnabled <> TRUE) then warnlog " :-("
            if (Keine.IsEnabled <> TRUE) then warnlog " :-("
            ' if (TextEinstellungen.IsEnabled <> TRUE) then warnlog " :-("
         '/// 'Color Resolution' listbox contains eight items ///'
         ' x = TextEinstellungen.GetItemCount
         ' if x <> 2 then warnlog "'TextEinstellungen' Count is wrong; should:2, is:" + x
         ' for i = 1 to x
         ' TextEinstellungen.Select i
         ' sleep 1
         ' Printlog " - " + i + ": '" +TextEinstellungen.GetSelText + "'"
         ' next i
         '/// leave dialog with cancel -> there has to be no file created! ///'
         EPSOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+sExt) = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "Ok :-)"
         else
            warnlog "Dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No '" + sFilter + "'-Option-Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog "'" + sFilter + "' has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "EPSOptionen"
      if EPSOptionen.Exists (2) then
      '  TextEinstellungen.select 2
         EPSOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tGIF
   dim x,i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "GIF - Graphics Interchange Format (.gif)"
   sExt = ".gif"

   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "GIFOptionen"
      if GIFOptionen.Exists (2) then
            Interlace.Uncheck
            TransparentSpeichern.UnCheck
         GIFOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tJPEG
   dim x,i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "JPEG - Joint Photographic Experts Group (.jpg;.jpeg;.jfif;.jif;.jpe)"
   sExt = ".jpg"

   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "JpegOptionen"
      if JpegOptionen.Exists (2) then
             Echtfarben.Check
             Qualitaet.ToMin
         JpegOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
