'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: id_001.inc,v $
'*
'*  $Revision: 1.64 $
'*
'*  last change: $Author: fredrikh $ $Date: 2006/08/14 12:54:05 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description :
'*
'***********************************************************************************
' #1 tiFileSaveAs
' #1 tiFileReload (sFileIn as string)
' #1 tiFileVersion (sFileIn as string)
' #1 tiFilePassword (sFileIn as string)
' #1 tiFileTemplates
' #1 tiFilePrint
' #1 tmFileNewFromTemplate
' #1 tmFileOpen
' #1 tmFileClose
' #1 tmFileSave
' #1 tmFileSaveAs
' #1 tmFileSaveAll
' #1 tmFileProperties
' #1 tmFilePrinterSetting
'\**********************************************************************************

'/// used Documents ///'
'///"graphics\update\input\tbo_alf_.sx?" ///

sub id_001
   printLog Chr(13) + "---------    id_001    ----------"

   call tiFilePassword
   call tiFileSaveAs
qaerrorlog "#i66163# tiFileReload outcommented due to bug. -FHA"
'   call tiFileReload
   call tiFileVersion
   printlog " File->Send not possible to test, because extrnal prg get's called!"
   call tiFileTemplates
   call tiFilePrint
'   Call tiFileNew instead i call:
   call tmFileNewFromTemplate
   call tmFileOpen
   call tmFileClose
   call tmFileSave
   call tmFileSaveAs
   call tmFileSaveAll
   call tmFileProperties
   call tmFilePrinterSetting
' special cases
'   Call AutoPilot      'inc\desktop\autopilo.inc
'   call tmFileExit ' don't test because unpredictable behaviour
end sub

testcase tiFileSaveAs
    if gPlatform = "sol" then
        QAErrorLog "#i59677# - Under Solaris vnc FileSaveAs testcase crashes/freezes the office"
        goto endsub
    end if
    dim sFileName as string ' test document & new created doc
'   dim sFormula as string  ' container for formula to create document with
    dim sTemp as string
    dim sFilter (50) as string
    dim i,x,y as integer
    dim Exlist(100) as string ' files to be deleted
    dim sFile, sPath as string ' filename and path to export

    sFilter (0) = 0 ' initalize ;-)...
    '/// used document: "graphics\update\input\tbo_alf_.sx?" ///
    sFileName = "graphics\update\input\tbo_alf_.sx" + left(Lcase(gApplication),1)         ' this is the file with all features
    sFile = "isas_"                                ' this is the filename of the export files
    sPath = ConvertPath ( gOfficePath + "user/work/graphics/update/"+Lcase(gApplication)+"\"+ gPlatform) ' this is the export path
    if dir (sPath) = "" then
        app.mkdir (sPath)
    end if

    Printlog "'/// deleting all files in output directory: \\user\\work\\graphics\\update\\Lcase(gApplication) gPlatform isas_* ///'"
    if gSamePC = TRUE then ' delete export directory
        GetFileList ( sPath, sFile+"*", Exlist() )
        if KillFileList ( Exlist() ) <> TRUE then
            Warnlog "Couldn't delete all Files in Output-Export-Directory, the followings are still there:"
            for i=1 to ListCount ( Exlist() )
                printlog "  <> " + Exlist(i)
            next i
        end if
    end if

    '///  load a sample presentation file  ///'
    Call hDateiOeffnen ( ConvertPath(gTesttoolPath + sFileName) )
    sleep(3)

'/// start loop 5 times for: ///'
'///    - StarImpress 5.0 ///
'///    - StarOffice 6.0 Presentation ///
'///    - StarOffice 6.0 Presentation Template ///
'///    - Microsoft PowerPoint 97/2000/XP Template ///
'///    - StarOffice 6.0 Drawing (StarOffice Impress) ///
'/// to be language independant, select first, second last,... and last filter from list -> but trie to check the names :-) ///'

' to use the helper fileSaveAs functions i get alll available filters...
   FileSaveAs
   sleep 2
   Kontext "SpeichernDlg"
   for i = 0 to 5
      if i=0 then x = Dateityp.GetItemCount
      if (i) then  ' set border, whenm start from beginning/end
         y = i     ' set filter from beginning
      else
         y = x-3     ' set filter from end
      endif
      ListAppend(sFilter(), Dateityp.GetItemText (y))
   next i
   SpeichernDlg.Cancel
   y = ListCount(sFilter())

   if gtSYSName = "Linux" then y=y-1
   '#i45961# - last part of filter-list deactivated due to BUG - FHA
   'TODO: JSI->FHA please verify if this special handling needed after the issue has been fixed.

   for i = 1 to y
      sFileName = sPath + sFile + (i)
      hSpeichernUnterMitFilter (sFileName, sFilter(i), TRUE )
   '/// file save with filter as: "graphics\update\output\\math\\fsas_[0,1,2,...]" ///'
      kontext
      if messagebox.exists then
         messagebox.Yes ' to go on ....
      endif
      printlog " saved with filter ("+i+"/"+y+"): "+ sFilter(i)
   next i
' TODO TBO: small check, if correct filter was used!
   sleep 3
   fileclose
   sleep 3
   kontext "Messagebox"
   if Messagebox.exists then
      printlog "Messagebox about informationloss... :-) that's OK: 'Text in the messagebox: "+Messagebox.GetText+"'"
      Messagebox.YES
   endif

'-----------------------------------------------------------------
'/// Load all saved files ///'
   hNewDocument

'/// a small loop, to load all files previous saved ///'

   sFilter (0) = 0
'///load documents from  "graphics\update\output\\impress\\fsas_*" ///
   sFileName = sPath
   GetFileList ( sFileName, sFile + "*", sFilter() )

'   call hNewDocument
   x = ListCount ( sFilter() )
   for i = 1 to x
     printlog "("+i+"/"+x+"): "+sFilter(i)
      hDateiOeffnen ( sFilter(i) )
      Sleep 3
      If hIsNamedDocLoaded (sFilter(i), true) Then
         printlog "  used filter: " + hGetUsedFilter()
      else
         sTemp = left(right(sFilter(i),2),1)
         if ( (sTemp = "t") OR (sTemp = "o") ) then
            printlog "document is --- TEMPLATE?! --- "
         else
            qaErrorlog "#116563# document didn't get loaded "
         endif
      endif
      hCloseDocument
      sleep 2
   next i
'   Call hCloseDocument
endcase

testcase tiFileReload
  Dim DokumentPfad$
  Dim Datei$
  if (lcase(gApplication) = "impress") then
     Datei$= (ConvertPath (gOfficePath + "user/work/graphics/update/version1.odp"))
  else
     Datei$= (ConvertPath (gOfficePath + "user/work/graphics/update/version1.odg"))
  end if
  if app.dir(ConvertPath (gOfficePath + "user/work/graphics/update/")) = "" then
    app.mkdir (ConvertPath (gOfficePath + "user/work/graphics/update/"))
  endif
'/// open application ///'
   Call hNewDocument
   sleep 2
'/// save document "..." ///'
   Call hSpeichernUnterKill (Datei$)
   sleep 2
'/// close document ///'
   Call hCloseDocument

'/// load document again ///'
   Call hDateiOeffnen (Datei$)
   sleep 2
'/// type something in document ///'
   call hTBOtypeInDoc
   sleep 2
'/// File->Reload ///'
   FileReload
   sleep 2
'/// Messagebox has to come up; say NO ///'
   Kontext "Messagebox"
   sleep 2
   Messagebox.No
   sleep 2

'/// File->Reload ///'
   FileReload
   sleep 2
   Kontext "Messagebox"
   sleep 2
'/// Messagebox has to come up; say YES ///'
   Messagebox.Yes
   sleep 1

'/// close document ///'
   Call hCloseDocument
'/// delete document ///'
   if Dir (Datei$) <> "" AND gSamePC = TRUE then kill Datei$
endcase

testcase tiFileVersion
  Dim DokumentPfad$
  Dim Datei$
  if (lcase(gApplication) = "impress") then
     Datei$= (ConvertPath (gOfficePath + "user/work/graphics/update/erwin.odp"))
  else
     Datei$= (ConvertPath (gOfficePath + "user/work/graphics/update/erwin.odg"))
  end if
  'if dir (ConvertPath (gOfficePath + "user/work/graphics/update/")) = "" then
  if dir (Datei$) = "" then app.mkdir (ConvertPath (gOfficePath + "user/work/graphics/update/"))
'/// open application ///'
   Call hNewDocument
   sleep 1
'/// save document as "..." ///'
   Call hSpeichernUnterKill (Datei$)
   sleep 1
'/// close document ///'
   Call hCloseDocument

'/// open document again ///'
   Call hDateiOeffnen (Datei$)
   sleep 1
'/// type something in document ///'
   call hTBOtypeInDoc
   sleep 1
'/// File->Versions ///'
   try
      FileVersions
   catch
      Warnlog "- File / Versions not accessible!"
      exit sub
   endcatch

   Kontext "Versionen"
   Call DialogTest ( Versionen )
'/// in Versions dialog press "save" ///'
   Speichern.Click
'/// type a comment ///'
   Kontext "VersionskommentarEingeben"
   Call DialogTest ( VersionskommentarEingeben )
'/// exit comment dialog with cancel ///'
   VersionskommentarEingeben.Cancel
   Kontext "Versionen"
'/// close version dialog ///'
   Versionen.Close
'/// close document ///'
   Call hCloseDocument
'   if Dir (Datei$) <> "" AND gSamePC = TRUE then kill Datei$
endcase

testcase tiFilePassword
   Dim DokumentPfad$
   Dim Datei$
   dim sFileName as string ' test document & new created doc
'   dim sFormula as string  ' container for formula to create document with
   dim e as string
   dim sTemp as string
   dim sFilter (50) as string
   dim i,x,y as integer
   dim Exlist(100) as string ' files to be deleted
   dim sFileIn, sFile, sPath as string ' filename and path to export

'///  save file to:  "graphics\update\output\"+Lcase(gApplication)+"\"+ gPlatform+"\"isp__" ///'
   sFile = "isp__"                                                     ' this is the filename of the export files
   sPath = ConvertPath ( gOfficePath + "user/work/graphics/update/"+Lcase(gApplication)+"\"+ gPlatform+"\") ' this is the export path
   mkdir (sPath)
   if dir (sPath) = "" then app.mkdir (sPath)
   if (lcase(gApplication) = "draw") then
      sFileIn = sPath + sFile + ".odg"
   endif
   if (lcase(gApplication) = "impress") then
      sFileIn = sPath + sFile + ".odp"
   endif
   Printlog "'/// deleting all files in output directory: \\graphics\update\output\\impress\\ gPlatform isp_* ///'"
   if gSamePC = TRUE then ' delete export directory
      GetFileList ( sPath, sFile+"*", Exlist() )
      if KillFileList ( Exlist() ) <> TRUE then
         Warnlog "Couldnt delete all Files in Output-Export-Directory, the followings are still there:"
         for i=1 to ListCount ( Exlist() )
            printlog "  <> " + Exlist(i)
         next i
      end if
   end if

'/// open application ///'
   Call hNewDocument
   sleep 1
'/// File->SaveAs ///'
   FileSaveAs
      Kontext "SpeichernDlg"
      Datei$ = ConvertPath ( sFileIn )
      printlog "   will use the file: "+Datei$
      if Dir (Datei$) <> "" then
         kill Datei$
      endif
      sleep 1
      '/// check 'password' ///'
      Passwort.Check
      '/// set 'filename' ///'
      Dateiname.SetText Datei$
      '/// press 'save' ///'
      Speichern.Click
   Sleep 2
   Kontext "Passwort"
      PasswortName.SetText "12345"
      PasswortBestaetigen.Settext "54321"
      '/// type password "12345", confirm password: "54321" -> WRONG ///'
      Passwort.OK
   sleep 2
   Kontext "Messagebox"
      '/// messagebox has to show up, say OK, if messagebox doesnt come up -> ERROR ///'
      if Messagebox.Exists(1) then
         Messagebox.OK
      else
         Warnlog "- Wrong password not recognized"
      end if
   Kontext "Passwort"
      '/// type password "12345", confirm password: "12345" -> RIGHT ///'
      PasswortName.SetText "12345"
      PasswortBestaetigen.SetText "12345"
      Passwort.OK
      '/// close document ///'
      sleep 2
   FileClose
   sleep 2

   '/// open document ///'
   FileOpen
      Kontext "OeffnenDlg"
      sleep 2
      Dateiname.SetText Datei$
      Oeffnen.Click
   sleep 2
   Kontext "PasswordFileOpen"
      '/// type password: "34567" -> WRONG ///'
      PasswortName.SetText "34567"
      try
         PasswordFileOpen.OK
      catch
         Printlog "- Wrong password not accepted"
      endcatch
   Kontext
   '/// messagebox has to show up, say OK, if messagebox doesn't come up -> ERROR ///'
      if Not Messagebox.Exists(1) then
         Warnlog "Wrong password while loading not recognized"
      else
         Messagebox.OK
         printlog "Wrong password on loading ok - recogniced"
      end if
   sleep 3
   '/// open document ///'
   hDateiOeffnen(Datei$)
   Kontext "PasswordFileOpen"
      sleep 2
      '/// type password: "12345" -> RIGHT ///'
      PasswortName.SetText "12345"
      PasswordFileOpen.OK
   sleep 5
   '/// File->SaveAs ///'
   FileSaveAs
      Kontext "SpeichernDlg"
      Dateiname.SetText Datei$
      if (Passwort.IsChecked <> TRUE) then
         Warnlog "Password has to be checked! :-("
      endif
      '/// press 'save', without changing any checkbox! -> file has to be saved WITH password protection ///'
      Speichern.Click
      sleep 1
   Kontext "Messagebox"
      '/// (if messagebox comes up, say YES) ///'
      if Messagebox.Exists(2) then
         Messagebox.Yes
      endif
      '/// password dialog has to show up! ///'
   Kontext "Passwort"
      if (Passwort.Exists(5) = FALSE)then
         Warnlog "- Password dialog Didn't pop up after pressing save"
      else
         Kontext "Passwort"
         '/// type password "a12345", confirm password: "a12345" -> RIGHT ///'
    sleep 1
         PasswortName.SetText "a12345"
         PasswortBestaetigen.SetText "a12345"
         Passwort.OK
         sleep 2
         '/// close document ///'
         FileClose
         sleep 1
      endif
   '/// open document ///'
   FileOpen
      sleep 2
      Kontext "OeffnenDlg"
      Dateiname.SetText Datei$
      Oeffnen.Click
      Kontext "PasswordFileOpen"
      sleep 1
      '/// type password: "a12345" -> RIGHT ///'
      PasswortName.SetText "a12345"
      PasswordFileOpen.OK
      sleep 5
   '/// File->SaveAs ///'
   FileSaveAs
      Kontext "SpeichernDlg"
      Dateiname.SetText Datei$
      if (Passwort.IsChecked <> TRUE) then
         Warnlog "Password has to be checked! :-("
      endif
      Passwort.UnCheck
      '/// press 'save', without changing any checkbox! -> file has to be saved WITH password protection ///'
      Speichern.Click
   Kontext "Messagebox"
      '/// (if messagebox comes up, say YES) ///'
      if Messagebox.Exists(2) then Messagebox.Yes
   '/// password dialog needn't to show up! ///'
   Kontext "Passwort"
      if (Passwort.Exists(5))then
         Warnlog "- Password dialog didn't pop up after pressing save"
         Kontext "Passwort"
         password.cancel
         '/// close document ///'
         FileClose
      else
         '/// close document ///'
         hCloseDocument
      end if
endcase

testcase tiFileTemplates
   Call hNewDocument

   FileTemplatesOrganize
      Kontext "DVVerwalten"
      sleep 1
      Call DialogTest (DVVerwalten)
      sleep 1
      PopuplisteLinks.Select 2
      sleep 1
      PopuplisteRechts.Select 2
      sleep 1
      WelcheDatei.Click
      sleep 1
         Kontext "Oeffnendlg"
         Call DialogTest (OeffnenDlg)
         sleep 1
      OeffnenDlg.Cancel
      sleep 2
      Kontext "DVVerwalten"
   DVVerwalten.Close

if gtSYSName = "Solaris x86" then
   qaErrorLog "#i62423# - FileTemplatesAddressBookSource outcommented under x86. - FHA"
else
   FileTemplatesAddressBookSource
     Printlog "- AddressBookAssignment"
      kontext "AddressBookSource"
      Call DialogTest (AddressBookSource)
      Administrate.Click
         kontext "AddressSourceAutopilot"
         AddressSourceAutopilot.Cancel
      kontext "AddressBookSource"
      AddressBookSource.Cancel
endif

   FileTemplatesSave
     Printlog "- Save template"
      sleep 1
      Kontext "Dokumentvorlagen"
      sleep 1
      Call DialogTest (Dokumentvorlagen)
      sleep 1
      Verwalten.Click
         sleep 2
         Kontext "DVVerwalten"
         Call DialogTest (DVVerwalten)
         sleep 3
      DVVerwalten.Close
      sleep 1
      Kontext "Dokumentvorlagen"
      sleep 1
   Dokumentvorlagen.Cancel
   sleep 1

   try
      FileTemplatesEdit
         Printlog "- Edit template"
         sleep 1
         Kontext "OeffnenDlg"
         sleep 1
         Call DialogTest (OeffnenDlg)
         sleep 1
      OeffnenDlg.Cancel
   catch
      Warnlog "- There are problems with File-Template-Save"
   endcatch
   sleep 1
   Call hCloseDocument
endcase

testcase tiFilePrint
   Call hNewDocument
'/// open application ///'
'/// File->Print ///'
   FilePrint
   sleep 1
   kontext
   if active.exists(5) then
       active.ok
       qaerrorlog "There is no printer available - please install one on your system!"
   endif
   sleep 2
   Kontext "DruckenDlg"
       Call DialogTest (DruckenDlg)
        '/// click 'options' ///'
       sleep 2
       Zusaetze.Click

       Kontext "DruckerZusaetzeDraw"
       Call DialogTest (DruckerZusaetzeDraw)
       DruckerZusaetzeDraw.Cancel
        '/// close options dialog with 'cancel' ///'
       Kontext "DruckenDlg"
       '/// close print dialog with 'cancel' ///'
       DruckenDlg.Cancel
   sleep (2)
'/// close application ///'
   Call hCloseDocument
endcase


'-----------------------------------------------------------
'*******************  M A T H dito *************************
'-----------------------------------------------------------


testcase tmFileNewFromTemplate
   Call hNewDocument
   FileNewFromTemplate
  '/// Open dialog with File / New / From Template ///
   sleep (5)
  Kontext "TemplateAndDocuments"
  '/// Check if dialog has been opened ///
  if TemplateAndDocuments.NotExists then
     Warnlog "Dialog Templates and Documents are not up!"
     exit sub
  endif
   Call DialogTest (TemplateAndDocuments)
   sleep 5
   try
      TemplateAndDocuments.Cancel
   catch
   endcatch
   sleep 5
   Call hCloseDocument
endcase

testcase tmFileOpen
   call hNewDocument
   FileOpen
      Kontext "OeffnenDlg"
      UebergeordneterOrdner.Click
      Standard.Click
      NurLesen.check
      Call DialogTest ( OeffnenDlg )
   OeffnenDlg.Cancel
   Sleep 2
   Call hCloseDocument
endcase

testcase tmFileClose
   printlog "- File Close"
   hNewDocument    ' just for the records: I open ONE document
   call hTBOtypeInDoc
   sleep (2)
   FileClose
   Kontext         ' Expecting "Modified, do you want to close?"
   if active.exists (5) then
      printlog "  Ok, active came up: " + active.gettext
      Active.Cancel   ' No, not this time
   else
      warnlog "active missing (1)"
   endif
      sleep (2)

   FileClose
   Kontext
   Active.Yes      ' but now - records: this document is closed
   sleep (2)

   Kontext "SpeichernDlg"
   Call DialogTest ( SpeichernDlg )
   SpeichernDlg.Cancel
   sleep (2)

   FileClose       ' now the office gets closed! (if there were no modifications!)
   Kontext
   Active.No
   sleep (2)
endcase
'-----------------------------------------------------------
testcase tmFileSave
   hNewDocument
   call hTBOtypeInDoc

   FileSave
   sleep 2
   Kontext "SpeichernDlg"
   UebergeordneterOrdner.click
   Standard.Click
'      NeuerOrdner.Click
'      DateiAuswahl.TypeKeys "Hello<Return>"
'      DateiLoeschen
'      Kontext "Messagebox"
'      MessageBox.Yes
   Call DialogTest (SpeichernDlg)
   Kontext "SpeichernDlg"
   Standard.Click
   SpeichernDlg.Cancel
    sleep 2
   Call hCloseDocument
endcase

testcase tmFileSaveAs

   hNewDocument
   sleep (2)
   call hTBOtypeInDoc

   FileSaveAs
   sleep 1
   Kontext "SpeichernDlg"
   if (SpeichernDlg.exists (5) = FALSE) then
      warnlog "FileSaveAs dialog is not visible"
   endif
   sleep 2
   Passwort.check
   Passwort.uncheck
   AutomatischeDateinamenserweiterung.check
   AutomatischeDateinamenserweiterung.uncheck
   UebergeordneterOrdner.click
   Standard.Click

   NeuerOrdner.click
      kontext "NeuerOrdner"
      neuerordner.cancel
   Kontext "SpeichernDlg"

   Call DialogTest (SpeichernDlg)

   Kontext "SpeichernDlg"
   SpeichernDlg.Cancel
   sleep (2)
   Call hCloseDocument
endcase

testcase tmFileSaveAll
   printlog "- File SaveAll"

   hNewDocument
   call hTBOtypeInDoc

   Printlog "  open 2. window"
   hNewDocument
   call hTBOtypeInDoc

   Printlog "  call save all"
   FileSaveAll
   Printlog "  cancel 1. save"
   Kontext "SpeichernDlg"
   SpeichernDlg.Cancel

   Printlog "  cancel 2. save"
   Sleep 2
   Kontext "SpeichernDlg"
   SpeichernDlg.Cancel
   Sleep 2

   try
      Kontext "SpeichernDlg"
      SpeichernDlg.Cancel
      printlog "smth had been typed in the starting window (just a hint ;-) )"
   catch
      printlog "--------- no other window wants to get saved. :-)"
   endcatch

   Sleep 2
   Printlog "  hCloseDocument both"
   Call hCloseDocument
   sleep 2
   Printlog "  first closed"
   Call hCloseDocument
   sleep 1
   Printlog "  second closed"
   sleep (5)
endcase

testcase tmFileProperties
   printlog "- File Properties"

   Call hNewDocument
   FileProperties

   Kontext
   active.SetPage TabDokument
   Kontext "TabDokument"
   Call DialogTest ( TabDokument )

   Kontext
   active.SetPage TabDokumentInfo
   Kontext "TabDokumentInfo"
   Call DialogTest ( TabDokumentInfo )

   Kontext
   active.SetPage TabBenutzer
   Kontext "TabBenutzer"
   Call DialogTest ( TabBenutzer )
   Infofelder.Click
      Kontext "InfonamenBearbeiten"
      Call DialogTest (InfonamenBearbeiten)
   InfonamenBearbeiten.Cancel

   Kontext
   active.SetPage TabInternet
   Kontext "TabInternet"
   Call DialogTest (TabInternet)
   TabInternet.Cancel
'*TabInternet           HID_DOCINFORELOAD
'DoNotRefreshAutomatically   sfx2:RadioButton:TP_DOCINFORELOAD:RB_NOAUTOUPDATE
'RefreshThisDocument    sfx2:RadioButton:TP_DOCINFORELOAD:RB_RELOADUPDATE
'RedirectFromThisDocument   sfx2:RadioButton:TP_DOCINFORELOAD:RB_FORWARDUPDATE
'TimeReload             sfx2:NumericField:TP_DOCINFORELOAD:ED_RELOAD
'TimeForward            sfx2:NumericField:TP_DOCINFORELOAD:ED_FORWARD
'URL                    sfx2:Edit:TP_DOCINFORELOAD:ED_URL
'BrowseURL              sfx2:PushButton:TP_DOCINFORELOAD:PB_BROWSEURL
'Frame                  sfx2:ComboBox:TP_DOCINFORELOAD:CB_FRAME

   Call hCloseDocument
endcase

testcase tmFilePrinterSetting
   printlog "- File Printersettings"
   Call hNewDocument
   sleep 3
   FilePrintersettings
   kontext
   if active.exists(5) then
       active.ok
       qaerrorlog "There is no printer available - please install one on your system!"
   endif
   sleep 2
   Kontext "DruckerEinrichten"
       Call DialogTest (DruckerEinrichten)
       sleep 2
       DruckerEinrichten.Cancel
   sleep 2
   Call hCloseDocument
endcase

testcase tdFileExport
   dim x as integer
'/// just call File->Export and exit ///'
   Call hNewDocument
   sleep 3
   FileExport
      Kontext "ExportierenDlg"
      Call DialogTest ( ExportierenDlg )
      UebergeordneterOrdner.Click
      Kontext "SpeichernDlg"
      '/// check number of available export filters. it has to be 17 ///'
      '///+ this is also done in the 'first test', I provide it just as an additional info here.///'
      '///+ testcase: ExFilterCountCompare ///'
      x=Dateityp.getitemcount
      if x <> 18 then warnlog "the number of filters is not 18, it is: " + x
   SpeichernDlg.Cancel
   sleep 2
   Call hCloseDocument
   sleep 2
endcase

testcase tmFileExit
   printlog "- File Close"
   Call hNewDocument
   Sleep 2
   try
      FileExit "SynchronMode", TRUE
      sleep 2
      Kontext
      sleep 2
      Kontext "MessageBox"
      if MessageBox.Exists(1) then ' this is the messagebox from the first window!
         Printlog MessageBox.GetText
         try
            MessageBox.OK
         catch
            MessageBox.No
         endcatch
      end if
      Kontext "MessageBox"
      if MessageBox.Exists(1) then
         Warnlog "MsgBox popped up and there were no changes in the document"
         Printlog MessageBox.GetText
         try
            MessageBox.OK
         catch
            MessageBox.No
         endcatch
      end if
   catch
      printlog "this exit is wanted :-)"
   endcatch
   try
      Sleep 20
      call hStartTheOffice ' from master.inc
   catch
      printlog "catch AGAIN"
   endcatch
   Kontext "SD_Praesentation"
   if SD_Praesentation.exists (2) then
      ViewToolbarsPresentation
   endif
endcase
