'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_lvl1_filternames.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: pj $ $Date: 2005/11/16 14:24:23 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description  :  Test if current UI filter names match archives references
'*
'************************************************************************
'*
' #1 calcCheckFilterNames     ' Initial routine
' #1 tMatchUIFilterName
' #1 tCheckFilterPosition
'*
'\***********************************************************************

sub calcCheckFilterNames

Printlog Chr(13) + "--------- Check filter names ---------"

  call tMatchUIFilterName ("calc8")
  call tMatchUIFilterName ("calc8t")
  call tMatchUIFilterName ("calc6")
  call tMatchUIFilterName ("calc6t" )
  call tMatchUIFilterName ("dif" )
  call tMatchUIFilterName ("dbf" )
  call tMatchUIFilterName ("xls97")
  call tMatchUIFilterName ("xls97t")
  call tMatchUIFilterName ("xls95")
  call tMatchUIFilterName ("xls95t")
  call tMatchUIFilterName ("xls5")
  call tMatchUIFilterName ("xls5t")
  call tMatchUIFilterName ("calc5")
  call tMatchUIFilterName ("calc5t")
  call tMatchUIFilterName ("calc4")
  call tMatchUIFilterName ("calc4t")
  call tMatchUIFilterName ("calc3")
  call tMatchUIFilterName ("calc3t")
  call tMatchUIFilterName ("sylk")
  call tMatchUIFilterName ("csv")
  call tMatchUIFilterName ("html")
  call tMatchUIFilterName ("msxml")
  
  call tCheckFilterPosition ("calc8")
  call tCheckFilterPosition ("calc8t")
  call tCheckFilterPosition ("calc6")
  call tCheckFilterPosition ("calc6t" )
  call tCheckFilterPosition ("dif" )
  call tCheckFilterPosition ("dbf" )
  call tCheckFilterPosition ("xls97")
  call tCheckFilterPosition ("xls97t")
  call tCheckFilterPosition ("xls95")
  call tCheckFilterPosition ("xls95t")
  call tCheckFilterPosition ("xls5")
  call tCheckFilterPosition ("xls5t")
  call tCheckFilterPosition ("calc5")
  call tCheckFilterPosition ("calc5t")
  call tCheckFilterPosition ("calc4")
  call tCheckFilterPosition ("calc4t")
  call tCheckFilterPosition ("calc3")
  call tCheckFilterPosition ("calc3t")
  call tCheckFilterPosition ("sylk")
  call tCheckFilterPosition ("csv")
  call tCheckFilterPosition ("html")
  call tCheckFilterPosition ("msxml")


end sub
'
'---------------------------------------------------------------------------
'
testcase tMatchUIFilterName ( sFilterKey as STRING )
'///<u><b>Check filter names in current calc UI against archived references</b></u>///
    dim sReferenceFilterName AS STRING
    dim sCurrentFilterName AS STRING
    '///<ul>
    '///<li>Get calc UI filter name for current 'sFilterKey'</li>///
        sCurrentFilterName =  fGetCalcFiltername( sFilterKey )
    
    printlog "Currently testing filter key: " & sFilterKey
    '///<li>Get archived reference name(see files in 'qatesttool/calc/tools/filters/')</li>///
    select case lcase ( sFilterKey )
           case "calc8"   : sReferenceFilterName = gCalcFilterOOo2
           case "calc8t"  : sReferenceFilterName = gCalcFilterOOo2Template
           case "calc6"   : sReferenceFilterName = gCalcFilterOOo1
           case "calc6t"  : sReferenceFilterName = gCalcFilterOOo1Template
           case "dif"     : sReferenceFilterName = gCalcFilterDIF
           case "dbf"     : sReferenceFilterName = gCalcFilterDBF
           case "xls97"   : sReferenceFilterName = gCalcFilterExcelXP
           case "xls97t"  : sReferenceFilterName = gCalcFilterExcelXPTemplate
           case "xls95"   : sReferenceFilterName = gCalcFilterExcel95
           case "xls95t"  : sReferenceFilterName = gCalcFilterExcel95Template
           case "xls5"    : sReferenceFilterName = gCalcFilterExcel5
           case "xls5t"   : sReferenceFilterName = gCalcFilterExcel5Template
           case "calc5"   : sReferenceFilterName = gCalcFilterSO5
           case "calc5t"  : sReferenceFilterName = gCalcFilterSO5Template
           case "calc4"   : sReferenceFilterName = gCalcFilterSO4
           case "calc4t"  : sReferenceFilterName = gCalcFilterSO4Template
           case "calc3"   : sReferenceFilterName = gCalcFilterSO3
           case "calc3t"  : sReferenceFilterName = gCalcFilterSO3Template
           case "sylk"    : sReferenceFilterName = gCalcFilterSYLK
           case "csv"     : sReferenceFilterName = gCalcFilterCSV
           case "html"    : sReferenceFilterName = gCalcFilterHTML
           case "msxml"   : sReferenceFilterName = gCalcFilterExcelXML
   end select
   '///<li>Compare both names</li>///
   if sReferenceFilterName = sCurrentFilterName then
       printlog "The determined filter name matches the archived filter name."
   else
   '///<li>Warn if names are different</li>///
       warnlog "The determined filter name doesn't match the archived filter name -> Check this out!"
       qaErrorLog "UI Name: " & sCurrentFilterName
       qaErrorLog "Archive: " & sReferenceFilterName
   endif
'///</ul>
endcase
'
'---------------------------------------------------------------------------
'
testcase tCheckFilterPosition ( sFilterKey as STRING )
'///<u><b>Check filter postion in 'File::Save As...' dialog</b></u>///
    dim iReferenceFilterPosition AS INTEGER
    dim iCurrentFilterPosition AS INTEGER
    dim sCurrentFilterName AS STRING
    '///<ul>
    '///<li>Get calc UI filter name for current 'sFilterKey'</li>///
        sCurrentFilterName =  fGetCalcFiltername( sFilterKey )
    
    printlog "Currently testing filter key: " & sFilterKey
    '///<li>Define expected filter position</li>///
    select case lcase ( sFilterKey )
           case "calc8"   : iReferenceFilterPosition = 1
           case "calc8t"  : iReferenceFilterPosition = 2
           case "calc6"   : iReferenceFilterPosition = 3
           case "calc6t"  : iReferenceFilterPosition = 4
           case "dif"     : iReferenceFilterPosition = 5
           case "dbf"     : iReferenceFilterPosition = 6
           case "xls97"   : iReferenceFilterPosition = 7
           case "xls97t"  : iReferenceFilterPosition = 8
           case "xls95"   : iReferenceFilterPosition = 9
           case "xls95t"  : iReferenceFilterPosition = 10
           case "xls5"    : iReferenceFilterPosition = 11
           case "xls5t"   : iReferenceFilterPosition = 12
           case "calc5"   : iReferenceFilterPosition = 13
           case "calc5t"  : iReferenceFilterPosition = 14
           case "calc4"   : iReferenceFilterPosition = 15
           case "calc4t"  : iReferenceFilterPosition = 16
           case "calc3"   : iReferenceFilterPosition = 17
           case "calc3t"  : iReferenceFilterPosition = 18
           case "sylk"    : iReferenceFilterPosition = 19
           case "csv"     : iReferenceFilterPosition = 20
           case "html"    : iReferenceFilterPosition = 21
           case "msxml"   : iReferenceFilterPosition = 22
   end select
   '///<li>Open new document</li>///
   call hNewDocument
   '///<li>Invoke File::Save as ...</li>///
   FileSaveAs
   Kontext "SpeichernDlg"
   '///<li>Select 'sCurrentFilterName' as 'File Type'</li>///
   DateiTyp.select ( sCurrentFilterName )
   '///<li>Get postion of selected item</li>///
   iCurrentFilterPosition = DateiTyp.GetSelIndex
   '///<li>Compare postion</li>///
   if iReferenceFilterPosition = iCurrentFilterPosition then
       printlog "The selected filter has the expected postion in the 'File Type' listbox."
   else
   '///<li>Warn position is unexpected</li>///
       warnlog "The selected filter has an unexpected postion in the 'File Type' listbox -> Check this out!"
       qaErrorLog "Expected Index: " & iCurrentFilterPosition
       qaErrorLog "Selected Index: " & iReferenceFilterPosition
   endif
   '///<li>Close dialog</li>///
   SpeichernDlg.Cancel
   '///<li>Close document</li>///
   call hCloseDocument
'///</ul>
endcase
'
'---------------------------------------------------------------------------
'

