'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: clipbrd_func.inc,v $
'*
'*  $Revision: 1.17 $
'*
'*  last change: $Author: hde $ $Date: 2006/02/16 08:43:17 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Functions for HTML-Test
'*
'************************************************************************
'*
' #0 wPasteAvailableClipboardFormats(TheNumber as integer
' #0 wSetClipboardtestDefaults(ForWhat as string) as boolean
' #0 wInsertNewCalcSheet(SheetName as string) as booloean
' #0 wRenameCalcSheet(NewName as string) as boolean
' #0 wFilterSpecialCharacters(ToFilter as string) as string
' #0 ReplaceCharacter(stringToChange$
' #0 wChangeHTMLCompatibility ( optional RecentCompatibility as integer ) as integer
'*
'\***********************************************************************

function wPasteAvailableClipboardFormats(TheNumber as integer, CheckWhat as String )
    Dim i as integer, ClipboardFormat as string
    For i = 1 to TheNumber
        try
            Auswahl.Select i
        catch
            if i <= TheNumber then
                QAErrorlog "Number of clipboard formats seems to be changed!"
            endif
            exit for
        endcatch            
        ClipboardFormat = Auswahl.GetSeltext
        printlog "- Paste as: " + ClipboardFormat        
        Select Case CheckWhat
            Case "ctext", "draw"
                if lcase(gPlatform) = "sol" and lcase(ClipboardFormat) = "bitmap" then
                    QAErrorlog "#i49505#Paste drawing object as bitmap crashes office"
                    goto s_next_item
                else
                    InhaltEinfuegen.Ok
                    Sleep 3
                endif
            Case else
                InhaltEinfuegen.Ok
                Sleep 3
        end select

        Kontext "Active"
        if Active.Exists then
            QAErrorlog " - " + Active.Gettext + "->Bug#110181"
            Active.Ok
        endif
        Call wDocSetContext
        Call wDokSchreiben "<Escape>",2
        Select Case gApplication
            Case "WRITER","MASTERDOC","HTMLDOKUMENT"
                Select Case CheckWhat
                    Case "text","field","table"
                    Call wDokSchreiben "<Down><End><Return>"
                    Call wDokSchreiben "(" + Clipboardformat + ")"
                    Call wDokSchreiben "<End><Return>",2
            Case "frame", "draw", "graphicL", "graphicE", "ole", "control", "ctext"
                'Call gMouseClick (50,100)
                Call wDokSchreiben ("<Escape>")
                Call wDokSchreiben "(" + Clipboardformat + ")"
                if i < TheNumber Then
                    if gApplication <> "HTMLDOKUMENT" then
                        InsertManualBreak
                        Kontext "UmbruchEinfuegen"
                        Seitenumbruch.Check
                        UmbruchEinfuegen.OK
                    else
                        Call wDokSchreiben ("<Return>" , 2)
                    endif
                endif
        end select
        EditPasteSpecialWriter
    
        Case "IMPRESS","DRAW"
            Call gMouseClick(50,100)
            Call wRenameImpressSlide(ClipboardFormat)
            if i < TheNumber Then
                Call wInsertNewImpressSlide
                EditPasteSpecial
            endif
    
        Case "CALC"
            '/// Rename first sheet ///
            if wRenameCalcSheet(Clipboardformat) = False then
                Warnlog "Unable to rename Sheet Name !"
            endif
            if i < TheNumber Then
                if wInsertNewCalcSheet(Clipboardformat) = False then
                    Warnlog "Unable to set Sheetname : " + Clipboardformat
                endif
                EditPasteSpecialCalc
            endif    
        end select
        s_next_item:
        Kontext "InhaltEinfuegen"
    next i
    
    f_exit:
    if InhaltEinfuegen.Exists then InhaltEinfuegen.Cancel
end function

' ---------------------------------------------------------------------------------

function wSetClipboardtestDefaults(ForWhat as string) as boolean
    '/// Points cursor to beginning of document ///
    Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\writer.sxw")
    Kontext "DocumentWriter"
    '/// Jump to beginning of document ///
    Call wDokSchreiben "<Mod1 Home>"
    '/// Check if beginning of document reached ///
    Call wDokSchreiben "<Mod1 Shift Right>"
    EditCopy
    'if GetClipboardText <> "Text " then
    ' warnlog "Error jump to beginning of document!"
    ' wSetClipboardtestDefaults = False
    'else
    Select Case ForWhat
        Case "text"
        '///+ Select first paragraph ///
        Call wDokSchreiben "<Shift End>"
        Call wDokSchreiben "<Shift Down>"
        '///+ Copy selected text ///
        
        Case "field"
        '///+ Select paragraph with 'Date Field' ///
        Call wDokSchreiben "<Down>",3
        Call wDokSchreiben "<Home><Shift End>"
        '///+ Copy selected text ///
        
        Case "table"
        '///+ Select paragraph with 'Table' ///
        Call wNavigatorAuswahl(2,1)
        'Call wDokSchreiben "<Down>",6
        Call wDokSchreiben "<Mod1 A>",2
        '///+ Copy selected table ///
        
        Case "frame"
        '///+ Select 'Frame' ///
        Call wDokSchreiben ( "<Shift F4>" )
        '///+ Copy selected frame ///
        
        Case "draw"
        '///+ Select 'Drawing Object' ///
        Call wDokSchreiben ( "<Shift F4>" )
        Call wDokSchreiben "<Tab>"
        '///+ Copy selected Drawing Object ///
        
        Case "graphicL"
        '///+ Select 'Linked Graphic' ///
        Call wDokSchreiben ( "<Shift F4>" )
        Call wDokSchreiben "<Tab>",2
        '///+ Copy selected Linked Graphic ///
        
        Case "graphicE"
        '///+ Select 'Embedded Graphic' ///
        Call wDokSchreiben ( "<Shift F4>" )
        Call wDokSchreiben "<Tab>",3
        '///+ Copy selected Embedded Graphic ///
        
        Case "ole"
        '///+ Select 'OLE Object' ///
        Call wDokSchreiben ( "<Shift F4>" )
        Call wDokSchreiben "<Tab>",4
        '///+ Copy selected OLE Object ///
        
        Case "control"
        '///+ Select 'Control' ///
        Call wDokSchreiben ( "<Shift F4>" )
        Call wDokSchreiben "<Tab>",5
        '///+ Copy selected Control ///
        
        Case else
            Warnlog "Unknown object!"
    
    end select
    try
        EditCopy
        wSetClipboardtestDefaults = True
    catch
        QAErrorlog "Error jump to beginning of document!"
        wSetClipboardtestDefaults = False
    endcatch
    
    ' Because of Clipboard bug set
    wSetClipboardtestDefaults = True
end function

' ---------------------------------------------------------------------------------

function wInsertNewCalcSheet(SheetName as string) as boolean
    SheetName= wFilterSpecialCharacters(SheetName)
    '/// Inserts a new shett and sets the name for it ///
    InsertSheetCalc
    Kontext "TabelleEinfuegenCalc"
    if TabelleEinfuegenCalc.Exists then
        Nach.Check
        '/// Check 'After current sheet' ///
        NeuErstellen.Check
        '/// Check 'New Sheet' ///
        'Tabellenname.Settext SheetName
        '/// Set Name of sheet ///
        TabelleEinfuegenCalc.Ok
        '/// Unable to set name of Sheet ? ///
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                Warnlog Active.Gettext
                Active.Ok
                Kontext "TabelleEinfuegenCalc"
                if TabelleEinfuegenCalc.Exists then TabelleEinfuegenCalc.Cancel
                wInsertNewCalcSheet = False
            else
                wInsertNewCalcSheet = True
            endif
        else
            wInsertNewCalcSheet = True
        endif
    else
        Warnlog "Dialog 'Insert Sheet' not up!"
        wInsertNewCalcSheet = False
    endif
end function

' ---------------------------------------------------------------------------------

function wRenameCalcSheet(NewName as string) as boolean
    '/// Renames an existing sheet in calc ///
    FormatSheetRename
    Kontext "TabelleUmbenennen"
    if TabelleUmbenennen.Exists then
        TabellenName.Settext wFilterSpecialCharacters(NewName)
        TabelleUmbenennen.Ok
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                Active.Ok
                Kontext "TabelleUmbenennen"
                if TabelleUmbenennen.Exists then TabelleUmbenennen.Cancel
                wRenameCalcSheet = False
            else
                wRenameCalcSheet = True
            endif
        else
            wRenameCalcSheet = True
        endif
    else
        wRenameCalcSheet = False
    endif
    
end function

' ---------------------------------------------------------------------------------

sub wInsertNewImpressSlide()
    InsertSlide
    'if gApplication = "IMPRESS" then
    'Kontext "SeiteEinfuegen"
    'SeitenName.Settext "Dummy"
    'SeiteEinfuegen.Ok
    'endif
end sub

' ---------------------------------------------------------------------------------

sub wRenameImpressSlide(NewName as string)
    '/// Edit->Layer->Rename ///'
    try
        EditRenameSlide
        Kontext "NameDlgPage"
        if NameDlgPage.Exists then
            NameField.Settext NewName
            NameDlgPage.Ok
        else
            try
                Kontext "DocumentDrawImpress"
                TabBar.TypeKeys NewName + "<Return>" , true
            catch
                Warnlog "Unable to rename Slide (No access to to Tab-Bar!)"
            endcatch
        endif
    catch
        Warnlog "Unable to rename Slide!"
    endcatch
    
end sub

' ---------------------------------------------------------------------------------

function wFilterSpecialCharacters(ToFilter as string) as string
     Dim i as integer, SpecialCharacters as string
     SpecialCharacters = "!$%&/()=?\}][{*+~'#;,:.-"
     '/// Replace SpecialCharacters in SheetName with an underscore (_) ///
     For i = 1 to len(SpecialCharacters)
        ToFilter = ReplaceCharacter(ToFilter,Mid$(SpecialCharacters,i,1),"_")
     next i
     wFilterSpecialCharacters = ToFilter
end function

' ---------------------------------------------------------------------------------

function ReplaceCharacter(stringToChange$, charToReplace$, replaceWith$) As String

    'Replaces a specified character in a string with another character that you specify
    Dim ln, n As Long
    Dim NextLetter As String
    Dim FinalString As String
    Dim txt, char, rep As String
    txt = stringToChange$ 'store all arguments in
    char = charToReplace$ 'new variables
    rep = replaceWith$

    ln = Len(txt)

    For n = 1 To ln Step 1
        NextLetter = Mid(txt, n, 1)
        If NextLetter = char Then
            NextLetter = rep
        End If
        FinalString = FinalString & NextLetter
    Next n
    ReplaceCharacter = FinalString

end function


Sub wDisableImpressAutopilot()

    gApplication = "IMPRESS"
    Call hNewDocument
    ToolsOptions
    Call hToolsOptions ("PRESENTATION","General")
    MitAutopilotStarten.UnCheck
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    Call hCloseDocument

end sub

function wChangeHTMLCompatibility ( optional RecentCompatibility as integer ) as integer
    Dim i as integer, CurrentCharSet as String
    Dim RecentCharSet as integer, CharsetFound as boolean
    '/// This function sets the charset in options to UTF-8 ///
    '/// Giving a parameter a special charset will be chosen ///
    
    CharsetFound = False
    ToolsOptions
    Call hToolsOptions("LOADSAVE", "HTMLCOMPATIBILITY")
    if IsMissing(RecentCompatibility) = True then
        RecentCharSet = Zeichensatz.GetSelIndex
        For i = 1 to Zeichensatz.GetItemCount
            Zeichensatz.Select i
            CurrentCharset = Zeichensatz.GetSelText
            if Instr(Ucase(CurrentCharset), "UTF-8") then
                i = Zeichensatz.GetItemCount + 1
                CharsetFound = True
            endif
        next i
    else
        CharsetFound = True
        RecentCharSet = RecentCompatibility
        Zeichensatz.Select RecentCompatibility
    endif
    if CharsetFound = True then
        printlog "Charset has been changed!"
    else
        Warnlog "Couldn't set Charset to UTF-8!"
    endif
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    wChangeHTMLCompatibility = RecentCharset
    
end function


function wChangeHTMLCompatibilityExport ( optional wExport as integer ) as integer
    Dim i as integer, CurrentExportSet as String
    Dim RecentExportSet as integer, ExportFound as boolean
    '/// This function sets the export in options to 'StarOffice Writer' ///
    '/// Giving a parameter a special export will be chosen ///
    
    ExportFound = False
    ToolsOptions
    Call hToolsOptions("LOADSAVE", "HTMLCOMPATIBILITY")
    if IsMissing ( wExport ) = True then
        RecentExportSet = Export.GetSelIndex
        For i = 1 to Export.GetItemCount
            Export.Select i
            CurrentExportset = Export.GetSelText
            if Instr(Ucase(CurrentExportset), "STAROFFICE WRITER") then
                i = Export.GetItemCount + 1
                ExportFound = True
            endif
        next i
    else
        ExportFound = True
        RecentExportSet = wExport
        Export.Select RecentExportSet
    endif
    if ExportFound = True then
        printlog "Export has been changed!"
    else
        Warnlog "Couldn't set Export to StarOffice Writer!"
    endif
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    wChangeHTMLCompatibilityExport = RecentExportSet
end function
