'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_textframes2.inc,v $
'*
'*  $Revision: 1.12 $
'*
'*  last change: $Author: hde $ $Date: 2006/04/10 14:16:49 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test of textframe - 2
'*
'\***********************************************************************

sub w_textframes2

    Call tTextframes_17         'Test protect contents - text insertion in frame must be suppressed
    Call tTextframes_18         'Test protect position - moving frame with mouse/keyboard suppressed
    Call tTextframes_19         'Test if frame can move when protect content is checked
    Call tTextframes_20         'Test frame without wrap
    Call tTextframes_21         'Test frame with wrap ( through)
    Call tTextframes_22         'Test wrap - before/after - 1
    Call tTextframes_23         'Test wrap - before/after - 2
    Call tTextframes_24         'Set more than 1 columns for the frame
    Call tTextframes_25         'Test columns' width
    Call tTextframes_26         'Test columns' spacing
    Call tTextframes_27         'Test columns' seperator line
    Call tTextframes_28         'Test overlap with different wrapping types
    Call tTextframes_29         'Test 'synchronize' distances for border (Check Synchronize)
    Call tTextframes_30         'Test 'synchronize' distances for border (UnCheck Synchronize)
    Call tTextframes_31         'Frame should be non-editable in read-only documents
    Call tTextframes_32         'Test input text into frame in read-only document when checking "Editable in read-only document"

end sub    

'---------------------------------------------------

testcase tTextframes_17

    Dim sTestText
    
    sTestText = "T"
    
    printlog "- Test protect contents - text insertion in frame must be suppressed"
    '/// Test protect contents - text insertion in frame must be suppressed
    
    Call hNewDocument
    
    '/// insert a frame
    Call fInsertFrame(20,50 , 30,60)
    
    '/// Format / Frame / Options , check contents
    Call fFormatFrame("TabZusaetze")
    InhaltSchuetzen.Check
    TabZusaetze.OK
    
    Call wDokSchreiben "<ESCAPE>"
    Wait 500
    
    Call gMouseClick(22,55)
    Wait 500
    
    '/// check if contents can be inserted into frame
    Call wDokSchreiben sTestText
    
    Kontext "Active"
    if Active.Exists then
        Active.Ok
    else
        Warnlog "The contents should not be inserted into frame!"
    endif
    
    Call hCloseDocument

endcase

'---------------------------------------------------

testcase tTextframes_18

    Dim sTestText
    
    sTestText = "T"
    
    printlog "- Test protect position - moving frame with mouse/keyboard suppressed"
    '/// Test protect position - moving frame with mouse/keyboard suppressed
    
    Call hNewDocument
    
    '/// insert a frame
    Call fInsertFrame(50,40 , 60,60)
    
    '/// Format / Frame / Options , check contents
    Call fFormatFrame("TabZusaetze")
    InhaltSchuetzen.Check
    PositionSchuetzen.Check
    TabZusaetze.OK
    
    '/// Move the frame to right (Right key 4 times)
    Call wDokSchreiben "<Right>" , 4
    Wait 500
    Call wDokSchreiben "<ESCAPE>"
    Wait 500
    
    Call gMouseClick(55,50)
    Sleep 2
    
    '/// check if the frame is moved
    Call wDokSchreiben sTestText
    
    Kontext "Active"
    if Active.Exists then
        Active.Ok
    else
        Warnlog "The contents should NOT be inserted into the frame!"
    endif
    
    Call wDokSchreiben "<Shift Left>"
    try
        EditCopy
        Wait 500
        if GetClipboardText = sTestText then Warnlog "Something wrong in the test !"
    catch
    endcatch
    
    Call hCloseDocument
    
endcase

'---------------------------------------------------

testcase tTextframes_19

    Dim sTestText
    
    sTestText = "T"
    
    printlog "- Test if frame can move when protect content is checked"
    '/// Test if frame can move when protect content is checked
    
    Call hNewDocument
    
    '/// insert a frame
    Call fInsertFrame(50,50 , 60,60)
    
    '/// Format / Frame / Options , check contents
    Call fFormatFrame("TabZusaetze")
    InhaltSchuetzen.Check
    TabZusaetze.OK
    
    '/// Move the frame to right (Right key 4 times)
    Call wDokSchreiben "<Right>" , 4
    Wait 500
    Call wDokSchreiben "<ESCAPE>"
    Wait 500
    
    Call gMouseClick(52,55)
    Wait 500
    
    '/// check if the frame is moved
    Call wDokSchreiben sTestText
    
    Kontext "Active"
    if Active.Exists then
        Warnlog "#i40348# The frame should move by keyboard!"
        Active.Ok
    endif
    
    Call wDokSchreiben "<Shift Left>"
    try
        EditCopy
        Wait 500
        if GetClipboardText <> sTestText then Warnlog "Something wrong in the test . Clipboard:" +GetClipboardText
    catch
        Warnlog "#i40348#"
    endcatch
    
    Call hCloseDocument

endcase

'---------------------------------------------------

testcase tTextframes_20

    Dim sTestFile , sTestText as String
    
    sTestFile = Convertpath (gTesttoolpath + "writer\level1\input\textframe\wrap.sxw")
    sTestText = "Test"
    
    printlog "- Test frame without wrap"
    '/// Test frame without wrap
    
    '/// Open a test file
    '/// + This test file is designed for without wrap test
    '/// + There are 1 page in the file.
    '/// + The frame is ocupied in the whole 1st page and wraped as Through
    '/// + Some text are behind the frame
    Call hDateiOeffnen(sTestFile)
    
    '/// Set focus to frame
    Call wDokSchreiben ( "<Shift F4>" )
    Sleep 1
    
    '/// Format / Frame / Wrap , check None in setting area
    Call fFormatFrame("TabUmlauf")
    Kein.Check
    wait 500
    TabUmlauf.OK
    
    '/// Check if frame is in 1st page
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test frame isn't in the first page!"
    end if
    Call fCloseNavigator
    
    '/// Check if test text are in 2nd page
    Call wDokSchreiben "<ESCAPE>"
    Call wDokSchreiben "<Home><Shift End>"
    
    try
        EditCopy
        Wait 500
        if GetClipboardText <> sTestText then Warnlog "Test text isn't right , GetClipboardText is " +GetClipboardText
    catch
        Warnlog "EditCopy can't be executed !"
    endcatch
    
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "2" then
        Warnlog "The test text isn't in the second page!"
    end if
    
    Call fCloseNavigator
    
    Call hCloseDocument
    
endcase

'-----------------------------------------------------------------

testcase tTextframes_21

    Dim sTestFile , sTestText as String
    
    sTestFile = Convertpath (gTesttoolpath + "writer\level1\input\textframe\through.sxw")
    sTestText = "Test"
    
    printlog "- Test frame with wrap "
    '/// Test frame with wrap
    
    '/// Open a test file
    '/// + This test file is designed for with through wrap test
    '/// + There are 2 page in the file.
    '/// + The frame is ocupied in the whole 1st page and wraped as None
    '/// + Some text are in the 2nd page
    
    Call hDateiOeffnen(sTestFile)
    
    '/// Set focus to frame
    Call wDokSchreiben ( "<Shift F4>" )
    Sleep 1
    
    '/// Format / Frame / Wrap , check through in setting area
    Call fFormatFrame("TabUmlauf")
    Durchlauf.Check
    wait 500
    TabUmlauf.OK
    
    '/// Check if frame are in 1st page
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test frame isn't in the first page!"
    end if
    Call fCloseNavigator
    
    '/// Check if test text are in 1st page
    Call wDokSchreiben "<ESCAPE>"
    Call wDokSchreiben "<Home><Shift End>"
    
    try
        EditCopy
        Wait 500
        if GetClipboardText <> sTestText then Warnlog "Test text isn't right , GetClipboardText is " +GetClipboardText
    catch
        Warnlog "EditCopy can't be executed !"
    endcatch
    
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test text isn't in the first page!"
    end if
    
    Call fCloseNavigator
    
    Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tTextframes_22

    Dim sTestFile , sTestText as String
    
    sTestFile = Convertpath (gTesttoolpath + "writer\level1\input\textframe\before.sxw")
    sTestText = "Test"
    
    printlog "- Test wrap - before/after - 1"
    '/// Test wrap - before/after - 1
    
    '/// Open a test file
    '/// + This test file is designed for with before/after wrap test
    '/// + There are 2 page in the file.
    '/// + The frame is ocupied in the whole 1st page and wraped as None
    '/// + there are some space in the left of the frame.
    '/// + Some text are in the 2nd page
    
    Call hDateiOeffnen(sTestFile)
    
    printlog "- Test wrap - before"
    
    '/// Set focus to frame
    Call wDokSchreiben ( "<Shift F4>" )
    Sleep 1
    
    '/// Format / Frame / Wrap , check before in setting area
    Call fFormatFrame("TabUmlauf")
    Links.Check
    wait 500
    TabUmlauf.OK
    
    '/// Check if frame are in 1st page
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test frame isn't in the first page!"
    end if
    Call fCloseNavigator
    
    '/// Check if test text are in 1st page
    Call wDokSchreiben "<ESCAPE>"
    Sleep 1
    Call wDokSchreiben "<Home><Shift End>"
    
    try
        EditCopy
        Wait 500
        if GetClipboardText <> sTestText then Warnlog "Test text isn't right , GetClipboardText is " +GetClipboardText
    catch
        Warnlog "EditCopy can't be executed !"
    endcatch
    
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test text isn't in the first page!"
    end if
    
    Call fCloseNavigator
    
    printlog "- Test wrap - after"
    
    'Set focus to frame
    Call wDokSchreiben ( "<Shift F4>" )
    Sleep 1
    
    '/// Format / Frame / Wrap , check after in setting area
    Call fFormatFrame("TabUmlauf")
    Rechts.Check
    wait 500
    TabUmlauf.OK
    
    '/// Check if frame are in 1st page
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test frame isn't in the first page!"
    end if
    Call fCloseNavigator
    
    '/// Check if test text are in 2nd page
    Call wDokSchreiben "<ESCAPE>"
    Sleep 1
    Call wDokSchreiben "<Home><Shift End>"
    
    try
        EditCopy
        Wait 500
        if GetClipboardText <> sTestText then Warnlog "Test text isn't right , GetClipboardText is " +GetClipboardText
    catch
        Warnlog "EditCopy can't be executed !"
    endcatch
    
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "2" then
        Warnlog "The test text isn't in the first page!"
    end if
    
    Call fCloseNavigator
    
    Call hCloseDocument
    
endcase

'-----------------------------------------------------------------

testcase tTextframes_23

    Dim sTestFile , sTestText as String
    
    sTestFile = Convertpath (gTesttoolpath + "writer\level1\input\textframe\after.sxw")
    sTestText = "Test"
    
    printlog "- Test wrap - before/after - 2"
    '/// Test wrap - before/after - 2
    
    '/// Open a test file
    '/// + This test file is designed for with before/after wrap test
    '/// + There are 2 page in the file.
    '/// + The frame is ocupied in the whole 1st page and wraped as None
    '/// + there are some space in the right of the frame.
    '/// + Some text are in the 2nd page
    
    Call hDateiOeffnen(sTestFile)
    
    printlog "- Test wrap - before"
    
    '/// Set focus to frame
    Call wDokSchreiben ( "<Shift F4>" )
    Sleep 1
    
    '/// Format / Frame / Wrap , check before in setting area
    Call fFormatFrame("TabUmlauf")
    Links.Check
    wait 500
    TabUmlauf.OK
    
    '/// Check if frame are in 1st page
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test frame isn't in the first page!"
    end if
    Call fCloseNavigator
    
    '/// Check if test text are in 1st page
    Call wDokSchreiben "<ESCAPE>"
    Sleep 1
    Call wDokSchreiben "<Home><Shift End>"
    
    try
        EditCopy
        Wait 500
        if GetClipboardText <> sTestText then Warnlog "Test text isn't right , GetClipboardText is " +GetClipboardText
    catch
        Warnlog "EditCopy can't be executed !"
    endcatch
    
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "2" then
        Warnlog "The test text isn't in the first page!"
    end if
    
    Call fCloseNavigator
    
    printlog "- Test wrap - after"
    
    '/// Set focus to frame
    Call wDokSchreiben ( "<Shift F4>" )
    Sleep 1
    
    '/// Format / Frame / Wrap , check after in setting area
    Call fFormatFrame("TabUmlauf")
    Rechts.Check
    wait 500
    TabUmlauf.OK
    
    '/// Check if frame are in 1st page
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test frame isn't in the first page!"
    end if
    Call fCloseNavigator
    
    '/// Check if test text are in 2nd page
    Call wDokSchreiben "<ESCAPE>"
    Sleep 1
    Call wDokSchreiben "<Home><Shift End>"
    
    try
        EditCopy
        Wait 500
        if GetClipboardText <> sTestText then Warnlog "Test text isn't right , GetClipboardText is " +GetClipboardText
    catch
        Warnlog "EditCopy can't be executed !"
    endcatch
    
    Kontext
    EditNavigator
    Kontext "NavigatorWriter"
    Sleep 1
    if Seitennummer.GetText <> "1" then
        Warnlog "The test text isn't in the first page!"
    end if
    
    Call fCloseNavigator
    
    Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tTextframes_24

    Dim sColumn as String
    
    sColumn = "3"
    
    printlog "- Set more than 1 columns for the frame"
    '/// Set more than 1 columns for the frame
    
    Call hNewDocument
    
    '/// Insert a frame
    Call wInsertFrame
    
    '/// Format / Frame / columns , set columns to 3 , close the dialogue
    Call fFormatFrame("TabSpalten")
    Anzahl.SetText sColumn
    wait 500
    TabSpalten.OK
    
    '/// Check if the column is set correctly
    Call fFormatFrame("TabSpalten")
    if Anzahl.GetText <> sColumn then Warnlog "the column isn't set correctly ! The column you get is:Anzahl.GetText"
    TabSpalten.Cancel
    
    Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tTextframes_25

    Dim sWidth , sSpacingToContent                    as String
    Dim sColumn                                       as String
    Dim sWidthColumn1 , sWidthColumn2 , sWidthColumn3 as String
    
    sWidth            = "6"+ gSeperator + "00" + gMeasurementUnit
    sSpacingToContent = "0"+ gSeperator + "00" + gMeasurementUnit
    
    sColumn = "3"
    
    sWidthColumn1     = "1"+ gSeperator + "00" + gMeasurementUnit
    sWidthColumn2     = "2"+ gSeperator + "00" + gMeasurementUnit
    sWidthColumn3     = "3"+ gSeperator + "00" + gMeasurementUnit
    
    printlog "- Test columns' width"
    '/// Test columns' width
    
    Call hNewDocument
    
    '/// Insert a frame
    Call wInsertFrame
    
    'Set frame's width
    Call fFormatFrame("TabType")
    Width.SetText   sWidth
    wait 500
    TabType.OK
    
    'Set frame's Spacing to Content
    Call fFormatFrame("TabUmrandung")
    Synchronisieren.Check
    wait 500
    Links.SetText sSpacingToContent
    wait 500
    TabUmrandung.OK
    
    '/// Format / Frame / columns , set columns to 3
    Call fFormatFrame("TabSpalten")
    Anzahl.SetText sColumn
    wait 500
    TabSpalten.OK
    
    '/// + Set 3 columns to different width
    Call fFormatFrame("TabSpalten")
    AutomBreite.Uncheck
    Sleep 1
    Spaltenbreite1.SetText sWidthColumn1
    wait 500
    Spaltenbreite2.SetText sWidthColumn2
    wait 500
    Spaltenbreite3.SetText sWidthColumn3
    wait 500
    TabSpalten.OK
    
    '/// Check if the columns' width is set correctly
    Call fFormatFrame("TabSpalten")
    if Spaltenbreite1.GetText <> sWidthColumn1 then Warnlog "the column1's width isn't set correctly !"
    if Spaltenbreite2.GetText <> sWidthColumn2 then Warnlog "the column2's width isn't set correctly !"
    if Spaltenbreite3.GetText <> sWidthColumn3 then Warnlog "the column3's width isn't set correctly !"
    TabSpalten.Cancel
    
    Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tTextframes_26
    
    Dim sWidth           , sSpacingToContent                   as String
    Dim sColumn                                                as String
    Dim sWidthColumn1    , sWidthColumn2    , sWidthColumn3    as String
    Dim sSpacing1        , sSpacing2                           as String
    Dim sNewWidthColumn1 , sNewWidthColumn2 , sNewWidthColumn3 as String
    
    sWidth            = "6"+ gSeperator + "00" + gMeasurementUnit
    sSpacingToContent = "0"+ gSeperator + "00" + gMeasurementUnit
    
    sColumn = "3"
    
    sWidthColumn1     = "1"+ gSeperator + "00" + gMeasurementUnit
    sWidthColumn2     = "2"+ gSeperator + "00" + gMeasurementUnit
    sWidthColumn3     = "3"+ gSeperator + "00" + gMeasurementUnit
    
    sSpacing1         = "0"+ gSeperator + "10" + gMeasurementUnit
    sSpacing2         = "0"+ gSeperator + "20" + gMeasurementUnit
    
    sNewWidthColumn1  = "1"+ gSeperator + "00" + gMeasurementUnit
    sNewWidthColumn2  = "1"+ gSeperator + "90" + gMeasurementUnit
    sNewWidthColumn3  = "2"+ gSeperator + "80" + gMeasurementUnit
    
    printlog "- Test columns' spacing"
    '/// Test columns' spacing
    
    Call hNewDocument
    
    '/// Insert a frame
    Call wInsertFrame
    
    'Set frame's width
    Call fFormatFrame("TabType")
    Width.SetText sWidth
    wait 500
    TabType.OK
    
    'Set frame's Spacing to Content
    Call fFormatFrame("TabUmrandung")
    Synchronisieren.Check
    wait 500
    Links.SetText sSpacingToContent
    wait 500
    TabUmrandung.OK
    
    '/// Format / Frame / columns , set columns to 3
    Call fFormatFrame("TabSpalten")
    Anzahl.SetText sColumn
    wait 500
    TabSpalten.OK
    
    '/// + Set 3 columns to different width
    Call fFormatFrame("TabSpalten")
    AutomBreite.Uncheck
    Sleep 1
    Spaltenbreite1.SetText sWidthColumn1
    wait 500
    Spaltenbreite2.SetText sWidthColumn2
    wait 500
    Spaltenbreite3.SetText sWidthColumn3
    wait 500
    TabSpalten.OK
    
    '/// + Set Spacing1 and Spacing2
    Call fFormatFrame("TabSpalten")
    Abstand12.SetText sSpacing1
    Sleep 2
    Abstand23.SetText sSpacing2
    Sleep 3
    Art.Select 1
    Sleep 1
    TabSpalten.OK
    Sleep 2
    
    '/// Check if the columns' width is set correctly
    Call fFormatFrame("TabSpalten")
    if NOT LiberalMeasurement(Spaltenbreite1.GetText , sNewWidthColumn1 ) then Warnlog "the column1's width isn't set correctly !"
    if NOT LiberalMeasurement(Spaltenbreite2.GetText , sNewWidthColumn2 ) then Warnlog "the column2's width isn't set correctly !"
    if NOT LiberalMeasurement(Spaltenbreite3.GetText , sNewWidthColumn3 ) then Warnlog "the column3's width isn't set correctly !"
    if NOT LiberalMeasurement(Abstand12.GetText      , sSpacing1        ) then Warnlog "the 1st spacing isn't set correctly !"
    if NOT LiberalMeasurement(Abstand23.GetText      , sSpacing2        ) then Warnlog "the 2nd spacing isn't set correctly !"
    TabSpalten.Cancel
    
    Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tTextframes_27
    
    Dim iLine   , iPosition as Integer
    Dim sHeight             as String
    
    iLine     = 3
    iPosition = 2
    sHeight   = "50%"
    
    printlog "- Test columns' seperator line"
    '/// Test columns' seperator line
    
    Call hNewDocument
    
    '/// Insert a frame
    Call wInsertFrame
    
    '/// Format / Frame / columns , set columns to 4
    '/// + default : column is 1 , Line and Height and Position isn't enabled
    Call fFormatFrame("TabSpalten")
    if Anzahl.GetText <> "1" then  Warnlog "the default column number is 1 , but get " +Anzahl.GetText
    
    try
        Art.Select      iLine
        Warnlog "Line : should be inactived !"
        Hoehe.SetText   sHeight
        Warnlog "Height : should be inactived !"
        Position.Select iPosition
        Warnlog "Position : should be inactived !"
    catch
    endcatch
    
    Anzahl.SetText "2"
    Wait 500
    TabSpalten.OK
    
    '/// Check if the columns' width is set correctly
    Call fFormatFrame("TabSpalten")
    Art.Select      iLine
    Sleep 2
    Hoehe.SetText   sHeight
    Sleep 2
    Position.Select iPosition
    Sleep 2
    TabSpalten.OK
    
    Call fFormatFrame("TabSpalten")
    if Art.GetSelIndex      <> iLine      then Warnlog "Line isn't correct!"
    Sleep 1
    if Hoehe.GetText        <> sHeight    then Warnlog "Height isn't correct!"
    Sleep 1
    if Position.GetSelIndex <> iPosition  then Warnlog "Position isn't correct!"
    Sleep 1
    TabSpalten.Cancel
    
    Call hCloseDocument
    
endcase

'-----------------------------------------------------------------

testcase tTextframes_28

    Dim sFrameName1 , sFrameName2 as String
    
    sFrameName1 = "Test1"
    sFrameName2 = "Test2"
    
    printlog "- Test overlap with different wrapping types"
    '/// Test overlap with different wrapping types
    
    Call hNewDocument
    
    '/// Insert a frame
    Call fInsertFrame(20, 30, 60, 45)
    
    '/// + Naming the frame
    Call fFormatFrame("TabZusaetze")
    ObjektName.SetText sFrameName1
    TabZusaetze.OK
    
    '/// + Set the frame's wrap
    Call fFormatFrame("TabUmlauf")
    Kein.Check
    Sleep 1
    TabUmlauf.OK
    Sleep 2
    Call wDokSchreiben "<ESCAPE>"
    Sleep 2
    
    '/// Insert another frame
    Call fInsertFrame(50, 55, 30, 35)
    
    '/// + Naming the frame
    Call fFormatFrame("TabZusaetze")
    ObjektName.SetText sFrameName2
    TabZusaetze.OK
    
    '/// + Set the frame's wrap
    Call fFormatFrame("TabUmlauf")
    Sleep 1
    Durchlauf.Check
    Sleep 1
    TabUmlauf.OK
    
    Call wDokSchreiben "<ESCAPE>"
    Sleep 2
    
    '/// Set focus to second frame
    Call wDokSchreiben ( "<Shift F4>" )
    wait 500
    
    '/// Check second frame's name
    Call fFormatFrame("TabZusaetze")
    if ObjektName.GetText <> sFrameName2 then Warnlog "The 2nd frame's name is wrong ! Get " +ObjektName.GetText
    TabZusaetze.Cancel
    
    '/// Check second frame's wrap status
    Call fFormatFrame("TabUmlauf")
    if Durchlauf.IsChecked <> TRUE then Warnlog "The 2nd frame's wrap status is wrong ! "
    TabUmlauf.Cancel
    
    '/// Set focus to first frame
    Call wDokSchreiben "<TAB>"
    Sleep 2
    
    '/// Check the frame's name and warp status
    'Check first frame's name
    Call fFormatFrame("TabZusaetze")
    if ObjektName.GetText <> sFrameName1 then Warnlog "The 1st frame's name is wrong ! Get " +ObjektName.GetText
    TabZusaetze.Cancel
    
    'Check first frame's wrap status
    Call fFormatFrame("TabUmlauf")
    if Kein.IsChecked <> TRUE then Warnlog "The 1st frame's wrap status is wrong ! "
    TabUmlauf.Cancel
    
    Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tTextframes_29

    Dim  sLeft1 , sRight1 , sTop1 , sBottom1 as String
    
    sLeft1   =  "0"+ gSeperator + "10" + gMeasurementUnit
    sRight1  =  "0"+ gSeperator + "11" + gMeasurementUnit
    sTop1    =  "0"+ gSeperator + "12" + gMeasurementUnit
    sBottom1 =  "0"+ gSeperator + "13" + gMeasurementUnit
    
    printlog "- Test 'synchronize' distances for border (Check Synchronize)"
    '/// Test "synchronize" distances for border (Check Synchronize)
    
    Call hNewDocument
    
    '/// insert a frame
    Call wInsertFrame
    
    '/// Format / Frame / Borders , check Synchronize ,
    '/// + then set spacing to contents
    '/// + to differect number (left, right, top, bottom)
    Call fFormatFrame("TabUmrandung")
    Synchronisieren.Check
    wait 500
    Links.SetText    sLeft1
    wait 500
    Rechts.SetText   sRight1
    wait 500
    Oben.SetText     sTop1
    wait 500
    Unten.SetText    sBottom1
    wait 500
    TabUmrandung.OK
    
    '/// Check if the spacing to contents is right
    Call fFormatFrame("TabUmrandung")
    if Synchronisieren.IsChecked <> TRUE     then Warnlog "checkbox synchronize should be checked!"
    if Links.GetText             <> sBottom1 then Warnlog "spacing to contents (left) isn't right!"
    if Rechts.GetText            <> sBottom1 then Warnlog "spacing to contents (right) isn't right!"
    if Oben.GetText              <> sBottom1 then Warnlog "spacing to contents (top) isn't right!"
    if Unten.GetText             <> sBottom1 then Warnlog "spacing to contents (bottom) isn't right!"
    TabUmrandung.Cancel
    
    Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tTextframes_30
    
    Dim  sLeft1 , sRight1 , sTop1 , sBottom1 as String
    
    sLeft1   =  "0"+ gSeperator + "10" + gMeasurementUnit
    sRight1  =  "0"+ gSeperator + "11" + gMeasurementUnit
    sTop1    =  "0"+ gSeperator + "12" + gMeasurementUnit
    sBottom1 =  "0"+ gSeperator + "13" + gMeasurementUnit
    
    printlog "- Test 'synchronize' distances for border (UnCheck Synchronize)"
    '/// Test "synchronize" distances for border (UnCheck Synchronize)
    
    Call hNewDocument
    
    '/// insert a frame
    Call wInsertFrame
    
    '/// Format / Frame / Borders , Uncheck Synchronize ,
    '/// + then set spacing to contents
    '/// + to differect number (left, right, top, bottom)
    Call fFormatFrame("TabUmrandung")
    Synchronisieren.UnCheck
    wait 500
    Links.SetText    sLeft1
    wait 500
    Rechts.SetText   sRight1
    wait 500
    Oben.SetText     sTop1
    wait 500
    Unten.SetText    sBottom1
    wait 500
    TabUmrandung.OK
    
    '/// Check if the spacing to contents is right
    Call fFormatFrame("TabUmrandung")
    if Synchronisieren.IsChecked =  TRUE     then Warnlog "checkbox synchronize should be checked!"
    if Links.GetText             <> sLeft1   then Warnlog "spacing to contents (left) isn't right!"
    if Rechts.GetText            <> sRight1  then Warnlog "spacing to contents (right) isn't right!"
    if Oben.GetText              <> sTop1    then Warnlog "spacing to contents (top) isn't right!"
    if Unten.GetText             <> sBottom1 then Warnlog "spacing to contents (bottom) isn't right!"
    TabUmrandung.Cancel
    
    Call hCloseDocument
    
endcase

'-----------------------------------------------------------------

testcase tTextframes_31

    Dim sTestFile as String
    
    sTestFile = ConvertPath (gOfficePath + "user\work\testFileReadOnly.odt" )
    
    if Dir(sTestFile) <> "" then
        setattr sTestFile , 0
        Sleep 2
        kill sTestFile
    end if
    
    printlog "- Frame should be non-editable in read-only documents"
    '/// Frame should be non-editable in read-only documents
    
    Call hNewDocument
    
    '/// insert a frame
    Call wInsertFrame
    
    '/// Save the file and set the file's property to Read-only
    Call hSpeichernUnter (sTestFile ,true)
    
    Call hCloseDocument
    Sleep 1
    
    setattr sTestFile , 1
    Sleep 2
    
    '/// Check if the frame is non-editable
    Call hDateiOeffnen(sTestFile)
    
    Call wDokSchreiben ( "<Shift F4>" )
    
    try
        FormatFrame
        Kontext
        Active.SetPage TabType
        Kontext "TabType"
        TabType.Cancel
        Warnlog "The frame should be non-editable!"
    catch
    endcatch
    
    Call hCloseDocument
    
endcase

'-----------------------------------------------------------------

testcase tTextframes_32

    Dim sTestFile , sText as String
    
    sText     = "Test"
    sTestFile = ConvertPath (gOfficePath + "user\work\testFileReadOnly.odt" )
    
    if Dir(sTestFile) <> "" then
        setattr sTestFile , 0
        Sleep 2
        kill sTestFile
    end if
    
    printlog "- Test input text into frame in read-only document when checking 'Editable in read-only document'"
    '/// Test input text into frame in read-only document when checking "Editable in read-only document"
    
    Call hNewDocument
    
    '/// insert a frame
    Call fInsertFrame(20,20 , 50,60)
    
    '/// Format / Frame / Options , check "Editable in read-only document"
    Call fFormatFrame("TabZusaetze")
    Editierbar.Check
    wait 500
    TabZusaetze.OK
    Call wDokSchreiben "<ESCAPE>"
    
    '/// Save the file and set the file's property to Read-only
    Call hSpeichernUnter (sTestFile ,true)
    
    Call hCloseDocument
    
    setattr sTestFile , 1
    Sleep 2
    
    '/// Check if the text can be inputed into frame
    Call hDateiOeffnen(sTestFile)
    
    Call gMouseClick(35,40)
    Wait 500
    
    try
        Call wDokSchreiben sText
        Sleep 1
    catch
        Warnlog "Can't input text into frame !"
    endcatch
    
    Call wDokSchreiben "<Shift Home>"
    Sleep 1
    
    EditCopy
    Sleep 1
    
    if GetClipboardText <> sText then Warnlog "The inputed text isn't right!"
    
    Call hCloseDocument
    
endcase
