'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_001a_.inc,v $
'*
'*  $Revision: 1.24 $
'*
'*  last change: $Author: hde $ $Date: 2006/08/16 07:28:51 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_001a_
    printLog Chr(13) + "--------- File Menu (w_001a_.inc) ----------"

    Call tFileProperties

    Call tFileTemplatesOrganize
    Call tFileTemplatesAddressbookSource
'   This has been disabled in Masterdocument until 6.1 Final
    if gApplication <> "MASTERDOC" then
        Call tFileTemplatesSave
    endif
    Call tFileTemplatesEdit

    Call tFilePagePreview
    Call tFilePrint
    Call tFilePrinterSetup

'   Call tFileExit

end sub

'-----------------------------------------------------------

testcase tFileProperties
    PrintLog "- File / Properties"

    Call hNewDocument
    '/// Open new document ///

    FileProperties
    '/// File / Properties ///

    Sleep 5
    Kontext
    try
        active.SetPage TabDokument
    catch
        Warnlog "Dialog 'FileProperties' not up! (Bug#99828)"
        goto endsub
    endcatch


    Kontext "TabDokument"
    Call DialogTest (TabDokument)
    '/// Switch to Tabpage 'General' ///

    Kontext
    active.SetPage TabDokumentinfo
    Kontext "TabDokumentinfo"
    Call DialogTest (TabDokumentinfo)
    '/// Switch to Tabpage 'Description' ///

    Kontext
    active.SetPage TabBenutzer
    Kontext "TabBenutzer"
    Call DialogTest ( TabBenutzer )
    '/// Switch to Tabpage 'User defined' ///

    Wait 500
    Infofelder.Click
    '/// Click 'Infofields' ///
    Kontext "InfonamenBearbeiten"
    Call DialogTest (InfonamenBearbeiten)
    InfonamenBearbeiten.Cancel
    '/// Close upcoming dialog with 'Cancel' ///

    Kontext
    active.SetPage TabInternet
    Kontext "TabInternet"
    Call DialogTest (TabInternet)
    '/// Switch to Tabpage 'Internet' ///

    Kontext
    active.SetPage TabStatistik
    Kontext "TabStatistik"
    Call DialogTest (TabStatistik)
    TabStatistik.Close
    '/// Switch to Tabpage 'Statistics' and close dialog ///

    Sleep 1
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileTemplatesOrganize
    Dim i as integer
    PrintLog "- File / Templates / Organize"

    Call hNewDocument
    '/// Open new document ///
    FileTemplatesOrganize
    '/// File / Templates / Organize ///
    Kontext "DVVerwalten"
    For i = 1 to 50
        if DVVerwalten.Exists then
            i = 51
        else
            Sleep 5
        endif
    next i
    if Not DVVerwalten.Exists then
        Warnlog "Dialog 'Template Management' not up !"
        Call hCloseDocument
        goto endsub
    endif
    wait 500
    ListeLinks.Select 1
    ListeLinks.TypeKeys "<Home>"
    '/// Select first entry in left list of dialog 'Template Management' (should be 'My Templates')///
    '/// 
    Sleep 1
    Befehle.Click
    wait 500
    Call hMenuSelectNr(3)
    '/// Select 'Commands -> Import Template' ///
    Wait 500
    if gUseSysDlg = False then
        Kontext "OeffnenDlg"
        if OeffnenDlg.Exists then
            OeffnenDlg.Cancel
        else
            Warnlog "FileOpen dialog not up!"
        endif
    endif
    '/// Close Filedialog ///

    Kontext "DVVerwalten"
    Sleep 1
    Befehle.Click
    wait 500
    Call hMenuSelectNr(4)
    '/// Select 'Commands -> Printer Settings ///

    Kontext "DruckerEinrichten"
    if DruckerEinrichten.Exists then
        DruckerEinrichten.Cancel
    else
        Warnlog "Printersettings dialog is not up!"
    endif
    '/// Cancel 'Printer-Setup' dialog ///

    Kontext "DVVerwalten"
    ListeRechts.Select 1
    '/// Select first entry in right list ///

    '/// Select pushbutton 'File..' ///
    if WelcheDatei.IsEnabled then
        WelcheDatei.Click
        if gUseSysDlg = False then
            Kontext "OeffnenDlg"
            OeffnenDlg.Cancel
            '/// Cancel Filedialog ///
        endif
    endif

    Kontext "DVVerwalten"
    AddressBook.Click
    Kontext "AddressbookSource"
    '/// Select pushbutton 'Address Book' ///
    if AddressbookSource.Exists then
        AddressbookSource.Cancel
        '/// Cancel Dialog 'Address Book-Assignment' ///
    else
        Warnlog "Dialog ' Address Book Source' not up!"
    endif

    Kontext "DVVerwalten"
    DVVerwalten.Close
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileTemplatesAddressbookSource
    printlog "- File / Templates / Address Book Source"
    Call hNewDocument
    '/// Open new document ///

    UseBindings
    '/// File / Templates /Address Book Source... ///
    FileTemplatesAddressbookSource

    Sleep 2
    Kontext "AddressbookSource"
    if AddressbookSource.Exists then
        Call DialogTest (AddressbookSource)
        '/// In 'Address Book Assignement' dialog click pushbutton 'Administrate' ///
        if gPlatform <> "x86" then 
            Administrate.Click
            Sleep 2
            '/// Close 'Data Source Administration' with 'Cancel' ///
            Kontext "DatabaseProperties"
            if Not DatabaseProperties.Exists then
                Kontext "AddressSourceAutopilot"
                if AddressSourceAutopilot.Exists then
                    AddressSourceAutopilot.Cancel
                endif
                Kontext "AddressbookSource"
                AddressbookSource.Cancel
            else
                'DatabaseProperties.SetPage TabConnection
                Kontext "TabConnection"        
                Call DialogTest ( TabConnection )
                Kontext "DatabaseProperties"
                DatabaseProperties.Close
                Kontext "AddressbookSource"
                AddressbookSource.Cancel
            endif
        else
            QAErrorlog "#i62423#Adress Source Autopilot crashes"
            Kontext "AddressbookSource"
            AddressbookSource.Cancel
        endif
        '/// Close dialog ///
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFileTemplatesSave
    printlog "- File / Templates / Save"
    Call hNewDocument
    '/// Open new document ///
    FileTemplatesSave
    '/// File / Templates / Save ///

    Kontext "DokumentVorlagen"
    Call DialogTest ( DokumentVorlagen )
    '/// On 'Templates' dialog click 'Organizer' ///

    Verwalten.Click
    Kontext "DVVerwalten"
    DVVerwalten.Close
    '/// Close dialog 'Template Management' ///

    Kontext "DokumentVorlagen"
    DokumentVorlagen.Cancel
    '/// Close 'Templates' dialog ///

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFileTemplatesEdit
    printlog "- File / Templates / Edit"

    Call hNewDocument
    '/// Open new document ///
    FileTemplatesEdit
    '/// File / Templates / Edit ///

    if gUseSysDlg = False then
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
    endif
    '/// Cancel Filedialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFilePagePreview
    PrintLog "- File / Page Preview"
    Dim gehtnicht as boolean
    gehtnicht = FALSE
    Select Case gApplication
        Case "WRITER"
            Call hNewDocument
            '/// Open new document ///

        Case "MASTERDOC"
            Call hNewDocument

        Case "HTMLDOKUMENT"
            printlog "Not in Writer/Web!"
            goto endsub
    end select

    Call wDokSchreiben("Just a small change!")
    '/// Enter some text in document ///
    FilePageView
    '/// File / Page Preview ///
    Sleep 1
    Kontext "DocPageViewWriter"
    if DocPageViewWriter.NotExists then
        Warnlog "Page Preview is not coming up!"
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                Active.No
            endif
        endif
    else
        if gehtnicht=FALSE then
            Kontext "PreviewObjectbar"
            if PreviewObjectbar.Exists = False then Call hToolbarSelect("PagePreview", true)
            '/// Select 'Zoom 100%' in toolbar ///
            try
                Massstab.Select 4
            catch
                Warnlog "Unable to change Zoom factor in toolbar! (Bug#110498)"
            endcatch
            
            Sleep 2
            
            Kontext "PreviewObjectbar"
            DruckenSeitenansicht.Click
            '/// Click 'Print Page Preview' in toolbar ///
            Kontext "Active"
            if Active.Exists then
                QAErrorlog "No default printer!"
                Active.ok
                Sleep 2
                Kontext "DruckenDlg"
                if DruckenDlg.Exists then DruckenDlg.Cancel
            else
                Kontext "DruckenDlg"
                '/// Close 'Print' dialog with cancel ///
                DruckenDlg.Cancel
            endif

            Kontext "PreviewObjectbar"
            '/// Click 'Print options page preview' in toolbar ///
            Skalierung.Click
            Kontext "DruckOptionen"
            Call DialogTest ( DruckOptionen )
            '/// Close 'Print Options' dialog with cancel ///
            DruckOptionen.Cancel

            Kontext "PreviewObjectbar"
            '/// Close Page Preview with button 'Close Preview' in toolbar ///
            SeitenansichtSchliessen.Click
        else
            Warnlog "Objectbar not addressable!"
        endif
    end if
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFilePrint
    PrintLog "- File / Print"

    Call hNewDocument
    '/// Open new document ///

    sleep 1
    '/// File / Print ///
    FilePrint

    Kontext "Active"
    Sleep 1
    if Active.Exists then
        if Active.GetRT = 304 then  
            QAErrorlog "No Default Printer!"
			Active.Ok
			Kontext "DruckenDlg"
			if DruckenDlg.Exists then DruckenDlg.Cancel
			Call hCloseDocument
			goto endsub
		endif
    endif
	Kontext "DruckenDlg"
	if DruckenDlg.Exists then
        '/// In printer dialog click 'Options' ///
        Zusaetze.Click
        Sleep 1

        Kontext "DruckerZusaetzeWriter"
        Call DialogTest (DruckerZusaetzeWriter)
        DruckerZusaetzeWriter.Cancel
        '/// Close 'Print options' with 'Cancel' ///
		Kontext "DruckenDlg"
        
		if gPlatGroup = "unx" then
            Eigenschaften.Click
            '/// On Unix-Platforms select 'Properties ///
            Wait 500
            Kontext
            Active.Setpage TabSPAPaper
            Kontext "TabSPAPaper"
            Call DialogTest ( TabSPAPaper )

            printlog( "ALLES WIRD GUT!" )
            Kontext
            Active.Setpage TabSPADevice
            Kontext "TabSPADevice"
            Call DialogTest ( TabSPADevice )

            TabSPADevice.Cancel
            '/// Cancel Printer Properties' (only unix) ///

		endif
		Kontext "DruckenDlg"
		Call DialogTest ( DruckenDlg )
		DruckenDlg.Cancel
		'/// Close 'Print' dialog ///
	else
		Warnlog "Print dialog is not up !"
	endif

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFilePrinterSetup
    PrintLog "- File / Printer Setup"

    Call hNewDocument
    '/// Open new document ///

    Sleep 1
    '/// File / Printer Settings ///
    FilePrintersettings
    Kontext "Active"
    Sleep 1
    if Active.Exists then
        if Active.GetRT = 304 then        
            QAErrorLog "No Default Printer!"
			Active.Ok
			Sleep 2
			Kontext "DruckerEinrichten"
			if DruckerEinrichten.Exists then
				Call DialogTest ( DruckerEinrichten )
				DruckerEinrichten.Cancel
			endif			
		endif
    else
        Kontext "DruckerEinrichten"
        Call DialogTest ( DruckerEinrichten )
        DruckerEinrichten.Cancel
        '/// Cancel 'Printer Setup' dialog ///
    endif
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFileExit
    PrintLog "- File / Exit"
    Call wDokSchreiben("Hallo ich schlieȖe mich gleich von ganz alleine")
    FileExit "SynchronMode", TRUE

    try
        Kontext "Active"
        if Active.Exists(1) then
            Active.No
        else
            Warnlog "Though a changed document is open, the office could be closed without a message!"
        end if
    catch
        Warnlog "Error on querying messagebox"
    endcatch

    Sleep 5
    Call hOfficeStarten

endcase
