'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_002_.inc,v $
'*
'*  $Revision: 1.44 $
'*
'*  last change: $Author: hde $ $Date: 2006/08/03 12:12:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*                                                                **
'* owner : helge.delfs@sun.com                                    **
'*                                                                **
'* short description :                                            **
'*                                                                **
'\******************************************************************

sub w_002_
    printLog Chr(13) + "--------- Edit Menu ( w_002_.inc ) ----------"

    Call tEditUndoRedo
    Call tEditRepeat

    Call tEditPaste
    Call tEditPasteSpecial

    Call tEditChanges
    Call tEditCompareDocument
    Call tEditFindAndReplace
    Call tEditNavigator     'wrn:0
    Call tEditAutoText
'   Call tEditAdressbook
'   Call tEditAdressbookInsertIntoText

'   Call tEditExchangeDatabase
    Call tEditHyperlink

    Call tEditFields
    Call tEditFieldsInputList
    Call tEditFootnote
    Call tEditIndexEntry

    Call tEditLinks
'   Call tEditFloatingFrame
    Call tEditPlugIn
    Call tEditImageMap
'   Call tEditObjectEdit
'   Call tEditObjectEdit2
'   Call tEditObjectOpen

end sub

'-----------------------------------------------------------

testcase tEditUndoRedo
    PrintLog "- Edit/Undo - Redo"

    Call hNewDocument (True)
    '/// Open new document ///

    Call hTabelleEinfuegen
    '/// Insert table ///
    EditUndo
    '/// Edit / Undo ///
    Sleep 1
    EditRedo
    '/// Undo / Redo ///
    Sleep 1
    EditUndo
    '/// Edit / Undo ///
    Sleep 1
    FileClose
    '/// File / Close ///
    Kontext
    if ( Active.Exists ) then
        if Active.GetRT = 304 then
            WarnLog ( "Messagebox: '" & Active.Gettext & "' should not appear" )
            Active.No
        endif
    endif

endcase

'----------------------------------------------------

testcase tEditRepeat
    PrintLog "- Edit/Repeat"

    Call hNewDocument
    '/// Open new document ///

    Call hTabelleEinfuegen
    '/// Insert table ///

    Call wDokSchreiben("<Down><Down>")
    '/// Move cursor out of table ///

    EditRepeat
    '/// Edit / Repeat ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'----------------------------------------------------

testcase tEditPaste
    PrintLog "- Edit/Paste"

    Call hNewDocument
    '/// Open new document ///

    Call wDokSchreiben("What a beatiful day !")
    '/// Insert some text in document ///

    EditSelectAll
    '/// Edit / Select All ///
    EditCut
    '/// Edit / Cut ///
    EditPaste
    '/// Edit / Paste ///
    Call wDokSchreiben("<Shift Home>")
    '/// Type <Shift Home > ///
    EditCopy
    '/// Edit / Copy ///
    Call wDokSchreiben("<Return>", 2)
    '/// Enter 2 Line breaks ///
    EditPaste
    '/// Edit / Paste ///
    EditSelectAll
    '/// Edit / Select All ///
    EditCut
    '/// Edit / Cut ///
    Call hCloseDocument
    '/// Close active document ///

endcase

'----------------------------------------------------

testcase tEditPasteSpecial
    PrintLog "- Edit/Paste Special"

    Call hNewDocument
    '/// Open new document ///

    if gSamePC = TRUE then
        PrintLog "  - External Clipboard"
        '/// Enter some text in external clipboard ///

        SetClipboard "Text from external clipboard!"
        sleep 1
        EditPaste
        '/// Paste from external clipboard with Edit / Paste in Office ///
        Call wDokSchreiben("<Mod1 A>")
        Sleep 1
        EditCopy
        Sleep 2
        if GetClipboardText <> "Text from external clipboard!" then
            Warnlog "External Clipboard not available!"
            Warnlog "Is: " & GetClipboardText
        endif
        Call wDokSchreiben("<End><Return>")
        SetClipboard ""
        SetClipboard "2nd Text from external clipboard!"
        try
            '/// Edit / Paste / Special ///
            EditPasteSpecialWriter
            Kontext "InhaltEinfuegen"
            if InhaltEinfuegen.Exists then
                try
                    Auswahl.Select 1
                catch
                    Warnlog "Unable to select entry in format list !"
                    InhaltEinfuegen.Close
                    Call hCloseDocument
                    goto endsub
                endcatch
                    InhaltEinfuegen.OK
                    wait 500
                    Kontext "Active"
                    if Active.Exists then
                        if Active.GetRT = 304 then
                            Warnlog "Maybe Bug#109331"
                            Warnlog Active.Gettext
                            try
                                Active.Ok
                            catch
                                Active.No
                            endcatch
                        endif
                    else
                        Call wDokSchreiben("<Home><Shift End>")
                        EditCopy
                        if GetClipboardText <> "2nd Text from external clipboard!" then Warnlog "Wrong Text inserted! Is: " & GetClipboardText
                    endif
            else
                Warnlog "Dialog 'Paste Special' is not up!"
            endif
        catch
            Exceptlog
        endcatch
    end if

    PrintLog "  - Internal Clipboard with StarOffice Writer-Text"
    '/// Enter some text in writer and copy it ///
    Call wDokSchreiben("<Return>Text from internal clipboard<Shift Home>")
    EditCopy
    Call wDokSchreiben("<End><Return>")
    EditPasteSpecialWriter
    '/// Edit / Paste / Special ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
        DialogTest ( InhaltEinfuegen )
        Auswahl.Select 1
        InhaltEinfuegen.OK
        Call wDokSchreiben "<Home><Shift End>"
        EditCopy
        if GetClipboardText <> "Text from internal clipboard" then Warnlog "Wrong Text inserted! Is: " & GetClipboardText
    else
        Warnlog "Dialog 'Paste Special' is not up!"
    endif
    Call hCloseDocument
    '/// Close active document ///
endcase

'----------------------------------------------------

testcase tEditChanges
    PrintLog "- Edit/Changes"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///

    Call wDokSchreiben("Hallo<Return><Return>")
    '/// Enter some text in document ///
    Sleep 1
    UseBindings
    '/// Select Edit / Changes / Record ///
    EditChangesRecord
    Sleep 1
    '/// Enter some more text in document ///
    Call wDokSchreiben("Aenderung 1<Return><Up><Up><End>")
    Call wDokSchreiben("<Backspace>", 4)
    Sleep 1
    UseBindings
    '/// Select Edit / Changes / Record ///
    EditChangesRecord
    Sleep 1
    UseBindings
    EditChangesShow
    '/// Select Edit / Changes / Show ///
    Sleep 1
    UseBindings
    '/// Select Edit / Changes / Show ///
    EditChangesShow
    Sleep 1
    UseBindings
    '/// Select Edit / Changes / Protect Trace ///
    EditChangesProtectTrace
    Sleep 1
    '/// Passwort-dialog has to come up, cancel it ///
    Kontext "Passwort"
    if Passwort.Exists then
        Passwort.Close
    else
        Warnlog "Password-dialog is not up!"
    endif

    UseBindings
    '/// Edit / Changes / Accept or Reject ///
    EditChangesAcceptOrReject
    '/// Dialog 'Accept or reject changes' has to come up ///
    Kontext "Redlining"
    if Redlining.Exists then
        '/// Step through all Tabpages ///
        TabControl.SetPage TabListe
        Call DialogTest ( Redlining )
        TabControl.SetPage TabFilter
        Call DialogTest ( Redlining )
        Redlining.Close
        '/// Close dialog ///
    else
        Warnlog "Dialog 'Redlining' not opened!"
    endif

    Call wDokSchreiben("<Down><Right>")
    UseBindings
    try
        '/// Point cursor into a changed text in document ///
        EditChangesComment
        '/// Edit / Changes / Comment ///
    catch
        Call wDokSchreiben("<Up>")
        try
            EditChangesComment
        catch
            Warnlog "Unable to execute 'Edit / Changes / Comment!"
        endcatch
    endcatch
    wait 500
    Kontext "Kommentar"
    Sleep 5
    '/// Dialog to comment a change has to come up ///
    if Kommentar.Exists then
        Call DialogTest ( Kommentar )
        Kommentar.Cancel
    else
        Warnlog "Dialog 'Comment' not opened!"
        '/// Close dialog 'Comment' ///
    endif
    Call hCloseDocument
    '/// Close active document ///
endcase

'----------------------------------------------------

testcase tEditCompareDocument
    PrintLog "- Edit/Compare Document"
    Select Case gApplication
        Case "WRITER"
            Call hNewDocument
            '/// Open new document ///
            EditCompareDocumentCalc
            '/// Edit / Compare document ///
        Case "MASTERDOC"
            printlog "Comparing documents not in Masterdocument!"
            goto endsub
        Case "HTMLDOKUMENT"
            printlog "Comparing documents not in WriterWeb!"
            goto endsub
    end select

    if gUseSysDlg = False then
        Kontext "OeffnenDlg"
        Dateiname.SetText ConvertPath ( gTesttoolPath & "writer\input\bt.sxw" )
        '/// in File-Open-dialog load "..\writer\input\bt.sxw" ///
        Oeffnen.Click
    endif
    Kontext "FilterAuswahl"
    if Filterauswahl.Exists then Filterauswahl.OK
    Sleep 2
    Kontext "Active"
    if Active.Exists then
        Warnlog Active.Gettext
        Active.Ok
    endif

    Kontext "Redlining"
    '/// Dialog 'Accept and Reject changes' has to come up ///
    if Redlining.Exists then
        TabControl.SetPage TabListe
        wait 500
        Kontext "Redlining"
        TabControl.SetPage TabFilter
        Kontext "Redlining"
        Redlining.Close
    '/// Close dialog///
    else
        Warnlog "- Dialog 'Redlining' does not exist!"
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'----------------------------------------------------

testcase tEditFindAndReplace
    PrintLog "- Edit/Find & Replace"
   
    '/// Open new document ///
    Call  hNewDocument
    EditSearchAndReplace
    '/// Edit / Find and Replace ///
    Kontext "FindAndReplace"
    if Attributes.IsVisible = False then
        More.Click
    endif
    
    Attributes.Click
    '/// in 'Find&Replace' dialog click 'Attributess' ///
    Kontext "Attribute"
    Call DialogTest ( Attribute )
    '/// Cancel dialog 'Attributess' ///
    Attribute.Cancel

    Kontext "FindAndReplace"
    Call DialogTest ( FindAndReplace )
    '/// In Find&Replace dialog uncheck 'Match case' ///
    SimilaritySearch.UnCheck
    '/// Click 'Format' ///
    Formats.Click
    '/// In dialog 'Text format' step throug all tabpages ///

    Kontext
    active.SetPage TabFont
    kontext "TabFont"
    Call DialogTest ( TabFont )
    Kontext
    active.SetPage TabFontEffects
    kontext "TabFontEffects"
    Call DialogTest ( TabFontEffects )

    Kontext
    active.SetPage TabEinzuegeUndAbstaende
    kontext "TabEinzuegeUndAbstaende"
    Call DialogTest ( TabEinzuegeUndAbstaende )

    Kontext
    Active.SetPage TabAusrichtungAbsatz
    Kontext "TabAusrichtungAbsatz"
    Call DialogTest ( TabAusrichtungAbsatz )

    Kontext
    active.SetPage TabTextfluss
    kontext "TabTextfluss"
    Call DialogTest ( TabTextfluss )

    Kontext
    active.SetPage TabHintergrund
    kontext "TabHintergrund"
    Call DialogTest ( TabHintergrund )
    TabHintergrund.Cancel
    '/// Close 'Text Format' dialog with cancel ///
    Wait 500

    Kontext "FindAndReplace"
    '/// In Find&Replace' select 'Similarity Search' ///
    SimilaritySearch.Check
    '/// The Searchbutton should be enabled, click it ///
    SimilaritySearchFor.Click
    wait 500

    Kontext "Aehnlichkeitssuche"
    DialogTest ( Aehnlichkeitssuche )
    Aehnlichkeitssuche.Cancel

    wait 500
    '/// Close 'Similarity Search' button with cancel ///
    Kontext "FindAndReplace"
    SimilaritySearch.Uncheck
    More.Click
    FindAndReplace.Close

    Call hCloseDocument
    '/// Close active document ///
endcase

'----------------------------------------------------

testcase tEditNavigator
    printlog "- Edit/Navigator"
    Dim ToolboxOk as boolean

    Call hNewDocument
    '/// Open new document ///

    if gApplication = "MASTERDOC" then
        Kontext "NavigatorGlobalDoc"
        if Not NavigatorGlobalDoc.Exists then EditNavigator
        Kontext "NavigatorGlobalDoc"
        Call DialogTest ( NavigatorGlobalDoc )

        printlog " - Umschalten"
        GlobaldokumentToolbox.Click Umschalten
        Sleep 5
        kontext "NavigatorWriter"

        try
            Toolbox.TearOff Navigation
            Kontext "NavigationsFenster"
            NavigationsFenster.Close
        catch
            Warnlog "Unable to Tear off Navigation Toolbox!"
        endcatch

        Kontext "NavigatorWriter"
        Umschalten.Click
        Kontext "NavigatorGlobalDoc"
        Sleep 5

        printlog "  - Bearbeiten"
        Bearbeiten.Click
        wait 500
        Kontext "Navigator"
        Navigator.Close
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endif

    Kontext "NavigatorWriter"
    if Not NavigatorWriter.Exists then EditNavigator
    Kontext "NavigatorWriter"
    '/// Open Navigator ///
    Call DialogTest ( NavigatorWriter )

    printlog "  - Navigation"
    ToolboxOK = True
    try
        '/// Tear Off Toolbox from Navigator ///
        Toolbox.TearOff Navigation
    catch
        Warnlog "Unable to tear off Toolbox (#i32092)"
        ToolboxOk = False
    endcatch

    if ToolboxOK = True then
        wait 500
        Kontext "NavigationsFenster"
        wait 500
        try
            '/// Close Navigator Toolbox ///
            NavigationsFenster.Close
        catch
        endcatch
    endif

    printlog "  - previous page"
    Kontext "NavigatorWriter"
    wait 500
    '/// In Navigator window click 'Previous page' ///
    VorherigeSeite.Click
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.No
            catch
                Active.Ok
            endcatch
        endif
    endif
    wait 500

    printlog "  - next page"
    Kontext "NavigatorWriter"
    '/// In Navigator window click 'Next page' ///
    NaechsteSeite.Click
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.No
            catch
                Active.Ok
            endcatch
        endif
    endif
    wait 500

    printlog "  - switch Selection box off and on"
    Kontext "NavigatorWriter"
    '/// Switch 'Listbox' On / Off ///
    if Auswahlliste.Exists then Auswahlbox.Click
    wait 500
    Auswahlbox.Click
    wait 500
    if Auswahlliste.NotExists then
        Warnlog "Navigator not maximized"
        Auswahlbox.Click
    end if

    printlog "  - Switch Content View on and off"
    '/// Switch Content View on and off ///
    Inhaltsansicht.Click
    wait 500
    Inhaltsansicht.Click
    wait 500

    printlog "  - Set Note"
    '/// Set Note ///
    Merker.Click
    wait 500

    printlog "  - jump to header"
    '/// jump to header ///
    Kopfzeile.Click
    wait 500

    printlog "  - jump to footer"
    '/// jump to footer ///
    Fusszeile.Click
    wait 500

    printlog "  - to Anchor <-> Text"
    '/// Anchor <-> Text ///
    AnkerText.Click
    wait 500

    Kontext "Navigator"
    try
        '/// Close Navigator ///
        Navigator.Close
    catch
        Errorlog
        EditNavigator
    endcatch

    Call hCloseDocument
    '/// Close active document ///
endcase

'---------------------------------------------------

testcase tEditAutotext
    PrintLog "- Edit/Autotext"
    Dim derBaustein as integer, derAutotext as integer, j as integer, k as integer
    Dim i as integer, CurrentEntryNr as integer, unxAutotextCategorie as integer

    Call hNewDocument
    '/// Open new document ///
    EditAutotext
    '/// Edit / Autotext ///
    Kontext "Active"
    for i = 1 to 10
        if Active.Exists then
            Warnlog Active.Gettext
            Active.Ok
        else
            i=11
        endif
    next i

    Kontext "AutoText"
    DialogTest ( AutoText )

    Kontext "AutoText"
    '/// Click Categories ///
    Bereiche.Click
    Sleep 5
    Kontext "Active"
    if Active.Exists then
        Warnlog Active.Gettext
        try
            Active.Yes
        catch
            Active.Ok
        endcatch
    endif
    try
        Active.No
        Kontext "AutoText"
        Bereiche.Click
    catch
    endcatch

    Kontext "BereicheBearbeitenAutoText"
    if BereicheBearbeitenAutoText.Exists then
        DialogTest ( BereicheBearbeitenAutoText )
        '/// Create a new categorie ///
        Bereich.SetText "Hallo"
        if Not Umbenennen.IsEnabled then
            if gNetzInst = False then
                Warnlog "- Not able to rename Categories, Button 'Rename' disabled!"
            endif
        endif

        if Neu.IsEnabled then
            Neu.Click
            Sleep 1
            if Loeschen.IsEnabled then
                '/// Delete created categorie ///
                Loeschen.Click
            else
                Warnlog "- Not able to delete new category. Button disabled!"
            endif
        else
            if gNetzInst = False then
                Warnlog "- Category cannot be created!"
            endif
        endif
        BereicheBearbeitenAutoText.Cancel
    else
        Warnlog "- Dialog to edit Categories not up!"
    endif
    '/// Close 'Edit Categories with 'Cancel' ///

    Kontext "AutoText"
    '/// In Autotext dialog click 'Path..' ///
    Pfade.Click
    Kontext "PfadeAuswaehlen"
    DialogTest ( PfadeAuswaehlen )
    Kontext "PfadeAuswaehlen"
    if Val(mid$(gMinor, 2, Len(gMinor))) >= 177 then
        '/// On 'Select Paths' dialog click 'add' ///
        Hinzufuegen.Click
        wait 500
        Kontext "OeffnenDlg"
        if OeffnenDlg.Exists then
            '/// Cancel File-Open dialog ///
            OeffnenDlg.Cancel
        else
            Warnlog "Dialog ' Select Paths' not up!"
        endif
        wait 500
        Kontext "PfadeAuswaehlen"
        '/// Cancel dialog 'Select Paths' ///
    else
        QAErrorlog "Dev-Note:Due to changes in hid.lst 'Add paths' is disabled in test minor prior m177"
    endif
    PfadeAuswaehlen.Cancel

    Sleep 2
    Kontext "AutoText"
    '/// In Autotext dialog select an autotext in list ///
    if gPlatgroup = "w95" then
        CurrentEntryNr = Liste.GetItemCount
        Liste.Select 1
        Liste.TypeKeys "-"
        Liste.TypeKeys "+"
        if CurrentEntryNr = Liste.GetItemCount then
            Liste.Select 2
            Liste.TypeKeys "+"
            Liste.Select 3
        else
            Liste.Select 2
        endif
    else
        '/// on Unix-Platforms you have to create an autotext first
        '/// to get the 'Autotext'-Button enabled
        unxAutotextCategorie = 1
        ' choose category and remember entry number
        Liste.TypeKeys "<Home>"
        for i = 1 to Liste.GetItemCount
            if Not Menue.IsEnabled then            
                Liste.TypeKeys "<Down>"
                unxAutotextCategorie = unxAutotextCategorie + 1
            endif
        next i
        Autotext.Close
        Call wDokSchreiben ( "Create a dummy autotext" )
        Call wDokSchreiben ( "<Shift Home>" )
        EditAutotext
        Kontext "AutoText"
        Liste.Select unxAutotextCategorie
        NameText.Settext "DummyAutotext"
        Kuerzel.Settext "dAt"        
        if Menue.IsEnabled then
            Menue.Click
            wait 500
            try
                Call hMenuSelectNr ( 1 )  'New
            catch
                ' This is a workaround as sometimes menu isn't opened for some reason
                Menue.Click
                wait 500
                try
                    Call hMenuSelectNr ( 1 )
                catch
                    Warnlog "Unable to create autotext"
                    Autotext.Close
                    Call hCloseDocument
                    goto endsub
                endcatch
            endcatch
            Autotext.Close
            Call wDokSchreiben "<Home>"
        else
            Warnlog "Unable to create autotext"
            Autotext.Close
            Call hCloseDocument
            goto endsub
        endif
        ' Select created autotext
        EditAutotext
        Kontext "Autotext"
        Liste.Select unxAutotextCategorie
        Liste.TypeKeys "+"
        Liste.TypeKeys "<Down>"        
    endif
    if Menue.IsEnabled then
        Menue.Click
        wait 500
        try
            '/// Select Autotext / Rename ///
            Call hMenuSelectNr ( 2 )  'Rename
            Kontext "TextbausteineUmbenennen"
            if TextbausteineUmbenennen.Exists then
                Call DialogTest ( TextbausteineUmbenennen )
                '/// Cancel 'Rename Autotext' ///
                TextbausteineUmbenennen.Cancel            
                sleep 1
            else
                Warnlog "Dialog 'Rename Autotext' not up!"
            endif
        catch
            Warnlog "Menu Autotext->'Rename' disabled !"
        endcatch

        Kontext "AutoText"
        Menue.Click
        wait 500
        try
            '/// Select Autotext / Macro ///
            Call hMenuSelectNr ( 5 )
            ' if no JRE is installed a messagebox appears
            Do
                j = j + 1
                Kontext "Active"
                if Active.Exists then
                    if Active.GetRT = 304 then
                        if j = 1 then Warnlog Active.Gettext    
                        Active.Ok
                    else
                        exit do
                    endif                    
                else
                    exit do
                endif
            Loop
            ' Dialog needs some time to be opened
            for k = 1 to 15                
                Kontext "MakroZuweisen"
                if MakroZuweisen.IsVisible then
                    '/// Cancel 'Macro' dialog///
                    MakroZuweisen.Cancel
                    exit for
                else
                    Sleep 1
                endif
            next k
            sleep 1
        catch
            Warnlog "Menu Autotext->'Macro' disabled !"
            Call hMenuClose
        endcatch

        Kontext "AutoText"
        Menue.Click
        wait 500
        try
            '/// Select Autotext / Edit ///
            Call hMenuSelectNr ( 4 )
            Sleep 5
            '/// Enter some text in document and close it ///
            Call wDokSchreiben("Hallo")
            if GetDocumentCount = 2 then
				QAErrorlog "#116138#The autotext has been edited in current document!"
			else
				FileClose						
				wait 500
				Kontext "Active"
				wait 500
				'/// A message that module has been changed should come up ///
				if Active.Exists then
                	Active.No
				else
					Warnlog "Though changing the text module the document could be closed without a query!"
				end if
			endif
            if gPlatgroup <> "w95" then
                if wDeleteAutotext("DummyAutotext") = false then
                    Warnlog "Unable to delete created autotext"
                endif
            endif
            Kontext "Autotext"
            if Autotext.Exists then Autotext.Close
            Call hCloseDocument
        catch
            Warnlog "Menu Autotext->'Edit' disabled !"
            Kontext "Active"
            if Active.Exists then
                if Active.GetRT = 304 then
                    Warnlog Active.Gettext
                    try
                        Active.No
                    catch
                        Active.Ok
                    endcatch
                endif
            endif
            Kontext "Autotext"
            '/// Close 'Autotext' dialog ///
            Autotext.Close
            if gPlatgroup <> "w95" then
                if wDeleteAutotext("DummyAutotext") = false then
                    Warnlog "Unable to delete created autotext"
                endif
            endif
            Kontext "Autotext"
            if Autotext.Exists then Autotext.Close            
            Call hCloseDocument
        endcatch
    else
        Warnlog "Button 'Autotext' disabled !"
        Autotext.Close
        Sleep 3
        Call hCloseDocument
    endif
endcase

'----------------------------------------------------------------

testcase tEditAdressbook
    PrintLog "- Edit/Adress Book"

    Call hNewDocument
    '/// Open new document ///

    EditAddressbook
    '/// Edit / Address book ///
    Kontext "FehlermeldungDatenbank"
    if FehlermeldungDatenbank.Exists then
        Warnlog " Databaseconnection not ok"
        FehlermeldungDatenbank.Cancel
    endif
    Sleep 2

    Kontext "Adressbuch"
    if Adressbuch.Exists then
        DialogTest ( Adressbuch )
        '/// Close 'Addess book' ///
        Adressbuch.Close
    else
        Warnlog "Address Book isn't up"
    endif
    Call hCloseDocument
    '/// Close active document ///

endcase

'----------------------------------------------------------------

testcase tEditExchangeDatabase
    PrintLog "- Edit/Exchange Database"

    Call hNewDocument
    '/// Open new document ///

    EditExchangeDatabase
    '/// Edit / Exchange Database ///
    Sleep 1
    Kontext "DatenbankAustauschen"
    Call DialogTest (DatenbankAustauschen)
    '/// Close dialog 'Exchange databases' ///
    DatenbankAustauschen.Cancel
    Call hCloseDocument
    '/// Close active document ///

endcase

'----------------------------------------------------------------

testcase tEditHyperlink
    Printlog "- Edit / Hyperlink"
    Call hNewDocument
    '/// Open new document ///
    InsertHyperlink
    '/// Insert / Hyperlink ///
    Sleep 5
    Kontext "Hyperlink"

    Call wEinfuegenHyperlink(1)
    Kontext "TabHyperlinkInternet"
    Internet.Check
    ZielUrl.Settext "http://www.sonor.de"
    '/// Enter URL  ///
    Kontext "Hyperlink"
    '/// Click 'Apply' ///
    Uebernehmen.Click
    '/// Close Hyperlink dialog ///
    Hyperlink.Close

    Call wDocSetContext
    try
        '/// Check if correct URL has been set to document ///
        EditCopy
        if GetClipBoardtext = "" then
            Warnlog "No Hyperlink or wrong hyperlink in document!" & GetClipBoardtext
        endif
    catch
        Warnlog "No Hyperlink in document!"
        goto endsub
    endcatch
    '/// Set cursor into link ///

    Call wDokSchreiben("<Left>")
    try
        '/// Edit / Hyperlink has to be enabled ///
        EditHyperlink
        Kontext "Hyperlink"
        if Hyperlink.Exists then
            Hyperlink.Close
        else
            Warnlog "- Hyperlinkdialog not up"
        endif
    catch
        Warnlog "- Not able to edit Hyperlink!"
    endcatch

    Call hCloseDocument
    '/// Close active document ///
endcase

'----------------------------------------------------------------

testcase tEditAdressbookInsertIntoText
    Printlog "- Edit/Adressbook/Insert Into Text"
    Dim Anzahl, TabAnzahl, i
    Call hNewDocument
    '/// Open new document ///

    EditAddressbook
    '/// Edit / Address Book ///

    Kontext "FehlermeldungDatenbank"
    if FehlermeldungDatenbank.Exists then
        Warnlog "Databaseconnection isn't ok"
        FehlermeldungDatenbank.Cancel
    endif
    Sleep 2

    Kontext "Adressbuch"
    if Adressbuch.Exists then
        Mischen.Click
        Kontext "DatenbankspaltenEinfuegen"
        if NOT EinfuegenAlsTabelle.IsChecked then EinfuegenAlsTabelle.Check
        if AuswahlDatenbankspaltenAlsTabelle.GetItemCount >0 then AlleUebernehmen.Click
        Eigenschaften.Click
        Kontext
        TabAnzahl = Active.GetPageCount
        if TabAnzahl <> 5  then warnlog "Number of tabpages not 5, but " & TabAnzahl & "!!!"
        Active.SetPage TabellenFormat
        Kontext "TabellenFormat"
        Call Dialogtest ( TabellenFormat )
        Kontext
        Active.SetPage TabTextflussTabelle
        Kontext "TabTextflussTabelle"
        Call Dialogtest ( TabTextflussTabelle )
        Kontext
        Active.SetPage TabSpaltenTabelle
        Kontext "TabSpaltenTabelle"
        Call Dialogtest ( TabSpaltenTabelle )
        Kontext
        Active.SetPage TabUmrandung
        Kontext "TabUmrandung"
        Call Dialogtest ( TabUmrandung )
        Kontext
        Active.SetPage TabHintergrund
        Kontext "TabHintergrund"
        Call Dialogtest ( TabHintergrund )
        TabHintergrund.Cancel
        Kontext "DatenbankspaltenEinfuegen"
        Autoformat.Click
        Kontext "AutoFormatTabelle"

        if Formatbox.GetItemCount > 2 then
            Formatbox.Select(3)
            More.Open
            Umbenennen.Click
            Kontext "AutoformatHinzufuegenWriter"
            AutoformatHinzufuegenWriter.Cancel
            Kontext "AutoFormatTabelle"
            More.Close
        else
            Warnlog "Only " & Formatbox.GetItemCount & " Table formats to query ?"
        endif

        AutoFormatTabelle.Cancel
        Kontext "DatenbankspaltenEinfuegen"
        EinfuegenAlsFelder.Check
        Anzahl = AuswahlDatenbankspalten.GetItemCount
        For i = 1 to CInt(Anzahl)-1
            AuswahlDatenbankspalten.Select(i)
            sleep(1)
            if FormatAusDatenbank.IsEnabled then Exit For
        next i
        FormatAnders.Check
        Anzahl = FormatAuswahl.GetItemCount
        FormatAuswahl.Select(Anzahl)
        Kontext "Zahlenformat"
        Zahlenformat.Cancel
        Kontext "DatenbankspaltenEinfuegen"
        FormatAusDatenbank.Check
        EinfuegenAlsText.Check
        if NOT EinfuegenAlsTabelle.IsChecked then EinfuegenAlsTabelle.Check
        AlleZurueck.Click
        DatenbankspaltenEinfuegen.Cancel
        Kontext "Adressbuch"
        Adressbuch.Close
    else
        Warnlog "Address Book isn't up "
    endif

    Call hCloseDocument
endcase

'----------------------------------------------------------------

testcase tEditFields
    PrintLog "- Edit/Fields"

    Call hNewDocument
    '/// Open new document ///

    InsertFieldsOther
    '/// Select Insert / Fields Other ///
    Kontext
    Active.Setpage TabDokumentFeldbefehle
    Kontext "TabDokumentFeldbefehle"
    Sleep 2
    Select Case gApplication
        Case "HTMLDOKUMENT"
            Select case iSprache
                case 01 : Feldtyp.Select 5
                          Auswahl.Select 1
                case 03 : Feldtyp.Select 8
                          Auswahl.Select 1
                case 07 : Feldtyp.Select 5
                          Auswahl.Select 1
                case 31 : Feldtyp.Select 1
                          Auswahl.Select 1
                case 33 : Feldtyp.Select 2
                          Auswahl.Select 1
                case 34 : Feldtyp.Select 7
                          Auswahl.Select 1
                case 36 : Feldtyp.Select 3
                          Auswahl.Select 1                             
                case 39 : Feldtyp.Select 3
                          Auswahl.Select 1
                case 45 : Feldtyp.Select 1
                          Auswahl.Select 1
                case 46 : Feldtyp.Select 2
                          Auswahl.Select 1
                case 48 : Feldtyp.Select 3
                          Auswahl.Select 1
                case 49 : Feldtyp.Select 1     'Absender
                          Auswahl.Select 1     'Firma
				case 55 : Feldtyp.Select 7
                          Auswahl.Select 1                
				case 81 : Feldtyp.Select 4
                          Auswahl.Select 1
                case 82 : Feldtyp.Select 2
                          Auswahl.Select 1
                case 86 : Feldtyp.Select 1
                          Auswahl.Select 1
                case 88 : Feldtyp.Select 2
                          Auswahl.Select 1

                case else :  Warnlog "Missing language support!"
                             TabDokumentFeldbefehle.Cancel
                             Call hCloseDocument
                             '/// Close active document ///
                             goto endsub
            end select
        Case else
            Select case iSprache
                case 01 : Feldtyp.Select 6
                          Auswahl.Select 1
                case 03 : Feldtyp.Select 9
                          Auswahl.Select 1
                case 07 : Feldtyp.Select 5
                          Auswahl.Select 1
                case 31 : Feldtyp.Select 1
                          Auswahl.Select 1
                case 33 : Feldtyp.Select 3
                          Auswahl.Select 1
                case 34 : Feldtyp.Select 9
                          Auswahl.Select 1
                case 36 : Feldtyp.Select 4
                          Auswahl.Select 1
                case 39 : Feldtyp.Select 4
                          Auswahl.Select 1
                case 45 : Feldtyp.Select 1
                          Auswahl.Select 1
                case 46 : Feldtyp.Select 2
                          Auswahl.Select 1
                case 48 : Feldtyp.Select 3
                          Auswahl.Select 1
                case 49 : Feldtyp.Select 1     'Absender
                          Auswahl.Select 1     'Firma
				case 55 : Feldtyp.Select 9
                          Auswahl.Select 1
				case 81 : Feldtyp.Select 5
                          Auswahl.Select 1
                case 82 : Feldtyp.Select 2
                          Auswahl.Select 2
                case 86 : Feldtyp.Select 1
                          Auswahl.Select 1
                case 88 : Feldtyp.Select 2
                          Auswahl.Select 1

                case else : Warnlog "Missing language support!"
                            TabDokumentFeldbefehle.Cancel
                            Call hCloseDocument
                            '/// Close active document ///
                            goto endsub
            end select
        end select
        '/// Insert Field 'Sender -> Company' ///

        Einfuegen.Click
        Sleep 2
        Schliessen.Click
        '/// Close Fields dialog ///

        Call wDokSchreiben("<Home>")

        '/// Put cursor in front of field ///
        EditFields
        '/// Edit / Fields ///

        Kontext "FeldbefehlBearbeitenDokument"
        Call DialogTest ( FeldbefehlBearbeitenDokument )
        Sleep 2

        '/// In 'Edit Fields' dialog select 'Edit' ///
        if Bearbeiten.IsVisible and Bearbeiten.IsEnabled then
            Bearbeiten.Click
            Kontext "TabBenutzerdaten"
            TabBenutzerdaten.Cancel
            Kontext "FeldbefehlBearbeitenDokument"
        else
            Warnlog "Button 'Edit' in Dialog disabled!"
        endif

        '/// Close dialog ///
        FeldbefehlBearbeitenDokument.Cancel
        Call hCloseDocument
        '/// Close active document ///

endcase

'----------------------------------------------------------------

testcase tEditFieldsInputList
    PrintLog "- Edit / Fields / Functions"
    If gApplication = "HTMLDOKUMENT" then goto endsub

    Call hNewDocument
    '/// Open new document ///

    InsertFieldsOther
    '/// Select Insert / Fields Other ///
    Kontext
    Active.Setpage TabFunktionen
    Kontext "TabFunktionen"
    Sleep 2
    '/// Goto Tabpage Functions and select 2nd entry (Input list) ///
    Feldtyp.Select 2
    if NewListEntry.IsVisible and NewListEntry.IsEnabled then
        '/// Add 1 entry to list ///
        if NewListEntry.IsEnabled then
            NewListEntry.Settext "MyNewListEntry"
            wait 500
            if AddListEntry.IsEnabled= True then AddListEntry.Click
        endif
        '/// Close Fields dialog ///
        if EntrysList.GetItemCount <> 1 then
            Warnlog "Entry has not been added to list!"
            Schliessen.Click
        else
            Einfuegen.Click
            Sleep 2
            Schliessen.Click
            Call wDokSchreiben "<Home>"
            try
                Call wDokSchreiben "<Mod1 Shift F9>"
                wait 500
                Kontext "EditInputList"
                if EditInputList.Exists then
                    Call DialogTest ( EditInputList )
                    EditInputList.Cancel
                else
                    Warnlog "Dialog 'Edit Input list' is not up!"
                endif
                Sleep 2
            catch
                Warnlog "Unable to 'Edit / Fields'!"
            endcatch
        endif
    else
        Warnlog "'Input list' probably not found!"
    endif
    Call hCloseDocument

endcase

'----------------------------------------------------------------

testcase tEditFootnote
    PrintLog "- Edit/Footnote"

    Call hNewDocument
    '/// Open new document ///

    InsertFootnote
    '/// Insert / Footnote ///
    Kontext "FussnoteEinfuegen"
    FussnoteEinfuegen.OK

    Call wDokSchreiben("<PageUp><Left>")

    '/// Edit / Footnote ///
    EditFootnote

    Kontext "FussnoteBearbeiten"
    Call DialogTest ( FussnoteBearbeiten )
    '/// Close 'Footnote' dialog ///
    FussnoteBearbeiten.Cancel

    Call hCloseDocument
    '/// Close active document ///

endcase

'----------------------------------------------------------------

testcase tEditIndexEntry
    PrintLog "- Edit/Index Entry"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif

    Call hNewDocument
    '/// Open new document ///

    Call wDokSchreiben("Ich werde ein Verzeichniseintrag")
    '/// Write down something in document ///
    Call wDokSchreiben("<Left>")
    InsertIndexesEntry
    '/// Insert / Indexes / Entry ///
    Kontext "VerzeichniseintragEinfuegen"
    try
        '/// Close dialog ///
        EintragOk.Click
    catch
        Warnlog "Index entry couldn't be inserted!(Button disabled)"
    endcatch
    EinfuegenSchliessen.Click

    Call wDokSchreiben("<End><Left>")
    try
        '/// Point cursor in Index entry ///
        EditIndexEntry
        '/// Edit / Index entry ///
        Kontext "VerzeichniseintragBearbeiten"
        Call DialogTest (VerzeichniseintragBearbeiten)
        BearbeitenSchliessen.Click
    catch
        Warnlog "Not able to edit index entry!"
    endcatch

    Call hCloseDocument
    '/// Close active document ///
endcase

'----------------------------------------------------------------

testcase tEditLinks
    PrintLog "- Edit/Links"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    
    Call hNewDocument
    Call hGrafikVerknuepftEinfuegen ( gTesttoolPath & "writer\input\grafik\jolink.jpg" )
    Wait 500
    try
        EditLinksWriter
    catch
        Warnlog "Error on calling Edit / Links ! (disabled)"
        Call hCloseDocument
        goto endsub
    endcatch

    Kontext "VerknuepfungenBearbeiten"
    if VerknuepfungenBearbeiten.Exists then
        Call DialogTest ( VerknuepfungenBearbeiten )
        Wait 500
        try
            Aendern.Click
            Kontext "GrafikEinfuegenDlg"
            GrafikEinfuegenDlg.Cancel
        catch
            Warnlog "Error modifying the link!"
        endcatch

        Kontext "VerknuepfungenBearbeiten"
        Wait 500
        try
            Aktualisieren.Click
        catch
            Warnlog "Error on updating the link!"
        endcatch
        Wait 500

        try
            Loesen.Click
            Kontext "Active"
            if Active.Exists then Active.No
        catch
            Warnlog "- Error on breaking the link!"
        endcatch

        Kontext "VerknuepfungenBearbeiten"
        VerknuepfungenBearbeiten.Close
    else
        Warnlog "Dialog Edit / Links not opened!"
    endif
    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------------

testcase tEditFloatingFrame
    PrintLog "- Try to edit Floating Frame in Writerdocument "

    Call hNewDocument
    '/// Open new document ///

    InsertFloatingFrame
    '/// Insert / Floating Frame ///

    Kontext "TabEigenschaften"
    '/// Enter a frame name ///

    FrameName.SetText "Hallo"
    Sleep 4
    Call DialogTest ( TabEigenschaften )
    '/// Click 'open' in 'Floating Frame Properties' ///
    Oeffnen.Click
    Kontext "OeffnenDlg"
    Call DialogTest ( OeffnenDlg )
    '/// Cancel File Open dialog ///
    OeffnenDlg.Cancel
    Kontext "TabEigenschaften"
    '/// Insert as 'Contents:' "..\writer\input\misc\frameset.htm"  ///
    Inhalt.SetText ConvertPath ( gTesttoolpath & "writer\input\misc\frameset.htm" )
    '/// Select 'OK' in 'Floating Frame Properties' ///
    TabEigenschaften.OK

    Sleep 4

    Call wDocSetContext
    '/// Edit / Object / Properties ///
    try
        EditObjectProperties
        Sleep 4
        Kontext "TabEigenschaften"
        TabEigenschaften.Cancel
    catch
        Warnlog "- unable to edit Frameset , Menu enabled ?"
    endcatch

    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------------

testcase tEditPlugIn
    PrintLog "- Edit/PlugIn"

    Call hNewDocument
    '/// Open new document ///
    EditPlugIn
    '/// Edit / Plugin ///
    Sleep 2
    EditPlugIn
    '/// Edit / Plugin ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------------

testcase tEditImageMap
    PrintLog "- Edit / ImageMap"

    Call hNewDocument
    '/// Open new document ///

    if hGrafikEinfuegen ( gTesttoolPath & "writer\input\grafik\jolink.jpg" )=true then
		Kontext "ImageMapEditor"
		if ImageMapEditor.Exists then ImageMapEditor.Close    
		try
			EditImageMap
			Kontext "ImageMapEditor"
			Call DialogTest (ImageMapEditor)
			Sleep 4
			ImageMapEditor.Close
		catch
			Warnlog "Edit/ImageMap disabled!"
		endcatch
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------------

testcase tEditObjectEdit
    PrintLog "- Edit / Object / Edit"

    Call hNewDocument
    '/// Open new document ///
    if hGrafikEinfuegen ( gTesttoolPath & "writer\input\grafik\jolink.jpg" ) = true then
        try
            EditObjectEdit
        catch
            Call wDocSetContext
            Warnlog "Edit/Object/Edit is disabled!"
        endcatch
        Sleep 2
        Call gMouseClick (10, 5)
        Call wDokSchreiben("<Delete>")
    endif

    Sleep 2
    if hGrafikVerknuepftEinfuegen ( gTesttoolPath & "writer\input\grafik\jolink.jpg" )=true then
        try
            EditObjectEdit
        catch
            Call wDocSetContext
            exit Sub
        endcatch

        Sleep 2
        Kontext "Active"
        if Active.Exists then
            Active.No
            wait 500
            EditObjectEdit
            Sleep 2
            Active.Yes
        else
            Warnlog "No Errormessage with editing linked graphics"
        endif
        Sleep 5
        Kontext "NeuesBild"
        if NeuesBild.Exists then
            Warnlog " Error with graphic links. EditObjectEdit wants to create a new object!"
            Erstellen.Click
            Sleep 2
        endif

        Call gMouseClick (10, 5)

        try
            Call wDokSchreiben("<Delete>")
        catch
            Warnlog "Maybe the Image couldn't be opened"
        endcatch
    endif
    Sleep 2
    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------------

testcase tEditObjectEdit2
    PrintLog "- Bearbeiten/Objekte edit"

    Call hNewDocument
    '/// Open new document ///

    InsertObjectChart
    Kontext "AutoformatDiagramm1"
    Fertigstellen.Click
    Sleep 2
    EditObjectEdit
    Sleep 2
    Call gMouseDoubleClick (50, 5)

    Sleep 2
    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------------

testcase tEditObjectOpen
    PrintLog "- Edit / Object Open"

    Call hNewDocument
    '/// Open new document ///

    InsertObjectChart
    Kontext "AutoformatDiagramm1"
    Fertigstellen.Click
    Sleep 2
    EditObjectOpen
    Sleep 2
    Kontext "DocumentChart"
    DocumentChart.MouseDown 50, 50
    DocumentChart.MouseUp 50, 50
    FileClose

    Sleep 2
    Call hCloseDocument
    '/// Close active document ///
endcase
