'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_AdabasD.inc,v $
'*
'*  $Revision: 1.10.2.2 $
'*
'*  last change: $Author: msc $ $Date: 2008/03/10 11:47:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Create Adabas DS & Table & fill in Test
'*
'\***********************************************************************
testcase b_lvl1_AdabasD

    printlog "------------------ b_lvl1_AdabasD.inc ---------------------"

    if gPlatform = "x86" then
        printlog "No Adabas available under x86."
    elseif gOOO then
        printlog "No Adabas available under OpenOffice.org."
    else             
    
        ' **************************************************
        '   databases specific settings for Adabas D 11.02
        ' **************************************************
           
        Dim sFileName as string
        sFileName = gOfficePath + "user/work/TT_Adabas.odb"
        
        Dim sDBURL as string
        sDBURL = "waikiki-3086:TTDB"
        
        Dim sTableName as string
        sTableName = "tt_test_table"    'table name lenght restriction
        
        Dim sUserName as string
        sUserName = "testtool"
        
        Dim sPWD as string
        sPWD = "testtool"
        
        dim sCatalog as string
        sCatalog = " "              ' empty for adabas
        
        dim sSchema as string
        sSchema = "TESTTOOL"        ' case sensitive !
        
        dim sRelTable1 as string    'for relation test (tRelation1&2)
        sRelTable1 = "tt_rel1"
        
        dim sRelTable2 as string    'for relation test (tRelation1&2)
        sRelTable2 = "tt_rel2"
        
        dim sRelTable3 as string    'for relation test (tRelation2)
        sRelTable3 = "tt_rel3"
        
        Dim aFieldTypeContent(17,3) as string     'database specific data matrix
            
        aFieldTypeContent(1,1)="tt_boolean"     'name of fieldtype
        aFieldTypeContent(1,2)="boolean"        'number of fieldtype (listbox entry)    
        
        aFieldTypeContent(2,1)="tt_long_byte"
        aFieldTypeContent(2,2)="long byte"
             
        aFieldTypeContent(3,1)="tt_varchar_byte"
        aFieldTypeContent(3,2)="varchar() byte"
             
        aFieldTypeContent(4,1)="tt_char_byte"
        aFieldTypeContent(4,2)="char() byte"
             
        aFieldTypeContent(5,1)="tt_long"        ' does not work #69846
        aFieldTypeContent(5,2)="long"
             
        aFieldTypeContent(6,1)="tt_char"
        aFieldTypeContent(6,2)="char"
            
        aFieldTypeContent(7,1)="tt_decimal"     ' will probably work after #108512 is fixed
        aFieldTypeContent(7,2)="decimal"
            
        aFieldTypeContent(8,1)="tt_fixed"       ' will probably work after #108512 is fixed
        aFieldTypeContent(8,2)="fixed"
            
        aFieldTypeContent(9,1)="tt_integer"
        aFieldTypeContent(9,2)="integer"
            
        aFieldTypeContent(10,1)="tt_smallint"
        aFieldTypeContent(10,2)="smallint"
            
        aFieldTypeContent(11,1)="tt_float"
        aFieldTypeContent(11,2)="float"
            
        aFieldTypeContent(12,1)="tt_real"
        aFieldTypeContent(12,2)="real"
            
        aFieldTypeContent(13,1)="tt_double_precision"
        aFieldTypeContent(13,2)="double precision"
            
        aFieldTypeContent(14,1)="tt_varchar"
        aFieldTypeContent(14,2)="varchar"
        
        aFieldTypeContent(15,1)="tt_date"
        aFieldTypeContent(15,2)="date"
            
        aFieldTypeContent(16,1)="tt_time"
        aFieldTypeContent(16,2)="time"
            
        aFieldTypeContent(17,1)="tt_timestamp"
        aFieldTypeContent(17,2)="timestamp"
            
        Dim aFieldContent(1,4) as string
        aFieldContent(1,1)="<Space>"
        aFieldContent(1,2)="1"
        aFieldContent(1,3)="1"
        aFieldContent(1,4)="1"
        
        dim dbok as boolean
        dbok = false
        
        dim aDatabaseProperties(5) as string
        aDatabaseProperties() = tools_dbtools_fgetAdabasDatabaseProperties()
    
        ' if and only if no properties are defined in the environment file the test is stopped
        if(aDatabaseProperties(1) = "no") then
            qaerrorlog "No database properties from Adabas defiened. The Test is stopped here."
            goto endsub
        endif        
        
        dbok = fCreateAdabasDatasource( sFileName, aDatabaseProperties(2), aDatabaseProperties(3), aDatabaseProperties(4))
                                        
        if dbok = true then
            call fOpenDatabase(sFileName,"testtool")
            call fDeleteTable( sTableName )
            call fCreateTable( aFieldTypeContent(), sTableName )    
            call fInsertIntoTable( aFieldContent(), sTableName )
            call fCloseDatabase
            
                call tRelation( sFileName, sPWD, sRelTable1, sRelTable2 )
                call tDoubleRelation( sFileName, sPWD, sRelTable1, sRelTable2, sRelTable3 )
                call b_lvl1_Query(sFileName,"adabas","testtool")  
            
        else
            warnlog "Data Source could not be created - beyond testcases stopped"
        endif  
    endif
endcase
