'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch2_file.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsi $ $Date: 2007/12/17 08:55:38 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Chart resource test - Menu FILE
'*
'************************************************************************
'*
' #1 tFileClose
' #1 tFileSaveAsOTS
' #1 tFileSaveAsSXC
' #1 tFileSaveAsSTC
' #1 tFileSaveAsXLS
' #1 tFileSaveAsXLT
' #1 tFileSaveAsSDC
' #1 tFileSaveAsVOR
' #1 tFileReload
'*
'\************************************************************************

testcase tFileClose
'///<u><b>Dialog test after invocation of File::Close</b></u
   '/// Load new document
   Call hNewDocument
   '/// Insert default chart
   InsertChart
   sleep(2)
   Kontext "ChartWizard"
   '/// Leave wizard with OK 
   ChartWizard.OK
   printlog "Left Chart wizard with OK"
   sleep(2)
   '/// File / Close
   FileClose
   printlog "File / Close executed"
   Kontext
   '/// MsgBox: Cancel
   Active.Cancel
   '/// File / Close
   FileClose
   '/// MsgBox: Save
   Kontext
   Active.Yes
   '/// Check for File Save dialo
   Kontext "SpeichernDlg"
   '/// Cancel File Save dialog
   SpeichernDlg.Cancel
   '/// File / Close
   FileClose
   Kontext
   '/// MsgBox: Discard
   Active.No
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsOTS
'///<u><b>Save the test file as OpenDocument Spreadsheet Template (.ots)</b></u>
    Dim sFilterUIName as string
    Dim aFilterExt(4) as string
    Dim sFilterName as string
    Dim sOutputFile as string
    
    sOutputFile = convertpath( gOfficepath & "user/work/verySimpleChart.ots" )

    '/// Load simple chart document   
    if fLoadVerySimpleChartAndSaveLocal() > 0 then
        warnlog "Loading test document failed!"
        goto endsub
    else
        printlog "Test document successfully been loaded."
    endif
    '/// Select first OLE using the navigator 
    call fSelectFirstOLE
    printlog "First OLE selected via navigator"
    '/// Edit / Object / Edit to enter Inplace Mode 
    EditObjectEdit
    printlog "Edit / Object / Edit"
    '/// Convert chart to 3D (just to edit document) 
    if NOT fConvertChartTo3D() then
        warnlog "Conversion of chart to 3D failed -> Quit testcase"
        Call hCloseDocument
        goto endsub
    else
        printlog "Conversation of chart to 3D was successful."
    endif
    '/// Unselect chart using Escape key 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"    
    '/// Save document as OpenDocument Spreadsheet Template (.ots)
    sFilterUIName = hGetUIFiltername("calc8_template")    
    aFilterExt = hGetFilternameExtension("calc8_template")    
    sFilterName = sFilterUIName & " (." & aFilterExt(0) & ")"
    printlog "UI filter name: " & sFilterName 
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , sFilterName ) then
        warnlog "Saving test document as '" & sFilterName & "' failed -> Aborting"
        call hCloseDocument
        goto endsub
    else
        printlog "Saving test document as '" & sFilterName & "' was successful."
    endif
    '/// Clsoing the Navigator
    Kontext "NavigatorCalc"
    if NavigatorCalc.Exists(1) then
    	NavigatorCalc.Close
        QAErrorLog "Why did fSelectFirstOLE not close this dialog?"
    endif
    '/// Close document 
    Call hCloseDocument 
endcase
'
'-------------------------------------------------------------
'
testcase tFileSaveAsSXC
'///<u><b>Save the test file as StarOffice 6.0/7 Spreadsheet (.sxc)</b></u>
    Dim sOutputFile as string
    Dim sFilterUIName as string
    Dim aFilterExt(4) as string
    Dim sFilterName as string
        
    sOutputFile = convertpath( gOfficepath & "user/work/verySimpleChart.sxc" )

    '/// Load simple chart document 
    if fLoadVerySimpleChartAndSaveLocal() > 0 then
        warnlog "Loading test document failed!"
        goto endsub
    else
        printlog "Loading test document was successful!"
    endif
    '/// Select chart using navigator 
    call fSelectFirstOLE
    printlog "First OLE selected via Navigator"
    '/// Edit / Object / Edit to enter Inplace Mode 
    EditObjectEdit
    printlog "Edit / Object / Edit"
    '/// Convert chart to 3D (just to edit document) 
    if NOT fConvertChartTo3D() then
        warnlog "Conversion of chart to 3D failed -> Quit testcase"
        Call hCloseDocument
        goto endsub
    else
        printlog "Conversation of chart to 3D was successful."
    endif
    '/// Unselect chart using Escape key 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"        
    '/// Save document as StarOffice 6.0/7 Spreadsheet (.sxc)
    sFilterUIName = hGetUIFiltername("StarOffice XML (Calc)")    
    aFilterExt = hGetFilternameExtension("calc_StarOffice_XML_Calc")    
    sFilterName = sFilterUIName & " (." & aFilterExt(0) & ")"
    printlog "UI filter name: " & sFilterName 
    
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , sFilterName ) then
        warnlog "Saving test document as '" & sFilterName & "' failed -> Aborting"
        call hCloseDocument
        goto endsub
    else
        printlog "Saving test document as '" & sFilterName & "' was successful."
    endif
    '/// Close document 
    Call hCloseDocument
endcase
'
'-------------------------------------------------------------
'
testcase tFileSaveAsSTC
'///<u><b>Save the test file as StarOffice 6.0/7 Spreadsheet Template (.stc)</b></u>
    Dim sOutputFile as string
    Dim sFilterUIName as string
    Dim aFilterExt(4) as string
    Dim sFilterName as string    
    
    sOutputFile = convertpath( gOfficepath & "user/work/verySimpleChart.stc" )

    '/// Load simple chart document 
    if fLoadVerySimpleChartAndSaveLocal() > 0 then
        warnlog "Loading test document seems to have failed -> Check this out!"
        goto endsub
    else
        printlog "Simple chart document successfully been loaded."   
    endif
    '/// Select chart using navigator 
    call fSelectFirstOLE
    '/// Edit / Object / Edit 
    EditObjectEdit
    '/// Convert chart to 3D (just to edit document) 
    if NOT fConvertChartTo3D() then
        warnlog "Conversion of chart to 3D failed -> Quit testcase"
        Call hCloseDocument
        goto endsub
    else
        printlog "Chart has been converted successfully to 3D."
    endif
    '/// Unselect chart using Escape key 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"
    '/// Save document as StarOffice 6.0/7 Spreadsheet Template (.stc)
    sFilterUIName = hGetUIFiltername("calc_StarOffice_XML_Calc_Template")    
    aFilterExt = hGetFilternameExtension("calc_StarOffice_XML_Calc_Template")    
    sFilterName = sFilterUIName & " (." & aFilterExt(0) & ")"    
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , sFilterName ) then
        warnlog "Saving test document as '" & sFilterName & "' failed -> Aborting"
        call hCloseDocument
        goto endsub
    else
        printlog "Saving as StarOffice 6.0/7 Spreadsheet Template (.stc) was successful."
    endif
    '/// Close document         
    Call hCloseDocument
endcase
'
'-------------------------------------------------------------
'
testcase tFileSaveAsXLS
'///<u><b>Save the test file as Microsoft Excel 97/2000/XP (.xls)</b></u>
    Dim sOutputFile as string
    Dim sFilterUIName as string
    Dim aFilterExt(4) as string
    Dim sFilterName as string
       
    sOutputFile = convertpath( gOfficepath & "user/work/verySimpleChart.xls" )

    '/// Load simple chart document <i>Testtoolpath</i>/chart2/update/input/verySimpleChart.ods
    if fLoadVerySimpleChartAndSaveLocal() > 0 then
        warnlog "Loading test document failed!"
        goto endsub
    endif
    '/// Edit / Navigator
    '/// Select the first OLE object in the tree view of the Navigator
    '/// Press <RETURN>
    call fSelectFirstOLE
    printlog "First OLE selected." 
    '/// Edit / Object / Edit to enter Inplace Mode   
    EditObjectEdit
    printlog "Edit / Object / Edit executed."
    '/// Format / Chart Type
    '/// Check 3D checkbox
    '/// Close Chart Type dialog
    if NOT fConvertChartTo3D() then
        warnlog "Conversion of chart to 3D failed -> Quit testcase"
        Call hCloseDocument
        goto endsub   
    else
        printlog "Chart type converted to 3D."
    endif
    '/// Unselect chart using Escape key 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"        
   '/// Save document as Microsoft Excel 97/2000/XP (.xls)
    sFilterUIName = hGetUIFiltername("MS Excel 97")    
    aFilterExt = hGetFilternameExtension("calc_MS_Excel_97")    
    sFilterName = sFilterUIName & " (." & aFilterExt(0) & ")"       
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , sFilterName ) then
        warnlog "Saving test document as '" & sFilterName & "' failed -> Aborting"
        call hCloseDocument
        goto endsub
    else
        printlog "Saving test document as '" & sFilterName & "' was successful."
    endif
   '/// Close document
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Escape>"
   Call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tFileSaveAsXLT
'///<u><b>Save the test file as Microsoft Excel 97/2000/XP Template(.xlt)</b></u>
    Dim sOutputFile as string
    Dim sFilterUIName as string
    Dim aFilterExt(4) as string
    Dim sFilterName as string
        
    sOutputFile = convertpath( gOfficepath & "user/work/verySimpleChart.xlt" )

    '/// Load simple chart document <i>Testtoolpath</i>/chart2/update/input/verySimpleChart.ods
    if fLoadVerySimpleChartAndSaveLocal() > 0 then
        warnlog "Loading test document failed!"
        goto endsub
    endif
    '/// Edit / Navigator
    '/// Select the first OLE object in the tree view of the Navigator
    '/// Press <RETURN>
    call fSelectFirstOLE
    printlog "First OLE selected." 
    '/// Edit / Object / Edit to enter Inplace Mode   
    EditObjectEdit
    printlog "Edit / Object / Edit executed."
    '/// Format / Chart Type
    '/// Check 3D checkbox
    '/// Close Chart Type dialog
    if NOT fConvertChartTo3D() then
        warnlog "Conversion of chart to 3D failed -> Quit testcase"
        Call hCloseDocument
        goto endsub   
    else
        printlog "Chart type converted to 3D."
    endif
    '/// Unselect chart using Escape key 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"        
    '/// Save document as Microsoft Excel 97/2000/XP Template(.xlt)    
    sFilterUIName = hGetUIFiltername("MS Excel 97 Vorlage/Template")    
    aFilterExt = hGetFilternameExtension("calc_MS_Excel_97_VorlageTemplate")    
    sFilterName = sFilterUIName & " (." & aFilterExt(0) & ")"       
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , sFilterName ) then
        warnlog "Saving test document as '" & sFilterName & "' failed -> Aborting"
        call hCloseDocument
        goto endsub
    else
        printlog "Saving test document as '" & sFilterName & "' was successful."
    endif
   '/// Close document
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Escape>"
   Call hCloseDocument
endcase
'
'-------------------------------------------------------------
'
testcase tFileSaveAsSDC
'///<u><b>Save the test file as StarCalc 5.0 (.sdc)</b></u> 
    Dim sOutputFile as string
    Dim sFilterUIName as string
    Dim aFilterExt(4) as string
    Dim sFilterName as string
   
    sOutputFile = convertpath( gOfficepath & "user/work/verySimpleChart.sdc" )

    '/// Load simple chart document 
    if fLoadVerySimpleChartAndSaveLocal() > 0 then
        warnlog "Loading test document seems to have failed -> Check this out!"
        goto endsub
    endif
    '/// Select chart using navigator 
    call fSelectFirstOLE
    '/// Invoke Edit::Object::Edit to enter Inplace Mode 
    EditObjectEdit
    '/// Convert chart to 3D (just to edit document) 
    if NOT fConvertChartTo3D() then
        warnlog "Conversion of chart to 3D failed -> Quit testcase"
        Call hCloseDocument
        goto endsub
    endif
    '/// Unselect chart using Escape key 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"
    '/// Save document as StarCalc 5.0 (.sdc) 
    sFilterUIName = hGetUIFiltername("StarCalc 5.0")    
    aFilterExt = hGetFilternameExtension("calc_StarCalc_50")    
    sFilterName = sFilterUIName & " (." & aFilterExt(0) & ")"       
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , sFilterName ) then
        warnlog "Saving test document as '" & sFilterName & "' failed -> Aborting"
        call hCloseDocument
        goto endsub
    else
        printlog "Saving test document as '" & sFilterName & "' was successful."
    endif
    '/// Close document 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"
    Call hCloseDocument
endcase
'
'-------------------------------------------------------------
'
testcase tFileSaveAsVOR
'///<u><b>Save the test file as StarCalc 5.0 Template(.vor)</b></u> 
    Dim sOutputFile as string
    Dim sFilterUIName as string
    Dim aFilterExt(4) as string
    Dim sFilterName as string
           
    sOutputFile = convertpath( gOfficepath & "user/work/verySimpleChart.vor" )

    '/// Load simple chart document 
    if fLoadVerySimpleChartAndSaveLocal() > 0 then
        warnlog "Loading test document seems to have failed -> Check this out!"
        goto endsub
    endif
    '/// Select chart using navigator 
    call fSelectFirstOLE
    '/// Invoke Edit::Object::Edit to enter Inplace Mode 
    EditObjectEdit
    '/// Convert chart to 3D (just to edit document) 
    if NOT fConvertChartTo3D() then
        warnlog "Conversion of chart to 3D failed -> Quit testcase"
        Call hCloseDocument
        goto endsub
    endif
    '/// Unselect chart using Escape key 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"
    '/// Save document as StarCalc 5.0 Template(.vor) 
    sFilterUIName = hGetUIFiltername("StarCalc 5.0 Vorlage/Template")    
    aFilterExt = hGetFilternameExtension("calc_StarCalc_50_VorlageTemplate")    
    sFilterName = sFilterUIName & " (." & aFilterExt(0) & ")"       
    if NOT hSpeichernUnterMitFilterKill ( sOutputFile , sFilterName ) then
        warnlog "Saving test document as '" & sFilterName & "' failed -> Aborting"
        call hCloseDocument
        goto endsub
    else
        printlog "Saving test document as '" & sFilterName & "' was successful."
    endif
    '/// Close document 
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Escape>"
    Call hCloseDocument
endcase
'
'-------------------------------------------------------------
'
testcase tFileReload
'///<u><b>Test invocation of File::Reload</b></u>

'/// 
   '/// Load simple chart document 
   if fLoadVerySimpleChartAndSaveLocal() > 0 then
       warnlog "Loading test document seems to have failed -> Check this out!"
       goto endsub
   endif
   '/// Select chart using navigator 
   call fSelectFirstOLE
   '/// Invoke Edit::Object::Edit to enter Inplace Mode 
   EditObjectEdit
   '/// Convert chart to 3D (just to edit document) 
   if NOT fConvertChartTo3D() then
       warnlog "Conversion of chart to 3D failed -> Quit testcase"
       Call hCloseDocument
       goto endsub
   endif
   '/// Unselect chart using Escape key 
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Escape>"
   sleep (2)
   '/// Reload File 
   FileReload
   '/// MsgBox 'Cancel all changes?' should be visible -> Commit OK 
   Kontext
   Active.Yes
   sleep (2)
   '/// Close document ///
   Call hCloseDocument
'/// 

endcase

