'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: sunsearchbar.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2007/10/31 12:14:11 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Quick test for the SunSearchBar
'*
'*******************************************************************************
'**
' #1 tSunSearchBarInAllApps ' Quick test for the SunSearchBar
'**
'\******************************************************************************

testcase tSunSearchBarInAllApps

    '///<h1>Quick test for the SunSearchBar</h1>
    '///<ul>
    
    const EXTENSION_NAME = "SunSearchToolbar.oxt"
    
    dim brc as boolean
    dim visible as boolean
    dim iCurrentDocType as integer
    
    '///+<li>Verify that the Sun Search Toolbar is installed. If not, quit.</li>
    brc = hIsExtensionAlreadyInstalled( EXTENSION_NAME )
 
    if ( brc ) then
    
        '///+<li>Verify that the Toolbar is *not* installed for OOo</li>
        if ( gOOo ) then
            warnlog( "The Sun Search Toolbar should not be installed for OOo" )
        else
            printlog( "The Sun Search Toolbar is installed." )
        endif

        '///+<li>Make sure we are on the backing window</li>
        do while ( getDocumentCount > 0 ) 
            call hCloseDocument()
        loop
        
        '///+<li>Verify that the toolbar is not visible</li>
        kontext "SearchBar"
        if ( SearchBar.exists() ) then
            warnlog( "The extension should not be visible in backing mode" )
        else
            printlog( "The Toolbar is not visible in backing mode, good." )
        endif    
        
        '///+<li>For all documenttypes we should see the toolbar</li>
        '///<ul>
        for iCurrentDoctype = 1 to 8
            
            select case ( iCurrentDocType )
            case 1 : visible = TRUE  : gApplication = "WRITER"
            case 2 : visible = TRUE  : gApplication = "CALC"
            case 3 : visible = TRUE  : gApplication = "DRAW"
            case 4 : visible = TRUE  : gApplication = "IMPRESS"
            case 5 : visible = FALSE : gApplication = "MATH"
            case 6 : visible = TRUE  : gApplication = "MASTERDOC"
            case 7 : visible = TRUE  : gApplication = "HTML"
            case 8 : visible = TRUE  : gApplication = "INSIGHT"
            end select
            
            '///+<li>Create a new document</li>
            call hNewDocument()
            
            '///+<li>Determine whether the toolbar should be visible or not, verify</li>
            kontext "SearchBar"
            if ( SearchBar.exists() ) then
                if ( visible ) then
                    printlog( gApplication & ": Toolbar is visible, good." )
                else
                    warnlog( gApplication & ": Error: Toolbar is visible" )
                endif
            else
                if ( not visible ) then
                    printlog( gApplication & ": Toolbar is not visible, good." )
                else
                    warnlog( gApplication & ": Error: Toolbar is not visible" )
                endif
            endif
            
            '///+<li>Close the document</li>
            call hCloseDocument()
            
        next iCurrentDocType
        '///<ul>
            
    else
    
        ' Here we have the reasons why the toolbars might not be installed:
        ' a) OpenOffice.org does not come with the bundled toolbar 
        ' b) We upgraded a Solaris build - in this case the toolbar is not installed
        '    (This would be aginst the patching policies)
        
        if ( gOOo ) then
            printlog( "The Sun Search Toolbar is not installed for OOo, good." )
        else
            if ( gtSysName = "Solaris SPARC" or gtSysName = "Solaris x86" ) then
                qaerrorlog( "Toolbar missing - is this a patched install?" )
            else
                warnlog( "The Sun Search Toolbar is missing." )
            endif
        endif

    endif
    '///</ul>
    
endcase

