'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_java_load_applets.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2007/10/16 13:56:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.Skottke@Sun.Com
'*
'*  short description : Load a number of files that trigger Java
'*
'*******************************************************************************
'**
' #1 tLoadJavaApplets ' Load a number of files that trigger Java
'**
'\******************************************************************************

testcase tLoadJavaApplets

    '///<h1>Load a number of files that trigger Java</h1>
    
    ' Desing goals:
    ' 1) This test should be able to load any relevant file from the 
    '    input directory without the need to update the code. It is 
    '    expected that more files will be added in the future, namely
    '    bugdocs
    ' 2) The test should recover when a file could not be loaded so that
    '    the remaining documents are tested
    
    dim cSourcePath as string           ' this is where the files are located
    dim aSourceFiles( 1000 ) as string  ' the list of files below cSourcePath
    dim iSourceFiles as integer         ' the number of files in aSourceFiles()
    
    dim brc as boolean
    
    const DOC_IDENTIFIER = "Testdocument for f_java_load_applets.bas"
    
    '///<ul>
    '///+<li>Determine the source directory from where the files will be loaded</li>
    cSourcePath = gTesttoolPath & "framework\basic\input\java_applets"
    cSourcePath = convertpath( cSourcePath )
    
    '///+<li>Remove all hs_err_pidXXXX.log files (if any)</li>
    brc = hFindCopyRemoveJavaLogs( cSourcePath )
    if ( not brc ) then
        qaerrorlog( "Removed hs_err_pidXXXX.log files from prior testrun" )
    endif
    
    '///+<li>Make sure we have exactly one modified initial document</li>
    hInitSingleDoc()
    kontext "DocumentWriter"
    DocumentWriter.typeKeys( DOC_IDENTIFIER )
    
    '///+<li>Load all HTML files</li>
    iSourceFiles = GetAllFileList( cSourcePath, "*.htm*", aSourceFiles() )    
    hBatchLoadJavaFiles( aSourceFiles(), DOC_IDENTIFIER )

    '///+<li>Load all .sx? files</li>
    iSourceFiles = GetAllFileList( cSourcePath, "*.sx?", aSourceFiles() )    
    hBatchLoadJavaFiles( aSourceFiles(), DOC_IDENTIFIER )
    
    '///+<li>Load all .od? files</li>
    iSourceFiles = GetAllFileList( cSourcePath, "*.od?", aSourceFiles() )    
    hBatchLoadJavaFiles( aSourceFiles(), DOC_IDENTIFIER  )

    '///</ul>

endcase

'*******************************************************************************


